set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/foo.vcxproj")
if(NOT EXISTS "${vcProjectFile}")
  set(RunCMake_TEST_FAILED "Project file ${vcProjectFile} does not exist.")
  return()
endif()

set(found_ImportLibrary 0)
set(found_TargetExt_dll 0)
file(STRINGS "${vcProjectFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES "<ImportLibrary>")
    set(found_ImportLibrary 1)
  endif()
  if(line MATCHES "<TargetExt[^\n]*\\.dll")
    set(found_TargetExt_dll 1)
  endif()
endforeach()
if(found_ImportLibrary)
  string(APPEND RunCMake_TEST_FAILED "ImportLibrary incorrectly found in\n  ${vcProjectFile}\n")
endif()
if(NOT found_TargetExt_dll)
  string(APPEND RunCMake_TEST_FAILED "TargetExt not found in\n  ${vcProjectFile}\n")
endif()
