/*
 *  Manual test for zeroing behavior with DUK_USE_ZERO_BUFFER_DATA unset.
 *
 *  Even with zeroing disabled, ArrayBuffer and typedarray constructors must
 *  zero result buffers.  Node.js buffers don't need to be zeroed (and Node.js
 *  won't do that).
 *
 *  The expect string is for DUK_USE_ZERO_BUFFER_DATA set, i.e. all data is
 *  zeroed (which is the default).  This is correct for ArrayBuffer and
 *  typedarray views, but not for Node.js.
 */

/*---
{
    "custom": true
}
---*/

/*===
|00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000|
|00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000|
{type:"Buffer",data:[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}
===*/

function test() {
    var buf;

    buf = new ArrayBuffer(256);
    print(Duktape.enc('jx', buf));

    buf = new Uint16Array(128);
    print(Duktape.enc('jx', buf));

    buf = new Buffer(256);
    print(Duktape.enc('jx', buf));
}

try {
    test();
} catch (e) {
    print(e.stack || e);
}
