/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Queue;

public class JobQueueInfo
implements Writable {
    static final String EMPTY_INFO = "N/A";
    private String queueName = "";
    private String queueState = Queue.QueueState.RUNNING.getStateName();
    private String schedulingInfo = "N/A";

    public JobQueueInfo() {
    }

    public JobQueueInfo(String queueName, String schedulingInfo) {
        this.queueName = queueName;
        this.schedulingInfo = schedulingInfo;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setSchedulingInfo(String schedulingInfo) {
        this.schedulingInfo = schedulingInfo != null ? schedulingInfo : EMPTY_INFO;
    }

    public String getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public void setQueueState(String state) {
        this.queueState = state;
    }

    public String getQueueState() {
        return this.queueState;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.queueName = Text.readString(in);
        this.queueState = Text.readString(in);
        this.schedulingInfo = Text.readString(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.queueName);
        Text.writeString(out, this.queueState);
        Text.writeString(out, this.schedulingInfo);
    }
}

