; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx,+xop | FileCheck %s
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+xop | FileCheck %s

define <4 x double> @pcmov_4f64(<4 x double> %a, <4 x double> %b, <4 x double> %m) {
; CHECK-LABEL: pcmov_4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %1 = bitcast <4 x double> %m to <4 x i64>
  %2 = bitcast <4 x double> %a to <4 x i64>
  %3 = and <4 x i64> %1, %2
  %4 = xor <4 x i64> %1, <i64 -1, i64 -1, i64 -1, i64 -1>
  %5 = bitcast <4 x double> %b to <4 x i64>
  %6 = and <4 x i64> %4, %5
  %7 = or <4 x i64> %3, %6
  %8 = bitcast <4 x i64> %7 to <4 x double>
  ret <4 x double> %8
}

define <2 x double> @pcmov_2f64(<2 x double> %a, <2 x double> %b, <2 x double> %m) {
; CHECK-LABEL: pcmov_2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %1 = bitcast <2 x double> %m to <2 x i64>
  %2 = bitcast <2 x double> %a to <2 x i64>
  %3 = and <2 x i64> %1, %2
  %4 = xor <2 x i64> %1, <i64 -1, i64 -1>
  %5 = bitcast <2 x double> %b to <2 x i64>
  %6 = and <2 x i64> %4, %5
  %7 = or <2 x i64> %3, %6
  %8 = bitcast <2 x i64> %7 to <2 x double>
  ret <2 x double> %8
}

define <8 x float> @pcmov_8f32(<8 x float> %a, <8 x float> %b, <8 x float> %m) {
; CHECK-LABEL: pcmov_8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %1 = bitcast <8 x float> %m to <8 x i32>
  %2 = bitcast <8 x float> %a to <8 x i32>
  %3 = and <8 x i32> %1, %2
  %4 = xor <8 x i32> %1, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %5 = bitcast <8 x float> %b to <8 x i32>
  %6 = and <8 x i32> %4, %5
  %7 = or <8 x i32> %3, %6
  %8 = bitcast <8 x i32> %7 to <8 x float>
  ret <8 x float> %8
}

define <4 x float> @pcmov_4f32(<4 x float> %a, <4 x float> %b, <4 x float> %m) {
; CHECK-LABEL: pcmov_4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %1 = bitcast <4 x float> %m to <4 x i32>
  %2 = bitcast <4 x float> %a to <4 x i32>
  %3 = and <4 x i32> %1, %2
  %4 = xor <4 x i32> %1, <i32 -1, i32 -1, i32 -1, i32 -1>
  %5 = bitcast <4 x float> %b to <4 x i32>
  %6 = and <4 x i32> %4, %5
  %7 = or <4 x i32> %3, %6
  %8 = bitcast <4 x i32> %7 to <4 x float>
  ret <4 x float> %8
}

define <4 x i64> @pcmov_4i64(<4 x i64> %a, <4 x i64> %b, <4 x i64> %m) {
; CHECK-LABEL: pcmov_4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %1 = and <4 x i64> %a, %m
  %2 = xor <4 x i64> %m, <i64 -1, i64 -1, i64 -1, i64 -1>
  %3 = and <4 x i64> %b, %2
  %4 = or <4 x i64> %1, %3
  ret <4 x i64> %4
}

define <2 x i64> @pcmov_2i64(<2 x i64> %a, <2 x i64> %b, <2 x i64> %m) {
; CHECK-LABEL: pcmov_2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %1 = and <2 x i64> %a, %m
  %2 = xor <2 x i64> %m, <i64 -1, i64 -1>
  %3 = and <2 x i64> %b, %2
  %4 = or <2 x i64> %1, %3
  ret <2 x i64> %4
}

define <8 x i32> @pcmov_8i32(<8 x i32> %a, <8 x i32> %b, <8 x i32> %m) {
; CHECK-LABEL: pcmov_8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %1 = and <8 x i32> %a, %m
  %2 = xor <8 x i32> %m, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %3 = and <8 x i32> %b, %2
  %4 = or <8 x i32> %1, %3
  ret <8 x i32> %4
}

define <4 x i32> @pcmov_4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %m) {
; CHECK-LABEL: pcmov_4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %1 = and <4 x i32> %a, %m
  %2 = xor <4 x i32> %m, <i32 -1, i32 -1, i32 -1, i32 -1>
  %3 = and <4 x i32> %b, %2
  %4 = or <4 x i32> %1, %3
  ret <4 x i32> %4
}

define <16 x i16> @pcmov_16i16(<16 x i16> %a, <16 x i16> %b, <16 x i16> %m) {
; CHECK-LABEL: pcmov_16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %1 = and <16 x i16> %a, %m
  %2 = xor <16 x i16> %m, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %3 = and <16 x i16> %b, %2
  %4 = or <16 x i16> %1, %3
  ret <16 x i16> %4
}

define <8 x i16> @pcmov_8i16(<8 x i16> %a, <8 x i16> %b, <8 x i16> %m) {
; CHECK-LABEL: pcmov_8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %1 = and <8 x i16> %a, %m
  %2 = xor <8 x i16> %m, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %3 = and <8 x i16> %b, %2
  %4 = or <8 x i16> %1, %3
  ret <8 x i16> %4
}

define <32 x i8> @pcmov_32i8(<32 x i8> %a, <32 x i8> %b, <32 x i8> %m) {
; CHECK-LABEL: pcmov_32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %1 = and <32 x i8> %a, %m
  %2 = xor <32 x i8> %m, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %3 = and <32 x i8> %b, %2
  %4 = or <32 x i8> %1, %3
  ret <32 x i8> %4
}

define <16 x i8> @pcmov_16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %m) {
; CHECK-LABEL: pcmov_16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %1 = and <16 x i8> %a, %m
  %2 = xor <16 x i8> %m, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %3 = and <16 x i8> %b, %2
  %4 = or <16 x i8> %1, %3
  ret <16 x i8> %4
}
