/* testlist.c generated by valac 0.36.11, the Vala compiler
 * generated from testlist.vala, do not modify */

/* testlist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_LIST_TESTS (list_tests_get_type ())
#define LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_TESTS, ListTests))
#define LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_TESTS, ListTestsClass))
#define IS_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_TESTS))
#define IS_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_TESTS))
#define LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_TESTS, ListTestsClass))

typedef struct _ListTests ListTests;
typedef struct _ListTestsClass ListTestsClass;
typedef struct _ListTestsPrivate ListTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _ListTests {
	CollectionTests parent_instance;
	ListTestsPrivate * priv;
};

struct _ListTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_retained) (ListTests* self);
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer list_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType list_tests_get_type (void) G_GNUC_CONST;
enum  {
	LIST_TESTS_0_PROPERTY
};
ListTests* list_tests_construct (GType object_type, const gchar* name);
CollectionTests* collection_tests_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target, GDestroyNotify test_target_destroy_notify);
void list_tests_test_iterator_is_ordered (ListTests* self);
static void _list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self);
void list_tests_test_list_iterator (ListTests* self);
static void _list_tests_test_list_iterator_gee_test_case_test_method (gpointer self);
void list_tests_test_duplicates_are_retained (ListTests* self);
static void _list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self);
void list_tests_test_get (ListTests* self);
static void _list_tests_test_get_gee_test_case_test_method (gpointer self);
void list_tests_test_set (ListTests* self);
static void _list_tests_test_set_gee_test_case_test_method (gpointer self);
void list_tests_test_insert (ListTests* self);
static void _list_tests_test_insert_gee_test_case_test_method (gpointer self);
void list_tests_test_remove_at (ListTests* self);
static void _list_tests_test_remove_at_gee_test_case_test_method (gpointer self);
void list_tests_test_index_of (ListTests* self);
static void _list_tests_test_index_of_gee_test_case_test_method (gpointer self);
void list_tests_test_first (ListTests* self);
static void _list_tests_test_first_gee_test_case_test_method (gpointer self);
void list_tests_test_last (ListTests* self);
static void _list_tests_test_last_gee_test_case_test_method (gpointer self);
void list_tests_test_insert_all (ListTests* self);
static void _list_tests_test_insert_all_gee_test_case_test_method (gpointer self);
void list_tests_test_slice (ListTests* self);
static void _list_tests_test_slice_gee_test_case_test_method (gpointer self);
gchar** test_data_get_data (int* result_length1);
guint* test_data_get_drawn_numbers (int* result_length1);
static void list_tests_real_test_duplicates_are_retained (ListTests* self);


static void _list_tests_test_iterator_is_ordered_gee_test_case_test_method (gpointer self) {
	list_tests_test_iterator_is_ordered ((ListTests*) self);
}


static void _list_tests_test_list_iterator_gee_test_case_test_method (gpointer self) {
	list_tests_test_list_iterator ((ListTests*) self);
}


static void _list_tests_test_duplicates_are_retained_gee_test_case_test_method (gpointer self) {
	list_tests_test_duplicates_are_retained ((ListTests*) self);
}


static void _list_tests_test_get_gee_test_case_test_method (gpointer self) {
	list_tests_test_get ((ListTests*) self);
}


static void _list_tests_test_set_gee_test_case_test_method (gpointer self) {
	list_tests_test_set ((ListTests*) self);
}


static void _list_tests_test_insert_gee_test_case_test_method (gpointer self) {
	list_tests_test_insert ((ListTests*) self);
}


static void _list_tests_test_remove_at_gee_test_case_test_method (gpointer self) {
	list_tests_test_remove_at ((ListTests*) self);
}


static void _list_tests_test_index_of_gee_test_case_test_method (gpointer self) {
	list_tests_test_index_of ((ListTests*) self);
}


static void _list_tests_test_first_gee_test_case_test_method (gpointer self) {
	list_tests_test_first ((ListTests*) self);
}


static void _list_tests_test_last_gee_test_case_test_method (gpointer self) {
	list_tests_test_last ((ListTests*) self);
}


static void _list_tests_test_insert_all_gee_test_case_test_method (gpointer self) {
	list_tests_test_insert_all ((ListTests*) self);
}


static void _list_tests_test_slice_gee_test_case_test_method (gpointer self) {
	list_tests_test_slice ((ListTests*) self);
}


ListTests* list_tests_construct (GType object_type, const gchar* name) {
	ListTests * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	self = (ListTests*) collection_tests_construct (object_type, _tmp0_);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] iterator is ordered", _list_tests_test_iterator_is_ordered_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] list iterator", _list_tests_test_list_iterator_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] duplicates are retained", _list_tests_test_duplicates_are_retained_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] get", _list_tests_test_get_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] set", _list_tests_test_set_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert", _list_tests_test_insert_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] remove_at", _list_tests_test_remove_at_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] index_of", _list_tests_test_index_of_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] first", _list_tests_test_first_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] last", _list_tests_test_last_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] insert_all", _list_tests_test_insert_all_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	gee_test_case_add_test ((GeeTestCase*) self, "[List] slice", _list_tests_test_slice_gee_test_case_test_method, g_object_ref (self), g_object_unref);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void list_tests_test_iterator_is_ordered (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeIterator* iterator = NULL;
	GeeList* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	gboolean _tmp6_;
	gchar** data = NULL;
	gint _tmp7_;
	gchar** _tmp8_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp9_;
	guint* _tmp10_;
	gint idx_length1;
	gint _idx_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	guint* _tmp15_;
	gint _tmp15__length1;
	GeeList* _tmp21_;
	GeeIterator* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	guint* _tmp30_;
	gint _tmp30__length1;
	GeeIterator* _tmp39_;
	gboolean _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = test_list;
	_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
	iterator = _tmp4_;
	_tmp5_ = iterator;
	_tmp6_ = gee_iterator_next (_tmp5_);
	_vala_assert (!_tmp6_, "! iterator.next ()");
	_tmp8_ = test_data_get_data (&_tmp7_);
	data = _tmp8_;
	data_length1 = _tmp7_;
	_data_size_ = data_length1;
	_tmp10_ = test_data_get_drawn_numbers (&_tmp9_);
	idx = _tmp10_;
	idx_length1 = _tmp9_;
	_idx_size_ = idx_length1;
	_tmp11_ = data;
	_tmp11__length1 = data_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp11_;
		s_collection_length1 = _tmp11__length1;
		for (s_it = 0; s_it < _tmp11__length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				GeeList* _tmp12_;
				const gchar* _tmp13_;
				gboolean _tmp14_;
				_tmp12_ = test_list;
				_tmp13_ = s;
				_tmp14_ = gee_collection_add ((GeeCollection*) _tmp12_, _tmp13_);
				_vala_assert (_tmp14_, "test_list.add (s)");
			}
		}
	}
	_tmp15_ = idx;
	_tmp15__length1 = idx_length1;
	{
		guint* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp15_;
		i_collection_length1 = _tmp15__length1;
		for (i_it = 0; i_it < _tmp15__length1; i_it = i_it + 1) {
			guint i = 0U;
			i = i_collection[i_it];
			{
				GeeList* _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				guint _tmp18_;
				const gchar* _tmp19_;
				gboolean _tmp20_;
				_tmp16_ = test_list;
				_tmp17_ = data;
				_tmp17__length1 = data_length1;
				_tmp18_ = i;
				_tmp19_ = _tmp17_[_tmp18_];
				_tmp20_ = gee_collection_add ((GeeCollection*) _tmp16_, _tmp19_);
				_vala_assert (_tmp20_, "test_list.add (data[i])");
			}
		}
	}
	_tmp21_ = test_list;
	_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
	_g_object_unref0 (iterator);
	iterator = _tmp22_;
	_tmp23_ = data;
	_tmp23__length1 = data_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp23_;
		s_collection_length1 = _tmp23__length1;
		for (s_it = 0; s_it < _tmp23__length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				GeeIterator* _tmp24_;
				gboolean _tmp25_;
				GeeIterator* _tmp26_;
				gpointer _tmp27_;
				gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp24_ = iterator;
				_tmp25_ = gee_iterator_next (_tmp24_);
				_vala_assert (_tmp25_, "iterator.next()");
				_tmp26_ = iterator;
				_tmp27_ = gee_iterator_get (_tmp26_);
				_tmp28_ = (gchar*) _tmp27_;
				_tmp29_ = s;
				_vala_assert (g_strcmp0 (_tmp28_, _tmp29_) == 0, "iterator.get () == s");
				_g_free0 (_tmp28_);
			}
		}
	}
	_tmp30_ = idx;
	_tmp30__length1 = idx_length1;
	{
		guint* i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp30_;
		i_collection_length1 = _tmp30__length1;
		for (i_it = 0; i_it < _tmp30__length1; i_it = i_it + 1) {
			guint i = 0U;
			i = i_collection[i_it];
			{
				GeeIterator* _tmp31_;
				gboolean _tmp32_;
				GeeIterator* _tmp33_;
				gpointer _tmp34_;
				gchar* _tmp35_;
				gchar** _tmp36_;
				gint _tmp36__length1;
				guint _tmp37_;
				const gchar* _tmp38_;
				_tmp31_ = iterator;
				_tmp32_ = gee_iterator_next (_tmp31_);
				_vala_assert (_tmp32_, "iterator.next()");
				_tmp33_ = iterator;
				_tmp34_ = gee_iterator_get (_tmp33_);
				_tmp35_ = (gchar*) _tmp34_;
				_tmp36_ = data;
				_tmp36__length1 = data_length1;
				_tmp37_ = i;
				_tmp38_ = _tmp36_[_tmp37_];
				_vala_assert (g_strcmp0 (_tmp35_, _tmp38_) == 0, "iterator.get () == data[i]");
				_g_free0 (_tmp35_);
			}
		}
	}
	_tmp39_ = iterator;
	_tmp40_ = gee_iterator_next (_tmp39_);
	_vala_assert (!_tmp40_, "! iterator.next ()");
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}


void list_tests_test_list_iterator (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeListIterator* iterator = NULL;
	GeeListIterator* _tmp2_;
	GeeListIterator* _tmp3_;
	gboolean _tmp4_;
	GeeListIterator* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GeeListIterator* _tmp10_;
	GeeListIterator* _tmp11_;
	gboolean _tmp12_;
	GeeListIterator* _tmp13_;
	gpointer _tmp14_;
	gchar* _tmp15_;
	GeeListIterator* _tmp16_;
	gint _tmp17_;
	GeeListIterator* _tmp18_;
	GeeListIterator* _tmp19_;
	gboolean _tmp20_;
	GeeListIterator* _tmp21_;
	gpointer _tmp22_;
	gchar* _tmp23_;
	GeeListIterator* _tmp24_;
	gint _tmp25_;
	GeeListIterator* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GeeListIterator* _tmp29_;
	gint _tmp30_;
	GeeListIterator* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GeeListIterator* _tmp34_;
	gint _tmp35_;
	GeeListIterator* _tmp36_;
	gboolean _tmp37_;
	GeeListIterator* _tmp38_;
	gpointer _tmp39_;
	gchar* _tmp40_;
	GeeListIterator* _tmp41_;
	gint _tmp42_;
	GeeListIterator* _tmp43_;
	GeeListIterator* _tmp44_;
	gboolean _tmp45_;
	GeeListIterator* _tmp46_;
	gboolean _tmp47_;
	GeeListIterator* _tmp48_;
	GeeListIterator* _tmp49_;
	gboolean _tmp50_;
	GeeListIterator* _tmp51_;
	gpointer _tmp52_;
	gchar* _tmp53_;
	GeeListIterator* _tmp54_;
	gint _tmp55_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_vala_assert (test_list != NULL, "test_list != null");
	_tmp2_ = gee_list_list_iterator (test_list);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_tmp4_ = gee_iterator_has_next ((GeeIterator*) _tmp3_);
	_vala_assert (!_tmp4_, "! iterator.has_next ()");
	_tmp5_ = iterator;
	_tmp6_ = gee_iterator_next ((GeeIterator*) _tmp5_);
	_vala_assert (!_tmp6_, "! iterator.next ()");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp7_, "test_list.add (\"one\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_list, "two");
	_vala_assert (_tmp8_, "test_list.add (\"two\")");
	_tmp9_ = gee_collection_add ((GeeCollection*) test_list, "three");
	_vala_assert (_tmp9_, "test_list.add (\"three\")");
	_tmp10_ = gee_list_list_iterator (test_list);
	_g_object_unref0 (iterator);
	iterator = _tmp10_;
	_tmp11_ = iterator;
	_tmp12_ = gee_iterator_next ((GeeIterator*) _tmp11_);
	_vala_assert (_tmp12_, "iterator.next()");
	_tmp13_ = iterator;
	_tmp14_ = gee_iterator_get ((GeeIterator*) _tmp13_);
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp15_);
	_tmp16_ = iterator;
	_tmp17_ = gee_list_iterator_index (_tmp16_);
	_vala_assert (_tmp17_ == 0, "iterator.index () == 0");
	_tmp18_ = iterator;
	gee_list_iterator_set (_tmp18_, "new one");
	_tmp19_ = iterator;
	_tmp20_ = gee_iterator_next ((GeeIterator*) _tmp19_);
	_vala_assert (_tmp20_, "iterator.next()");
	_tmp21_ = iterator;
	_tmp22_ = gee_iterator_get ((GeeIterator*) _tmp21_);
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "two") == 0, "iterator.get () == \"two\"");
	_g_free0 (_tmp23_);
	_tmp24_ = iterator;
	_tmp25_ = gee_list_iterator_index (_tmp24_);
	_vala_assert (_tmp25_ == 1, "iterator.index () == 1");
	_tmp26_ = iterator;
	gee_list_iterator_set (_tmp26_, "new two");
	_tmp27_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_ == 3, "test_list.size == 3");
	_tmp29_ = iterator;
	_tmp30_ = gee_list_iterator_index (_tmp29_);
	_vala_assert (_tmp30_ == 1, "iterator.index () == 1");
	_tmp31_ = iterator;
	gee_list_iterator_add (_tmp31_, "after two");
	_tmp32_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp33_ = _tmp32_;
	_vala_assert (_tmp33_ == 4, "test_list.size == 4");
	_tmp34_ = iterator;
	_tmp35_ = gee_list_iterator_index (_tmp34_);
	_vala_assert (_tmp35_ == 2, "iterator.index () == 2");
	_tmp36_ = iterator;
	_tmp37_ = gee_iterator_next ((GeeIterator*) _tmp36_);
	_vala_assert (_tmp37_, "iterator.next()");
	_tmp38_ = iterator;
	_tmp39_ = gee_iterator_get ((GeeIterator*) _tmp38_);
	_tmp40_ = (gchar*) _tmp39_;
	_vala_assert (g_strcmp0 (_tmp40_, "three") == 0, "iterator.get () == \"three\"");
	_g_free0 (_tmp40_);
	_tmp41_ = iterator;
	_tmp42_ = gee_list_iterator_index (_tmp41_);
	_vala_assert (_tmp42_ == 3, "iterator.index () == 3");
	_tmp43_ = iterator;
	gee_list_iterator_set (_tmp43_, "new three");
	_tmp44_ = iterator;
	_tmp45_ = gee_iterator_has_next ((GeeIterator*) _tmp44_);
	_vala_assert (!_tmp45_, "! iterator.has_next ()");
	_tmp46_ = iterator;
	_tmp47_ = gee_iterator_next ((GeeIterator*) _tmp46_);
	_vala_assert (!_tmp47_, "! iterator.next ()");
	_tmp48_ = gee_list_list_iterator (test_list);
	_g_object_unref0 (iterator);
	iterator = _tmp48_;
	_tmp49_ = iterator;
	_tmp50_ = gee_iterator_next ((GeeIterator*) _tmp49_);
	_vala_assert (_tmp50_, "iterator.next ()");
	_tmp51_ = iterator;
	_tmp52_ = gee_iterator_get ((GeeIterator*) _tmp51_);
	_tmp53_ = (gchar*) _tmp52_;
	_vala_assert (g_strcmp0 (_tmp53_, "new one") == 0, "iterator.get () == \"new one\"");
	_g_free0 (_tmp53_);
	_tmp54_ = iterator;
	_tmp55_ = gee_list_iterator_index (_tmp54_);
	_vala_assert (_tmp55_ == 0, "iterator.index () == 0");
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_list);
}


static void list_tests_real_test_duplicates_are_retained (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_vala_assert (test_list != NULL, "test_list != null");
	_tmp2_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp2_, "test_list.add (\"one\")");
	_tmp3_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp3_, "test_list.contains (\"one\")");
	_tmp4_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 1, "test_list.size == 1");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp6_, "test_list.add (\"one\")");
	_tmp7_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp7_, "test_list.contains (\"one\")");
	_tmp8_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ == 2, "test_list.size == 2");
	_tmp10_ = gee_collection_add ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp10_, "test_list.add (\"one\")");
	_tmp11_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp11_, "test_list.contains (\"one\")");
	_tmp12_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp13_ == 3, "test_list.size == 3");
	_tmp14_ = gee_collection_remove ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp14_, "test_list.remove (\"one\")");
	_tmp15_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp15_, "test_list.contains (\"one\")");
	_tmp16_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp17_ == 2, "test_list.size == 2");
	_tmp18_ = gee_collection_remove ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp18_, "test_list.remove (\"one\")");
	_tmp19_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp19_, "test_list.contains (\"one\")");
	_tmp20_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp21_ = _tmp20_;
	_vala_assert (_tmp21_ == 1, "test_list.size == 1");
	_tmp22_ = gee_collection_remove ((GeeCollection*) test_list, "one");
	_vala_assert (_tmp22_, "test_list.remove (\"one\")");
	_tmp23_ = gee_collection_contains ((GeeCollection*) test_list, "one");
	_vala_assert (!_tmp23_, "!test_list.contains (\"one\")");
	_tmp24_ = gee_collection_get_size ((GeeCollection*) test_list);
	_tmp25_ = _tmp24_;
	_vala_assert (_tmp25_ == 0, "test_list.size == 0");
	_g_object_unref0 (test_list);
}


void list_tests_test_duplicates_are_retained (ListTests* self) {
	g_return_if_fail (self != NULL);
	LIST_TESTS_GET_CLASS (self)->test_duplicates_are_retained (self);
}


void list_tests_test_get (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	gchar** data = NULL;
	gint _tmp2_;
	gchar** _tmp3_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp4_;
	guint* _tmp5_;
	gint idx_length1;
	gint _idx_size_;
	GeeList* _tmp6_;
	gboolean _tmp7_;
	GeeList* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	GeeList* _tmp15_;
	gpointer _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp24_;
	guint* _tmp37_;
	gint _tmp37__length1;
	GeeList* _tmp45_;
	gboolean _tmp46_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp3_ = test_data_get_data (&_tmp2_);
	data = _tmp3_;
	data_length1 = _tmp2_;
	_data_size_ = data_length1;
	_tmp5_ = test_data_get_drawn_numbers (&_tmp4_);
	idx = _tmp5_;
	idx_length1 = _tmp4_;
	_idx_size_ = idx_length1;
	_tmp6_ = test_list;
	_vala_assert (_tmp6_ != NULL, "test_list != null");
	_tmp7_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp7_) {
		GeeList* _tmp8_;
		gpointer _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = test_list;
		_tmp9_ = gee_list_get (_tmp8_, 0);
		_tmp10_ = (gchar*) _tmp9_;
		_g_free0 (_tmp10_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp11_ = test_list;
	_tmp12_ = data;
	_tmp12__length1 = data_length1;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = gee_collection_add ((GeeCollection*) _tmp11_, _tmp13_);
	_vala_assert (_tmp14_, "test_list.add (data[0])");
	_tmp15_ = test_list;
	_tmp16_ = gee_list_get (_tmp15_, 0);
	_tmp17_ = (gchar*) _tmp16_;
	_tmp18_ = data;
	_tmp18__length1 = data_length1;
	_tmp19_ = _tmp18_[0];
	_vala_assert (g_strcmp0 (_tmp17_, _tmp19_) == 0, "test_list.get (0) == data[0]");
	_g_free0 (_tmp17_);
	_tmp20_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp20_) {
		GeeList* _tmp21_;
		gpointer _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = test_list;
		_tmp22_ = gee_list_get (_tmp21_, 1);
		_tmp23_ = (gchar*) _tmp22_;
		_g_free0 (_tmp23_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp24_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp24_) {
		GeeList* _tmp25_;
		gpointer _tmp26_;
		gchar* _tmp27_;
		_tmp25_ = test_list;
		_tmp26_ = gee_list_get (_tmp25_, -1);
		_tmp27_ = (gchar*) _tmp26_;
		_g_free0 (_tmp27_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				gint _tmp30_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				GeeList* _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				gint _tmp34_;
				const gchar* _tmp35_;
				gboolean _tmp36_;
				if (!_tmp28_) {
					gint _tmp29_;
					_tmp29_ = i;
					i = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp30_ = i;
				_tmp31_ = data;
				_tmp31__length1 = data_length1;
				if (!(_tmp30_ < _tmp31__length1)) {
					break;
				}
				_tmp32_ = test_list;
				_tmp33_ = data;
				_tmp33__length1 = data_length1;
				_tmp34_ = i;
				_tmp35_ = _tmp33_[_tmp34_];
				_tmp36_ = gee_collection_add ((GeeCollection*) _tmp32_, _tmp35_);
				_vala_assert (_tmp36_, "test_list.add (data[i])");
			}
		}
	}
	_tmp37_ = idx;
	_tmp37__length1 = idx_length1;
	{
		guint* j_collection = NULL;
		gint j_collection_length1 = 0;
		gint _j_collection_size_ = 0;
		gint j_it = 0;
		j_collection = _tmp37_;
		j_collection_length1 = _tmp37__length1;
		for (j_it = 0; j_it < _tmp37__length1; j_it = j_it + 1) {
			guint j = 0U;
			j = j_collection[j_it];
			{
				GeeList* _tmp38_;
				guint _tmp39_;
				gpointer _tmp40_;
				gchar* _tmp41_;
				gchar** _tmp42_;
				gint _tmp42__length1;
				guint _tmp43_;
				const gchar* _tmp44_;
				_tmp38_ = test_list;
				_tmp39_ = j;
				_tmp40_ = gee_list_get (_tmp38_, (gint) _tmp39_);
				_tmp41_ = (gchar*) _tmp40_;
				_tmp42_ = data;
				_tmp42__length1 = data_length1;
				_tmp43_ = j;
				_tmp44_ = _tmp42_[_tmp43_];
				_vala_assert (g_strcmp0 (_tmp41_, _tmp44_) == 0, "test_list.get ((int)j) == data[j]");
				_g_free0 (_tmp41_);
			}
		}
	}
	_tmp45_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp45_);
	_tmp46_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp46_) {
		GeeList* _tmp47_;
		gpointer _tmp48_;
		gchar* _tmp49_;
		_tmp47_ = test_list;
		_tmp48_ = gee_list_get (_tmp47_, 0);
		_tmp49_ = (gchar*) _tmp48_;
		_g_free0 (_tmp49_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_set (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeList* _tmp11_;
	gboolean _tmp12_;
	GeeList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeList* _tmp16_;
	gpointer _tmp17_;
	gchar* _tmp18_;
	GeeList* _tmp19_;
	GeeList* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeList* _tmp23_;
	gpointer _tmp24_;
	gchar* _tmp25_;
	GeeList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gboolean _tmp29_;
	GeeList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = test_list;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 0, "test_list.size == 0");
	_tmp6_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp6_) {
		GeeList* _tmp7_;
		_tmp7_ = test_list;
		gee_list_set (_tmp7_, 0, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp8_ = test_list;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_assert (_tmp10_ == 0, "test_list.size == 0");
	_tmp11_ = test_list;
	_tmp12_ = gee_collection_add ((GeeCollection*) _tmp11_, "one");
	_vala_assert (_tmp12_, "test_list.add (\"one\")");
	_tmp13_ = test_list;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_ == 1, "test_list.size == 1");
	_tmp16_ = test_list;
	_tmp17_ = gee_list_get (_tmp16_, 0);
	_tmp18_ = (gchar*) _tmp17_;
	_vala_assert (g_strcmp0 (_tmp18_, "one") == 0, "test_list.get (0) == \"one\"");
	_g_free0 (_tmp18_);
	_tmp19_ = test_list;
	gee_list_set (_tmp19_, 0, "two");
	_tmp20_ = test_list;
	_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	_vala_assert (_tmp22_ == 1, "test_list.size == 1");
	_tmp23_ = test_list;
	_tmp24_ = gee_list_get (_tmp23_, 0);
	_tmp25_ = (gchar*) _tmp24_;
	_vala_assert (g_strcmp0 (_tmp25_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp25_);
	_tmp26_ = test_list;
	_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_ == 1, "test_list.size == 1");
	_tmp29_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp29_) {
		GeeList* _tmp30_;
		_tmp30_ = test_list;
		gee_list_set (_tmp30_, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp31_ = test_list;
	_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	_vala_assert (_tmp33_ == 1, "test_list.size == 1");
	_g_object_unref0 (test_list);
}


void list_tests_test_insert (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gboolean _tmp3_;
	GeeList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GeeList* _tmp12_;
	gpointer _tmp13_;
	gchar* _tmp14_;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	gpointer _tmp17_;
	gchar* _tmp18_;
	GeeList* _tmp19_;
	gpointer _tmp20_;
	gchar* _tmp21_;
	GeeList* _tmp22_;
	GeeList* _tmp23_;
	gpointer _tmp24_;
	gchar* _tmp25_;
	GeeList* _tmp26_;
	gpointer _tmp27_;
	gchar* _tmp28_;
	GeeList* _tmp29_;
	gpointer _tmp30_;
	gchar* _tmp31_;
	gboolean _tmp32_;
	GeeList* _tmp34_;
	GeeList* _tmp35_;
	gpointer _tmp36_;
	gchar* _tmp37_;
	GeeList* _tmp38_;
	gpointer _tmp39_;
	gchar* _tmp40_;
	GeeList* _tmp41_;
	gpointer _tmp42_;
	gchar* _tmp43_;
	GeeList* _tmp44_;
	gpointer _tmp45_;
	gchar* _tmp46_;
	gboolean _tmp47_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_;
		_tmp4_ = test_list;
		gee_list_insert (_tmp4_, 1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = test_list;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_ == 0, "test_list.size == 0");
	_tmp8_ = test_list;
	gee_list_insert (_tmp8_, 0, "one");
	_tmp9_ = test_list;
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	_vala_assert (_tmp11_ == 1, "test_list.size == 1");
	_tmp12_ = test_list;
	_tmp13_ = gee_list_get (_tmp12_, 0);
	_tmp14_ = (gchar*) _tmp13_;
	_vala_assert (g_strcmp0 (_tmp14_, "one") == 0, "test_list.get (0) == \"one\"");
	_g_free0 (_tmp14_);
	_tmp15_ = test_list;
	gee_list_insert (_tmp15_, 0, "two");
	_tmp16_ = test_list;
	_tmp17_ = gee_list_get (_tmp16_, 0);
	_tmp18_ = (gchar*) _tmp17_;
	_vala_assert (g_strcmp0 (_tmp18_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp18_);
	_tmp19_ = test_list;
	_tmp20_ = gee_list_get (_tmp19_, 1);
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp21_);
	_tmp22_ = test_list;
	gee_list_insert (_tmp22_, 1, "three");
	_tmp23_ = test_list;
	_tmp24_ = gee_list_get (_tmp23_, 0);
	_tmp25_ = (gchar*) _tmp24_;
	_vala_assert (g_strcmp0 (_tmp25_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp25_);
	_tmp26_ = test_list;
	_tmp27_ = gee_list_get (_tmp26_, 1);
	_tmp28_ = (gchar*) _tmp27_;
	_vala_assert (g_strcmp0 (_tmp28_, "three") == 0, "test_list.get (1) == \"three\"");
	_g_free0 (_tmp28_);
	_tmp29_ = test_list;
	_tmp30_ = gee_list_get (_tmp29_, 2);
	_tmp31_ = (gchar*) _tmp30_;
	_vala_assert (g_strcmp0 (_tmp31_, "one") == 0, "test_list.get (2) == \"one\"");
	_g_free0 (_tmp31_);
	_tmp32_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp32_) {
		GeeList* _tmp33_;
		_tmp33_ = test_list;
		gee_list_insert (_tmp33_, 4, "four");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp34_ = test_list;
	gee_list_insert (_tmp34_, 3, "four");
	_tmp35_ = test_list;
	_tmp36_ = gee_list_get (_tmp35_, 0);
	_tmp37_ = (gchar*) _tmp36_;
	_vala_assert (g_strcmp0 (_tmp37_, "two") == 0, "test_list.get (0) == \"two\"");
	_g_free0 (_tmp37_);
	_tmp38_ = test_list;
	_tmp39_ = gee_list_get (_tmp38_, 1);
	_tmp40_ = (gchar*) _tmp39_;
	_vala_assert (g_strcmp0 (_tmp40_, "three") == 0, "test_list.get (1) == \"three\"");
	_g_free0 (_tmp40_);
	_tmp41_ = test_list;
	_tmp42_ = gee_list_get (_tmp41_, 2);
	_tmp43_ = (gchar*) _tmp42_;
	_vala_assert (g_strcmp0 (_tmp43_, "one") == 0, "test_list.get (2) == \"one\"");
	_g_free0 (_tmp43_);
	_tmp44_ = test_list;
	_tmp45_ = gee_list_get (_tmp44_, 3);
	_tmp46_ = (gchar*) _tmp45_;
	_vala_assert (g_strcmp0 (_tmp46_, "four") == 0, "test_list.get (3) == \"four\"");
	_g_free0 (_tmp46_);
	_tmp47_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp47_) {
		GeeList* _tmp48_;
		_tmp48_ = test_list;
		gee_list_insert (_tmp48_, -1, "zero");
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_remove_at (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp7_;
	gchar** data = NULL;
	gint _tmp11_;
	gchar** _tmp12_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp13_;
	guint* _tmp14_;
	gint idx_length1;
	gint _idx_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GeeList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GeeList* _tmp23_;
	gpointer _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	const gchar* _tmp27_;
	GeeList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	GeeList* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	gpointer _tmp45_;
	gchar* _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	gchar** _tmp48_;
	gint _tmp48__length1;
	const gchar* _tmp49_;
	GeeList* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gchar** _tmp53_;
	gint _tmp53__length1;
	guint expected_size = 0U;
	gchar** _tmp65_;
	gint _tmp65__length1;
	gint current_idx = 0;
	GeeList* _tmp134_;
	gint _tmp135_;
	gint _tmp136_;
	gint _tmp137_;
	gboolean _tmp138_;
	gboolean _tmp143_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_;
		gpointer _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = test_list;
		_tmp5_ = gee_list_remove_at (_tmp4_, 0);
		_tmp6_ = (gchar*) _tmp5_;
		_g_free0 (_tmp6_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp7_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp7_) {
		GeeList* _tmp8_;
		gpointer _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = test_list;
		_tmp9_ = gee_list_remove_at (_tmp8_, 1);
		_tmp10_ = (gchar*) _tmp9_;
		_g_free0 (_tmp10_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp12_ = test_data_get_data (&_tmp11_);
	data = _tmp12_;
	data_length1 = _tmp11_;
	_data_size_ = data_length1;
	_tmp14_ = test_data_get_drawn_numbers (&_tmp13_);
	idx = _tmp14_;
	idx_length1 = _tmp13_;
	_idx_size_ = idx_length1;
	_tmp15_ = data;
	_tmp15__length1 = data_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp15_;
		s_collection_length1 = _tmp15__length1;
		for (s_it = 0; s_it < _tmp15__length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				GeeList* _tmp16_;
				const gchar* _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = test_list;
				_tmp17_ = s;
				_tmp18_ = gee_collection_add ((GeeCollection*) _tmp16_, _tmp17_);
				_vala_assert (_tmp18_, "test_list.add (s)");
			}
		}
	}
	_tmp19_ = test_list;
	_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = data;
	_tmp22__length1 = data_length1;
	_vala_assert (_tmp21_ == _tmp22__length1, "test_list.size == data.length");
	_tmp23_ = test_list;
	_tmp24_ = gee_list_remove_at (_tmp23_, 0);
	_tmp25_ = (gchar*) _tmp24_;
	_tmp26_ = data;
	_tmp26__length1 = data_length1;
	_tmp27_ = _tmp26_[0];
	_vala_assert (g_strcmp0 (_tmp25_, _tmp27_) == 0, "test_list.remove_at (0) == data[0]");
	_g_free0 (_tmp25_);
	_tmp28_ = test_list;
	_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = data;
	_tmp31__length1 = data_length1;
	_vala_assert (_tmp30_ == (_tmp31__length1 - 1), "test_list.size == data.length - 1");
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				GeeList* _tmp36_;
				gint _tmp37_;
				gpointer _tmp38_;
				gchar* _tmp39_;
				gchar** _tmp40_;
				gint _tmp40__length1;
				gint _tmp41_;
				const gchar* _tmp42_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				_tmp35_ = data;
				_tmp35__length1 = data_length1;
				if (!(_tmp34_ < (_tmp35__length1 - 1))) {
					break;
				}
				_tmp36_ = test_list;
				_tmp37_ = i;
				_tmp38_ = gee_list_get (_tmp36_, _tmp37_ - 1);
				_tmp39_ = (gchar*) _tmp38_;
				_tmp40_ = data;
				_tmp40__length1 = data_length1;
				_tmp41_ = i;
				_tmp42_ = _tmp40_[_tmp41_];
				_vala_assert (g_strcmp0 (_tmp39_, _tmp42_) == 0, "test_list.get (i - 1) == data[i]");
				_g_free0 (_tmp39_);
			}
		}
	}
	_tmp43_ = test_list;
	_tmp44_ = data;
	_tmp44__length1 = data_length1;
	_tmp45_ = gee_list_remove_at (_tmp43_, _tmp44__length1 - 2);
	_tmp46_ = (gchar*) _tmp45_;
	_tmp47_ = data;
	_tmp47__length1 = data_length1;
	_tmp48_ = data;
	_tmp48__length1 = data_length1;
	_tmp49_ = _tmp47_[_tmp48__length1 - 1];
	_vala_assert (g_strcmp0 (_tmp46_, _tmp49_) == 0, "test_list.remove_at (data.length - 2) == data[data.length - 1]");
	_g_free0 (_tmp46_);
	_tmp50_ = test_list;
	_tmp51_ = gee_collection_get_size ((GeeCollection*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = data;
	_tmp53__length1 = data_length1;
	_vala_assert (_tmp52_ == (_tmp53__length1 - 2), "test_list.size == data.length - 2");
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp54_ = FALSE;
			_tmp54_ = TRUE;
			while (TRUE) {
				gint _tmp56_;
				gchar** _tmp57_;
				gint _tmp57__length1;
				GeeList* _tmp58_;
				gint _tmp59_;
				gpointer _tmp60_;
				gchar* _tmp61_;
				gchar** _tmp62_;
				gint _tmp62__length1;
				gint _tmp63_;
				const gchar* _tmp64_;
				if (!_tmp54_) {
					gint _tmp55_;
					_tmp55_ = i;
					i = _tmp55_ + 1;
				}
				_tmp54_ = FALSE;
				_tmp56_ = i;
				_tmp57_ = data;
				_tmp57__length1 = data_length1;
				if (!(_tmp56_ < (_tmp57__length1 - 2))) {
					break;
				}
				_tmp58_ = test_list;
				_tmp59_ = i;
				_tmp60_ = gee_list_get (_tmp58_, _tmp59_ - 1);
				_tmp61_ = (gchar*) _tmp60_;
				_tmp62_ = data;
				_tmp62__length1 = data_length1;
				_tmp63_ = i;
				_tmp64_ = _tmp62_[_tmp63_];
				_vala_assert (g_strcmp0 (_tmp61_, _tmp64_) == 0, "test_list.get (i - 1) == data[i]");
				_g_free0 (_tmp61_);
			}
		}
	}
	_tmp65_ = data;
	_tmp65__length1 = data_length1;
	expected_size = (guint) (_tmp65__length1 - 2);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp66_ = FALSE;
			_tmp66_ = TRUE;
			while (TRUE) {
				guint _tmp68_;
				guint* _tmp69_;
				gint _tmp69__length1;
				gint to_remove = 0;
				guint* _tmp70_;
				gint _tmp70__length1;
				guint _tmp71_;
				guint _tmp72_;
				gboolean _tmp73_ = FALSE;
				guint* _tmp74_;
				gint _tmp74__length1;
				guint _tmp75_;
				guint _tmp76_;
				gchar** _tmp77_;
				gint _tmp77__length1;
				GeeList* _tmp100_;
				gint _tmp101_;
				gpointer _tmp102_;
				gchar* _tmp103_;
				gchar** _tmp104_;
				gint _tmp104__length1;
				guint* _tmp105_;
				gint _tmp105__length1;
				guint _tmp106_;
				guint _tmp107_;
				const gchar* _tmp108_;
				GeeList* _tmp109_;
				gint _tmp110_;
				gint _tmp111_;
				guint _tmp112_;
				guint _tmp113_;
				if (!_tmp66_) {
					guint _tmp67_;
					_tmp67_ = i;
					i = _tmp67_ + 1;
				}
				_tmp66_ = FALSE;
				_tmp68_ = i;
				_tmp69_ = idx;
				_tmp69__length1 = idx_length1;
				if (!(_tmp68_ < ((guint) _tmp69__length1))) {
					break;
				}
				_tmp70_ = idx;
				_tmp70__length1 = idx_length1;
				_tmp71_ = i;
				_tmp72_ = _tmp70_[_tmp71_];
				to_remove = ((gint) _tmp72_) - 1;
				_tmp74_ = idx;
				_tmp74__length1 = idx_length1;
				_tmp75_ = i;
				_tmp76_ = _tmp74_[_tmp75_];
				_tmp77_ = data;
				_tmp77__length1 = data_length1;
				if (_tmp76_ == ((guint) (_tmp77__length1 - 1))) {
					_tmp73_ = TRUE;
				} else {
					guint* _tmp78_;
					gint _tmp78__length1;
					guint _tmp79_;
					guint _tmp80_;
					_tmp78_ = idx;
					_tmp78__length1 = idx_length1;
					_tmp79_ = i;
					_tmp80_ = _tmp78_[_tmp79_];
					_tmp73_ = _tmp80_ == ((guint) 0);
				}
				if (_tmp73_) {
					continue;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp81_ = FALSE;
						_tmp81_ = TRUE;
						while (TRUE) {
							guint _tmp83_;
							guint _tmp84_;
							guint* _tmp85_;
							gint _tmp85__length1;
							guint _tmp86_;
							guint _tmp87_;
							guint* _tmp88_;
							gint _tmp88__length1;
							guint _tmp89_;
							guint _tmp90_;
							if (!_tmp81_) {
								guint _tmp82_;
								_tmp82_ = j;
								j = _tmp82_ + 1;
							}
							_tmp81_ = FALSE;
							_tmp83_ = j;
							_tmp84_ = i;
							if (!(_tmp83_ < _tmp84_)) {
								break;
							}
							_tmp85_ = idx;
							_tmp85__length1 = idx_length1;
							_tmp86_ = j;
							_tmp87_ = _tmp85_[_tmp86_];
							_tmp88_ = idx;
							_tmp88__length1 = idx_length1;
							_tmp89_ = i;
							_tmp90_ = _tmp88_[_tmp89_];
							if (_tmp87_ < _tmp90_) {
								gboolean _tmp91_ = FALSE;
								guint* _tmp92_;
								gint _tmp92__length1;
								guint _tmp93_;
								guint _tmp94_;
								gchar** _tmp95_;
								gint _tmp95__length1;
								gint _tmp99_;
								_tmp92_ = idx;
								_tmp92__length1 = idx_length1;
								_tmp93_ = j;
								_tmp94_ = _tmp92_[_tmp93_];
								_tmp95_ = data;
								_tmp95__length1 = data_length1;
								if (_tmp94_ == ((guint) (_tmp95__length1 - 1))) {
									_tmp91_ = TRUE;
								} else {
									guint* _tmp96_;
									gint _tmp96__length1;
									guint _tmp97_;
									guint _tmp98_;
									_tmp96_ = idx;
									_tmp96__length1 = idx_length1;
									_tmp97_ = j;
									_tmp98_ = _tmp96_[_tmp97_];
									_tmp91_ = _tmp98_ == ((guint) 0);
								}
								if (_tmp91_) {
									continue;
								}
								_tmp99_ = to_remove;
								to_remove = _tmp99_ - 1;
							}
						}
					}
				}
				_tmp100_ = test_list;
				_tmp101_ = to_remove;
				_tmp102_ = gee_list_remove_at (_tmp100_, _tmp101_);
				_tmp103_ = (gchar*) _tmp102_;
				_tmp104_ = data;
				_tmp104__length1 = data_length1;
				_tmp105_ = idx;
				_tmp105__length1 = idx_length1;
				_tmp106_ = i;
				_tmp107_ = _tmp105_[_tmp106_];
				_tmp108_ = _tmp104_[_tmp107_];
				_vala_assert (g_strcmp0 (_tmp103_, _tmp108_) == 0, "test_list.remove_at (to_remove) == data[idx[i]]");
				_g_free0 (_tmp103_);
				_tmp109_ = test_list;
				_tmp110_ = gee_collection_get_size ((GeeCollection*) _tmp109_);
				_tmp111_ = _tmp110_;
				_tmp112_ = expected_size;
				expected_size = _tmp112_ - 1;
				_tmp113_ = expected_size;
				_vala_assert (((guint) _tmp111_) == _tmp113_, "test_list.size == --expected_size");
			}
		}
	}
	current_idx = 0;
	{
		guint i = 0U;
		i = (guint) 1;
		{
			gboolean _tmp114_ = FALSE;
			_tmp114_ = TRUE;
			while (TRUE) {
				guint _tmp116_;
				gchar** _tmp117_;
				gint _tmp117__length1;
				gboolean skip = FALSE;
				gboolean _tmp126_;
				GeeList* _tmp127_;
				gint _tmp128_;
				gpointer _tmp129_;
				gchar* _tmp130_;
				gchar** _tmp131_;
				gint _tmp131__length1;
				guint _tmp132_;
				const gchar* _tmp133_;
				if (!_tmp114_) {
					guint _tmp115_;
					_tmp115_ = i;
					i = _tmp115_ + 1;
				}
				_tmp114_ = FALSE;
				_tmp116_ = i;
				_tmp117_ = data;
				_tmp117__length1 = data_length1;
				if (!(_tmp116_ < ((guint) (_tmp117__length1 - 1)))) {
					break;
				}
				skip = FALSE;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp118_ = FALSE;
						_tmp118_ = TRUE;
						while (TRUE) {
							gint _tmp120_;
							guint* _tmp121_;
							gint _tmp121__length1;
							guint _tmp122_;
							guint* _tmp123_;
							gint _tmp123__length1;
							gint _tmp124_;
							guint _tmp125_;
							if (!_tmp118_) {
								gint _tmp119_;
								_tmp119_ = j;
								j = _tmp119_ + 1;
							}
							_tmp118_ = FALSE;
							_tmp120_ = j;
							_tmp121_ = idx;
							_tmp121__length1 = idx_length1;
							if (!(_tmp120_ < _tmp121__length1)) {
								break;
							}
							_tmp122_ = i;
							_tmp123_ = idx;
							_tmp123__length1 = idx_length1;
							_tmp124_ = j;
							_tmp125_ = _tmp123_[_tmp124_];
							if (_tmp122_ == _tmp125_) {
								skip = TRUE;
								break;
							}
						}
					}
				}
				_tmp126_ = skip;
				if (_tmp126_) {
					continue;
				}
				_tmp127_ = test_list;
				_tmp128_ = current_idx;
				current_idx = _tmp128_ + 1;
				_tmp129_ = gee_list_get (_tmp127_, _tmp128_);
				_tmp130_ = (gchar*) _tmp129_;
				_tmp131_ = data;
				_tmp131__length1 = data_length1;
				_tmp132_ = i;
				_tmp133_ = _tmp131_[_tmp132_];
				_vala_assert (g_strcmp0 (_tmp130_, _tmp133_) == 0, "test_list.get(current_idx++) == data[i]");
				_g_free0 (_tmp130_);
			}
		}
	}
	_tmp134_ = test_list;
	_tmp135_ = gee_collection_get_size ((GeeCollection*) _tmp134_);
	_tmp136_ = _tmp135_;
	_tmp137_ = current_idx;
	_vala_assert (_tmp136_ == _tmp137_, "test_list.size == current_idx");
	_tmp138_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp138_) {
		GeeList* _tmp139_;
		gint _tmp140_;
		gpointer _tmp141_;
		gchar* _tmp142_;
		_tmp139_ = test_list;
		_tmp140_ = current_idx;
		_tmp141_ = gee_list_remove_at (_tmp139_, _tmp140_);
		_tmp142_ = (gchar*) _tmp141_;
		_g_free0 (_tmp142_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp143_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp143_) {
		GeeList* _tmp144_;
		gpointer _tmp145_;
		gchar* _tmp146_;
		_tmp144_ = test_list;
		_tmp145_ = gee_list_remove_at (_tmp144_, -1);
		_tmp146_ = (gchar*) _tmp145_;
		_g_free0 (_tmp146_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_index_of (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	gchar** data = NULL;
	gint _tmp2_;
	gchar** _tmp3_;
	gint data_length1;
	gint _data_size_;
	guint* idx = NULL;
	gint _tmp4_;
	guint* _tmp5_;
	gint idx_length1;
	gint _idx_size_;
	GeeList* _tmp6_;
	GeeList* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gint _tmp10_;
	GeeList* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	GeeList* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gint _tmp18_;
	GeeList* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	const gchar* _tmp21_;
	gint _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp3_ = test_data_get_data (&_tmp2_);
	data = _tmp3_;
	data_length1 = _tmp2_;
	_data_size_ = data_length1;
	_tmp5_ = test_data_get_drawn_numbers (&_tmp4_);
	idx = _tmp5_;
	idx_length1 = _tmp4_;
	_idx_size_ = idx_length1;
	_tmp6_ = test_list;
	_vala_assert (_tmp6_ != NULL, "test_list != null");
	_tmp7_ = test_list;
	_tmp8_ = data;
	_tmp8__length1 = data_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = gee_list_index_of (_tmp7_, _tmp9_);
	_vala_assert (_tmp10_ == -1, "test_list.index_of (data[0]) == -1");
	_tmp11_ = test_list;
	_tmp12_ = data;
	_tmp12__length1 = data_length1;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = gee_collection_add ((GeeCollection*) _tmp11_, _tmp13_);
	_vala_assert (_tmp14_, "test_list.add (data[0])");
	_tmp15_ = test_list;
	_tmp16_ = data;
	_tmp16__length1 = data_length1;
	_tmp17_ = _tmp16_[0];
	_tmp18_ = gee_list_index_of (_tmp15_, _tmp17_);
	_vala_assert (_tmp18_ == 0, "test_list.index_of (data[0]) == 0");
	_tmp19_ = test_list;
	_tmp20_ = data;
	_tmp20__length1 = data_length1;
	_tmp21_ = _tmp20_[1];
	_tmp22_ = gee_list_index_of (_tmp19_, _tmp21_);
	_vala_assert (_tmp22_ == -1, "test_list.index_of (data[1]) == -1");
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				gint _tmp25_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				GeeList* _tmp27_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				const gchar* _tmp30_;
				gboolean _tmp31_;
				guint* _tmp32_;
				gint _tmp32__length1;
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp25_ = i;
				_tmp26_ = data;
				_tmp26__length1 = data_length1;
				if (!(_tmp25_ < _tmp26__length1)) {
					break;
				}
				_tmp27_ = test_list;
				_tmp28_ = data;
				_tmp28__length1 = data_length1;
				_tmp29_ = i;
				_tmp30_ = _tmp28_[_tmp29_];
				_tmp31_ = gee_collection_add ((GeeCollection*) _tmp27_, _tmp30_);
				_vala_assert (_tmp31_, "test_list.add (data[i])");
				_tmp32_ = idx;
				_tmp32__length1 = idx_length1;
				{
					guint* j_collection = NULL;
					gint j_collection_length1 = 0;
					gint _j_collection_size_ = 0;
					gint j_it = 0;
					j_collection = _tmp32_;
					j_collection_length1 = _tmp32__length1;
					for (j_it = 0; j_it < _tmp32__length1; j_it = j_it + 1) {
						guint j = 0U;
						j = j_collection[j_it];
						{
							guint _tmp33_;
							gint _tmp34_;
							_tmp33_ = j;
							_tmp34_ = i;
							if (_tmp33_ <= ((guint) _tmp34_)) {
								GeeList* _tmp35_;
								gchar** _tmp36_;
								gint _tmp36__length1;
								guint _tmp37_;
								const gchar* _tmp38_;
								gint _tmp39_;
								guint _tmp40_;
								_tmp35_ = test_list;
								_tmp36_ = data;
								_tmp36__length1 = data_length1;
								_tmp37_ = j;
								_tmp38_ = _tmp36_[_tmp37_];
								_tmp39_ = gee_list_index_of (_tmp35_, _tmp38_);
								_tmp40_ = j;
								_vala_assert (((guint) _tmp39_) == _tmp40_, "test_list.index_of (data[j]) == j");
							} else {
								GeeList* _tmp41_;
								gchar** _tmp42_;
								gint _tmp42__length1;
								guint _tmp43_;
								const gchar* _tmp44_;
								gint _tmp45_;
								_tmp41_ = test_list;
								_tmp42_ = data;
								_tmp42__length1 = data_length1;
								_tmp43_ = j;
								_tmp44_ = _tmp42_[_tmp43_];
								_tmp45_ = gee_list_index_of (_tmp41_, _tmp44_);
								_vala_assert (_tmp45_ == -1, "test_list.index_of (data[j]) == -1");
							}
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (test_list);
}


void list_tests_test_first (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gboolean _tmp3_;
	GeeList* _tmp7_;
	gboolean _tmp8_;
	GeeList* _tmp9_;
	gpointer _tmp10_;
	gchar* _tmp11_;
	GeeList* _tmp12_;
	gpointer _tmp13_;
	gchar* _tmp14_;
	GeeList* _tmp15_;
	gpointer _tmp16_;
	gchar* _tmp17_;
	GeeList* _tmp18_;
	gboolean _tmp19_;
	GeeList* _tmp20_;
	gboolean _tmp21_;
	GeeList* _tmp22_;
	gpointer _tmp23_;
	gchar* _tmp24_;
	GeeList* _tmp25_;
	gpointer _tmp26_;
	gchar* _tmp27_;
	GeeList* _tmp28_;
	gpointer _tmp29_;
	gchar* _tmp30_;
	GeeList* _tmp31_;
	gboolean _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_;
		gpointer _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = test_list;
		_tmp5_ = gee_list_first (_tmp4_);
		_tmp6_ = (gchar*) _tmp5_;
		_g_free0 (_tmp6_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp7_ = test_list;
	_tmp8_ = gee_collection_add ((GeeCollection*) _tmp7_, "one");
	_vala_assert (_tmp8_, "test_list.add (\"one\")");
	_tmp9_ = test_list;
	_tmp10_ = gee_list_first (_tmp9_);
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "one") == 0, "test_list.first () == \"one\"");
	_g_free0 (_tmp11_);
	_tmp12_ = test_list;
	_tmp13_ = gee_list_first (_tmp12_);
	_tmp14_ = (gchar*) _tmp13_;
	_tmp15_ = test_list;
	_tmp16_ = gee_list_get (_tmp15_, 0);
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp14_, _tmp17_) == 0, "test_list.first () == test_list.get (0)");
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp18_ = test_list;
	_tmp19_ = gee_collection_add ((GeeCollection*) _tmp18_, "two");
	_vala_assert (_tmp19_, "test_list.add (\"two\")");
	_tmp20_ = test_list;
	_tmp21_ = gee_collection_add ((GeeCollection*) _tmp20_, "three");
	_vala_assert (_tmp21_, "test_list.add (\"three\")");
	_tmp22_ = test_list;
	_tmp23_ = gee_list_first (_tmp22_);
	_tmp24_ = (gchar*) _tmp23_;
	_vala_assert (g_strcmp0 (_tmp24_, "one") == 0, "test_list.first () == \"one\"");
	_g_free0 (_tmp24_);
	_tmp25_ = test_list;
	_tmp26_ = gee_list_first (_tmp25_);
	_tmp27_ = (gchar*) _tmp26_;
	_tmp28_ = test_list;
	_tmp29_ = gee_list_get (_tmp28_, 0);
	_tmp30_ = (gchar*) _tmp29_;
	_vala_assert (g_strcmp0 (_tmp27_, _tmp30_) == 0, "test_list.first () == test_list.get (0)");
	_g_free0 (_tmp30_);
	_g_free0 (_tmp27_);
	_tmp31_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp31_);
	_tmp32_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp32_) {
		GeeList* _tmp33_;
		gpointer _tmp34_;
		gchar* _tmp35_;
		_tmp33_ = test_list;
		_tmp34_ = gee_list_first (_tmp33_);
		_tmp35_ = (gchar*) _tmp34_;
		_g_free0 (_tmp35_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_last (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gboolean _tmp3_;
	GeeList* _tmp7_;
	gboolean _tmp8_;
	GeeList* _tmp9_;
	gpointer _tmp10_;
	gchar* _tmp11_;
	GeeList* _tmp12_;
	gpointer _tmp13_;
	gchar* _tmp14_;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gpointer _tmp19_;
	gchar* _tmp20_;
	GeeList* _tmp21_;
	gboolean _tmp22_;
	GeeList* _tmp23_;
	gboolean _tmp24_;
	GeeList* _tmp25_;
	gpointer _tmp26_;
	gchar* _tmp27_;
	GeeList* _tmp28_;
	gpointer _tmp29_;
	gchar* _tmp30_;
	GeeList* _tmp31_;
	GeeList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gpointer _tmp35_;
	gchar* _tmp36_;
	GeeList* _tmp37_;
	gboolean _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_;
		gpointer _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = test_list;
		_tmp5_ = gee_list_last (_tmp4_);
		_tmp6_ = (gchar*) _tmp5_;
		_g_free0 (_tmp6_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp7_ = test_list;
	_tmp8_ = gee_collection_add ((GeeCollection*) _tmp7_, "one");
	_vala_assert (_tmp8_, "test_list.add (\"one\")");
	_tmp9_ = test_list;
	_tmp10_ = gee_list_last (_tmp9_);
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "one") == 0, "test_list.last () == \"one\"");
	_g_free0 (_tmp11_);
	_tmp12_ = test_list;
	_tmp13_ = gee_list_last (_tmp12_);
	_tmp14_ = (gchar*) _tmp13_;
	_tmp15_ = test_list;
	_tmp16_ = test_list;
	_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_list_get (_tmp15_, _tmp18_ - 1);
	_tmp20_ = (gchar*) _tmp19_;
	_vala_assert (g_strcmp0 (_tmp14_, _tmp20_) == 0, "test_list.last () == test_list.get (test_list.size - 1)");
	_g_free0 (_tmp20_);
	_g_free0 (_tmp14_);
	_tmp21_ = test_list;
	_tmp22_ = gee_collection_add ((GeeCollection*) _tmp21_, "two");
	_vala_assert (_tmp22_, "test_list.add (\"two\")");
	_tmp23_ = test_list;
	_tmp24_ = gee_collection_add ((GeeCollection*) _tmp23_, "three");
	_vala_assert (_tmp24_, "test_list.add (\"three\")");
	_tmp25_ = test_list;
	_tmp26_ = gee_list_last (_tmp25_);
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp27_, "three") == 0, "test_list.last () == \"three\"");
	_g_free0 (_tmp27_);
	_tmp28_ = test_list;
	_tmp29_ = gee_list_last (_tmp28_);
	_tmp30_ = (gchar*) _tmp29_;
	_tmp31_ = test_list;
	_tmp32_ = test_list;
	_tmp33_ = gee_collection_get_size ((GeeCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = gee_list_get (_tmp31_, _tmp34_ - 1);
	_tmp36_ = (gchar*) _tmp35_;
	_vala_assert (g_strcmp0 (_tmp30_, _tmp36_) == 0, "test_list.last () == test_list.get (test_list.size - 1)");
	_g_free0 (_tmp36_);
	_g_free0 (_tmp30_);
	_tmp37_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp37_);
	_tmp38_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp38_) {
		GeeList* _tmp39_;
		gpointer _tmp40_;
		gchar* _tmp41_;
		_tmp39_ = test_list;
		_tmp40_ = gee_list_last (_tmp39_);
		_tmp41_ = (gchar*) _tmp40_;
		_g_free0 (_tmp41_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (test_list);
}


void list_tests_test_insert_all (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeArrayList* dummy = NULL;
	GeeArrayList* _tmp3_;
	GeeList* _tmp4_;
	gboolean _tmp5_;
	GeeList* _tmp6_;
	gboolean _tmp7_;
	GeeList* _tmp8_;
	gboolean _tmp9_;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeArrayList* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GeeList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GeeArrayList* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	GeeList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	gboolean _tmp27_;
	GeeArrayList* _tmp28_;
	gboolean _tmp29_;
	GeeArrayList* _tmp30_;
	gboolean _tmp31_;
	GeeList* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	GeeArrayList* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	GeeList* _tmp38_;
	GeeArrayList* _tmp39_;
	GeeList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GeeArrayList* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	GeeList* _tmp46_;
	GeeArrayList* _tmp47_;
	GeeArrayList* _tmp48_;
	gboolean _tmp49_;
	GeeArrayList* _tmp50_;
	gboolean _tmp51_;
	GeeArrayList* _tmp52_;
	gboolean _tmp53_;
	GeeList* _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	GeeList* _tmp60_;
	GeeArrayList* _tmp61_;
	GeeList* _tmp62_;
	gboolean _tmp63_;
	GeeList* _tmp64_;
	gboolean _tmp65_;
	GeeList* _tmp66_;
	gboolean _tmp67_;
	GeeArrayList* _tmp68_;
	gboolean _tmp69_;
	GeeArrayList* _tmp70_;
	gboolean _tmp71_;
	GeeArrayList* _tmp72_;
	gboolean _tmp73_;
	GeeList* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	GeeArrayList* _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	GeeList* _tmp80_;
	GeeArrayList* _tmp81_;
	GeeList* _tmp82_;
	gint _tmp83_;
	gint _tmp84_;
	GeeArrayList* _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
	GeeList* _tmp88_;
	gpointer _tmp89_;
	gchar* _tmp90_;
	GeeList* _tmp91_;
	gpointer _tmp92_;
	gchar* _tmp93_;
	GeeList* _tmp94_;
	gpointer _tmp95_;
	gchar* _tmp96_;
	GeeList* _tmp97_;
	gpointer _tmp98_;
	gchar* _tmp99_;
	GeeList* _tmp100_;
	gpointer _tmp101_;
	gchar* _tmp102_;
	GeeList* _tmp103_;
	gpointer _tmp104_;
	gchar* _tmp105_;
	GeeList* _tmp106_;
	GeeArrayList* _tmp107_;
	GeeList* _tmp108_;
	gboolean _tmp109_;
	GeeList* _tmp110_;
	gboolean _tmp111_;
	GeeList* _tmp112_;
	gboolean _tmp113_;
	GeeList* _tmp114_;
	gboolean _tmp115_;
	GeeArrayList* _tmp116_;
	gboolean _tmp117_;
	GeeArrayList* _tmp118_;
	gboolean _tmp119_;
	GeeArrayList* _tmp120_;
	gboolean _tmp121_;
	GeeList* _tmp122_;
	gint _tmp123_;
	gint _tmp124_;
	GeeArrayList* _tmp125_;
	gint _tmp126_;
	gint _tmp127_;
	GeeList* _tmp128_;
	GeeArrayList* _tmp129_;
	GeeList* _tmp130_;
	gint _tmp131_;
	gint _tmp132_;
	GeeArrayList* _tmp133_;
	gint _tmp134_;
	gint _tmp135_;
	GeeList* _tmp136_;
	gpointer _tmp137_;
	gchar* _tmp138_;
	GeeList* _tmp139_;
	gpointer _tmp140_;
	gchar* _tmp141_;
	GeeList* _tmp142_;
	gpointer _tmp143_;
	gchar* _tmp144_;
	GeeList* _tmp145_;
	gpointer _tmp146_;
	gchar* _tmp147_;
	GeeList* _tmp148_;
	gpointer _tmp149_;
	gchar* _tmp150_;
	GeeList* _tmp151_;
	gpointer _tmp152_;
	gchar* _tmp153_;
	GeeList* _tmp154_;
	gpointer _tmp155_;
	gchar* _tmp156_;
	GeeList* _tmp157_;
	GeeArrayList* _tmp158_;
	GeeList* _tmp159_;
	gboolean _tmp160_;
	GeeList* _tmp161_;
	gboolean _tmp162_;
	GeeList* _tmp163_;
	gboolean _tmp164_;
	GeeArrayList* _tmp165_;
	gboolean _tmp166_;
	GeeArrayList* _tmp167_;
	gboolean _tmp168_;
	GeeArrayList* _tmp169_;
	gboolean _tmp170_;
	GeeList* _tmp171_;
	gint _tmp172_;
	gint _tmp173_;
	GeeArrayList* _tmp174_;
	gint _tmp175_;
	gint _tmp176_;
	GeeList* _tmp177_;
	GeeArrayList* _tmp178_;
	GeeList* _tmp179_;
	gint _tmp180_;
	gint _tmp181_;
	GeeArrayList* _tmp182_;
	gint _tmp183_;
	gint _tmp184_;
	GeeList* _tmp185_;
	gpointer _tmp186_;
	gchar* _tmp187_;
	GeeList* _tmp188_;
	gpointer _tmp189_;
	gchar* _tmp190_;
	GeeList* _tmp191_;
	gpointer _tmp192_;
	gchar* _tmp193_;
	GeeList* _tmp194_;
	gpointer _tmp195_;
	gchar* _tmp196_;
	GeeList* _tmp197_;
	gpointer _tmp198_;
	gchar* _tmp199_;
	GeeList* _tmp200_;
	gpointer _tmp201_;
	gchar* _tmp202_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	dummy = _tmp3_;
	_tmp4_ = test_list;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "zero");
	_vala_assert (_tmp5_, "test_list.add (\"zero\")");
	_tmp6_ = test_list;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "one");
	_vala_assert (_tmp7_, "test_list.add (\"one\")");
	_tmp8_ = test_list;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "two");
	_vala_assert (_tmp9_, "test_list.add (\"two\")");
	_tmp10_ = test_list;
	_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	_vala_assert (_tmp12_ == 3, "test_list.size == 3");
	_tmp13_ = dummy;
	_tmp14_ = gee_collection_get_is_empty ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_assert (_tmp15_, "dummy.is_empty");
	_tmp16_ = test_list;
	_tmp17_ = dummy;
	gee_list_insert_all (_tmp16_, 0, (GeeCollection*) _tmp17_);
	_tmp18_ = test_list;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_vala_assert (_tmp20_ == 3, "test_list.size == 3");
	_tmp21_ = dummy;
	_tmp22_ = gee_collection_get_is_empty ((GeeCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	_vala_assert (_tmp23_, "dummy.is_empty");
	_tmp24_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp24_);
	_tmp25_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp25_);
	_tmp26_ = dummy;
	_tmp27_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, "zero");
	_vala_assert (_tmp27_, "dummy.add (\"zero\")");
	_tmp28_ = dummy;
	_tmp29_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, "one");
	_vala_assert (_tmp29_, "dummy.add (\"one\")");
	_tmp30_ = dummy;
	_tmp31_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, "two");
	_vala_assert (_tmp31_, "dummy.add (\"two\")");
	_tmp32_ = test_list;
	_tmp33_ = gee_collection_get_is_empty ((GeeCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	_vala_assert (_tmp34_, "test_list.is_empty");
	_tmp35_ = dummy;
	_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
	_tmp37_ = _tmp36_;
	_vala_assert (_tmp37_ == 3, "dummy.size == 3");
	_tmp38_ = test_list;
	_tmp39_ = dummy;
	gee_list_insert_all (_tmp38_, 0, (GeeCollection*) _tmp39_);
	_tmp40_ = test_list;
	_tmp41_ = gee_collection_get_size ((GeeCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	_vala_assert (_tmp42_ == 3, "test_list.size == 3");
	_tmp43_ = dummy;
	_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_assert (_tmp45_ == 3, "dummy.size == 3");
	_tmp46_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp46_);
	_tmp47_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp47_);
	_tmp48_ = dummy;
	_tmp49_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, "zero");
	_vala_assert (_tmp49_, "dummy.add (\"zero\")");
	_tmp50_ = dummy;
	_tmp51_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, "one");
	_vala_assert (_tmp51_, "dummy.add (\"one\")");
	_tmp52_ = dummy;
	_tmp53_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, "two");
	_vala_assert (_tmp53_, "dummy.add (\"two\")");
	_tmp54_ = test_list;
	_tmp55_ = gee_collection_get_is_empty ((GeeCollection*) _tmp54_);
	_tmp56_ = _tmp55_;
	_vala_assert (_tmp56_, "test_list.is_empty");
	_tmp57_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp57_) {
		GeeList* _tmp58_;
		GeeArrayList* _tmp59_;
		_tmp58_ = test_list;
		_tmp59_ = dummy;
		gee_list_insert_all (_tmp58_, 1, (GeeCollection*) _tmp59_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp60_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp60_);
	_tmp61_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp61_);
	_tmp62_ = test_list;
	_tmp63_ = gee_collection_add ((GeeCollection*) _tmp62_, "three");
	_vala_assert (_tmp63_, "test_list.add (\"three\")");
	_tmp64_ = test_list;
	_tmp65_ = gee_collection_add ((GeeCollection*) _tmp64_, "four");
	_vala_assert (_tmp65_, "test_list.add (\"four\")");
	_tmp66_ = test_list;
	_tmp67_ = gee_collection_add ((GeeCollection*) _tmp66_, "five");
	_vala_assert (_tmp67_, "test_list.add (\"five\")");
	_tmp68_ = dummy;
	_tmp69_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, "zero");
	_vala_assert (_tmp69_, "dummy.add (\"zero\")");
	_tmp70_ = dummy;
	_tmp71_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp70_, "one");
	_vala_assert (_tmp71_, "dummy.add (\"one\")");
	_tmp72_ = dummy;
	_tmp73_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp72_, "two");
	_vala_assert (_tmp73_, "dummy.add (\"two\")");
	_tmp74_ = test_list;
	_tmp75_ = gee_collection_get_size ((GeeCollection*) _tmp74_);
	_tmp76_ = _tmp75_;
	_vala_assert (_tmp76_ == 3, "test_list.size == 3");
	_tmp77_ = dummy;
	_tmp78_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp77_);
	_tmp79_ = _tmp78_;
	_vala_assert (_tmp79_ == 3, "dummy.size == 3");
	_tmp80_ = test_list;
	_tmp81_ = dummy;
	gee_list_insert_all (_tmp80_, 0, (GeeCollection*) _tmp81_);
	_tmp82_ = test_list;
	_tmp83_ = gee_collection_get_size ((GeeCollection*) _tmp82_);
	_tmp84_ = _tmp83_;
	_vala_assert (_tmp84_ == 6, "test_list.size == 6");
	_tmp85_ = dummy;
	_tmp86_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp85_);
	_tmp87_ = _tmp86_;
	_vala_assert (_tmp87_ == 3, "dummy.size == 3");
	_tmp88_ = test_list;
	_tmp89_ = gee_list_get (_tmp88_, 0);
	_tmp90_ = (gchar*) _tmp89_;
	_vala_assert (g_strcmp0 (_tmp90_, "zero") == 0, "test_list.get (0) == \"zero\"");
	_g_free0 (_tmp90_);
	_tmp91_ = test_list;
	_tmp92_ = gee_list_get (_tmp91_, 1);
	_tmp93_ = (gchar*) _tmp92_;
	_vala_assert (g_strcmp0 (_tmp93_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp93_);
	_tmp94_ = test_list;
	_tmp95_ = gee_list_get (_tmp94_, 2);
	_tmp96_ = (gchar*) _tmp95_;
	_vala_assert (g_strcmp0 (_tmp96_, "two") == 0, "test_list.get (2) == \"two\"");
	_g_free0 (_tmp96_);
	_tmp97_ = test_list;
	_tmp98_ = gee_list_get (_tmp97_, 3);
	_tmp99_ = (gchar*) _tmp98_;
	_vala_assert (g_strcmp0 (_tmp99_, "three") == 0, "test_list.get (3) == \"three\"");
	_g_free0 (_tmp99_);
	_tmp100_ = test_list;
	_tmp101_ = gee_list_get (_tmp100_, 4);
	_tmp102_ = (gchar*) _tmp101_;
	_vala_assert (g_strcmp0 (_tmp102_, "four") == 0, "test_list.get (4) == \"four\"");
	_g_free0 (_tmp102_);
	_tmp103_ = test_list;
	_tmp104_ = gee_list_get (_tmp103_, 5);
	_tmp105_ = (gchar*) _tmp104_;
	_vala_assert (g_strcmp0 (_tmp105_, "five") == 0, "test_list.get (5) == \"five\"");
	_g_free0 (_tmp105_);
	_tmp106_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp106_);
	_tmp107_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp107_);
	_tmp108_ = test_list;
	_tmp109_ = gee_collection_add ((GeeCollection*) _tmp108_, "zero");
	_vala_assert (_tmp109_, "test_list.add (\"zero\")");
	_tmp110_ = test_list;
	_tmp111_ = gee_collection_add ((GeeCollection*) _tmp110_, "one");
	_vala_assert (_tmp111_, "test_list.add (\"one\")");
	_tmp112_ = test_list;
	_tmp113_ = gee_collection_add ((GeeCollection*) _tmp112_, "five");
	_vala_assert (_tmp113_, "test_list.add (\"five\")");
	_tmp114_ = test_list;
	_tmp115_ = gee_collection_add ((GeeCollection*) _tmp114_, "six");
	_vala_assert (_tmp115_, "test_list.add (\"six\")");
	_tmp116_ = dummy;
	_tmp117_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp116_, "two");
	_vala_assert (_tmp117_, "dummy.add (\"two\")");
	_tmp118_ = dummy;
	_tmp119_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp118_, "three");
	_vala_assert (_tmp119_, "dummy.add (\"three\")");
	_tmp120_ = dummy;
	_tmp121_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, "four");
	_vala_assert (_tmp121_, "dummy.add (\"four\")");
	_tmp122_ = test_list;
	_tmp123_ = gee_collection_get_size ((GeeCollection*) _tmp122_);
	_tmp124_ = _tmp123_;
	_vala_assert (_tmp124_ == 4, "test_list.size == 4");
	_tmp125_ = dummy;
	_tmp126_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp125_);
	_tmp127_ = _tmp126_;
	_vala_assert (_tmp127_ == 3, "dummy.size == 3");
	_tmp128_ = test_list;
	_tmp129_ = dummy;
	gee_list_insert_all (_tmp128_, 2, (GeeCollection*) _tmp129_);
	_tmp130_ = test_list;
	_tmp131_ = gee_collection_get_size ((GeeCollection*) _tmp130_);
	_tmp132_ = _tmp131_;
	_vala_assert (_tmp132_ == 7, "test_list.size == 7");
	_tmp133_ = dummy;
	_tmp134_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp133_);
	_tmp135_ = _tmp134_;
	_vala_assert (_tmp135_ == 3, "dummy.size == 3");
	_tmp136_ = test_list;
	_tmp137_ = gee_list_get (_tmp136_, 0);
	_tmp138_ = (gchar*) _tmp137_;
	_vala_assert (g_strcmp0 (_tmp138_, "zero") == 0, "test_list.get (0) == \"zero\"");
	_g_free0 (_tmp138_);
	_tmp139_ = test_list;
	_tmp140_ = gee_list_get (_tmp139_, 1);
	_tmp141_ = (gchar*) _tmp140_;
	_vala_assert (g_strcmp0 (_tmp141_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp141_);
	_tmp142_ = test_list;
	_tmp143_ = gee_list_get (_tmp142_, 2);
	_tmp144_ = (gchar*) _tmp143_;
	_vala_assert (g_strcmp0 (_tmp144_, "two") == 0, "test_list.get (2) == \"two\"");
	_g_free0 (_tmp144_);
	_tmp145_ = test_list;
	_tmp146_ = gee_list_get (_tmp145_, 3);
	_tmp147_ = (gchar*) _tmp146_;
	_vala_assert (g_strcmp0 (_tmp147_, "three") == 0, "test_list.get (3) == \"three\"");
	_g_free0 (_tmp147_);
	_tmp148_ = test_list;
	_tmp149_ = gee_list_get (_tmp148_, 4);
	_tmp150_ = (gchar*) _tmp149_;
	_vala_assert (g_strcmp0 (_tmp150_, "four") == 0, "test_list.get (4) == \"four\"");
	_g_free0 (_tmp150_);
	_tmp151_ = test_list;
	_tmp152_ = gee_list_get (_tmp151_, 5);
	_tmp153_ = (gchar*) _tmp152_;
	_vala_assert (g_strcmp0 (_tmp153_, "five") == 0, "test_list.get (5) == \"five\"");
	_g_free0 (_tmp153_);
	_tmp154_ = test_list;
	_tmp155_ = gee_list_get (_tmp154_, 6);
	_tmp156_ = (gchar*) _tmp155_;
	_vala_assert (g_strcmp0 (_tmp156_, "six") == 0, "test_list.get (6) == \"six\"");
	_g_free0 (_tmp156_);
	_tmp157_ = test_list;
	gee_collection_clear ((GeeCollection*) _tmp157_);
	_tmp158_ = dummy;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp158_);
	_tmp159_ = test_list;
	_tmp160_ = gee_collection_add ((GeeCollection*) _tmp159_, "zero");
	_vala_assert (_tmp160_, "test_list.add (\"zero\")");
	_tmp161_ = test_list;
	_tmp162_ = gee_collection_add ((GeeCollection*) _tmp161_, "one");
	_vala_assert (_tmp162_, "test_list.add (\"one\")");
	_tmp163_ = test_list;
	_tmp164_ = gee_collection_add ((GeeCollection*) _tmp163_, "two");
	_vala_assert (_tmp164_, "test_list.add (\"two\")");
	_tmp165_ = dummy;
	_tmp166_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp165_, "three");
	_vala_assert (_tmp166_, "dummy.add (\"three\")");
	_tmp167_ = dummy;
	_tmp168_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp167_, "four");
	_vala_assert (_tmp168_, "dummy.add (\"four\")");
	_tmp169_ = dummy;
	_tmp170_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp169_, "five");
	_vala_assert (_tmp170_, "dummy.add (\"five\")");
	_tmp171_ = test_list;
	_tmp172_ = gee_collection_get_size ((GeeCollection*) _tmp171_);
	_tmp173_ = _tmp172_;
	_vala_assert (_tmp173_ == 3, "test_list.size == 3");
	_tmp174_ = dummy;
	_tmp175_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp174_);
	_tmp176_ = _tmp175_;
	_vala_assert (_tmp176_ == 3, "dummy.size == 3");
	_tmp177_ = test_list;
	_tmp178_ = dummy;
	gee_list_insert_all (_tmp177_, 3, (GeeCollection*) _tmp178_);
	_tmp179_ = test_list;
	_tmp180_ = gee_collection_get_size ((GeeCollection*) _tmp179_);
	_tmp181_ = _tmp180_;
	_vala_assert (_tmp181_ == 6, "test_list.size == 6");
	_tmp182_ = dummy;
	_tmp183_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp182_);
	_tmp184_ = _tmp183_;
	_vala_assert (_tmp184_ == 3, "dummy.size == 3");
	_tmp185_ = test_list;
	_tmp186_ = gee_list_get (_tmp185_, 0);
	_tmp187_ = (gchar*) _tmp186_;
	_vala_assert (g_strcmp0 (_tmp187_, "zero") == 0, "test_list.get (0) == \"zero\"");
	_g_free0 (_tmp187_);
	_tmp188_ = test_list;
	_tmp189_ = gee_list_get (_tmp188_, 1);
	_tmp190_ = (gchar*) _tmp189_;
	_vala_assert (g_strcmp0 (_tmp190_, "one") == 0, "test_list.get (1) == \"one\"");
	_g_free0 (_tmp190_);
	_tmp191_ = test_list;
	_tmp192_ = gee_list_get (_tmp191_, 2);
	_tmp193_ = (gchar*) _tmp192_;
	_vala_assert (g_strcmp0 (_tmp193_, "two") == 0, "test_list.get (2) == \"two\"");
	_g_free0 (_tmp193_);
	_tmp194_ = test_list;
	_tmp195_ = gee_list_get (_tmp194_, 3);
	_tmp196_ = (gchar*) _tmp195_;
	_vala_assert (g_strcmp0 (_tmp196_, "three") == 0, "test_list.get (3) == \"three\"");
	_g_free0 (_tmp196_);
	_tmp197_ = test_list;
	_tmp198_ = gee_list_get (_tmp197_, 4);
	_tmp199_ = (gchar*) _tmp198_;
	_vala_assert (g_strcmp0 (_tmp199_, "four") == 0, "test_list.get (4) == \"four\"");
	_g_free0 (_tmp199_);
	_tmp200_ = test_list;
	_tmp201_ = gee_list_get (_tmp200_, 5);
	_tmp202_ = (gchar*) _tmp201_;
	_vala_assert (g_strcmp0 (_tmp202_, "five") == 0, "test_list.get (5) == \"five\"");
	_g_free0 (_tmp202_);
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}


void list_tests_test_slice (ListTests* self) {
	GeeList* test_list = NULL;
	GeeCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* dummy = NULL;
	gboolean _tmp3_;
	GeeList* _tmp6_;
	gboolean _tmp7_;
	GeeList* _tmp8_;
	gboolean _tmp9_;
	GeeList* _tmp10_;
	gboolean _tmp11_;
	GeeList* _tmp12_;
	gboolean _tmp13_;
	GeeList* _tmp14_;
	gboolean _tmp15_;
	GeeList* _tmp16_;
	gboolean _tmp17_;
	GeeList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GeeList* _tmp21_;
	GeeList* _tmp22_;
	GeeList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GeeList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GeeList* _tmp29_;
	gpointer _tmp30_;
	gchar* _tmp31_;
	GeeList* _tmp32_;
	gpointer _tmp33_;
	gchar* _tmp34_;
	GeeList* _tmp35_;
	gpointer _tmp36_;
	gchar* _tmp37_;
	gboolean _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_LIST) ? ((GeeList*) _tmp0_) : NULL);
	test_list = _tmp1_;
	_tmp2_ = test_list;
	_vala_assert (_tmp2_ != NULL, "test_list != null");
	_tmp3_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp3_) {
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		_tmp4_ = test_list;
		_tmp5_ = gee_list_slice (_tmp4_, 1, 4);
		_g_object_unref0 (dummy);
		dummy = _tmp5_;
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp6_ = test_list;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "zero");
	_vala_assert (_tmp7_, "test_list.add (\"zero\")");
	_tmp8_ = test_list;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "one");
	_vala_assert (_tmp9_, "test_list.add (\"one\")");
	_tmp10_ = test_list;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "two");
	_vala_assert (_tmp11_, "test_list.add (\"two\")");
	_tmp12_ = test_list;
	_tmp13_ = gee_collection_add ((GeeCollection*) _tmp12_, "three");
	_vala_assert (_tmp13_, "test_list.add (\"three\")");
	_tmp14_ = test_list;
	_tmp15_ = gee_collection_add ((GeeCollection*) _tmp14_, "four");
	_vala_assert (_tmp15_, "test_list.add (\"four\")");
	_tmp16_ = test_list;
	_tmp17_ = gee_collection_add ((GeeCollection*) _tmp16_, "five");
	_vala_assert (_tmp17_, "test_list.add (\"five\")");
	_tmp18_ = test_list;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_vala_assert (_tmp20_ == 6, "test_list.size == 6");
	_tmp21_ = test_list;
	_tmp22_ = gee_list_slice (_tmp21_, 1, 4);
	_g_object_unref0 (dummy);
	dummy = _tmp22_;
	_tmp23_ = dummy;
	_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_vala_assert (_tmp25_ == 3, "dummy.size == 3");
	_tmp26_ = test_list;
	_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp28_ == 6, "test_list.size == 6");
	_tmp29_ = dummy;
	_tmp30_ = gee_list_get (_tmp29_, 0);
	_tmp31_ = (gchar*) _tmp30_;
	_vala_assert (g_strcmp0 (_tmp31_, "one") == 0, "dummy.get (0) == \"one\"");
	_g_free0 (_tmp31_);
	_tmp32_ = dummy;
	_tmp33_ = gee_list_get (_tmp32_, 1);
	_tmp34_ = (gchar*) _tmp33_;
	_vala_assert (g_strcmp0 (_tmp34_, "two") == 0, "dummy.get (1) == \"two\"");
	_g_free0 (_tmp34_);
	_tmp35_ = dummy;
	_tmp36_ = gee_list_get (_tmp35_, 2);
	_tmp37_ = (gchar*) _tmp36_;
	_vala_assert (g_strcmp0 (_tmp37_, "three") == 0, "dummy.get (2) == \"three\"");
	_g_free0 (_tmp37_);
	_tmp38_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp38_) {
		GeeList* _tmp39_;
		GeeList* _tmp40_;
		_tmp39_ = test_list;
		_tmp40_ = gee_list_slice (_tmp39_, 0, 9);
		_g_object_unref0 (dummy);
		dummy = _tmp40_;
		exit (0);
	}
	g_test_trap_assert_failed ();
	_g_object_unref0 (dummy);
	_g_object_unref0 (test_list);
}


static void list_tests_class_init (ListTestsClass * klass) {
	list_tests_parent_class = g_type_class_peek_parent (klass);
	((ListTestsClass *) klass)->test_duplicates_are_retained = (void (*) (ListTests *)) list_tests_real_test_duplicates_are_retained;
}


static void list_tests_instance_init (ListTests * self) {
}


GType list_tests_get_type (void) {
	static volatile gsize list_tests_type_id__volatile = 0;
	if (g_once_init_enter (&list_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListTests), 0, (GInstanceInitFunc) list_tests_instance_init, NULL };
		GType list_tests_type_id;
		list_tests_type_id = g_type_register_static (TYPE_COLLECTION_TESTS, "ListTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&list_tests_type_id__volatile, list_tests_type_id);
	}
	return list_tests_type_id__volatile;
}



