/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef FB2XMLPARSERCONTEXT_H_INCLUDED
#define FB2XMLPARSERCONTEXT_H_INCLUDED

namespace libebook
{

struct EBOOKToken;

class FB2XMLParserContext
{
public:
  virtual ~FB2XMLParserContext() = 0;

  /** Destroy this context and return parent.
    *
    * @todo It would be handier to use shared_ptr to manage the context
    * lifetimes.
    *
    * @return The parent context.
    */
  virtual FB2XMLParserContext *leaveContext() const = 0;

  /** Create a context for parsing a child element.
    *
    * @return A new context or @c 0 if the child element cannot be handled.
    */
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns) = 0;

  /** Signalize the start of an element.
    *
    * This can be used if initialization of the context needs virtual
    * function calls.
    */
  virtual void startOfElement() = 0;

  /** Signalize the end of an element.
    */
  virtual void endOfElement() = 0;

  /** Process an attribute.
    *
    * Attributes are handled to the current element's context one by
    * one.
    */
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value) = 0;

  /** Signalize the end of attributes.
    */
  virtual void endOfAttributes() = 0;

  /** Process textual content of an element.
    *
    * This function can be called more than once if the element has
    * mixed content.
    */
  virtual void text(const char *value) = 0;
};

}

#endif // FB2XMLPARSERCONTEXT_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
