.TH "ZIP_FILE_RENAME" "3" "June 23, 2012" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_file_rename\fP
\- rename file in zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
int
zip_file_rename zip_t *archive zip_uint64_t index const char *name zip_flags_t flags
.SH "DESCRIPTION"
The file at position
\fIindex\fP
in the zip archive
\fIarchive\fP
is renamed to
\fIname\fP.
The
\fIflags\fP
argument can be any of:
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_ENC_GUESS\fP
Guess encoding of
\fIname\fP
(default).
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_ENC_UTF_8\fP
Interpret
\fIname\fP
as UTF-8.
.TP XZIPXFLXENCXSTRICTXX
\fRZIP_FL_ENC_CP437\fP
Interpret
\fIname\fP
as code page 437 (CP-437).
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fIarchive\fP
is set to indicate the error.
.SH "ERRORS"
zip_rename
fails if:
.TP 17n
[\fRZIP_ER_DELETED\fP]
The file to be renamed has been deleted from the archive.
.TP 17n
[\fRZIP_ER_EXISTS\fP]
There is already a file called
\fIname\fP
in the archive.
.TP 17n
[\fRZIP_ER_INVAL\fP]
\fIindex\fP
is not a valid file index in
\fIarchive\fP,
\fIname is\fP
\fRNULL\fP,
the empty string, or not a valid UTF-8 encoded string.
Also a file cannot be renamed to a directory or vice versa.
Directories are denoted by a trailing slash.
.SH "SEE ALSO"
libzip(3),
zip_unchange(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
