#include <initializer_list>

namespace
{
struct CursorData
{
    CursorData(char const* name, unsigned int hotspot_x, unsigned int hotspot_y, char const* pixel_data) :
        name(name), hotspot_x(hotspot_x), hotspot_y(hotspot_y), pixel_data(reinterpret_cast<unsigned char const*>(pixel_data)) {}

    unsigned int const width{24};
    unsigned int const height{24};
    char const* const name;
    unsigned int const hotspot_x;
    unsigned int const hotspot_y;
    unsigned char const* const pixel_data;
};
auto const cursor_data = {
CursorData{"arrow", 7, 4,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1"
    "\0\0\0\2\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\207\0\0\0\14\0\0\0\2\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\11\0\0\0\377"
    "\3\3\3\231\0\0\0\23\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\25\25\25\371\2\2\2\225\0\0\0\22\0\0\0\2"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0"
    "\377\334\334\334\377\21\21\21\372\1\1\1\213\0\0\0\20\0\0\0\2\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\376\376\376\377\326\326"
    "\326\377\16\16\16\372\1\1\1\201\0\0\0\17\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\373\373\373\377\377\377\377\377\320\320\320"
    "\377\14\14\14\372\0\0\0\170\0\0\0\16\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\13\0\0\0\377\367\367\367\377\376\376\376\377\377\377\377\377\311\311"
    "\311\377\12\12\12\372\0\0\0\160\0\0\0\15\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\13\0\0\0\377\364\364\364\377\373\373\373\377\377\377\377\377\377\377\377"
    "\377\303\303\303\377\12\12\12\372\0\0\0\150\0\0\0\14\0\0\0\1\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\13\0\0\0\377\360\360\360\377\370\370\370\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\273\273\273\377\11\11\11\371\0\0\0\140\0\0\0\13\0\0\0\1"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\355\355\355\377\364\364\364\377\373\373\373"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\264\264\264\377\11\11\11"
    "\370\0\0\0\131\0\0\0\13\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\351\351\351\377\361"
    "\361\361\377\370\370\370\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\252\252\252\377\11\11\11\367\0\0\0\121\0\0\0\11\0\0\0\1\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0"
    "\0\0\377\346\346\346\377\355\355\355\377\364\364\364\377\373\373\373\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\242\242\242\376\11\11"
    "\11\365\0\0\0\113\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\343\343\343\377\352\352\352\377"
    "\361\361\361\377\370\370\370\377\375\375\375\377\53\53\53\375\10\10\10\374\10\10"
    "\10\374\10\10\10\374\1\1\1\377\2\2\2\356\0\0\0\72\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\337\337"
    "\337\377\346\346\346\377\327\327\327\377\234\234\234\377\374\374\374\377\220\220"
    "\220\376\12\12\12\337\0\0\0\153\0\0\0\134\0\0\0\131\0\0\0\123\0\0\0\61\0\0\0\10"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\13\0\0\0\377\334\334\334\377\313\313\313\377\32\32\32\372\13\13\13\373\353\353"
    "\353\377\365\365\365\377\16\16\16\372\0\0\0\147\0\0\0\32\0\0\0\17\0\0\0\16\0\0\0"
    "\11\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\13\0\0\0\377\300\300\300\377\26\26\26\372\4\4\4\265\10\10\10\317\176"
    "\176\176\375\374\374\374\377\177\177\177\375\11\11\11\310\0\0\0\33\0\0\0\2\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\13\0\0\0\377\24\24\24\372\3\3\3\256\0\0\0\105\0\0\0\116\14\14"
    "\14\371\355\355\355\377\357\357\357\377\12\12\12\372\0\0\0\115\0\0\0\11\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\13\0\0\0\376\2\2\2\244\0\0\0\101\0\0\0\23\0\0\0\15\11\11\11\304"
    "\201\201\201\375\374\374\374\377\71\71\71\370\0\0\0\211\0\0\0\22\0\0\0\1\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\11\0\0\0\176\0\0\0\65\0\0\0\22\0\0\0\2\0\0\0\3\0\0\0\102\10\10\10\370\76"
    "\76\76\370\12\12\12\365\0\0\0\156\0\0\0\21\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0\16\0\0"
    "\0\13\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\10\0\0\0\114\0\0\0\220\0\0\0\145\0\0\0\50\0"
    "\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\2\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0"
    "\0\0\7\0\0\0\22\0\0\0\21\0\0\0\6\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"busy", 14, 14,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\2"
    "\0\0\0\3\0\0\0\2\0\0\0\1\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1"
    "\0\0\0\75\6\6\6\212\22\22\22\311\14\14\14\361\14\14\14\362\22\22\22\317\7\7\7"
    "\222\0\0\0\117\0\0\0\10\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\20\13\13\13\251\45\45\45"
    "\362\217\217\217\376\303\303\303\377\362\362\362\377\365\365\365\377\312\312\312"
    "\377\225\225\225\376\60\60\60\363\15\15\15\302\0\0\0\46\0\0\0\5\0\0\0\1\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\67\16\16"
    "\16\352\174\174\174\370\365\365\365\377\373\373\373\377\376\376\376\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\376\376\376\377\373\373\373\377\220\220"
    "\220\374\17\17\17\360\1\1\1\130\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\16\16\16\16\350\303\303\303\377\365\365\365\377"
    "\371\371\371\377\377\377\377\377\375\375\375\377\323\323\323\377\323\323\323\377"
    "\375\375\375\377\377\377\377\377\377\377\377\377\374\374\374\377\326\326\326\377"
    "\21\21\21\360\0\0\0\62\0\0\0\10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\1\12\12\12\244\171\171\171\370\364\364\364\377\267\267\267\377\220\220"
    "\220\377\343\343\343\377\353\353\353\377\112\112\112\377\107\107\107\377\352\352"
    "\352\377\375\375\375\377\373\373\373\377\377\377\377\377\373\373\373\377\221\221"
    "\221\374\15\15\15\312\0\0\0\30\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\65\41\41\41\360\357\357\357\377\364\364\364\377\221\221\221\377\71\71\71"
    "\377\162\162\162\377\327\327\327\377\132\132\132\377\127\127\127\377\351\351\351"
    "\377\340\340\340\377\340\340\340\377\374\374\374\377\375\375\375\377\370\370\370"
    "\377\62\62\62\365\0\0\0\154\0\0\0\15\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\2"
    "\2\172\171\171\171\374\363\363\363\377\370\370\370\377\335\335\335\377\164\164"
    "\164\377\122\122\122\377\320\320\320\377\346\346\346\377\343\343\343\377\364\364"
    "\364\377\326\326\326\377\340\340\340\377\374\374\374\377\376\376\376\377\371\371"
    "\371\377\231\231\231\377\11\11\11\261\0\0\0\31\0\0\0\3\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\1\20\20\20\273\254\254\254\377\363\363\363\377\362\362\362\377\357\357\357"
    "\377\335\335\335\377\320\320\320\377\367\367\367\377\377\377\377\377\377\377\377"
    "\377\376\376\376\377\365\365\365\377\366\366\366\377\373\373\373\377\377\377\377"
    "\377\371\371\371\377\311\311\311\377\22\22\22\337\0\0\0\46\0\0\0\7\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\2\16\16\16\352\334\334\334\377\352\352\352\377\254\254\254\377"
    "\216\216\216\377\245\245\245\377\361\361\361\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\372\372\372\377\336\336\336\377\333\333\333\377"
    "\365\365\365\377\370\370\370\377\360\360\360\377\13\13\13\367\0\0\0\63\0\0\0\14"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\16\16\16\352\333\333\333\377\351\351\351\377"
    "\257\257\257\377\232\232\232\377\260\260\260\377\361\361\361\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\372\372\372\377\336\336\336\377"
    "\333\333\333\377\363\363\363\377\367\367\367\377\356\356\356\377\14\14\14\367\0"
    "\0\0\75\0\0\0\17\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\17\17\17\275\251\251\251\377"
    "\357\357\357\377\354\354\354\377\353\353\353\377\360\360\360\377\365\365\365\377"
    "\376\376\376\377\377\377\377\377\377\377\377\377\376\376\376\377\366\366\366\377"
    "\367\367\367\377\372\372\372\377\371\371\371\377\364\364\364\377\306\306\306\377"
    "\21\21\21\340\0\0\0\71\0\0\0\16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\2\2\2\175\163"
    "\163\163\373\354\354\354\377\361\361\361\377\361\361\361\377\334\334\334\377\324"
    "\324\324\377\364\364\364\377\372\372\372\377\372\372\372\377\365\365\365\377\326"
    "\326\326\377\340\340\340\377\370\370\370\377\366\366\366\377\361\361\361\377\224"
    "\224\224\377\10\10\10\265\0\0\0\55\0\0\0\12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\73\36\36\36\362\345\345\345\377\356\356\356\377\352\352\352\377\320\320\320"
    "\377\326\326\326\377\361\361\361\377\332\332\332\377\335\335\335\377\363\363\363"
    "\377\333\333\333\377\332\332\332\377\363\363\363\377\362\362\362\377\355\355\355"
    "\377\55\55\55\366\0\0\0\176\0\0\0\40\0\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\11\11\11\11\253\155\155\155\371\352\352\352\377\354\354\354\377\350\350\350"
    "\377\355\355\355\377\361\361\361\377\322\322\322\377\324\324\324\377\363\363\363"
    "\377\362\362\362\377\360\360\360\377\361\361\361\377\356\356\356\377\205\205\205"
    "\374\14\14\14\316\0\0\0\102\0\0\0\24\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\2\0\0\0\35\15\15\15\352\263\263\263\377\351\351\351\377\354\354\354\377\356"
    "\356\356\377\357\357\357\377\347\347\347\377\350\350\350\377\361\361\361\377\360"
    "\360\360\377\357\357\357\377\354\354\354\377\304\304\304\377\17\17\17\362\0\0\0"
    "\132\0\0\0\46\0\0\0\10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0"
    "\0\0\112\15\15\15\355\153\153\153\371\342\342\342\377\351\351\351\377\353\353"
    "\353\377\354\354\354\377\354\354\354\377\354\354\354\377\353\353\353\377\350\350"
    "\350\377\176\176\176\373\16\16\16\362\1\1\1\175\0\0\0\63\0\0\0\17\0\0\0\2\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\11\0\0\0\54\11\11\11"
    "\267\36\36\36\365\175\175\175\375\254\254\254\377\331\331\331\377\336\336\336"
    "\377\263\263\263\377\202\202\202\376\46\46\46\365\13\13\13\314\0\0\0\132\0\0\0"
    "\64\0\0\0\24\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\1\0\0\0\10\0\0\0\32\0\0\0\135\3\3\3\241\20\20\20\322\15\15\15\362\14"
    "\14\14\364\20\20\20\327\4\4\4\253\0\0\0\170\0\0\0\102\0\0\0\46\0\0\0\20\0\0\0\4"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\4\0\0\0\16\0\0\0\33\0\0\0\50\0\0\0\65\0\0\0\76\0\0\0\73\0\0\0\56"
    "\0\0\0\42\0\0\0\25\0\0\0\10\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\4\0\0"
    "\0\10\0\0\0\15\0\0\0\20\0\0\0\17\0\0\0\12\0\0\0\6\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"caret", 13, 13,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\1\0\0\0\5\0\0\0\6\0\0\0\5\0\0\0\6\0\0\0\6\0\0\0\4\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\11\11\11\245\0\0\0\377\0\0\0\377\5\5\5"
    "\366\0\0\0\377\0\0\0\377\13\13\13\314\0\0\0\13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\5\7\7\7\371\343\343\343\377\376\376\376\377\236\236\236\377\371\371"
    "\371\377\371\371\371\377\5\5\5\375\0\0\0\65\0\0\0\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\4\11\11\11\264\0\0\0\377\0\0\0\377\357\357\357\377\14\14\14\375\0\0\0"
    "\377\13\13\13\326\0\0\0\44\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\10\0\0\0\53\7\7\7\372\357\357\357\377\10\10\10\373\0\0\0\123\0\0\0\43\0\0\0\4\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\11\7\7\7\371\357"
    "\357\357\377\10\10\10\373\0\0\0\73\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\7\7\7\371\357\357\357\377\10\10\10\373\0\0\0"
    "\72\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\6\7\7\7\371\357\357\357\377\10\10\10\373\0\0\0\72\0\0\0\4\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\7\7\7\371\357\357\357\377"
    "\10\10\10\373\0\0\0\72\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\6\7\7\7\371\357\357\357\377\10\10\10\373\0\0\0\72\0\0\0\4\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\7\7\7\371"
    "\357\357\357\377\10\10\10\373\0\0\0\72\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\7\7\7\371\357\357\357\377\10\10\10\373\0"
    "\0\0\72\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\6\7\7\7\371\357\357\357\377\10\10\10\373\0\0\0\72\0\0\0\4\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\13\7\7\7\371\357\357\357"
    "\377\10\10\10\373\0\0\0\75\0\0\0\10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\1\11\11\11\245\0\0\0\377\0\0\0\377\357\357\357\377\14\14\14\375\0\0\0"
    "\377\13\13\13\314\0\0\0\13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\7\7\7"
    "\371\343\343\343\377\377\377\377\377\303\303\303\377\374\374\374\377\371\371\371"
    "\377\5\5\5\375\0\0\0\65\0\0\0\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\11\11"
    "\11\264\0\0\0\377\0\0\0\377\6\6\6\371\0\0\0\377\0\0\0\377\13\13\13\326\0\0\0\44"
    "\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\11\0\0\0\53\0\0\0\57\0\0"
    "\0\53\0\0\0\56\0\0\0\57\0\0\0\43\0\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"default", 7, 4,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1"
    "\0\0\0\2\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\207\0\0\0\14\0\0\0\2\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\11\0\0\0\377"
    "\3\3\3\231\0\0\0\23\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\25\25\25\371\2\2\2\225\0\0\0\22\0\0\0\2"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0"
    "\377\334\334\334\377\21\21\21\372\1\1\1\213\0\0\0\20\0\0\0\2\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\376\376\376\377\326\326"
    "\326\377\16\16\16\372\1\1\1\201\0\0\0\17\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\373\373\373\377\377\377\377\377\320\320\320"
    "\377\14\14\14\372\0\0\0\170\0\0\0\16\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\13\0\0\0\377\367\367\367\377\376\376\376\377\377\377\377\377\311\311"
    "\311\377\12\12\12\372\0\0\0\160\0\0\0\15\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\13\0\0\0\377\364\364\364\377\373\373\373\377\377\377\377\377\377\377\377"
    "\377\303\303\303\377\12\12\12\372\0\0\0\150\0\0\0\14\0\0\0\1\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\13\0\0\0\377\360\360\360\377\370\370\370\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\273\273\273\377\11\11\11\371\0\0\0\140\0\0\0\13\0\0\0\1"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\355\355\355\377\364\364\364\377\373\373\373"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\264\264\264\377\11\11\11"
    "\370\0\0\0\131\0\0\0\13\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\351\351\351\377\361"
    "\361\361\377\370\370\370\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\252\252\252\377\11\11\11\367\0\0\0\121\0\0\0\11\0\0\0\1\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0"
    "\0\0\377\346\346\346\377\355\355\355\377\364\364\364\377\373\373\373\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\242\242\242\376\11\11"
    "\11\365\0\0\0\113\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\343\343\343\377\352\352\352\377"
    "\361\361\361\377\370\370\370\377\375\375\375\377\53\53\53\375\10\10\10\374\10\10"
    "\10\374\10\10\10\374\1\1\1\377\2\2\2\356\0\0\0\72\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\0\0\0\377\337\337"
    "\337\377\346\346\346\377\327\327\327\377\234\234\234\377\374\374\374\377\220\220"
    "\220\376\12\12\12\337\0\0\0\153\0\0\0\134\0\0\0\131\0\0\0\123\0\0\0\61\0\0\0\10"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\13\0\0\0\377\334\334\334\377\313\313\313\377\32\32\32\372\13\13\13\373\353\353"
    "\353\377\365\365\365\377\16\16\16\372\0\0\0\147\0\0\0\32\0\0\0\17\0\0\0\16\0\0\0"
    "\11\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\13\0\0\0\377\300\300\300\377\26\26\26\372\4\4\4\265\10\10\10\317\176"
    "\176\176\375\374\374\374\377\177\177\177\375\11\11\11\310\0\0\0\33\0\0\0\2\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\13\0\0\0\377\24\24\24\372\3\3\3\256\0\0\0\105\0\0\0\116\14\14"
    "\14\371\355\355\355\377\357\357\357\377\12\12\12\372\0\0\0\115\0\0\0\11\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\13\0\0\0\376\2\2\2\244\0\0\0\101\0\0\0\23\0\0\0\15\11\11\11\304"
    "\201\201\201\375\374\374\374\377\71\71\71\370\0\0\0\211\0\0\0\22\0\0\0\1\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\11\0\0\0\176\0\0\0\65\0\0\0\22\0\0\0\2\0\0\0\3\0\0\0\102\10\10\10\370\76"
    "\76\76\370\12\12\12\365\0\0\0\156\0\0\0\21\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0\16\0\0"
    "\0\13\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\10\0\0\0\114\0\0\0\220\0\0\0\145\0\0\0\50\0"
    "\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\2\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0"
    "\0\0\7\0\0\0\22\0\0\0\21\0\0\0\6\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"pointing-hand", 11, 5,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\13\0\0\0\11\0\0\0\4\0\0\0"
    "\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\7\7\7"
    "\206\7\7\7\370\6\6\6\371\3\3\3\173\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\23\7\7\7\371\342\342\342\377\313\313\313\377"
    "\12\12\12\363\0\0\0\34\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\1\0\0\0\37\10\10\10\372\377\377\377\377\347\347\347\377\11\11\11\366\0\0\0"
    "\46\0\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\40\10"
    "\10\10\372\377\377\377\377\347\347\347\377\11\11\11\366\0\0\0\53\0\0\0\15\0\0\0"
    "\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\40\10\10\10\372\377\377"
    "\377\377\347\347\347\377\2\2\2\376\13\13\13\362\12\12\12\353\0\0\0\103\0\0\0\11"
    "\0\0\0\6\0\0\0\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\40\10\10\10\372\377\377\377\377"
    "\350\350\350\377\114\114\114\377\345\345\345\377\215\215\215\377\7\7\7\364\12\12"
    "\12\363\12\12\12\360\0\0\0\145\0\0\0\26\0\0\0\7\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\5\0\0\0\46\10\10\10\372"
    "\377\377\377\377\347\347\347\377\232\232\232\377\377\377\377\377\345\345\345\377"
    "\46\46\46\377\341\341\341\377\304\304\304\377\11\11\11\374\5\5\5\374\13\13\13"
    "\344\0\0\0\114\0\0\0\6\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\54\10\10\10\357\3\3\3\374\13\13\13\374\377\377\377\377\347\347\347\377\331"
    "\331\331\377\377\377\377\377\377\377\377\377\165\165\165\377\377\377\377\377\377"
    "\377\377\377\164\164\164\377\377\377\377\377\247\247\247\377\3\3\3\375\0\0\0\53"
    "\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\7\7\7\240\174\174\174"
    "\376\324\324\324\377\16\16\16\376\377\377\377\377\355\355\355\377\373\373\373"
    "\377\377\377\377\377\377\377\377\377\305\305\305\377\377\377\377\377\377\377\377"
    "\377\301\301\301\377\377\377\377\377\377\377\377\377\10\10\10\373\0\0\0\74\0\0\0"
    "\12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\7\17\17\17\332\301\301\301\377"
    "\343\343\343\377\16\16\16\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\376\376\376\377\377\377\377\377\377\377\377\377"
    "\374\374\374\377\377\377\377\377\377\377\377\377\10\10\10\373\0\0\0\77\0\0\0\13"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\15\15\15\355\333\333\333\377"
    "\352\352\352\377\17\17\17\377\377\377\377\377\353\353\353\377\335\335\335\377"
    "\374\374\374\377\356\356\356\377\332\332\332\377\370\370\370\377\363\363\363\377"
    "\327\327\327\377\377\377\377\377\377\377\377\377\10\10\10\373\0\0\0\77\0\0\0\13"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\14\13\13\13\362\344\344\344\377"
    "\374\374\374\377\322\322\322\377\376\376\376\377\235\235\235\377\240\240\240\377"
    "\373\373\373\377\236\236\236\377\242\242\242\377\365\365\365\377\240\240\240\377"
    "\245\245\245\377\377\377\377\377\377\377\377\377\10\10\10\373\0\0\0\77\0\0\0\13"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\15\7\7\7\367\350\350\350\377\373"
    "\373\373\377\373\373\373\377\373\373\373\377\373\373\373\377\373\373\373\377\373"
    "\373\373\377\373\373\373\377\373\373\373\377\373\373\373\377\373\373\373\377\373"
    "\373\373\377\373\373\373\377\373\373\373\377\10\10\10\373\0\0\0\77\0\0\0\13\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\16\4\4\4\373\343\343\343\377\355\355"
    "\355\377\355\355\355\377\355\355\355\377\355\355\355\377\355\355\355\377\355\355"
    "\355\377\355\355\355\377\355\355\355\377\355\355\355\377\355\355\355\377\355\355"
    "\355\377\355\355\355\377\353\353\353\377\6\6\6\374\0\0\0\74\0\0\0\13\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\14\13\13\13\346\241\241\241\377\337\337\337"
    "\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337"
    "\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337"
    "\377\337\337\337\377\217\217\217\377\14\14\14\350\0\0\0\57\0\0\0\12\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\0\142\7\7\7\366\10\10\10\372\14\14\14"
    "\371\13\13\13\372\12\12\12\372\12\12\12\372\12\12\12\372\11\11\11\372\11\11\11"
    "\372\11\11\11\372\10\10\10\373\10\10\10\373\10\10\10\373\11\11\11\362\0\0\0\175"
    "\0\0\0\40\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\12\0\0\0"
    "\41\0\0\0\105\0\0\0\122\0\0\0\122\0\0\0\122\0\0\0\122\0\0\0\120\0\0\0\117\0\0\0"
    "\117\0\0\0\115\0\0\0\115\0\0\0\115\0\0\0\113\0\0\0\73\0\0\0\41\0\0\0\12\0\0\0\1"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\5\0\0\0\11\0\0\0"
    "\14\0\0\0\14\0\0\0\14\0\0\0\14\0\0\0\14\0\0\0\14\0\0\0\14\0\0\0\13\0\0\0\13\0\0"
    "\0\13\0\0\0\13\0\0\0\11\0\0\0\5\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"open-hand", 11, 5,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\13\0\0\0\11\0\0\0\4\0\0\0"
    "\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\7\7\7"
    "\206\7\7\7\370\6\6\6\371\3\3\3\173\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\23\7\7\7\371\342\342\342\377\313\313\313\377"
    "\12\12\12\363\0\0\0\34\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\1\0\0\0\37\10\10\10\372\377\377\377\377\347\347\347\377\11\11\11\366\0\0\0"
    "\46\0\0\0\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\40\10"
    "\10\10\372\377\377\377\377\347\347\347\377\11\11\11\366\0\0\0\53\0\0\0\15\0\0\0"
    "\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\40\10\10\10\372\377\377"
    "\377\377\347\347\347\377\2\2\2\376\13\13\13\362\12\12\12\353\0\0\0\103\0\0\0\11"
    "\0\0\0\6\0\0\0\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\40\10\10\10\372\377\377\377\377"
    "\350\350\350\377\114\114\114\377\345\345\345\377\215\215\215\377\7\7\7\364\12\12"
    "\12\363\12\12\12\360\0\0\0\145\0\0\0\26\0\0\0\7\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\5\0\0\0\46\10\10\10\372"
    "\377\377\377\377\347\347\347\377\232\232\232\377\377\377\377\377\345\345\345\377"
    "\46\46\46\377\341\341\341\377\304\304\304\377\11\11\11\374\5\5\5\374\13\13\13"
    "\344\0\0\0\114\0\0\0\6\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\54\10\10\10\357\3\3\3\374\13\13\13\374\377\377\377\377\347\347\347\377\331"
    "\331\331\377\377\377\377\377\377\377\377\377\165\165\165\377\377\377\377\377\377"
    "\377\377\377\164\164\164\377\377\377\377\377\247\247\247\377\3\3\3\375\0\0\0\53"
    "\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\7\7\7\240\174\174\174"
    "\376\324\324\324\377\16\16\16\376\377\377\377\377\355\355\355\377\373\373\373"
    "\377\377\377\377\377\377\377\377\377\305\305\305\377\377\377\377\377\377\377\377"
    "\377\301\301\301\377\377\377\377\377\377\377\377\377\10\10\10\373\0\0\0\74\0\0\0"
    "\12\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\7\17\17\17\332\301\301\301\377"
    "\343\343\343\377\16\16\16\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\376\376\376\377\377\377\377\377\377\377\377\377"
    "\374\374\374\377\377\377\377\377\377\377\377\377\10\10\10\373\0\0\0\77\0\0\0\13"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\13\15\15\15\355\333\333\333\377"
    "\352\352\352\377\17\17\17\377\377\377\377\377\353\353\353\377\335\335\335\377"
    "\374\374\374\377\356\356\356\377\332\332\332\377\370\370\370\377\363\363\363\377"
    "\327\327\327\377\377\377\377\377\377\377\377\377\10\10\10\373\0\0\0\77\0\0\0\13"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\14\13\13\13\362\344\344\344\377"
    "\374\374\374\377\322\322\322\377\376\376\376\377\235\235\235\377\240\240\240\377"
    "\373\373\373\377\236\236\236\377\242\242\242\377\365\365\365\377\240\240\240\377"
    "\245\245\245\377\377\377\377\377\377\377\377\377\10\10\10\373\0\0\0\77\0\0\0\13"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\15\7\7\7\367\350\350\350\377\373"
    "\373\373\377\373\373\373\377\373\373\373\377\373\373\373\377\373\373\373\377\373"
    "\373\373\377\373\373\373\377\373\373\373\377\373\373\373\377\373\373\373\377\373"
    "\373\373\377\373\373\373\377\373\373\373\377\10\10\10\373\0\0\0\77\0\0\0\13\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\16\4\4\4\373\343\343\343\377\355\355"
    "\355\377\355\355\355\377\355\355\355\377\355\355\355\377\355\355\355\377\355\355"
    "\355\377\355\355\355\377\355\355\355\377\355\355\355\377\355\355\355\377\355\355"
    "\355\377\355\355\355\377\353\353\353\377\6\6\6\374\0\0\0\74\0\0\0\13\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\14\13\13\13\346\241\241\241\377\337\337\337"
    "\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337"
    "\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337"
    "\377\337\337\337\377\217\217\217\377\14\14\14\350\0\0\0\57\0\0\0\12\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\0\142\7\7\7\366\10\10\10\372\14\14\14"
    "\371\13\13\13\372\12\12\12\372\12\12\12\372\12\12\12\372\11\11\11\372\11\11\11"
    "\372\11\11\11\372\10\10\10\373\10\10\10\373\10\10\10\373\11\11\11\362\0\0\0\175"
    "\0\0\0\40\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\12\0\0\0"
    "\41\0\0\0\105\0\0\0\122\0\0\0\122\0\0\0\122\0\0\0\122\0\0\0\120\0\0\0\117\0\0\0"
    "\117\0\0\0\115\0\0\0\115\0\0\0\115\0\0\0\113\0\0\0\73\0\0\0\41\0\0\0\12\0\0\0\1"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\5\0\0\0\11\0\0\0"
    "\14\0\0\0\14\0\0\0\14\0\0\0\14\0\0\0\14\0\0\0\14\0\0\0\14\0\0\0\13\0\0\0\13\0\0"
    "\0\13\0\0\0\13\0\0\0\11\0\0\0\5\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"closed-hand", 15, 13,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\7\7\7\214\5\5\5\371\2\2\2\374\1\1\1\143\0\0\0"
    "\47\0\0\0\34\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\2\2\140\7\7\7\364\3\3\3"
    "\373\15\15\15\372\351\351\351\377\320\320\320\377\33\33\33\371\27\27\27\364\10"
    "\10\10\370\1\1\1\145\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\10\10\10\365\313\313\313"
    "\377\367\367\367\377\142\142\142\377\377\377\377\377\377\377\377\377\116\116\116"
    "\377\377\377\377\377\323\323\323\377\7\7\7\371\0\0\0\103\0\0\0\25\0\0\0\3\0\0\0"
    "\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\15\0\0"
    "\0\43\10\10\10\371\377\377\377\377\377\377\377\377\255\255\255\377\377\377\377"
    "\377\377\377\377\377\245\245\245\377\377\377\377\377\377\377\377\377\35\35\35"
    "\375\24\24\24\367\11\11\11\361\0\0\0\120\0\0\0\15\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\31\3\3\3\371\10\10\10\371\14\14\14\375\377\377"
    "\377\377\377\377\377\377\361\361\361\377\377\377\377\377\377\377\377\377\363\363"
    "\363\377\377\377\377\377\377\377\377\377\312\312\312\377\377\377\377\377\254\254"
    "\254\377\5\5\5\370\0\0\0\101\0\0\0\17\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\3\3\3\3\210\132\132\132\370\357\357\357\377\17\17\17\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\367\367\367\377"
    "\3\3\3\375\0\0\0\115\0\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\13"
    "\13\13\354\312\312\312\377\357\357\357\377\17\17\17\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\367\367\367\377\3\3\3"
    "\375\0\0\0\116\0\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\3\3\3"
    "\374\367\367\367\377\366\366\366\377\170\170\170\377\377\377\377\377\325\325\325"
    "\377\375\375\375\377\363\363\363\377\326\326\326\377\373\373\373\377\370\370\370"
    "\377\332\332\332\377\367\367\367\377\373\373\373\377\367\367\367\377\3\3\3\375\0"
    "\0\0\116\0\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\3\3\3\374\367"
    "\367\367\377\377\377\377\377\377\377\377\377\377\377\377\377\243\243\243\377\260"
    "\260\260\377\352\352\352\377\240\240\240\377\256\256\256\377\361\361\361\377\236"
    "\236\236\377\251\251\251\377\366\366\366\377\367\367\367\377\3\3\3\375\0\0\0\116"
    "\0\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\3\3\3\374\361\361\361"
    "\377\372\372\372\377\372\372\372\377\372\372\372\377\372\372\372\377\365\365\365"
    "\377\372\372\372\377\372\372\372\377\365\365\365\377\372\372\372\377\372\372\372"
    "\377\366\366\366\377\372\372\372\377\362\362\362\377\3\3\3\375\0\0\0\116\0\0\0"
    "\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\15\15\15\334\261\261\261\377"
    "\361\361\361\377\361\361\361\377\361\361\361\377\361\361\361\377\361\361\361\377"
    "\361\361\361\377\361\361\361\377\361\361\361\377\361\361\361\377\361\361\361\377"
    "\361\361\361\377\361\361\361\377\340\340\340\377\6\6\6\372\0\0\0\116\0\0\0\22\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\1\1\1\174\67\67\67\371\330\330"
    "\330\377\350\350\350\377\350\350\350\377\350\350\350\377\350\350\350\377\350\350"
    "\350\377\350\350\350\377\350\350\350\377\350\350\350\377\350\350\350\377\350\350"
    "\350\377\350\350\350\377\214\214\214\377\16\16\16\341\0\0\0\113\0\0\0\21\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\31\7\7\7\265\7\7\7\372\21\21\21"
    "\370\20\20\20\370\20\20\20\370\20\20\20\370\17\17\17\371\16\16\16\371\16\16\16"
    "\371\16\16\16\371\15\15\15\371\15\15\15\371\15\15\15\371\11\11\11\363\0\0\0\200"
    "\0\0\0\65\0\0\0\13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0"
    "\17\0\0\0\105\0\0\0\151\0\0\0\157\0\0\0\157\0\0\0\157\0\0\0\156\0\0\0\154\0\0\0"
    "\154\0\0\0\154\0\0\0\153\0\0\0\152\0\0\0\152\0\0\0\134\0\0\0\73\0\0\0\22\0\0\0\2"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\5\0\0\0"
    "\10\0\0\0\11\0\0\0\11\0\0\0\11\0\0\0\11\0\0\0\10\0\0\0\10\0\0\0\10\0\0\0\10\0\0"
    "\0\10\0\0\0\10\0\0\0\10\0\0\0\5\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"horizontal-resize", 13, 13,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\147\0\0\0\4\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\2\0\0\0\127\0\0\0\3\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\2\2\2\147\0\0\0\375"
    "\0\0\0\25\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\11\3\3\3\362\2\2\2\161\0\0\0\10"
    "\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\1\2\2\2\143\21\21\21\367\0\0\0\377\0\0\0\50\0\0\0\14\0\0\0\1\0\0"
    "\0\0\0\0\0\1\0\0\0\16\7\7\7\370\20\20\20\372\3\3\3\173\0\0\0\10\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\1\135\21\21"
    "\21\367\326\326\326\377\0\0\0\377\0\0\0\56\0\0\0\15\0\0\0\1\0\0\0\0\0\0\0\1\0\0"
    "\0\20\7\7\7\371\314\314\314\377\25\25\25\370\3\3\3\175\0\0\0\10\0\0\0\1\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\1\131\17\17\17\366\324\324"
    "\324\377\377\377\377\377\0\0\0\377\0\0\0\57\0\0\0\15\0\0\0\2\0\0\0\0\0\0\0\2\0\0"
    "\0\20\7\7\7\371\357\357\357\377\336\336\336\377\26\26\26\370\4\4\4\200\0\0\0\10"
    "\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\125\17\17\17\366\322\322"
    "\322\377\377\377\377\377\377\377\377\377\0\0\0\377\14\14\14\360\14\14\14\356\14"
    "\14\14\356\14\14\14\355\14\14\14\356\14\14\14\356\1\1\1\377\357\357\357\377\377"
    "\377\377\377\340\340\340\377\27\27\27\370\3\3\3\201\0\0\0\10\0\0\0\1\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\120\17\17\17\366\320\320\320\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337"
    "\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337\377\375\375\375"
    "\377\377\377\377\377\377\377\377\377\341\341\341\377\31\31\31\370\4\4\4\204\0\0"
    "\0\10\0\0\0\1\0\0\0\1\0\0\0\60\4\4\4\373\302\302\302\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\365\365\365\377\364\364\364\377\364\364\364\377\364\364"
    "\364\377\364\364\364\377\364\364\364\377\364\364\364\377\364\364\364\377\364\364"
    "\364\377\365\365\365\377\377\377\377\377\377\377\377\377\377\377\377\377\334\334"
    "\334\377\4\4\4\376\0\0\0\145\0\0\0\6\0\0\0\2\0\0\0\17\7\7\7\262\62\62\62\367\353"
    "\353\353\377\373\373\373\377\376\376\376\377\326\326\326\377\327\327\327\377\327"
    "\327\327\377\327\327\327\377\327\327\327\377\327\327\327\377\327\327\327\377\327"
    "\327\327\377\327\327\327\377\326\326\326\377\376\376\376\377\376\376\376\377\357"
    "\357\357\377\102\102\102\371\12\12\12\321\0\0\0\67\0\0\0\17\0\0\0\1\0\0\0\10\0\0"
    "\0\43\10\10\10\274\64\64\64\367\336\336\336\377\355\355\355\377\345\345\345\377"
    "\31\31\31\373\23\23\23\370\23\23\23\370\23\23\23\370\23\23\23\370\23\23\23\370"
    "\23\23\23\370\31\31\31\373\327\327\327\377\367\367\367\377\342\342\342\377\100"
    "\100\100\371\11\11\11\322\0\0\0\112\0\0\0\41\0\0\0\10\0\0\0\0\0\0\0\1\0\0\0\12\0"
    "\0\0\46\10\10\10\276\66\66\66\367\331\331\331\377\344\344\344\377\0\0\0\377\0\0"
    "\0\157\0\0\0\151\0\0\0\147\0\0\0\147\0\0\0\147\0\0\0\151\6\6\6\373\321\321\321"
    "\377\331\331\331\377\77\77\77\371\11\11\11\320\0\0\0\113\0\0\0\44\0\0\0\12\0\0\0"
    "\1\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\13\0\0\0\46\10\10\10\277\71\71\71\370\354\354"
    "\354\377\0\0\0\377\0\0\0\72\0\0\0\40\0\0\0\27\0\0\0\26\0\0\0\27\0\0\0\42\7\7\7"
    "\371\325\325\325\377\75\75\75\370\11\11\11\317\0\0\0\112\0\0\0\43\0\0\0\12\0\0\0"
    "\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\13\0\0\0\50\10\10\10\302\73\73"
    "\73\367\0\0\0\377\0\0\0\57\0\0\0\16\0\0\0\2\0\0\0\1\0\0\0\2\0\0\0\21\7\7\7\371"
    "\63\63\63\371\11\11\11\315\0\0\0\111\0\0\0\43\0\0\0\12\0\0\0\1\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\13\0\0\0\50\10\10\10\303\0\0\0\377"
    "\0\0\0\56\0\0\0\15\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\20\4\4\4\366\11\11\11\310\0\0\0"
    "\110\0\0\0\43\0\0\0\12\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\2\0\0\0\14\0\0\0\51\0\0\0\271\0\0\0\51\0\0\0\14\0\0\0\1\0\0"
    "\0\0\0\0\0\1\0\0\0\17\0\0\0\247\0\0\0\73\0\0\0\42\0\0\0\12\0\0\0\1\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0"
    "\14\0\0\0\34\0\0\0\27\0\0\0\11\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\12\0\0\0\31\0\0\0"
    "\27\0\0\0\11\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\4\0\0\0\5\0\0\0\2\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\2\0\0\0\5\0\0\0\4\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"vertical-resize", 13, 13,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\2\0\0\0\76\0\0\0\6\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\5\5\5\202\1\1\1\376\5\5\5\214\0\0\0\14\0\0\0"
    "\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\4\4\4\200\40"
    "\40\40\366\324\324\324\377\40\40\40\367\4\4\4\220\0\0\0\15\0\0\0\2\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\4\4\4\176\36\36\36\365\351\351\351\377\377"
    "\377\377\377\351\351\351\377\36\36\36\367\4\4\4\216\0\0\0\15\0\0\0\2\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\2\4\4\4\175\35\35\35\366\347\347\347\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\347\347\347\377\35\35\35\367\4\4\4\215\0\0\0\14\0\0"
    "\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\2\4\4\4\174\33\33\33\366\346\346\346\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\346\346\346\377\33"
    "\33\33\367\4\4\4\214\0\0\0\14\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\3\3\3\172\32\32\32\366\345\345\345\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\345\345\345\377\32\32\32\367\3\3\3\212\0\0\0\14"
    "\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\161\0\0\0\377\2\2\2\376\4\4\4\375\4\4\4\375\5\5\5\376\377\377\377\377\377\377"
    "\377\377\377\377\377\377\5\5\5\376\4\4\4\375\4\4\4\375\2\2\2\376\0\0\0\377\0\0\0"
    "\202\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0"
    "\0\0\23\0\0\0\60\0\0\0\104\0\0\0\112\0\0\0\115\0\0\0\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\0\0\0\377\0\0\0\133\0\0\0\116\0\0\0\112\0\0\0\105\0\0\0"
    "\61\0\0\0\16\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\4\0\0\0\14\0\0\0\20\0\0\0\21\0\0\0\32\0\0\0\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\0\0\0\377\0\0\0\76\0\0\0\33\0\0\0\21\0\0\0\20\0\0\0\14\0\0"
    "\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\1\0\0\0\1\0\0\0\13\0\0\0\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\0\0\0\377\0\0\0\66\0\0\0\14\0\0\0\1\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\12\0\0\0\377\377\377\377\377\377\377\377\377\377\377\377\377\0\0\0"
    "\377\0\0\0\66\0\0\0\14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12"
    "\0\0\0\377\377\377\377\377\377\377\377\377\377\377\377\377\0\0\0\377\0\0\0\66\0"
    "\0\0\14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\4\0\0\0\5\0\0\0\6\0\0\0\17\0\0\0\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\0\0\0\377\0\0\0\70\0\0\0\21\0\0\0\6"
    "\0\0\0\5\0\0\0\4\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\2\0\0\0\212\4\4\4\365\7\7\7\370\7\7\7\370\7\7\7\370\0\0\0\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\0\0\0\377\7\7\7\371\7\7\7\370\7\7\7\370\4\4"
    "\4\365\0\0\0\222\0\0\0\12\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\1\0\0\0\16\7\7\7\255\43\43\43\371\334\334\334\377\357\357\357\377\357"
    "\357\357\377\377\377\377\377\377\377\377\377\377\377\377\377\357\357\357\377\357"
    "\357\357\377\336\336\336\377\47\47\47\370\7\7\7\271\0\0\0\61\0\0\0\16\0\0\0\1\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\30\7\7\7"
    "\257\50\50\50\370\340\340\340\377\372\372\372\377\377\377\377\377\377\377\377"
    "\377\376\376\376\377\372\372\372\377\343\343\343\377\55\55\55\370\7\7\7\275\0\0"
    "\0\100\0\0\0\32\0\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\5\0\0\0\30\6\6\6\252\45\45\45\370\326\326\326\377\360\360"
    "\360\377\375\375\375\377\355\355\355\377\332\332\332\377\53\53\53\370\7\7\7\274"
    "\0\0\0\100\0\0\0\32\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\27\5\5\5\246\42\42\42\370\320"
    "\320\320\377\331\331\331\377\331\331\331\377\51\51\51\370\6\6\6\272\0\0\0\100\0"
    "\0\0\32\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\27\5\5\5\241\37\37\37\370"
    "\313\313\313\377\47\47\47\370\6\6\6\270\0\0\0\77\0\0\0\32\0\0\0\5\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\26\4\4\4\234\1\1\1\376\6\6\6\266\0\0\0"
    "\77\0\0\0\32\0\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\4\0\0\0\25\0\0\0\145\0\0\0\67\0\0\0\31\0\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0\14\0\0\0\16\0\0\0\4\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\1\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"diagonal-resize-bottom-to-top", 22, 5,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2"
    "\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\1\0\0\0\1\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\10\10\10\236\7\7\7\367\7\7\7\367\7\7\7"
    "\367\7\7\7\367\7\7\7\367\7\7\7\367\7\7\7\367\7\7\7\367\7\7\7\367\7\7\7\367\7\7\7"
    "\367\7\7\7\367\7\7\7\367\7\7\7\367\7\7\7\367\13\13\13\306\0\0\0\14\0\0\0\4\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\3\3\3\374\337\337\337\377\357\357\357\377\357"
    "\357\357\377\357\357\357\377\357\357\357\377\357\357\357\377\357\357\357\377\357"
    "\357\357\377\357\357\357\377\357\357\357\377\357\357\357\377\357\357\357\377\357"
    "\357\357\377\357\357\357\377\357\357\357\377\3\3\3\375\0\0\0\65\0\0\0\17\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\7\3\3\3\374\362\362\362\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\4\4\4\375\0\0\0\106\0\0\0\26\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\7\12\12\12\304\6\6\6\374\10\10\10\373\10\10\10"
    "\373\10\10\10\373\10\10\10\373\10\10\10\373\10\10\10\373\10\10\10\373\10\10\10"
    "\373\10\10\10\373\10\10\10\373\10\10\10\373\14\14\14\375\370\370\370\377\377\377"
    "\377\377\4\4\4\375\0\0\0\110\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0"
    "\0\0\32\0\0\0\106\0\0\0\131\0\0\0\134\0\0\0\133\0\0\0\133\0\0\0\133\0\0\0\133\0"
    "\0\0\133\0\0\0\133\0\0\0\133\0\0\0\133\0\0\0\135\3\3\3\375\367\367\367\377\377"
    "\377\377\377\4\4\4\375\0\0\0\111\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\1\0\0\0\66\2\2\2\346\7\7\7\370\7\7\7\370\7\7\7\370\7\7\7\370\7\7\7\370\7\7\7"
    "\370\7\7\7\370\7\7\7\370\7\7\7\370\4\4\4\366\0\0\0\67\3\3\3\374\367\367\367\377"
    "\377\377\377\377\4\4\4\375\0\0\0\111\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\7\0\0\0\116\11\11\11\367\246\246\246\377\357\357\357\377\357\357"
    "\357\377\357\357\357\377\357\357\357\377\357\357\357\377\357\357\357\377\357\357"
    "\357\377\10\10\10\373\0\0\0\110\3\3\3\374\367\367\367\377\377\377\377\377\4\4\4"
    "\375\0\0\0\111\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\20"
    "\0\0\0\132\12\12\12\367\264\264\264\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\376\376\376\377\375\375\375\377\10\10\10\373\0\0\0\124"
    "\3\3\3\374\367\367\367\377\377\377\377\377\4\4\4\375\0\0\0\111\0\0\0\30\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0\20\0\0\0\132\12\12\12\367"
    "\262\262\262\377\377\377\377\377\377\377\377\377\377\377\377\377\375\375\375\377"
    "\367\367\367\377\10\10\10\373\0\0\0\125\3\3\3\374\367\367\367\377\377\377\377"
    "\377\4\4\4\375\0\0\0\111\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\3\0\0\0\20\2\2\2\243\40\40\40\373\372\372\372\377\377\377\377"
    "\377\377\377\377\377\375\375\375\377\362\362\362\377\10\10\10\373\0\0\0\125\3\3"
    "\3\374\367\367\367\377\377\377\377\377\4\4\4\375\0\0\0\111\0\0\0\30\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\3\3\3\162\27\27\27\366\332"
    "\332\332\377\351\351\351\377\332\332\332\377\375\375\375\377\373\373\373\377\355"
    "\355\355\377\10\10\10\373\0\0\0\125\3\3\3\374\367\367\367\377\377\377\377\377\4"
    "\4\4\375\0\0\0\111\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\1\3\3\3\160\27\27\27\366\333\333\333\377\352\352\352\377\241\241\241\377\4\4"
    "\4\375\244\244\244\376\352\352\352\377\345\345\345\377\10\10\10\373\0\0\0\125\3"
    "\3\3\374\367\367\367\377\377\377\377\377\4\4\4\375\0\0\0\111\0\0\0\30\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\2\2\2\157\27\27\27\366\334\334\334\377"
    "\355\355\355\377\254\254\254\377\11\11\11\370\0\0\0\234\11\11\11\367\245\245\245"
    "\376\340\340\340\377\10\10\10\373\0\0\0\125\3\3\3\374\367\367\367\377\377\377"
    "\377\377\4\4\4\375\0\0\0\111\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2"
    "\2\2\157\26\26\26\365\335\335\335\377\357\357\357\377\270\270\270\377\13\13\13"
    "\371\0\0\0\203\0\0\0\104\0\0\0\143\11\11\11\366\261\261\261\377\10\10\10\373\0\0"
    "\0\125\3\3\3\374\367\367\367\377\377\377\377\377\4\4\4\375\0\0\0\111\0\0\0\30\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\55\1\1\1\376\261\261\261\377\351\351\351"
    "\377\277\277\277\377\15\15\15\372\0\0\0\216\0\0\0\100\0\0\0\36\0\0\0\24\0\0\0"
    "\126\12\12\12\366\2\2\2\376\0\0\0\125\3\3\3\374\364\364\364\377\375\375\375\377"
    "\3\3\3\375\0\0\0\110\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\10\1\1\1\166"
    "\15\15\15\371\243\243\243\377\22\22\22\371\1\1\1\231\0\0\0\103\0\0\0\36\0\0\0\7"
    "\0\0\0\3\0\0\0\17\0\0\0\131\2\2\2\366\0\0\0\120\13\13\13\312\7\7\7\373\7\7\7\373"
    "\13\13\13\334\0\0\0\100\0\0\0\25\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0"
    "\23\0\0\0\160\3\3\3\373\3\3\3\244\0\0\0\105\0\0\0\41\0\0\0\10\0\0\0\0\0\0\0\0\0"
    "\0\0\3\0\0\0\20\0\0\0\125\0\0\0\67\0\0\0\55\0\0\0\106\0\0\0\126\0\0\0\107\0\0\0"
    "\51\0\0\0\14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\24\0\0\0\104"
    "\0\0\0\70\0\0\0\42\0\0\0\12\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0\13\0\0"
    "\0\20\0\0\0\15\0\0\0\20\0\0\0\24\0\0\0\22\0\0\0\12\0\0\0\3\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0\13\0\0\0\17\0\0\0\10\0\0\0\1\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\1\0\0\0\1\0\0\0\1\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\1\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0"
},
CursorData{"diagonal-resize-top_to_bottom", 24, 24,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\25\0\0\0"
    "\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\116\4\4\4\367\0\0\0\140\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\67\0\0\0\4\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\1\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\142\15\15\15\367\230\230\230"
    "\377\13\13\13\370\0\0\0\137\0\0\0\11\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\63\2"
    "\2\2\361\0\0\0\25\12\12\12\262\0\0\0\377\0\0\0\377\13\13\13\303\0\0\0\15\0\0\0\4"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\70\0\0\0\377\301\301\301\377\377\377\377"
    "\377\277\277\277\377\11\11\11\370\0\0\0\122\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\61\13"
    "\13\13\361\0\0\0\377\0\0\0\63\3\3\3\374\363\363\363\377\374\374\374\377\3\3\3"
    "\375\0\0\0\64\0\0\0\20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\11\6\6\6\230\46\46"
    "\46\367\355\355\355\377\377\377\377\377\261\261\261\377\11\11\11\366\0\0\0\106\0"
    "\0\0\7\0\0\0\56\13\13\13\360\265\265\265\377\0\0\0\377\0\0\0\105\3\3\3\374\367"
    "\367\367\377\377\377\377\377\4\4\4\375\0\0\0\106\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\4\0\0\0\27\6\6\6\244\46\46\46\370\355\355\355\377\377\377\377"
    "\377\241\241\241\376\11\11\11\362\0\0\0\141\13\13\13\360\260\260\260\376\377\377"
    "\377\377\0\0\0\377\0\0\0\110\3\3\3\374\367\367\367\377\377\377\377\377\4\4\4\375"
    "\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\0\32\6\6"
    "\6\246\46\46\46\370\355\355\355\377\377\377\377\377\216\216\216\375\2\2\2\376"
    "\254\254\254\376\377\377\377\377\377\377\377\377\0\0\0\377\0\0\0\111\3\3\3\374"
    "\367\367\367\377\377\377\377\377\4\4\4\375\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\0\32\7\7\7\250\46\46\46\370\355\355"
    "\355\377\377\377\377\377\327\327\327\377\377\377\377\377\377\377\377\377\376\376"
    "\376\377\0\0\0\377\0\0\0\111\3\3\3\374\367\367\367\377\377\377\377\377\4\4\4\375"
    "\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\6\0\0\0\33\5\5\5\274\62\62\62\373\376\376\376\377\377\377\377\377\377\377\377"
    "\377\375\375\375\377\371\371\371\377\0\0\0\377\0\0\0\111\3\3\3\374\367\367\367"
    "\377\377\377\377\377\4\4\4\375\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\77\13\13\13\365\267\267\267\377\376\376"
    "\376\377\376\376\376\377\376\376\376\377\373\373\373\377\361\361\361\377\0\0\0"
    "\377\0\0\0\111\3\3\3\374\367\367\367\377\377\377\377\377\4\4\4\375\0\0\0\112\0\0"
    "\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\73\13\13\13"
    "\363\261\261\261\377\335\335\335\377\331\331\331\377\332\332\332\377\332\332\332"
    "\377\332\332\332\377\350\350\350\377\0\0\0\377\0\0\0\111\3\3\3\374\367\367\367"
    "\377\377\377\377\377\4\4\4\375\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\73\14\14\14\363\272\272\272\377\353\353\353\377\344\344"
    "\344\377\345\345\345\377\345\345\345\377\345\345\345\377\346\346\346\377\362\362"
    "\362\377\0\0\0\377\0\0\0\111\3\3\3\374\367\367\367\377\377\377\377\377\4\4\4\375"
    "\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\75\2\2\2\364\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\107\3\3\3\374\367\367\367\377\377\377\377\377\4\4\4\375"
    "\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\10\0\0\0\41\0"
    "\0\0\76\0\0\0\115\0\0\0\120\0\0\0\120\0\0\0\120\0\0\0\120\0\0\0\120\0\0\0\120\0"
    "\0\0\120\0\0\0\113\0\0\0\72\3\3\3\374\367\367\367\377\377\377\377\377\4\4\4\375"
    "\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\11\11\11\257\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0"
    "\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\367\367\367\377\377\377\377\377\4\4"
    "\4\375\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\3\3\3\374\356"
    "\356\356\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\4\4"
    "\4\375\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\3\3\3\374\356"
    "\356\356\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\376\376\376\377\4\4"
    "\4\375\0\0\0\112\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\11\11\11\267\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\12\12\12"
    "\344\0\0\0\100\0\0\0\30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0\24\0\0\0"
    "\70\0\0\0\113\0\0\0\116\0\0\0\115\0\0\0\115\0\0\0\115\0\0\0\115\0\0\0\115\0\0\0"
    "\115\0\0\0\115\0\0\0\115\0\0\0\115\0\0\0\115\0\0\0\115\0\0\0\115\0\0\0\105\0\0\0"
    "\52\0\0\0\17\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\0\0\0\16\0\0\0\24\0"
    "\0\0\24\0\0\0\24\0\0\0\24\0\0\0\24\0\0\0\24\0\0\0\24\0\0\0\24\0\0\0\24\0\0\0\24"
    "\0\0\0\24\0\0\0\24\0\0\0\24\0\0\0\24\0\0\0\22\0\0\0\12\0\0\0\4\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"omnidirectional-resize", 15, 13,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\7\7\7\214\5\5\5\371\2\2\2\374\1\1\1\143\0\0\0"
    "\47\0\0\0\34\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\2\2\140\7\7\7\364\3\3\3"
    "\373\15\15\15\372\351\351\351\377\320\320\320\377\33\33\33\371\27\27\27\364\10"
    "\10\10\370\1\1\1\145\0\0\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\5\10\10\10\365\313\313\313"
    "\377\367\367\367\377\142\142\142\377\377\377\377\377\377\377\377\377\116\116\116"
    "\377\377\377\377\377\323\323\323\377\7\7\7\371\0\0\0\103\0\0\0\25\0\0\0\3\0\0\0"
    "\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\15\0\0"
    "\0\43\10\10\10\371\377\377\377\377\377\377\377\377\255\255\255\377\377\377\377"
    "\377\377\377\377\377\245\245\245\377\377\377\377\377\377\377\377\377\35\35\35"
    "\375\24\24\24\367\11\11\11\361\0\0\0\120\0\0\0\15\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\31\3\3\3\371\10\10\10\371\14\14\14\375\377\377"
    "\377\377\377\377\377\377\361\361\361\377\377\377\377\377\377\377\377\377\363\363"
    "\363\377\377\377\377\377\377\377\377\377\312\312\312\377\377\377\377\377\254\254"
    "\254\377\5\5\5\370\0\0\0\101\0\0\0\17\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\3\3\3\3\210\132\132\132\370\357\357\357\377\17\17\17\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\367\367\367\377"
    "\3\3\3\375\0\0\0\115\0\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\13"
    "\13\13\354\312\312\312\377\357\357\357\377\17\17\17\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\367\367\367\377\3\3\3"
    "\375\0\0\0\116\0\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\3\3\3"
    "\374\367\367\367\377\366\366\366\377\170\170\170\377\377\377\377\377\325\325\325"
    "\377\375\375\375\377\363\363\363\377\326\326\326\377\373\373\373\377\370\370\370"
    "\377\332\332\332\377\367\367\367\377\373\373\373\377\367\367\367\377\3\3\3\375\0"
    "\0\0\116\0\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\3\3\3\374\367"
    "\367\367\377\377\377\377\377\377\377\377\377\377\377\377\377\243\243\243\377\260"
    "\260\260\377\352\352\352\377\240\240\240\377\256\256\256\377\361\361\361\377\236"
    "\236\236\377\251\251\251\377\366\366\366\377\367\367\367\377\3\3\3\375\0\0\0\116"
    "\0\0\0\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\3\3\3\374\361\361\361"
    "\377\372\372\372\377\372\372\372\377\372\372\372\377\372\372\372\377\365\365\365"
    "\377\372\372\372\377\372\372\372\377\365\365\365\377\372\372\372\377\372\372\372"
    "\377\366\366\366\377\372\372\372\377\362\362\362\377\3\3\3\375\0\0\0\116\0\0\0"
    "\22\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\15\15\15\334\261\261\261\377"
    "\361\361\361\377\361\361\361\377\361\361\361\377\361\361\361\377\361\361\361\377"
    "\361\361\361\377\361\361\361\377\361\361\361\377\361\361\361\377\361\361\361\377"
    "\361\361\361\377\361\361\361\377\340\340\340\377\6\6\6\372\0\0\0\116\0\0\0\22\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\1\1\1\174\67\67\67\371\330\330"
    "\330\377\350\350\350\377\350\350\350\377\350\350\350\377\350\350\350\377\350\350"
    "\350\377\350\350\350\377\350\350\350\377\350\350\350\377\350\350\350\377\350\350"
    "\350\377\350\350\350\377\214\214\214\377\16\16\16\341\0\0\0\113\0\0\0\21\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\31\7\7\7\265\7\7\7\372\21\21\21"
    "\370\20\20\20\370\20\20\20\370\20\20\20\370\17\17\17\371\16\16\16\371\16\16\16"
    "\371\16\16\16\371\15\15\15\371\15\15\15\371\15\15\15\371\11\11\11\363\0\0\0\200"
    "\0\0\0\65\0\0\0\13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0"
    "\17\0\0\0\105\0\0\0\151\0\0\0\157\0\0\0\157\0\0\0\157\0\0\0\156\0\0\0\154\0\0\0"
    "\154\0\0\0\154\0\0\0\153\0\0\0\152\0\0\0\152\0\0\0\134\0\0\0\73\0\0\0\22\0\0\0\2"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\5\0\0\0"
    "\10\0\0\0\11\0\0\0\11\0\0\0\11\0\0\0\11\0\0\0\10\0\0\0\10\0\0\0\10\0\0\0\10\0\0"
    "\0\10\0\0\0\10\0\0\0\10\0\0\0\5\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"vsplit-resize", 13, 13,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\2\0\0\0\76\0\0\0\6\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\5\5\5\202\1\1\1\376\5\5\5\214\0\0\0\14\0\0\0"
    "\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\4\4\4\200\40"
    "\40\40\366\324\324\324\377\40\40\40\367\4\4\4\220\0\0\0\15\0\0\0\2\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\4\4\4\176\36\36\36\365\351\351\351\377\377"
    "\377\377\377\351\351\351\377\36\36\36\367\4\4\4\216\0\0\0\15\0\0\0\2\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\2\4\4\4\175\35\35\35\366\347\347\347\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\347\347\347\377\35\35\35\367\4\4\4\215\0\0\0\14\0\0"
    "\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\2\4\4\4\174\33\33\33\366\346\346\346\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\346\346\346\377\33"
    "\33\33\367\4\4\4\214\0\0\0\14\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\3\3\3\172\32\32\32\366\345\345\345\377"
    "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\377\377\345\345\345\377\32\32\32\367\3\3\3\212\0\0\0\14"
    "\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\161\0\0\0\377\2\2\2\376\4\4\4\375\4\4\4\375\5\5\5\376\377\377\377\377\377\377"
    "\377\377\377\377\377\377\5\5\5\376\4\4\4\375\4\4\4\375\2\2\2\376\0\0\0\377\0\0\0"
    "\202\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0"
    "\0\0\23\0\0\0\60\0\0\0\104\0\0\0\112\0\0\0\115\0\0\0\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\0\0\0\377\0\0\0\133\0\0\0\116\0\0\0\112\0\0\0\105\0\0\0"
    "\61\0\0\0\16\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\4\0\0\0\14\0\0\0\20\0\0\0\21\0\0\0\32\0\0\0\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\0\0\0\377\0\0\0\76\0\0\0\33\0\0\0\21\0\0\0\20\0\0\0\14\0\0"
    "\0\4\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\1\0\0\0\1\0\0\0\13\0\0\0\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\0\0\0\377\0\0\0\66\0\0\0\14\0\0\0\1\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\12\0\0\0\377\377\377\377\377\377\377\377\377\377\377\377\377\0\0\0"
    "\377\0\0\0\66\0\0\0\14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\12"
    "\0\0\0\377\377\377\377\377\377\377\377\377\377\377\377\377\0\0\0\377\0\0\0\66\0"
    "\0\0\14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\4\0\0\0\5\0\0\0\6\0\0\0\17\0\0\0\377\377"
    "\377\377\377\377\377\377\377\377\377\377\377\0\0\0\377\0\0\0\70\0\0\0\21\0\0\0\6"
    "\0\0\0\5\0\0\0\4\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\2\0\0\0\212\4\4\4\365\7\7\7\370\7\7\7\370\7\7\7\370\0\0\0\377\377\377\377"
    "\377\377\377\377\377\377\377\377\377\0\0\0\377\7\7\7\371\7\7\7\370\7\7\7\370\4\4"
    "\4\365\0\0\0\222\0\0\0\12\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\1\0\0\0\16\7\7\7\255\43\43\43\371\334\334\334\377\357\357\357\377\357"
    "\357\357\377\377\377\377\377\377\377\377\377\377\377\377\377\357\357\357\377\357"
    "\357\357\377\336\336\336\377\47\47\47\370\7\7\7\271\0\0\0\61\0\0\0\16\0\0\0\1\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\30\7\7\7"
    "\257\50\50\50\370\340\340\340\377\372\372\372\377\377\377\377\377\377\377\377"
    "\377\376\376\376\377\372\372\372\377\343\343\343\377\55\55\55\370\7\7\7\275\0\0"
    "\0\100\0\0\0\32\0\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\5\0\0\0\30\6\6\6\252\45\45\45\370\326\326\326\377\360\360"
    "\360\377\375\375\375\377\355\355\355\377\332\332\332\377\53\53\53\370\7\7\7\274"
    "\0\0\0\100\0\0\0\32\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\27\5\5\5\246\42\42\42\370\320"
    "\320\320\377\331\331\331\377\331\331\331\377\51\51\51\370\6\6\6\272\0\0\0\100\0"
    "\0\0\32\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\27\5\5\5\241\37\37\37\370"
    "\313\313\313\377\47\47\47\370\6\6\6\270\0\0\0\77\0\0\0\32\0\0\0\5\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\0\0\26\4\4\4\234\1\1\1\376\6\6\6\266\0\0\0"
    "\77\0\0\0\32\0\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\4\0\0\0\25\0\0\0\145\0\0\0\67\0\0\0\31\0\0\0\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\3\0\0\0\14\0\0\0\16\0\0\0\4\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\1\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"hsplit-resize", 13, 13,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\147\0\0\0\4\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\2\0\0\0\127\0\0\0\3\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\2\2\2\147\0\0\0\375"
    "\0\0\0\25\0\0\0\10\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\11\3\3\3\362\2\2\2\161\0\0\0\10"
    "\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\1\2\2\2\143\21\21\21\367\0\0\0\377\0\0\0\50\0\0\0\14\0\0\0\1\0\0"
    "\0\0\0\0\0\1\0\0\0\16\7\7\7\370\20\20\20\372\3\3\3\173\0\0\0\10\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\1\135\21\21"
    "\21\367\326\326\326\377\0\0\0\377\0\0\0\56\0\0\0\15\0\0\0\1\0\0\0\0\0\0\0\1\0\0"
    "\0\20\7\7\7\371\314\314\314\377\25\25\25\370\3\3\3\175\0\0\0\10\0\0\0\1\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\1\131\17\17\17\366\324\324"
    "\324\377\377\377\377\377\0\0\0\377\0\0\0\57\0\0\0\15\0\0\0\2\0\0\0\0\0\0\0\2\0\0"
    "\0\20\7\7\7\371\357\357\357\377\336\336\336\377\26\26\26\370\4\4\4\200\0\0\0\10"
    "\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\1\1\125\17\17\17\366\322\322"
    "\322\377\377\377\377\377\377\377\377\377\0\0\0\377\14\14\14\360\14\14\14\356\14"
    "\14\14\356\14\14\14\355\14\14\14\356\14\14\14\356\1\1\1\377\357\357\357\377\377"
    "\377\377\377\340\340\340\377\27\27\27\370\3\3\3\201\0\0\0\10\0\0\0\1\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\120\17\17\17\366\320\320\320\377\377\377\377\377\377\377\377"
    "\377\377\377\377\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337"
    "\377\337\337\337\377\337\337\337\377\337\337\337\377\337\337\337\377\375\375\375"
    "\377\377\377\377\377\377\377\377\377\341\341\341\377\31\31\31\370\4\4\4\204\0\0"
    "\0\10\0\0\0\1\0\0\0\1\0\0\0\60\4\4\4\373\302\302\302\377\377\377\377\377\377\377"
    "\377\377\377\377\377\377\365\365\365\377\364\364\364\377\364\364\364\377\364\364"
    "\364\377\364\364\364\377\364\364\364\377\364\364\364\377\364\364\364\377\364\364"
    "\364\377\365\365\365\377\377\377\377\377\377\377\377\377\377\377\377\377\334\334"
    "\334\377\4\4\4\376\0\0\0\145\0\0\0\6\0\0\0\2\0\0\0\17\7\7\7\262\62\62\62\367\353"
    "\353\353\377\373\373\373\377\376\376\376\377\326\326\326\377\327\327\327\377\327"
    "\327\327\377\327\327\327\377\327\327\327\377\327\327\327\377\327\327\327\377\327"
    "\327\327\377\327\327\327\377\326\326\326\377\376\376\376\377\376\376\376\377\357"
    "\357\357\377\102\102\102\371\12\12\12\321\0\0\0\67\0\0\0\17\0\0\0\1\0\0\0\10\0\0"
    "\0\43\10\10\10\274\64\64\64\367\336\336\336\377\355\355\355\377\345\345\345\377"
    "\31\31\31\373\23\23\23\370\23\23\23\370\23\23\23\370\23\23\23\370\23\23\23\370"
    "\23\23\23\370\31\31\31\373\327\327\327\377\367\367\367\377\342\342\342\377\100"
    "\100\100\371\11\11\11\322\0\0\0\112\0\0\0\41\0\0\0\10\0\0\0\0\0\0\0\1\0\0\0\12\0"
    "\0\0\46\10\10\10\276\66\66\66\367\331\331\331\377\344\344\344\377\0\0\0\377\0\0"
    "\0\157\0\0\0\151\0\0\0\147\0\0\0\147\0\0\0\147\0\0\0\151\6\6\6\373\321\321\321"
    "\377\331\331\331\377\77\77\77\371\11\11\11\320\0\0\0\113\0\0\0\44\0\0\0\12\0\0\0"
    "\1\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\13\0\0\0\46\10\10\10\277\71\71\71\370\354\354"
    "\354\377\0\0\0\377\0\0\0\72\0\0\0\40\0\0\0\27\0\0\0\26\0\0\0\27\0\0\0\42\7\7\7"
    "\371\325\325\325\377\75\75\75\370\11\11\11\317\0\0\0\112\0\0\0\43\0\0\0\12\0\0\0"
    "\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\13\0\0\0\50\10\10\10\302\73\73"
    "\73\367\0\0\0\377\0\0\0\57\0\0\0\16\0\0\0\2\0\0\0\1\0\0\0\2\0\0\0\21\7\7\7\371"
    "\63\63\63\371\11\11\11\315\0\0\0\111\0\0\0\43\0\0\0\12\0\0\0\1\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\13\0\0\0\50\10\10\10\303\0\0\0\377"
    "\0\0\0\56\0\0\0\15\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\20\4\4\4\366\11\11\11\310\0\0\0"
    "\110\0\0\0\43\0\0\0\12\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\2\0\0\0\14\0\0\0\51\0\0\0\271\0\0\0\51\0\0\0\14\0\0\0\1\0\0"
    "\0\0\0\0\0\1\0\0\0\17\0\0\0\247\0\0\0\73\0\0\0\42\0\0\0\12\0\0\0\1\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0"
    "\14\0\0\0\34\0\0\0\27\0\0\0\11\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\12\0\0\0\31\0\0\0"
    "\27\0\0\0\11\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\0\0\0\4\0\0\0\5\0\0\0\2\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\2\0\0\0\5\0\0\0\4\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
CursorData{"crosshair", 13, 13,
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1"
    "\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\2\10\10\10\233\0\0\0\377\0\0\0\377\10\10\10\240\0\0\0\10"
    "\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\0"
    "\377\363\363\363\377\363\363\363\377\0\0\0\377\0\0\0\35\0\0\0\6\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\14\0\0\0\377\377\377\377\377\377"
    "\377\377\377\0\0\0\377\0\0\0\56\0\0\0\14\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\1\0\0\0\16\0\0\0\377\377\377\377\377\377\377\377\377\0\0\0\377\0"
    "\0\0\63\0\0\0\16\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0"
    "\16\0\0\0\377\377\377\377\377\377\377\377\377\0\0\0\377\0\0\0\63\0\0\0\16\0\0\0"
    "\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\16\0\0\0\377\377\377"
    "\377\377\377\377\377\377\0\0\0\377\0\0\0\63\0\0\0\16\0\0\0\1\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\16\0\0\0\377\363\363\363\377\363\363\363\377"
    "\0\0\0\377\0\0\0\63\0\0\0\16\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0"
    "\0\3\0\0\0\16\10\10\10\253\0\0\0\377\0\0\0\377\10\10\10\272\0\0\0\56\0\0\0\16\0"
    "\0\0\3\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\2"
    "\10\10\10\233\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\10\10"
    "\10\243\0\0\0\45\0\0\0\76\0\0\0\111\0\0\0\76\10\10\10\247\0\0\0\377\0\0\0\377\0"
    "\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\10\10\10\240\0\0\0\10\0\0\0\2\0\0\0\0\0\0"
    "\0\6\0\0\0\377\363\363\363\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\377\377\363\363\363\377\0\0\0\377\0\0\0\45\0\0\0\32\0\0\0\31\0\0\0\32\0"
    "\0\0\377\363\363\363\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\377\377\363\363\363\377\0\0\0\377\0\0\0\35\0\0\0\6\0\0\0\0\0\0\0\14\0\0\0\377"
    "\363\363\363\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
    "\363\363\363\377\0\0\0\377\0\0\0\56\0\0\0\15\0\0\0\4\0\0\0\15\0\0\0\377\363\363"
    "\363\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\363\363"
    "\363\377\0\0\0\377\0\0\0\55\0\0\0\14\0\0\0\1\0\0\0\14\10\10\10\252\0\0\0\377\0\0"
    "\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\10\10\10\272\0\0\0\56\0\0\0\15\0"
    "\0\0\4\0\0\0\15\10\10\10\253\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0\0\0\377\0"
    "\0\0\377\10\10\10\272\0\0\0\55\0\0\0\14\0\0\0\1\0\0\0\6\0\0\0\35\0\0\0\74\0\0\0"
    "\112\0\0\0\114\0\0\0\114\0\0\0\114\0\0\0\113\0\0\0\76\10\10\10\247\0\0\0\377\0\0"
    "\0\377\10\10\10\243\0\0\0\45\0\0\0\76\0\0\0\113\0\0\0\114\0\0\0\114\0\0\0\114\0"
    "\0\0\112\0\0\0\74\0\0\0\35\0\0\0\6\0\0\0\0\0\0\0\2\0\0\0\10\0\0\0\24\0\0\0\31\0"
    "\0\0\32\0\0\0\32\0\0\0\32\0\0\0\31\0\0\0\32\0\0\0\377\363\363\363\377\363\363"
    "\363\377\0\0\0\377\0\0\0\45\0\0\0\32\0\0\0\31\0\0\0\32\0\0\0\32\0\0\0\32\0\0\0"
    "\31\0\0\0\24\0\0\0\10\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\2\0\0\0\2\0\0\0\2\0"
    "\0\0\2\0\0\0\2\0\0\0\3\0\0\0\16\0\0\0\377\377\377\377\377\377\377\377\377\0\0\0"
    "\377\0\0\0\56\0\0\0\16\0\0\0\3\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\1\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0"
    "\0\0\16\0\0\0\377\377\377\377\377\377\377\377\377\0\0\0\377\0\0\0\63\0\0\0\16\0"
    "\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\16\0\0\0\377\377"
    "\377\377\377\377\377\377\377\0\0\0\377\0\0\0\63\0\0\0\16\0\0\0\1\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\16\0\0\0\377\377\377\377\377\377\377\377"
    "\377\0\0\0\377\0\0\0\63\0\0\0\16\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\1\0\0\0\16\0\0\0\377\363\363\363\377\363\363\363\377\0\0\0\377\0\0\0\63\0"
    "\0\0\16\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\14\10\10"
    "\10\253\0\0\0\377\0\0\0\377\10\10\10\272\0\0\0\56\0\0\0\14\0\0\0\1\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\0\0\0\35\0\0\0\74\0\0\0\110\0\0\0\74"
    "\0\0\0\35\0\0\0\6\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\2\0\0\0\10\0\0\0\24\0\0\0\30\0\0\0\24\0\0\0\10\0\0\0\2\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\2\0\0\0\2\0\0\0\2\0\0\0\1"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
},
};
}
