/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.contrib.ArcLine;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.standard.AbstractHandle;

public class ChangeArcCurvatureHandle
extends AbstractHandle {
    private final ArcLine myArc;

    public ChangeArcCurvatureHandle(ArcLine arcLine) {
        super(arcLine);
        this.myArc = arcLine;
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        super.invokeStep(n, n2, n3, n4, drawingView);
        Point point = this.myArc.endPoint();
        this.myArc.invalidate();
        this.myArc.controlPoint(new Point(n, n2));
        this.myArc.changed();
    }

    public Point locate() {
        Point point = this.myArc.controlPoint();
        return new Point(point.x, point.y);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        Point point = this.myArc.endPoint();
        graphics.setColor(Color.black);
        graphics.drawLine(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, point.x, point.y);
        graphics.setColor(Color.yellow);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

