/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CAddInCollectionDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/AddInCollectionXml.h"

using namespace Caf;

void AddInCollectionXml::add(
	const SmartPtrCAddInCollectionDoc addInCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AddInCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(addInCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<std::string> addInVal =
			addInCollectionDoc->getAddInCollection();
		CAF_CM_VALIDATE_STL(addInVal);

		if (! addInVal.empty()) {
			for (TConstIterator<std::deque<std::string> > addInIter(addInVal);
				addInIter; addInIter++) {
				const SmartPtrCXmlElement addInXml =
					thisXml->createAndAddElement("addIn");
				addInXml->setValue(*addInIter);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCAddInCollectionDoc AddInCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("AddInCollectionXml", "parse");

	SmartPtrCAddInCollectionDoc addInCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection addInChildrenXml =
			thisXml->findRequiredChildren("addIn");

		std::deque<std::string> addInVal;
		if (! addInChildrenXml.IsNull() && ! addInChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> addInXmlIter(*addInChildrenXml);
				addInXmlIter; addInXmlIter++) {
				const SmartPtrCXmlElement addInXml = addInXmlIter->second;
				const std::string addInDoc = addInXml->getValue();
				addInVal.push_back(addInDoc);
			}
		}

		addInCollectionDoc.CreateInstance();
		addInCollectionDoc->initialize(
			addInVal);
	}
	CAF_CM_EXIT;

	return addInCollectionDoc;
}

