/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CProtocolDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/ProtocolXml.h"

using namespace Caf;

void ProtocolXml::add(
	const SmartPtrCProtocolDoc protocolDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProtocolXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(protocolDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string uriVal = protocolDoc->getUri();
		CAF_CM_VALIDATE_STRING(uriVal);
		thisXml->addAttribute("uri", uriVal);

		const std::string nameVal = protocolDoc->getName();
		if (! nameVal.empty()) {
			thisXml->addAttribute("name", nameVal);
		}

		const std::string sequenceNumberVal =
			CStringConv::toString<int32>(protocolDoc->getSequenceNumber());
		if (! sequenceNumberVal.empty()) {
			thisXml->addAttribute("sequenceNumber", sequenceNumberVal);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCProtocolDoc ProtocolXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProtocolXml", "parse");

	SmartPtrCProtocolDoc protocolDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string uriVal =
			thisXml->findRequiredAttribute("uri");

		const std::string nameVal =
			thisXml->findOptionalAttribute("name");

		const std::string sequenceNumberStrVal =
			thisXml->findOptionalAttribute("sequenceNumber");
		int32 sequenceNumberVal = 0;
		if (! sequenceNumberStrVal.empty()) {
			sequenceNumberVal = CStringConv::fromString<int32>(sequenceNumberStrVal);
		}

		protocolDoc.CreateInstance();
		protocolDoc->initialize(
			uriVal,
			nameVal,
			sequenceNumberVal);
	}
	CAF_CM_EXIT;

	return protocolDoc;
}

