/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocUtils/EnumConvertersXml.h"
#include "Doc/CafCoreTypesDoc/CafCoreTypesDocTypes.h"

#include "Doc/SchemaTypesDoc/CMethodParameterDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/MethodParameterXml.h"

using namespace Caf;

void MethodParameterXml::add(
	const SmartPtrCMethodParameterDoc methodParameterDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MethodParameterXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(methodParameterDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameVal = methodParameterDoc->getName();
		CAF_CM_VALIDATE_STRING(nameVal);
		thisXml->addAttribute("name", nameVal);

		const std::string typeVal =
			EnumConvertersXml::convertParameterTypeToString(methodParameterDoc->getType());
		CAF_CM_VALIDATE_STRING(typeVal);
		thisXml->addAttribute("type", typeVal);

		const std::string isOptionalVal = methodParameterDoc->getIsOptional() ? "true" : "false";
		CAF_CM_VALIDATE_STRING(isOptionalVal);
		thisXml->addAttribute("isOptional", isOptionalVal);

		const std::string isListVal = methodParameterDoc->getIsList() ? "true" : "false";
		if (! isListVal.empty()) {
			thisXml->addAttribute("isList", isListVal);
		}

		const std::string defaultValVal = methodParameterDoc->getDefaultVal();
		if (! defaultValVal.empty()) {
			thisXml->addAttribute("default", defaultValVal);
		}

		const std::string displayNameVal = methodParameterDoc->getDisplayName();
		if (! displayNameVal.empty()) {
			thisXml->addAttribute("displayName", displayNameVal);
		}

		const std::string descriptionVal = methodParameterDoc->getDescription();
		if (! descriptionVal.empty()) {
			thisXml->addAttribute("description", descriptionVal);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCMethodParameterDoc MethodParameterXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MethodParameterXml", "parse");

	SmartPtrCMethodParameterDoc methodParameterDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string nameStrVal =
			thisXml->findRequiredAttribute("name");
		const std::string nameVal = nameStrVal;

		const std::string typeStrVal =
			thisXml->findRequiredAttribute("type");
		PARAMETER_TYPE typeVal = PARAMETER_NONE;
		if (! typeStrVal.empty()) {
			typeVal = EnumConvertersXml::convertStringToParameterType(typeStrVal);
		}

		const std::string isOptionalStrVal =
			thisXml->findRequiredAttribute("isOptional");
		bool isOptionalVal = false;
		if (! isOptionalStrVal.empty()) {
			isOptionalVal = (isOptionalStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string isListStrVal =
			thisXml->findOptionalAttribute("isList");
		bool isListVal = false;
		if (! isListStrVal.empty()) {
			isListVal = (isListStrVal.compare("true") == 0)  ? true : false;
		}

		const std::string defaultValStrVal =
			thisXml->findOptionalAttribute("default");
		const std::string defaultValVal = defaultValStrVal;

		const std::string displayNameStrVal =
			thisXml->findOptionalAttribute("displayName");
		const std::string displayNameVal = displayNameStrVal;

		const std::string descriptionStrVal =
			thisXml->findOptionalAttribute("description");
		const std::string descriptionVal = descriptionStrVal;

		methodParameterDoc.CreateInstance();
		methodParameterDoc->initialize(
			nameVal,
			typeVal,
			isOptionalVal,
			isListVal,
			defaultValVal,
			displayNameVal,
			descriptionVal);
	}
	CAF_CM_EXIT;

	return methodParameterDoc;
}

