/* RawSupport.c generated by valac 0.36.6, the Vala compiler
 * generated from RawSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libraw/libraw.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <time.h>


#define TYPE_PHOTO_FILE_FORMAT_DRIVER (photo_file_format_driver_get_type ())
#define PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver))
#define PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))
#define IS_PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define IS_PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define PHOTO_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))

typedef struct _PhotoFileFormatDriver PhotoFileFormatDriver;
typedef struct _PhotoFileFormatDriverClass PhotoFileFormatDriverClass;
typedef struct _PhotoFileFormatDriverPrivate PhotoFileFormatDriverPrivate;

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;

#define TYPE_RAW_FILE_FORMAT_DRIVER (raw_file_format_driver_get_type ())
#define RAW_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver))
#define RAW_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriverClass))
#define IS_RAW_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_FILE_FORMAT_DRIVER))
#define IS_RAW_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_FILE_FORMAT_DRIVER))
#define RAW_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriverClass))

typedef struct _RawFileFormatDriver RawFileFormatDriver;
typedef struct _RawFileFormatDriverClass RawFileFormatDriverClass;
typedef struct _RawFileFormatDriverPrivate RawFileFormatDriverPrivate;
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

#define TYPE_RAW_FILE_FORMAT_PROPERTIES (raw_file_format_properties_get_type ())
#define RAW_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties))
#define RAW_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatPropertiesClass))
#define IS_RAW_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_FILE_FORMAT_PROPERTIES))
#define IS_RAW_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_FILE_FORMAT_PROPERTIES))
#define RAW_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatPropertiesClass))

typedef struct _RawFileFormatProperties RawFileFormatProperties;
typedef struct _RawFileFormatPropertiesClass RawFileFormatPropertiesClass;

#define TYPE_RAW_READER (raw_reader_get_type ())
#define RAW_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_READER, RawReader))
#define RAW_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_READER, RawReaderClass))
#define IS_RAW_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_READER))
#define IS_RAW_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_READER))
#define RAW_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_READER, RawReaderClass))

typedef struct _RawReader RawReader;
typedef struct _RawReaderClass RawReaderClass;

#define TYPE_RAW_SNIFFER (raw_sniffer_get_type ())
#define RAW_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_SNIFFER, RawSniffer))
#define RAW_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_SNIFFER, RawSnifferClass))
#define IS_RAW_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_SNIFFER))
#define IS_RAW_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_SNIFFER))
#define RAW_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_SNIFFER, RawSnifferClass))

typedef struct _RawSniffer RawSniffer;
typedef struct _RawSnifferClass RawSnifferClass;
typedef struct _PhotoFileFormatPropertiesPrivate PhotoFileFormatPropertiesPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_PHOTO_FILE_FORMAT_FLAGS (photo_file_format_flags_get_type ())
typedef struct _RawFileFormatPropertiesPrivate RawFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
typedef struct _RawSnifferPrivate RawSnifferPrivate;

#define GRAW_TYPE_PROCESSOR (graw_processor_get_type ())
#define GRAW_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSOR, GRawProcessor))
#define GRAW_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSOR, GRawProcessorClass))
#define GRAW_IS_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSOR))
#define GRAW_IS_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSOR))
#define GRAW_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSOR, GRawProcessorClass))

typedef struct _GRawProcessor GRawProcessor;
typedef struct _GRawProcessorClass GRawProcessorClass;

#define GRAW_TYPE_FLIP (graw_flip_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _graw_processor_unref0(var) ((var == NULL) ? NULL : (var = (graw_processor_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;
typedef struct _RawReaderPrivate RawReaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GRAW_TYPE_PROCESSED_IMAGE (graw_processed_image_get_type ())
#define GRAW_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImage))
#define GRAW_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))
#define GRAW_IS_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_IS_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_PROCESSED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))

typedef struct _GRawProcessedImage GRawProcessedImage;
typedef struct _GRawProcessedImageClass GRawProcessedImageClass;
#define _graw_processed_image_unref0(var) ((var == NULL) ? NULL : (var = (graw_processed_image_unref (var), NULL)))

#define PHOTO_FILE_READER_TYPE_ROLE (photo_file_reader_role_get_type ())

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;

#define TYPE_ORIENTATION (orientation_get_type ())

typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoFileFormatDriver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatDriverPrivate * priv;
};

struct _PhotoFileFormatDriverClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatDriver *self);
	PhotoFileFormatProperties* (*get_properties) (PhotoFileFormatDriver* self);
	PhotoFileReader* (*create_reader) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoMetadata* (*create_metadata) (PhotoFileFormatDriver* self);
	gboolean (*can_write_image) (PhotoFileFormatDriver* self);
	gboolean (*can_write_metadata) (PhotoFileFormatDriver* self);
	PhotoFileWriter* (*create_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileMetadataWriter* (*create_metadata_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileSniffer* (*create_sniffer) (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options);
};

struct _RawFileFormatDriver {
	PhotoFileFormatDriver parent_instance;
	RawFileFormatDriverPrivate * priv;
};

struct _RawFileFormatDriverClass {
	PhotoFileFormatDriverClass parent_class;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	PHOTO_FILE_FORMAT_FLAGS_NONE = 0x00000000
} PhotoFileFormatFlags;

struct _PhotoFileFormatProperties {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatPropertiesPrivate * priv;
};

struct _PhotoFileFormatPropertiesClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatProperties *self);
	PhotoFileFormat (*get_file_format) (PhotoFileFormatProperties* self);
	PhotoFileFormatFlags (*get_flags) (PhotoFileFormatProperties* self);
	gboolean (*is_recognized_extension) (PhotoFileFormatProperties* self, const gchar* ext);
	gchar* (*get_default_extension) (PhotoFileFormatProperties* self);
	gchar** (*get_known_extensions) (PhotoFileFormatProperties* self, int* result_length1);
	gchar* (*get_default_mime_type) (PhotoFileFormatProperties* self);
	gchar** (*get_mime_types) (PhotoFileFormatProperties* self, int* result_length1);
	gchar* (*get_user_visible_name) (PhotoFileFormatProperties* self);
};

struct _RawFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	RawFileFormatPropertiesPrivate * priv;
};

struct _RawFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _RawSniffer {
	PhotoFileSniffer parent_instance;
	RawSnifferPrivate * priv;
};

struct _RawSnifferClass {
	PhotoFileSnifferClass parent_class;
};

typedef enum  {
	GRAW_FLIP_FROM_SOURCE = -1,
	GRAW_FLIP_NONE = 0,
	GRAW_FLIP_UPSIDE_DOWN = 3,
	GRAW_FLIP_COUNTERCLOCKWISE = 5,
	GRAW_FLIP_CLOCKWISE = 6
} GRawFlip;

typedef enum  {
	GRAW_EXCEPTION_UNSPECIFIED,
	GRAW_EXCEPTION_UNSUPPORTED_FILE,
	GRAW_EXCEPTION_NONEXISTANT_IMAGE,
	GRAW_EXCEPTION_OUT_OF_ORDER_CALL,
	GRAW_EXCEPTION_NO_THUMBNAIL,
	GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL,
	GRAW_EXCEPTION_OUT_OF_MEMORY,
	GRAW_EXCEPTION_DATA_ERROR,
	GRAW_EXCEPTION_IO_ERROR,
	GRAW_EXCEPTION_CANCELLED_BY_CALLBACK,
	GRAW_EXCEPTION_BAD_CROP,
	GRAW_EXCEPTION_SYSTEM_ERROR
} GRawException;
#define GRAW_EXCEPTION graw_exception_quark ()
struct _Dimensions {
	gint width;
	gint height;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

struct _RawReader {
	PhotoFileReader parent_instance;
	RawReaderPrivate * priv;
};

struct _RawReaderClass {
	PhotoFileReaderClass parent_class;
};

typedef enum  {
	PHOTO_FILE_READER_ROLE_DEFAULT,
	PHOTO_FILE_READER_ROLE_THUMBNAIL
} PhotoFileReaderRole;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _BackingPhotoID {
	gint64 id;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};


static gpointer raw_file_format_driver_parent_class = NULL;
static RawFileFormatDriver* raw_file_format_driver_instance;
static RawFileFormatDriver* raw_file_format_driver_instance = NULL;
static gpointer raw_file_format_properties_parent_class = NULL;
static gchar** raw_file_format_properties_KNOWN_EXTENSIONS;
static gint raw_file_format_properties_KNOWN_EXTENSIONS_length1;
static gchar** raw_file_format_properties_KNOWN_EXTENSIONS = NULL;
static gint raw_file_format_properties_KNOWN_EXTENSIONS_length1 = 0;
static gint _raw_file_format_properties_KNOWN_EXTENSIONS_size_ = 0;
static gchar** raw_file_format_properties_KNOWN_MIME_TYPES;
static gint raw_file_format_properties_KNOWN_MIME_TYPES_length1;
static gchar** raw_file_format_properties_KNOWN_MIME_TYPES = NULL;
static gint raw_file_format_properties_KNOWN_MIME_TYPES_length1 = 0;
static gint _raw_file_format_properties_KNOWN_MIME_TYPES_size_ = 0;
static RawFileFormatProperties* raw_file_format_properties_instance;
static RawFileFormatProperties* raw_file_format_properties_instance = NULL;
static gpointer raw_sniffer_parent_class = NULL;
static gpointer raw_reader_parent_class = NULL;

gpointer photo_file_format_driver_ref (gpointer instance);
void photo_file_format_driver_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_driver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_driver (GValue* value, gpointer v_object);
void value_take_photo_file_format_driver (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_driver (const GValue* value);
GType photo_file_format_driver_get_type (void) G_GNUC_CONST;
gpointer photo_file_format_properties_ref (gpointer instance);
void photo_file_format_properties_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_properties (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_properties (GValue* value, gpointer v_object);
void value_take_photo_file_format_properties (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_properties (const GValue* value);
GType photo_file_format_properties_get_type (void) G_GNUC_CONST;
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType photo_file_writer_get_type (void) G_GNUC_CONST;
GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST;
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
gpointer photo_file_sniffer_ref (gpointer instance);
void photo_file_sniffer_unref (gpointer instance);
GParamSpec* param_spec_photo_file_sniffer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_sniffer (GValue* value, gpointer v_object);
void value_take_photo_file_sniffer (GValue* value, gpointer v_object);
gpointer value_get_photo_file_sniffer (const GValue* value);
GType photo_file_sniffer_get_type (void) G_GNUC_CONST;
GType raw_file_format_driver_get_type (void) G_GNUC_CONST;
enum  {
	RAW_FILE_FORMAT_DRIVER_DUMMY_PROPERTY
};
void raw_file_format_driver_init (void);
RawFileFormatDriver* raw_file_format_driver_new (void);
RawFileFormatDriver* raw_file_format_driver_construct (GType object_type);
void raw_file_format_properties_init (void);
RawFileFormatDriver* raw_file_format_driver_get_instance (void);
static PhotoFileFormatProperties* raw_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
GType raw_file_format_properties_get_type (void) G_GNUC_CONST;
RawFileFormatProperties* raw_file_format_properties_get_instance (void);
static PhotoFileReader* raw_file_format_driver_real_create_reader (PhotoFileFormatDriver* base, const gchar* filepath);
RawReader* raw_reader_new (const gchar* filepath);
RawReader* raw_reader_construct (GType object_type, const gchar* filepath);
GType raw_reader_get_type (void) G_GNUC_CONST;
static PhotoMetadata* raw_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
static gboolean raw_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean raw_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* raw_file_format_driver_real_create_writer (PhotoFileFormatDriver* base, const gchar* filepath);
static PhotoFileMetadataWriter* raw_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base, const gchar* filepath);
static PhotoFileSniffer* raw_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base, GFile* file, PhotoFileSnifferOptions options);
RawSniffer* raw_sniffer_new (GFile* file, PhotoFileSnifferOptions options);
RawSniffer* raw_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
GType raw_sniffer_get_type (void) G_GNUC_CONST;
PhotoFileFormatDriver* photo_file_format_driver_construct (GType object_type);
static void raw_file_format_driver_finalize (PhotoFileFormatDriver * obj);
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType photo_file_format_flags_get_type (void) G_GNUC_CONST;
enum  {
	RAW_FILE_FORMAT_PROPERTIES_DUMMY_PROPERTY
};
RawFileFormatProperties* raw_file_format_properties_new (void);
RawFileFormatProperties* raw_file_format_properties_construct (GType object_type);
static PhotoFileFormat raw_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static gchar* raw_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags raw_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* raw_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** raw_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base, int* result_length1);
static gchar** _vala_array_dup10 (gchar** self, int length);
static gchar* raw_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** raw_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base, int* result_length1);
static gchar** _vala_array_dup11 (gchar** self, int length);
PhotoFileFormatProperties* photo_file_format_properties_construct (GType object_type);
static void raw_file_format_properties_finalize (PhotoFileFormatProperties * obj);
gpointer detected_photo_information_ref (gpointer instance);
void detected_photo_information_unref (gpointer instance);
GParamSpec* param_spec_detected_photo_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_detected_photo_information (GValue* value, gpointer v_object);
void value_take_detected_photo_information (GValue* value, gpointer v_object);
gpointer value_get_detected_photo_information (const GValue* value);
GType detected_photo_information_get_type (void) G_GNUC_CONST;
enum  {
	RAW_SNIFFER_DUMMY_PROPERTY
};
PhotoFileSniffer* photo_file_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
static DetectedPhotoInformation* raw_sniffer_real_sniff (PhotoFileSniffer* base, gboolean* is_corrupted, GError** error);
DetectedPhotoInformation* detected_photo_information_new (void);
DetectedPhotoInformation* detected_photo_information_construct (GType object_type);
gpointer graw_processor_ref (gpointer instance);
void graw_processor_unref (gpointer instance);
GParamSpec* graw_param_spec_processor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void graw_value_set_processor (GValue* value, gpointer v_object);
void graw_value_take_processor (GValue* value, gpointer v_object);
gpointer graw_value_get_processor (const GValue* value);
GType graw_processor_get_type (void) G_GNUC_CONST;
GRawProcessor* graw_processor_new (enum LibRaw_constructor_flags options);
GRawProcessor* graw_processor_construct (GType object_type, enum LibRaw_constructor_flags options);
libraw_output_params_t* graw_processor_get_output_params (GRawProcessor* self);
GType graw_flip_get_type (void) G_GNUC_CONST;
GQuark graw_exception_quark (void);
void graw_processor_open_file (GRawProcessor* self, const gchar* filename, GError** error);
void graw_processor_unpack (GRawProcessor* self, GError** error);
void graw_processor_adjust_sizes_info_only (GRawProcessor* self, GError** error);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
libraw_image_sizes_t graw_processor_get_sizes (GRawProcessor* self);
void dimensions_init (Dimensions *self, gint width, gint height);
PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self, GError** error);
gchar* photo_metadata_exif_hash (PhotoMetadata* self);
gchar* photo_metadata_thumbnail_hash (PhotoMetadata* self);
gchar* md5_file (GFile* file, GError** error);
enum  {
	RAW_READER_DUMMY_PROPERTY
};
PhotoFileReader* photo_file_reader_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
static PhotoMetadata* raw_reader_real_read_metadata (PhotoFileReader* base, GError** error);
void media_metadata_read_from_file (MediaMetadata* self, GFile* file, GError** error);
GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static GdkPixbuf* raw_reader_real_unscaled_read (PhotoFileReader* base, GError** error);
void graw_processor_configure_for_rgb_display (GRawProcessor* self, gboolean half_size);
gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
void graw_processor_process (GRawProcessor* self, GError** error);
gpointer graw_processed_image_ref (gpointer instance);
void graw_processed_image_unref (gpointer instance);
GParamSpec* graw_param_spec_processed_image (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void graw_value_set_processed_image (GValue* value, gpointer v_object);
void graw_value_take_processed_image (GValue* value, gpointer v_object);
gpointer graw_value_get_processed_image (const GValue* value);
GType graw_processed_image_get_type (void) G_GNUC_CONST;
GRawProcessedImage* graw_processor_make_mem_image (GRawProcessor* self, GError** error);
GdkPixbuf* graw_processed_image_get_pixbuf_copy (GRawProcessedImage* self);
static GdkPixbuf* raw_reader_real_scaled_read (PhotoFileReader* base, Dimensions* full, Dimensions* scaled, GError** error);
GType photo_file_reader_role_get_type (void) G_GNUC_CONST;
PhotoFileReaderRole photo_file_reader_get_role (PhotoFileReader* self);
void graw_processor_unpack_thumb (GRawProcessor* self, GError** error);
GRawProcessedImage* graw_processor_make_thumb_image (GRawProcessor* self, GError** error);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp);
GType raw_developer_get_type (void) G_GNUC_CONST;
RawDeveloper* raw_developer_as_array (int* result_length1);
gchar* raw_developer_to_string (RawDeveloper self);
RawDeveloper raw_developer_from_string (const gchar* value);
gchar* raw_developer_get_label (RawDeveloper self);
gboolean raw_developer_is_equivalent (RawDeveloper self, RawDeveloper d);
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_photo_row (GValue* value, gpointer v_object);
void value_take_backing_photo_row (GValue* value, gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
BackingPhotoRow* raw_developer_create_backing_row_for_development (RawDeveloper self, const gchar* raw_filepath, const gchar* camera_development_filename, GError** error);
BackingPhotoRow* backing_photo_row_new (void);
BackingPhotoRow* backing_photo_row_construct (GType object_type);
void disassemble_filename (const gchar* basename, gchar* * name, gchar* * ext);
gchar* library_files_convert_basename (const gchar* basename);
GFile* generate_unique_file (GFile* dir, const gchar* basename, gboolean* collision, GError** error);
gboolean claim_file (GFile* file, GError** error);
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
GType orientation_get_type (void) G_GNUC_CONST;


void raw_file_format_driver_init (void) {
	RawFileFormatDriver* _tmp0_;
#line 11 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_driver_new ();
#line 11 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_photo_file_format_driver_unref0 (raw_file_format_driver_instance);
#line 11 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_driver_instance = _tmp0_;
#line 12 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_init ();
#line 669 "RawSupport.c"
}


static gpointer _photo_file_format_driver_ref0 (gpointer self) {
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self ? photo_file_format_driver_ref (self) : NULL;
#line 676 "RawSupport.c"
}


RawFileFormatDriver* raw_file_format_driver_get_instance (void) {
	RawFileFormatDriver* result = NULL;
	RawFileFormatDriver* _tmp0_;
	RawFileFormatDriver* _tmp1_;
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_driver_instance;
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp1_;
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 692 "RawSupport.c"
}


static PhotoFileFormatProperties* raw_file_format_driver_real_get_properties (PhotoFileFormatDriver* base) {
	RawFileFormatDriver * self;
	PhotoFileFormatProperties* result = NULL;
	RawFileFormatProperties* _tmp0_;
#line 19 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 20 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_get_instance ();
#line 20 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties);
#line 20 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 708 "RawSupport.c"
}


static PhotoFileReader* raw_file_format_driver_real_create_reader (PhotoFileFormatDriver* base, const gchar* filepath) {
	RawFileFormatDriver * self;
	PhotoFileReader* result = NULL;
	const gchar* _tmp0_;
	RawReader* _tmp1_;
#line 23 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 23 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 24 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = filepath;
#line 24 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = raw_reader_new (_tmp0_);
#line 24 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_READER, PhotoFileReader);
#line 24 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 729 "RawSupport.c"
}


static PhotoMetadata* raw_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base) {
	RawFileFormatDriver * self;
	PhotoMetadata* result = NULL;
	PhotoMetadata* _tmp0_;
#line 27 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 28 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = photo_metadata_new ();
#line 28 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 745 "RawSupport.c"
}


static gboolean raw_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base) {
	RawFileFormatDriver * self;
	gboolean result = FALSE;
#line 31 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 32 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = FALSE;
#line 32 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 758 "RawSupport.c"
}


static gboolean raw_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base) {
	RawFileFormatDriver * self;
	gboolean result = FALSE;
#line 35 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 36 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = FALSE;
#line 36 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 771 "RawSupport.c"
}


static PhotoFileWriter* raw_file_format_driver_real_create_writer (PhotoFileFormatDriver* base, const gchar* filepath) {
	RawFileFormatDriver * self;
	PhotoFileWriter* result = NULL;
#line 39 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 39 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 40 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = NULL;
#line 40 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 786 "RawSupport.c"
}


static PhotoFileMetadataWriter* raw_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base, const gchar* filepath) {
	RawFileFormatDriver * self;
	PhotoFileMetadataWriter* result = NULL;
#line 43 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 43 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 44 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = NULL;
#line 44 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 801 "RawSupport.c"
}


static PhotoFileSniffer* raw_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base, GFile* file, PhotoFileSnifferOptions options) {
	RawFileFormatDriver * self;
	PhotoFileSniffer* result = NULL;
	GFile* _tmp0_;
	PhotoFileSnifferOptions _tmp1_;
	RawSniffer* _tmp2_;
#line 47 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 47 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = file;
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = options;
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = raw_sniffer_new (_tmp0_, _tmp1_);
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer);
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 825 "RawSupport.c"
}


RawFileFormatDriver* raw_file_format_driver_construct (GType object_type) {
	RawFileFormatDriver* self = NULL;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = (RawFileFormatDriver*) photo_file_format_driver_construct (object_type);
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self;
#line 835 "RawSupport.c"
}


RawFileFormatDriver* raw_file_format_driver_new (void) {
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return raw_file_format_driver_construct (TYPE_RAW_FILE_FORMAT_DRIVER);
#line 842 "RawSupport.c"
}


static void raw_file_format_driver_class_init (RawFileFormatDriverClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_driver_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->finalize = raw_file_format_driver_finalize;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver *)) raw_file_format_driver_real_get_properties;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver *, const gchar*)) raw_file_format_driver_real_create_reader;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver *)) raw_file_format_driver_real_create_metadata;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver *)) raw_file_format_driver_real_can_write_image;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver *)) raw_file_format_driver_real_can_write_metadata;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver *, const gchar*)) raw_file_format_driver_real_create_writer;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver *, const gchar*)) raw_file_format_driver_real_create_metadata_writer;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver *, GFile*, PhotoFileSnifferOptions)) raw_file_format_driver_real_create_sniffer;
#line 867 "RawSupport.c"
}


static void raw_file_format_driver_instance_init (RawFileFormatDriver * self) {
}


static void raw_file_format_driver_finalize (PhotoFileFormatDriver * obj) {
	RawFileFormatDriver * self;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	PHOTO_FILE_FORMAT_DRIVER_CLASS (raw_file_format_driver_parent_class)->finalize (obj);
#line 881 "RawSupport.c"
}


GType raw_file_format_driver_get_type (void) {
	static volatile gsize raw_file_format_driver_type_id__volatile = 0;
	if (g_once_init_enter (&raw_file_format_driver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RawFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawFileFormatDriver), 0, (GInstanceInitFunc) raw_file_format_driver_instance_init, NULL };
		GType raw_file_format_driver_type_id;
		raw_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "RawFileFormatDriver", &g_define_type_info, 0);
		g_once_init_leave (&raw_file_format_driver_type_id__volatile, raw_file_format_driver_type_id);
	}
	return raw_file_format_driver_type_id__volatile;
}


void raw_file_format_properties_init (void) {
	RawFileFormatProperties* _tmp0_;
#line 122 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_new ();
#line 122 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_photo_file_format_properties_unref0 (raw_file_format_properties_instance);
#line 122 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_instance = _tmp0_;
#line 905 "RawSupport.c"
}


static gpointer _photo_file_format_properties_ref0 (gpointer self) {
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self ? photo_file_format_properties_ref (self) : NULL;
#line 912 "RawSupport.c"
}


RawFileFormatProperties* raw_file_format_properties_get_instance (void) {
	RawFileFormatProperties* result = NULL;
	RawFileFormatProperties* _tmp0_;
	RawFileFormatProperties* _tmp1_;
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_instance;
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp1_;
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 928 "RawSupport.c"
}


static PhotoFileFormat raw_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	PhotoFileFormat result = 0;
#line 129 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 130 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = PHOTO_FILE_FORMAT_RAW;
#line 130 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 941 "RawSupport.c"
}


static gchar* raw_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 133 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 134 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = g_strdup (_ ("RAW"));
#line 134 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp0_;
#line 134 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 957 "RawSupport.c"
}


static PhotoFileFormatFlags raw_file_format_properties_real_get_flags (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	PhotoFileFormatFlags result = 0;
#line 137 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 138 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
#line 138 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 970 "RawSupport.c"
}


static gchar* raw_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 141 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 145 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = g_strdup ("raw");
#line 145 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp0_;
#line 145 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 986 "RawSupport.c"
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = g_new0 (gchar*, length + 1);
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	for (i = 0; i < length; i++) {
#line 997 "RawSupport.c"
		gchar* _tmp0_;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp0_ = g_strdup (self[i]);
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		result[i] = _tmp0_;
#line 1003 "RawSupport.c"
	}
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 1007 "RawSupport.c"
}


static gchar** raw_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base, int* result_length1) {
	RawFileFormatProperties * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
#line 148 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_KNOWN_EXTENSIONS;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0__length1 = raw_file_format_properties_KNOWN_EXTENSIONS_length1;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup10 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1__length1 = _tmp0__length1;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = _tmp1_;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2__length1 = _tmp1__length1;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (result_length1) {
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		*result_length1 = _tmp2__length1;
#line 1038 "RawSupport.c"
	}
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp2_;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 1044 "RawSupport.c"
}


static gchar* raw_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 152 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_KNOWN_MIME_TYPES;
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0__length1 = raw_file_format_properties_KNOWN_MIME_TYPES_length1;
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _tmp0_[0];
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp2_;
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 1069 "RawSupport.c"
}


static gchar** _vala_array_dup11 (gchar** self, int length) {
	gchar** result;
	int i;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = g_new0 (gchar*, length + 1);
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	for (i = 0; i < length; i++) {
#line 1080 "RawSupport.c"
		gchar* _tmp0_;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp0_ = g_strdup (self[i]);
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		result[i] = _tmp0_;
#line 1086 "RawSupport.c"
	}
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 1090 "RawSupport.c"
}


static gchar** raw_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base, int* result_length1) {
	RawFileFormatProperties * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
#line 156 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_KNOWN_MIME_TYPES;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0__length1 = raw_file_format_properties_KNOWN_MIME_TYPES_length1;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup11 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1__length1 = _tmp0__length1;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = _tmp1_;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2__length1 = _tmp1__length1;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (result_length1) {
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		*result_length1 = _tmp2__length1;
#line 1121 "RawSupport.c"
	}
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp2_;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 1127 "RawSupport.c"
}


RawFileFormatProperties* raw_file_format_properties_construct (GType object_type) {
	RawFileFormatProperties* self = NULL;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = (RawFileFormatProperties*) photo_file_format_properties_construct (object_type);
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self;
#line 1137 "RawSupport.c"
}


RawFileFormatProperties* raw_file_format_properties_new (void) {
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return raw_file_format_properties_construct (TYPE_RAW_FILE_FORMAT_PROPERTIES);
#line 1144 "RawSupport.c"
}


static void raw_file_format_properties_class_init (RawFileFormatPropertiesClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar** _tmp88_;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_parent_class = g_type_class_peek_parent (klass);
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->finalize = raw_file_format_properties_finalize;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties *)) raw_file_format_properties_real_get_file_format;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties *)) raw_file_format_properties_real_get_user_visible_name;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties *)) raw_file_format_properties_real_get_flags;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties *)) raw_file_format_properties_real_get_default_extension;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties *, int*)) raw_file_format_properties_real_get_known_extensions;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties *)) raw_file_format_properties_real_get_default_mime_type;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties *, int*)) raw_file_format_properties_real_get_mime_types;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = g_strdup ("3fr");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = g_strdup ("arw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = g_strdup ("srf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = g_strdup ("sr2");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = g_strdup ("bay");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp5_ = g_strdup ("crw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp6_ = g_strdup ("cr2");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp7_ = g_strdup ("cap");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp8_ = g_strdup ("iiq");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp9_ = g_strdup ("eip");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp10_ = g_strdup ("dcs");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp11_ = g_strdup ("dcr");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp12_ = g_strdup ("drf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp13_ = g_strdup ("k25");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp14_ = g_strdup ("kdc");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp15_ = g_strdup ("dng");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp16_ = g_strdup ("erf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp17_ = g_strdup ("fff");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp18_ = g_strdup ("mef");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp19_ = g_strdup ("mos");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp20_ = g_strdup ("mrw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp21_ = g_strdup ("nef");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp22_ = g_strdup ("nrw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp23_ = g_strdup ("orf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp24_ = g_strdup ("ptx");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp25_ = g_strdup ("pef");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp26_ = g_strdup ("pxn");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp27_ = g_strdup ("r3d");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp28_ = g_strdup ("raf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp29_ = g_strdup ("raw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp30_ = g_strdup ("rw2");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp31_ = g_strdup ("raw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp32_ = g_strdup ("rwl");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp33_ = g_strdup ("rwz");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp34_ = g_strdup ("x3f");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp35_ = g_strdup ("srw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_ = g_new0 (gchar*, 36 + 1);
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[0] = _tmp0_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[1] = _tmp1_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[2] = _tmp2_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[3] = _tmp3_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[4] = _tmp4_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[5] = _tmp5_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[6] = _tmp6_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[7] = _tmp7_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[8] = _tmp8_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[9] = _tmp9_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[10] = _tmp10_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[11] = _tmp11_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[12] = _tmp12_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[13] = _tmp13_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[14] = _tmp14_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[15] = _tmp15_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[16] = _tmp16_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[17] = _tmp17_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[18] = _tmp18_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[19] = _tmp19_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[20] = _tmp20_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[21] = _tmp21_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[22] = _tmp22_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[23] = _tmp23_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[24] = _tmp24_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[25] = _tmp25_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[26] = _tmp26_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[27] = _tmp27_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[28] = _tmp28_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[29] = _tmp29_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[30] = _tmp30_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[31] = _tmp31_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[32] = _tmp32_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[33] = _tmp33_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[34] = _tmp34_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[35] = _tmp35_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_KNOWN_EXTENSIONS = _tmp36_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_KNOWN_EXTENSIONS_length1 = 36;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp37_ = g_strdup ("image/x-dcraw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp38_ = g_strdup ("image/x-canon-cr2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp39_ = g_strdup ("image/x-canon-crw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp40_ = g_strdup ("image/x-fuji-raf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp41_ = g_strdup ("image/x-adobe-dng");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp42_ = g_strdup ("image/x-panasonic-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp43_ = g_strdup ("image/x-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp44_ = g_strdup ("image/x-minolta-mrw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp45_ = g_strdup ("image/x-nikon-nef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp46_ = g_strdup ("image/x-olympus-orf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp47_ = g_strdup ("image/x-pentax-pef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp48_ = g_strdup ("image/x-sony-arw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp49_ = g_strdup ("image/x-sony-srf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp50_ = g_strdup ("image/x-sony-sr2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp51_ = g_strdup ("image/x-samsung-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp52_ = g_strdup ("image/x-3fr");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp53_ = g_strdup ("image/x-arw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp54_ = g_strdup ("image/x-srf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp55_ = g_strdup ("image/x-sr2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp56_ = g_strdup ("image/x-bay");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp57_ = g_strdup ("image/x-crw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp58_ = g_strdup ("image/x-cr2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp59_ = g_strdup ("image/x-cap");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp60_ = g_strdup ("image/x-iiq");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp61_ = g_strdup ("image/x-eip");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp62_ = g_strdup ("image/x-dcs");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp63_ = g_strdup ("image/x-dcr");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp64_ = g_strdup ("image/x-drf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp65_ = g_strdup ("image/x-k25");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp66_ = g_strdup ("image/x-kdc");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp67_ = g_strdup ("image/x-dng");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp68_ = g_strdup ("image/x-erf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp69_ = g_strdup ("image/x-fff");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp70_ = g_strdup ("image/x-mef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp71_ = g_strdup ("image/x-mos");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp72_ = g_strdup ("image/x-mrw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp73_ = g_strdup ("image/x-nef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp74_ = g_strdup ("image/x-nrw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp75_ = g_strdup ("image/x-orf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp76_ = g_strdup ("image/x-ptx");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp77_ = g_strdup ("image/x-pef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp78_ = g_strdup ("image/x-pxn");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp79_ = g_strdup ("image/x-r3d");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp80_ = g_strdup ("image/x-raf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp81_ = g_strdup ("image/x-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp82_ = g_strdup ("image/x-rw2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp83_ = g_strdup ("image/x-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp84_ = g_strdup ("image/x-rwl");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp85_ = g_strdup ("image/x-rwz");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp86_ = g_strdup ("image/x-x3f");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp87_ = g_strdup ("image/x-srw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_ = g_new0 (gchar*, 51 + 1);
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[0] = _tmp37_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[1] = _tmp38_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[2] = _tmp39_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[3] = _tmp40_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[4] = _tmp41_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[5] = _tmp42_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[6] = _tmp43_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[7] = _tmp44_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[8] = _tmp45_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[9] = _tmp46_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[10] = _tmp47_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[11] = _tmp48_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[12] = _tmp49_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[13] = _tmp50_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[14] = _tmp51_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[15] = _tmp52_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[16] = _tmp53_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[17] = _tmp54_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[18] = _tmp55_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[19] = _tmp56_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[20] = _tmp57_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[21] = _tmp58_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[22] = _tmp59_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[23] = _tmp60_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[24] = _tmp61_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[25] = _tmp62_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[26] = _tmp63_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[27] = _tmp64_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[28] = _tmp65_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[29] = _tmp66_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[30] = _tmp67_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[31] = _tmp68_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[32] = _tmp69_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[33] = _tmp70_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[34] = _tmp71_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[35] = _tmp72_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[36] = _tmp73_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[37] = _tmp74_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[38] = _tmp75_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[39] = _tmp76_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[40] = _tmp77_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[41] = _tmp78_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[42] = _tmp79_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[43] = _tmp80_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[44] = _tmp81_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[45] = _tmp82_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[46] = _tmp83_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[47] = _tmp84_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[48] = _tmp85_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[49] = _tmp86_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[50] = _tmp87_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_KNOWN_MIME_TYPES = _tmp88_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_KNOWN_MIME_TYPES_length1 = 51;
#line 1616 "RawSupport.c"
}


static void raw_file_format_properties_instance_init (RawFileFormatProperties * self) {
}


static void raw_file_format_properties_finalize (PhotoFileFormatProperties * obj) {
	RawFileFormatProperties * self;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (raw_file_format_properties_parent_class)->finalize (obj);
#line 1630 "RawSupport.c"
}


GType raw_file_format_properties_get_type (void) {
	static volatile gsize raw_file_format_properties_type_id__volatile = 0;
	if (g_once_init_enter (&raw_file_format_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RawFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawFileFormatProperties), 0, (GInstanceInitFunc) raw_file_format_properties_instance_init, NULL };
		GType raw_file_format_properties_type_id;
		raw_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "RawFileFormatProperties", &g_define_type_info, 0);
		g_once_init_leave (&raw_file_format_properties_type_id__volatile, raw_file_format_properties_type_id);
	}
	return raw_file_format_properties_type_id__volatile;
}


RawSniffer* raw_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options) {
	RawSniffer* self = NULL;
	GFile* _tmp0_;
	PhotoFileSnifferOptions _tmp1_;
#line 162 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 163 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = file;
#line 163 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = options;
#line 163 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = (RawSniffer*) photo_file_sniffer_construct (object_type, _tmp0_, _tmp1_);
#line 162 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self;
#line 1660 "RawSupport.c"
}


RawSniffer* raw_sniffer_new (GFile* file, PhotoFileSnifferOptions options) {
#line 162 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return raw_sniffer_construct (TYPE_RAW_SNIFFER, file, options);
#line 1667 "RawSupport.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self ? g_error_copy (self) : NULL;
#line 1674 "RawSupport.c"
}


static DetectedPhotoInformation* raw_sniffer_real_sniff (PhotoFileSniffer* base, gboolean* is_corrupted, GError** error) {
	RawSniffer * self;
	gboolean _vala_is_corrupted = FALSE;
	DetectedPhotoInformation* result = NULL;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp0_;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp1_;
	GRawProcessor* _tmp2_;
	libraw_output_params_t* _tmp3_;
	libraw_output_params_t* _tmp4_;
	DetectedPhotoInformation* _tmp14_;
	GRawProcessor* _tmp15_;
	libraw_image_sizes_t _tmp16_;
	gushort _tmp17_;
	GRawProcessor* _tmp18_;
	libraw_image_sizes_t _tmp19_;
	gushort _tmp20_;
	DetectedPhotoInformation* _tmp21_;
	DetectedPhotoInformation* _tmp22_;
	DetectedPhotoInformation* _tmp23_;
	RawReader* reader = NULL;
	GFile* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	RawReader* _tmp27_;
	RawReader* _tmp28_;
	DetectedPhotoInformation* _tmp34_;
	PhotoMetadata* _tmp35_;
	gboolean _tmp44_;
	DetectedPhotoInformation* _tmp50_;
	gchar* _tmp51_;
	DetectedPhotoInformation* _tmp52_;
	GError * _inner_error_ = NULL;
#line 166 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_SNIFFER, RawSniffer);
#line 168 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_vala_is_corrupted = FALSE;
#line 170 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = detected_photo_information_new ();
#line 170 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	detected = _tmp0_;
#line 172 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
#line 172 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	processor = _tmp1_;
#line 173 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = processor;
#line 173 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = graw_processor_get_output_params (_tmp2_);
#line 173 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = _tmp3_;
#line 173 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	(*_tmp4_).user_flip = (gint) GRAW_FLIP_NONE;
#line 1732 "RawSupport.c"
	{
		GRawProcessor* _tmp5_;
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRawProcessor* _tmp9_;
		GRawProcessor* _tmp10_;
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp5_ = processor;
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp7_ = g_file_get_path (_tmp6_);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp8_ = _tmp7_;
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		graw_processor_open_file (_tmp5_, _tmp8_, &_inner_error_);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp8_);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 1756 "RawSupport.c"
				goto __catch36_graw_exception;
			}
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_clear_error (&_inner_error_);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return NULL;
#line 1769 "RawSupport.c"
		}
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp9_ = processor;
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		graw_processor_unpack (_tmp9_, &_inner_error_);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 1779 "RawSupport.c"
				goto __catch36_graw_exception;
			}
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_clear_error (&_inner_error_);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return NULL;
#line 1792 "RawSupport.c"
		}
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp10_ = processor;
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		graw_processor_adjust_sizes_info_only (_tmp10_, &_inner_error_);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 1802 "RawSupport.c"
				goto __catch36_graw_exception;
			}
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_clear_error (&_inner_error_);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return NULL;
#line 1815 "RawSupport.c"
		}
	}
	goto __finally36;
	__catch36_graw_exception:
	{
		GError* exception = NULL;
		GError* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		exception = _inner_error_;
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_inner_error_ = NULL;
#line 180 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp11_ = exception;
#line 180 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (g_error_matches (_tmp11_, GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_FILE)) {
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = NULL;
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_error_free0 (exception);
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (is_corrupted) {
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				*is_corrupted = _vala_is_corrupted;
#line 1845 "RawSupport.c"
			}
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 1849 "RawSupport.c"
		}
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp12_ = exception;
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp13_ = _g_error_copy0 (_tmp12_);
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_inner_error_ = _tmp13_;
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_error_free0 (exception);
#line 1859 "RawSupport.c"
		goto __finally36;
	}
	__finally36:
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_detected_photo_information_unref0 (detected);
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 1873 "RawSupport.c"
	}
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp14_ = detected;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp15_ = processor;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp16_ = graw_processor_get_sizes (_tmp15_);
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp17_ = _tmp16_.iwidth;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp18_ = processor;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp19_ = graw_processor_get_sizes (_tmp18_);
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp20_ = _tmp19_.iheight;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	dimensions_init (&_tmp14_->image_dim, (gint) _tmp17_, (gint) _tmp20_);
#line 187 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp21_ = detected;
#line 187 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp21_->colorspace = GDK_COLORSPACE_RGB;
#line 188 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp22_ = detected;
#line 188 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp22_->channels = 3;
#line 189 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp23_ = detected;
#line 189 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp23_->bits_per_channel = 8;
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp24_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp25_ = g_file_get_path (_tmp24_);
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp26_ = _tmp25_;
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp27_ = raw_reader_new (_tmp26_);
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp28_ = _tmp27_;
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp26_);
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	reader = _tmp28_;
#line 1917 "RawSupport.c"
	{
		PhotoMetadata* _tmp29_ = NULL;
		RawReader* _tmp30_;
		PhotoMetadata* _tmp31_;
		DetectedPhotoInformation* _tmp32_;
		PhotoMetadata* _tmp33_;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp30_ = reader;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp31_ = photo_file_reader_read_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_PHOTO_FILE_READER, PhotoFileReader), &_inner_error_);
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp29_ = _tmp31_;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1932 "RawSupport.c"
			goto __catch37_g_error;
		}
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp32_ = detected;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp33_ = _tmp29_;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp29_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_media_metadata_unref0 (_tmp32_->metadata);
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp32_->metadata = _tmp33_;
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_media_metadata_unref0 (_tmp29_);
#line 1947 "RawSupport.c"
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* err = NULL;
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		err = _inner_error_;
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_inner_error_ = NULL;
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_error_free0 (err);
#line 1959 "RawSupport.c"
	}
	__finally37:
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_photo_file_adapter_unref0 (reader);
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_detected_photo_information_unref0 (detected);
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 1974 "RawSupport.c"
	}
#line 198 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp34_ = detected;
#line 198 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp35_ = _tmp34_->metadata;
#line 198 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp35_ != NULL) {
#line 1982 "RawSupport.c"
		DetectedPhotoInformation* _tmp36_;
		DetectedPhotoInformation* _tmp37_;
		PhotoMetadata* _tmp38_;
		gchar* _tmp39_;
		DetectedPhotoInformation* _tmp40_;
		DetectedPhotoInformation* _tmp41_;
		PhotoMetadata* _tmp42_;
		gchar* _tmp43_;
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp36_ = detected;
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp37_ = detected;
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp38_ = _tmp37_->metadata;
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp39_ = photo_metadata_exif_hash (_tmp38_);
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp36_->exif_md5);
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp36_->exif_md5 = _tmp39_;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp40_ = detected;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp41_ = detected;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp42_ = _tmp41_->metadata;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp43_ = photo_metadata_thumbnail_hash (_tmp42_);
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp40_->thumbnail_md5);
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp40_->thumbnail_md5 = _tmp43_;
#line 2015 "RawSupport.c"
	}
#line 203 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp44_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 203 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp44_) {
#line 2021 "RawSupport.c"
		gchar* _tmp45_ = NULL;
		GFile* _tmp46_;
		gchar* _tmp47_;
		DetectedPhotoInformation* _tmp48_;
		gchar* _tmp49_;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp46_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp47_ = md5_file (_tmp46_, &_inner_error_);
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp45_ = _tmp47_;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_photo_file_adapter_unref0 (reader);
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return NULL;
#line 2045 "RawSupport.c"
		}
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp48_ = detected;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp49_ = _tmp45_;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp45_ = NULL;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp48_->md5);
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp48_->md5 = _tmp49_;
#line 203 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp45_);
#line 2059 "RawSupport.c"
	}
#line 206 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp50_ = detected;
#line 206 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp51_ = g_strdup ("raw");
#line 206 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp50_->format_name);
#line 206 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp50_->format_name = _tmp51_;
#line 207 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp52_ = detected;
#line 207 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp52_->file_format = PHOTO_FILE_FORMAT_RAW;
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = detected;
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_photo_file_adapter_unref0 (reader);
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processor_unref0 (processor);
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (is_corrupted) {
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		*is_corrupted = _vala_is_corrupted;
#line 2083 "RawSupport.c"
	}
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2087 "RawSupport.c"
}


static void raw_sniffer_class_init (RawSnifferClass * klass) {
#line 161 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_sniffer_parent_class = g_type_class_peek_parent (klass);
#line 161 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer *, gboolean*, GError**)) raw_sniffer_real_sniff;
#line 2096 "RawSupport.c"
}


static void raw_sniffer_instance_init (RawSniffer * self) {
}


GType raw_sniffer_get_type (void) {
	static volatile gsize raw_sniffer_type_id__volatile = 0;
	if (g_once_init_enter (&raw_sniffer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RawSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawSniffer), 0, (GInstanceInitFunc) raw_sniffer_instance_init, NULL };
		GType raw_sniffer_type_id;
		raw_sniffer_type_id = g_type_register_static (TYPE_PHOTO_FILE_SNIFFER, "RawSniffer", &g_define_type_info, 0);
		g_once_init_leave (&raw_sniffer_type_id__volatile, raw_sniffer_type_id);
	}
	return raw_sniffer_type_id__volatile;
}


RawReader* raw_reader_construct (GType object_type, const gchar* filepath) {
	RawReader* self = NULL;
	const gchar* _tmp0_;
#line 214 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 215 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = filepath;
#line 215 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = (RawReader*) photo_file_reader_construct (object_type, _tmp0_, PHOTO_FILE_FORMAT_RAW);
#line 214 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self;
#line 2127 "RawSupport.c"
}


RawReader* raw_reader_new (const gchar* filepath) {
#line 214 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return raw_reader_construct (TYPE_RAW_READER, filepath);
#line 2134 "RawSupport.c"
}


static PhotoMetadata* raw_reader_real_read_metadata (PhotoFileReader* base, GError** error) {
	RawReader * self;
	PhotoMetadata* result = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError * _inner_error_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_READER, RawReader);
#line 219 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = photo_metadata_new ();
#line 219 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	metadata = _tmp0_;
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = _tmp1_;
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata), _tmp2_, &_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_media_metadata_unref0 (metadata);
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2168 "RawSupport.c"
	}
#line 222 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = metadata;
#line 222 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2174 "RawSupport.c"
}


static GdkPixbuf* raw_reader_real_unscaled_read (PhotoFileReader* base, GError** error) {
	RawReader * self;
	GdkPixbuf* result = NULL;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp0_;
	GRawProcessor* _tmp1_;
	GRawProcessor* _tmp2_;
	libraw_output_params_t* _tmp3_;
	libraw_output_params_t* _tmp4_;
	GRawProcessor* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GRawProcessor* _tmp8_;
	GRawProcessor* _tmp9_;
	GRawProcessedImage* _tmp10_ = NULL;
	GRawProcessor* _tmp11_;
	GRawProcessedImage* _tmp12_;
	GdkPixbuf* _tmp13_;
	GError * _inner_error_ = NULL;
#line 225 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_READER, RawReader);
#line 226 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
#line 226 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	processor = _tmp0_;
#line 227 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = processor;
#line 227 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_configure_for_rgb_display (_tmp1_, FALSE);
#line 228 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = processor;
#line 228 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = graw_processor_get_output_params (_tmp2_);
#line 228 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = _tmp3_;
#line 228 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	(*_tmp4_).user_flip = (gint) GRAW_FLIP_NONE;
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp5_ = processor;
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp6_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp7_ = _tmp6_;
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_open_file (_tmp5_, _tmp7_, &_inner_error_);
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp7_);
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2233 "RawSupport.c"
	}
#line 231 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp8_ = processor;
#line 231 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_unpack (_tmp8_, &_inner_error_);
#line 231 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 231 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 231 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 231 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2247 "RawSupport.c"
	}
#line 232 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp9_ = processor;
#line 232 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_process (_tmp9_, &_inner_error_);
#line 232 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 232 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 232 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 232 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2261 "RawSupport.c"
	}
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp11_ = processor;
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp12_ = graw_processor_make_mem_image (_tmp11_, &_inner_error_);
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp10_ = _tmp12_;
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2277 "RawSupport.c"
	}
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp13_ = graw_processed_image_get_pixbuf_copy (_tmp10_);
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp13_;
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processed_image_unref0 (_tmp10_);
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processor_unref0 (processor);
#line 234 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2289 "RawSupport.c"
}


static GdkPixbuf* raw_reader_real_scaled_read (PhotoFileReader* base, Dimensions* full, Dimensions* scaled, GError** error) {
	RawReader * self;
	GdkPixbuf* result = NULL;
	gdouble width_proportion = 0.0;
	Dimensions _tmp0_;
	gint _tmp1_;
	Dimensions _tmp2_;
	gint _tmp3_;
	gdouble height_proportion = 0.0;
	Dimensions _tmp4_;
	gint _tmp5_;
	Dimensions _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_ = FALSE;
	gdouble _tmp9_;
	gboolean half_size = FALSE;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp11_;
	GRawProcessor* _tmp12_;
	gboolean _tmp13_;
	GRawProcessor* _tmp14_;
	libraw_output_params_t* _tmp15_;
	libraw_output_params_t* _tmp16_;
	GRawProcessor* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GRawProcessor* _tmp30_;
	GRawProcessor* _tmp31_;
	GRawProcessedImage* image = NULL;
	GRawProcessor* _tmp32_;
	GRawProcessedImage* _tmp33_;
	GRawProcessedImage* _tmp34_;
	GdkPixbuf* _tmp35_;
	GdkPixbuf* _tmp36_;
	Dimensions _tmp37_;
	GdkPixbuf* _tmp38_;
	GdkPixbuf* _tmp39_;
	GError * _inner_error_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_READER, RawReader);
#line 237 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (full != NULL, NULL);
#line 237 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (scaled != NULL, NULL);
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = *scaled;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _tmp0_.width;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = *full;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = _tmp2_.width;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	width_proportion = ((gdouble) _tmp1_) / ((gdouble) _tmp3_);
#line 240 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = *scaled;
#line 240 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp5_ = _tmp4_.height;
#line 240 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp6_ = *full;
#line 240 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp7_ = _tmp6_.height;
#line 240 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	height_proportion = ((gdouble) _tmp5_) / ((gdouble) _tmp7_);
#line 241 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp9_ = width_proportion;
#line 241 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp9_ < 0.5) {
#line 2361 "RawSupport.c"
		gdouble _tmp10_;
#line 241 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp10_ = height_proportion;
#line 241 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp8_ = _tmp10_ < 0.5;
#line 2367 "RawSupport.c"
	} else {
#line 241 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp8_ = FALSE;
#line 2371 "RawSupport.c"
	}
#line 241 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	half_size = _tmp8_;
#line 243 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp11_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
#line 243 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	processor = _tmp11_;
#line 244 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp12_ = processor;
#line 244 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp13_ = half_size;
#line 244 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_configure_for_rgb_display (_tmp12_, _tmp13_);
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp14_ = processor;
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp15_ = graw_processor_get_output_params (_tmp14_);
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp16_ = _tmp15_;
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	(*_tmp16_).user_flip = (gint) GRAW_FLIP_NONE;
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp17_ = processor;
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp18_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp19_ = _tmp18_;
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_open_file (_tmp17_, _tmp19_, &_inner_error_);
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp19_);
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2411 "RawSupport.c"
	}
	{
		PhotoFileReaderRole _tmp20_;
#line 249 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp20_ = photo_file_reader_get_role (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_READER, PhotoFileReader));
#line 249 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (_tmp20_ == PHOTO_FILE_READER_ROLE_THUMBNAIL) {
#line 2419 "RawSupport.c"
			GRawProcessor* _tmp21_;
			GRawProcessedImage* image = NULL;
			GRawProcessor* _tmp22_;
			GRawProcessedImage* _tmp23_;
			GRawProcessedImage* _tmp24_;
			GdkPixbuf* _tmp25_;
			GdkPixbuf* _tmp26_;
			Dimensions _tmp27_;
			GdkPixbuf* _tmp28_;
			GdkPixbuf* _tmp29_;
#line 250 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp21_ = processor;
#line 250 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			graw_processor_unpack_thumb (_tmp21_, &_inner_error_);
#line 250 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2436 "RawSupport.c"
				goto __catch38_g_error;
			}
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp22_ = processor;
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp23_ = graw_processor_make_thumb_image (_tmp22_, &_inner_error_);
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			image = _tmp23_;
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2447 "RawSupport.c"
				goto __catch38_g_error;
			}
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp24_ = image;
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp25_ = graw_processed_image_get_pixbuf_copy (_tmp24_);
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp26_ = _tmp25_;
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp27_ = *scaled;
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp28_ = resize_pixbuf (_tmp26_, &_tmp27_, GDK_INTERP_BILINEAR);
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp29_ = _tmp28_;
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_object_unref0 (_tmp26_);
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp29_;
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processed_image_unref0 (image);
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2472 "RawSupport.c"
		}
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* _error_ = NULL;
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_error_ = _inner_error_;
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_inner_error_ = NULL;
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_error_free0 (_error_);
#line 2485 "RawSupport.c"
	}
	__finally38:
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2496 "RawSupport.c"
	}
#line 260 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp30_ = processor;
#line 260 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_unpack (_tmp30_, &_inner_error_);
#line 260 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 260 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 260 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 260 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2510 "RawSupport.c"
	}
#line 261 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp31_ = processor;
#line 261 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_process (_tmp31_, &_inner_error_);
#line 261 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 261 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 261 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 261 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2524 "RawSupport.c"
	}
#line 263 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp32_ = processor;
#line 263 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp33_ = graw_processor_make_mem_image (_tmp32_, &_inner_error_);
#line 263 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	image = _tmp33_;
#line 263 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 263 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 263 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 263 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2540 "RawSupport.c"
	}
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp34_ = image;
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp35_ = graw_processed_image_get_pixbuf_copy (_tmp34_);
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_ = _tmp35_;
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp37_ = *scaled;
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp38_ = resize_pixbuf (_tmp36_, &_tmp37_, GDK_INTERP_BILINEAR);
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp39_ = _tmp38_;
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (_tmp36_);
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp39_;
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processed_image_unref0 (image);
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processor_unref0 (processor);
#line 265 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2564 "RawSupport.c"
}


static void raw_reader_class_init (RawReaderClass * klass) {
#line 213 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_reader_parent_class = g_type_class_peek_parent (klass);
#line 213 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileReaderClass *) klass)->read_metadata = (PhotoMetadata* (*) (PhotoFileReader *, GError**)) raw_reader_real_read_metadata;
#line 213 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileReaderClass *) klass)->unscaled_read = (GdkPixbuf* (*) (PhotoFileReader *, GError**)) raw_reader_real_unscaled_read;
#line 213 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader *, Dimensions*, Dimensions*, GError**)) raw_reader_real_scaled_read;
#line 2577 "RawSupport.c"
}


static void raw_reader_instance_init (RawReader * self) {
}


GType raw_reader_get_type (void) {
	static volatile gsize raw_reader_type_id__volatile = 0;
	if (g_once_init_enter (&raw_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RawReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawReader), 0, (GInstanceInitFunc) raw_reader_instance_init, NULL };
		GType raw_reader_type_id;
		raw_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_READER, "RawReader", &g_define_type_info, 0);
		g_once_init_leave (&raw_reader_type_id__volatile, raw_reader_type_id);
	}
	return raw_reader_type_id__volatile;
}


RawDeveloper* raw_developer_as_array (int* result_length1) {
	RawDeveloper* result = NULL;
	RawDeveloper* _tmp0_;
	RawDeveloper* _tmp1_;
	gint _tmp1__length1;
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = g_new0 (RawDeveloper, 3);
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_[0] = RAW_DEVELOPER_SHOTWELL;
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_[1] = RAW_DEVELOPER_CAMERA;
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_[2] = RAW_DEVELOPER_EMBEDDED;
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _tmp0_;
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1__length1 = 3;
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (result_length1) {
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		*result_length1 = _tmp1__length1;
#line 2618 "RawSupport.c"
	}
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp1_;
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2624 "RawSupport.c"
}


gchar* raw_developer_to_string (RawDeveloper self) {
	gchar* result = NULL;
#line 280 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	switch (self) {
#line 280 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 2634 "RawSupport.c"
		{
			gchar* _tmp0_;
#line 282 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp0_ = g_strdup ("SHOTWELL");
#line 282 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp0_;
#line 282 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2643 "RawSupport.c"
		}
#line 280 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_CAMERA:
#line 2647 "RawSupport.c"
		{
			gchar* _tmp1_;
#line 284 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp1_ = g_strdup ("CAMERA");
#line 284 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp1_;
#line 284 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2656 "RawSupport.c"
		}
#line 280 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 2660 "RawSupport.c"
		{
			gchar* _tmp2_;
#line 286 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp2_ = g_strdup ("EMBEDDED");
#line 286 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp2_;
#line 286 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2669 "RawSupport.c"
		}
		default:
		{
#line 288 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_assert_not_reached ();
#line 2675 "RawSupport.c"
		}
	}
}


RawDeveloper raw_developer_from_string (const gchar* value) {
	RawDeveloper result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	static GQuark _tmp2_label0 = 0;
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	static GQuark _tmp2_label1 = 0;
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	static GQuark _tmp2_label2 = 0;
#line 292 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (value != NULL, 0);
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = value;
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _tmp0_;
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("SHOTWELL")))) {
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		switch (0) {
#line 2704 "RawSupport.c"
			default:
			{
#line 295 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				result = RAW_DEVELOPER_SHOTWELL;
#line 295 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				return result;
#line 2711 "RawSupport.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("CAMERA")))) {
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		switch (0) {
#line 2717 "RawSupport.c"
			default:
			{
#line 297 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				result = RAW_DEVELOPER_CAMERA;
#line 297 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				return result;
#line 2724 "RawSupport.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("EMBEDDED")))) {
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		switch (0) {
#line 2730 "RawSupport.c"
			default:
			{
#line 299 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				result = RAW_DEVELOPER_EMBEDDED;
#line 299 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				return result;
#line 2737 "RawSupport.c"
			}
		}
	} else {
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		switch (0) {
#line 2743 "RawSupport.c"
			default:
			{
#line 301 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				g_assert_not_reached ();
#line 2748 "RawSupport.c"
			}
		}
	}
}


gchar* raw_developer_get_label (RawDeveloper self) {
	gchar* result = NULL;
#line 306 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	switch (self) {
#line 306 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 2761 "RawSupport.c"
		{
			gchar* _tmp0_;
#line 308 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp0_ = g_strdup (_ ("Shotwell"));
#line 308 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp0_;
#line 308 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2770 "RawSupport.c"
		}
#line 306 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_CAMERA:
#line 306 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 2776 "RawSupport.c"
		{
			gchar* _tmp1_;
#line 311 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp1_ = g_strdup (_ ("Camera"));
#line 311 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp1_;
#line 311 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2785 "RawSupport.c"
		}
		default:
		{
#line 313 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_assert_not_reached ();
#line 2791 "RawSupport.c"
		}
	}
}


gboolean raw_developer_is_equivalent (RawDeveloper self, RawDeveloper d) {
	gboolean result = FALSE;
	RawDeveloper _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 320 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = d;
#line 320 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (self == _tmp0_) {
#line 321 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		result = TRUE;
#line 321 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return result;
#line 2810 "RawSupport.c"
	}
#line 323 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (self == RAW_DEVELOPER_CAMERA) {
#line 2814 "RawSupport.c"
		RawDeveloper _tmp3_;
#line 323 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp3_ = d;
#line 323 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp2_ = _tmp3_ == RAW_DEVELOPER_EMBEDDED;
#line 2820 "RawSupport.c"
	} else {
#line 323 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp2_ = FALSE;
#line 2824 "RawSupport.c"
	}
#line 323 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp2_) {
#line 323 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp1_ = TRUE;
#line 2830 "RawSupport.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 324 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (self == RAW_DEVELOPER_EMBEDDED) {
#line 2835 "RawSupport.c"
			RawDeveloper _tmp5_;
#line 324 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp5_ = d;
#line 324 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp4_ = _tmp5_ == RAW_DEVELOPER_CAMERA;
#line 2841 "RawSupport.c"
		} else {
#line 324 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp4_ = FALSE;
#line 2845 "RawSupport.c"
		}
#line 324 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp1_ = _tmp4_;
#line 2849 "RawSupport.c"
	}
#line 323 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp1_) {
#line 325 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		result = TRUE;
#line 325 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return result;
#line 2857 "RawSupport.c"
	}
#line 327 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = FALSE;
#line 327 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2863 "RawSupport.c"
}


BackingPhotoRow* raw_developer_create_backing_row_for_development (RawDeveloper self, const gchar* raw_filepath, const gchar* camera_development_filename, GError** error) {
	BackingPhotoRow* result = NULL;
	BackingPhotoRow* ns = NULL;
	BackingPhotoRow* _tmp0_;
	GFile* master = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	gchar* name = NULL;
	gchar* ext = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* basename = NULL;
	const gchar* _tmp8_;
	gchar* newbasename = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean c = FALSE;
	GFile* new_back = NULL;
	GFile* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	const gchar* _tmp32_;
	gboolean _tmp33_ = FALSE;
	GFile* _tmp34_;
	GFile* _tmp35_;
	GFile* _tmp36_;
	BackingPhotoRow* _tmp37_;
	BackingPhotoRow* _tmp38_;
	GFile* _tmp39_;
	gchar* _tmp40_;
	GError * _inner_error_ = NULL;
#line 332 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (raw_filepath != NULL, NULL);
#line 334 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = backing_photo_row_new ();
#line 334 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	ns = _tmp0_;
#line 335 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = raw_filepath;
#line 335 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 335 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	master = _tmp2_;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = master;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = g_file_get_basename (_tmp3_);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp5_ = _tmp4_;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	disassemble_filename (_tmp5_, &_tmp6_, &_tmp7_);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (name);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	name = _tmp6_;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (ext);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	ext = _tmp7_;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp5_);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp8_ = camera_development_filename;
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp8_ == NULL) {
#line 2935 "RawSupport.c"
		gchar* _tmp9_ = NULL;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (self != RAW_DEVELOPER_CAMERA) {
#line 2948 "RawSupport.c"
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp10_ = raw_developer_to_string (self);
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp11_ = _tmp10_;
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp13_ = _tmp12_;
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp14_ = g_strconcat ("_", _tmp13_, NULL);
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp9_);
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp9_ = _tmp14_;
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp13_);
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp11_);
#line 2972 "RawSupport.c"
		} else {
			gchar* _tmp15_;
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp15_ = g_strdup ("");
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp9_);
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp9_ = _tmp15_;
#line 2981 "RawSupport.c"
		}
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp16_ = name;
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp17_ = g_strconcat (_tmp16_, "_", NULL);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp18_ = _tmp17_;
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp19_ = ext;
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp21_ = _tmp20_;
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp22_ = g_strconcat (_tmp21_, _tmp9_, NULL);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp23_ = _tmp22_;
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp24_ = g_strconcat (_tmp23_, ".jpg", NULL);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (basename);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		basename = _tmp24_;
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp23_);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp21_);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp18_);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp9_);
#line 3013 "RawSupport.c"
	} else {
		const gchar* _tmp25_;
		gchar* _tmp26_;
#line 347 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp25_ = camera_development_filename;
#line 347 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp26_ = g_strdup (_tmp25_);
#line 347 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (basename);
#line 347 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		basename = _tmp26_;
#line 3025 "RawSupport.c"
	}
#line 350 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp27_ = basename;
#line 350 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp28_ = library_files_convert_basename (_tmp27_);
#line 350 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	newbasename = _tmp28_;
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp29_ = master;
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp30_ = g_file_get_parent (_tmp29_);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp31_ = _tmp30_;
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp32_ = newbasename;
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp34_ = generate_unique_file (_tmp31_, _tmp32_, &_tmp33_, &_inner_error_);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	c = _tmp33_;
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp35_ = _tmp34_;
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (_tmp31_);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	new_back = _tmp35_;
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (newbasename);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (basename);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (ext);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (name);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_object_unref0 (master);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_backing_photo_row_unref0 (ns);
#line 353 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 3069 "RawSupport.c"
	}
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_ = new_back;
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	claim_file (_tmp36_, &_inner_error_);
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_object_unref0 (new_back);
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (newbasename);
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (basename);
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (ext);
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (name);
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_object_unref0 (master);
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_backing_photo_row_unref0 (ns);
#line 354 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 3095 "RawSupport.c"
	}
#line 355 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp37_ = ns;
#line 355 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp37_->file_format = PHOTO_FILE_FORMAT_JFIF;
#line 356 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp38_ = ns;
#line 356 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp39_ = new_back;
#line 356 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp40_ = g_file_get_path (_tmp39_);
#line 356 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp38_->filepath);
#line 356 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp38_->filepath = _tmp40_;
#line 358 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = ns;
#line 358 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (new_back);
#line 358 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (newbasename);
#line 358 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (basename);
#line 358 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (ext);
#line 358 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (name);
#line 358 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (master);
#line 358 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 3127 "RawSupport.c"
}


GType raw_developer_get_type (void) {
	static volatile gsize raw_developer_type_id__volatile = 0;
	if (g_once_init_enter (&raw_developer_type_id__volatile)) {
		static const GEnumValue values[] = {{RAW_DEVELOPER_SHOTWELL, "RAW_DEVELOPER_SHOTWELL", "shotwell"}, {RAW_DEVELOPER_CAMERA, "RAW_DEVELOPER_CAMERA", "camera"}, {RAW_DEVELOPER_EMBEDDED, "RAW_DEVELOPER_EMBEDDED", "embedded"}, {0, NULL, NULL}};
		GType raw_developer_type_id;
		raw_developer_type_id = g_enum_register_static ("RawDeveloper", values);
		g_once_init_leave (&raw_developer_type_id__volatile, raw_developer_type_id);
	}
	return raw_developer_type_id__volatile;
}



