/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2019 NXP
 *
 */

#ifndef __DTS_IMX8MN_PINFUNC_H
#define __DTS_IMX8MN_PINFUNC_H

/*
 * The pin function ID is a tuple of
 * <mux_reg conf_reg input_reg mux_mode input_val>
 */
#define MX8MN_IOMUXC_BOOT_MODE2_CCMSRCGPCMIX_BOOT_MODE2                        0x0020 0x025C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_BOOT_MODE2_I2C1_SCL                                       0x0020 0x025C 0x055C 0x1 0x3
#define MX8MN_IOMUXC_BOOT_MODE3_CCMSRCGPCMIX_BOOT_MODE3                        0x0024 0x0260 0x0000 0x0 0x0
#define MX8MN_IOMUXC_BOOT_MODE3_I2C1_SDA                                       0x0024 0x0260 0x056C 0x1 0x3
#define MX8MN_IOMUXC_GPIO1_IO00_GPIO1_IO0                                      0x0028 0x0290 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO00_CCMSRCGPCMIX_ENET_PHY_REF_CLK_ROOT             0x0028 0x0290 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO00_ANAMIX_REF_CLK_32K                             0x0028 0x0290 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO00_CCMSRCGPCMIX_EXT_CLK1                          0x0028 0x0290 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO01_GPIO1_IO1                                      0x002C 0x0294 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO01_PWM1_OUT                                       0x002C 0x0294 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO01_ANAMIX_REF_CLK_24M                             0x002C 0x0294 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO01_CCMSRCGPCMIX_EXT_CLK2                          0x002C 0x0294 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO02_GPIO1_IO2                                      0x0030 0x0298 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO02_WDOG1_WDOG_B                                   0x0030 0x0298 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO02_WDOG1_WDOG_ANY                                 0x0030 0x0298 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO03_GPIO1_IO3                                      0x0034 0x029C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO03_USDHC1_VSELECT                                 0x0034 0x029C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO03_SDMA1_EXT_EVENT0                               0x0034 0x029C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO03_ANAMIX_XTAL_OK                                 0x0034 0x029C 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO04_GPIO1_IO4                                      0x0038 0x02A0 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO04_USDHC2_VSELECT                                 0x0038 0x02A0 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO04_SDMA1_EXT_EVENT1                               0x0038 0x02A0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO04_ANAMIX_XTAL_OK_LV                              0x0038 0x02A0 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO05_GPIO1_IO5                                      0x003C 0x02A4 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO05_M4_NMI                                         0x003C 0x02A4 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO05_CCMSRCGPCMIX_PMIC_READY                        0x003C 0x02A4 0x04BC 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO05_CCMSRCGPCMIX_INT_BOOT                          0x003C 0x02A4 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO06_GPIO1_IO6                                      0x0040 0x02A8 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO06_ENET1_MDC                                      0x0040 0x02A8 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO06_USDHC1_CD_B                                    0x0040 0x02A8 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO06_CCMSRCGPCMIX_EXT_CLK3                          0x0040 0x02A8 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO07_GPIO1_IO7                                      0x0044 0x02AC 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO07_ENET1_MDIO                                     0x0044 0x02AC 0x04C0 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO07_USDHC1_WP                                      0x0044 0x02AC 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO07_CCMSRCGPCMIX_EXT_CLK4                          0x0044 0x02AC 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO08_GPIO1_IO8                                      0x0048 0x02B0 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO08_ENET1_1588_EVENT0_IN                           0x0048 0x02B0 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO08_PWM1_OUT                                       0x0048 0x02B0 0x0000 0x2 0x0
#define MX8MN_IOMUXC_GPIO1_IO08_USDHC2_RESET_B                                 0x0048 0x02B0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO08_CCMSRCGPCMIX_WAIT                              0x0048 0x02B0 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO09_GPIO1_IO9                                      0x004C 0x02B4 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO09_ENET1_1588_EVENT0_OUT                          0x004C 0x02B4 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO09_PWM2_OUT                                       0x004C 0x02B4 0x0000 0x2 0x0
#define MX8MN_IOMUXC_GPIO1_IO09_USDHC3_RESET_B                                 0x004C 0x02B4 0x0000 0x4 0x0
#define MX8MN_IOMUXC_GPIO1_IO09_SDMA2_EXT_EVENT0                               0x004C 0x02B4 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO09_CCMSRCGPCMIX_STOP                              0x004C 0x02B4 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO10_GPIO1_IO10                                     0x0050 0x02B8 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO10_USB1_OTG_ID                                    0x0050 0x02B8 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO10_PWM3_OUT                                       0x0050 0x02B8 0x0000 0x2 0x0
#define MX8MN_IOMUXC_GPIO1_IO11_GPIO1_IO11                                     0x0054 0x02BC 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO11_PWM2_OUT                                       0x0054 0x02BC 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO11_USDHC3_VSELECT                                 0x0054 0x02BC 0x0000 0x4 0x0
#define MX8MN_IOMUXC_GPIO1_IO11_CCMSRCGPCMIX_PMIC_READY                        0x0054 0x02BC 0x04BC 0x5 0x1
#define MX8MN_IOMUXC_GPIO1_IO11_CCMSRCGPCMIX_OUT0                              0x0054 0x02BC 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO12_GPIO1_IO12                                     0x0058 0x02C0 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO12_USB1_OTG_PWR                                   0x0058 0x02C0 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO12_SDMA2_EXT_EVENT1                               0x0058 0x02C0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO12_CCMSRCGPCMIX_OUT1                              0x0058 0x02C0 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO13_GPIO1_IO13                                     0x005C 0x02C4 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO13_USB1_OTG_OC                                    0x005C 0x02C4 0x0000 0x1 0x0
#define MX8MN_IOMUXC_GPIO1_IO13_PWM2_OUT                                       0x005C 0x02C4 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO13_CCMSRCGPCMIX_OUT2                              0x005C 0x02C4 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO14_GPIO1_IO14                                     0x0060 0x02C8 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO14_USDHC3_CD_B                                    0x0060 0x02C8 0x0598 0x4 0x2
#define MX8MN_IOMUXC_GPIO1_IO14_PWM3_OUT                                       0x0060 0x02C8 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO14_CCMSRCGPCMIX_CLKO1                             0x0060 0x02C8 0x0000 0x6 0x0
#define MX8MN_IOMUXC_GPIO1_IO15_GPIO1_IO15                                     0x0064 0x02CC 0x0000 0x0 0x0
#define MX8MN_IOMUXC_GPIO1_IO15_USDHC3_WP                                      0x0064 0x02CC 0x05B8 0x4 0x2
#define MX8MN_IOMUXC_GPIO1_IO15_PWM4_OUT                                       0x0064 0x02CC 0x0000 0x5 0x0
#define MX8MN_IOMUXC_GPIO1_IO15_CCMSRCGPCMIX_CLKO2                             0x0064 0x02CC 0x0000 0x6 0x0
#define MX8MN_IOMUXC_ENET_MDC_ENET1_MDC                                        0x0068 0x02D0 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_MDC_SAI6_TX_DATA0                                    0x0068 0x02D0 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_MDC_PDM_BIT_STREAM3                                  0x0068 0x02D0 0x0540 0x3 0x1
#define MX8MN_IOMUXC_ENET_MDC_SPDIF1_OUT                                       0x0068 0x02D0 0x0000 0x4 0x0
#define MX8MN_IOMUXC_ENET_MDC_GPIO1_IO16                                       0x0068 0x02D0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_MDC_USDHC3_STROBE                                    0x0068 0x02D0 0x059C 0x6 0x1
#define MX8MN_IOMUXC_ENET_MDIO_ENET1_MDIO                                      0x006C 0x02D4 0x04C0 0x0 0x1
#define MX8MN_IOMUXC_ENET_MDIO_SAI6_TX_SYNC                                    0x006C 0x02D4 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_MDIO_PDM_BIT_STREAM2                                 0x006C 0x02D4 0x053C 0x3 0x1
#define MX8MN_IOMUXC_ENET_MDIO_SPDIF1_IN                                       0x006C 0x02D4 0x05CC 0x4 0x1
#define MX8MN_IOMUXC_ENET_MDIO_GPIO1_IO17                                      0x006C 0x02D4 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_MDIO_USDHC3_DATA5                                    0x006C 0x02D4 0x0550 0x6 0x1
#define MX8MN_IOMUXC_ENET_TD3_ENET1_RGMII_TD3                                  0x0070 0x02D8 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_TD3_SAI6_TX_BCLK                                     0x0070 0x02D8 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_TD3_PDM_BIT_STREAM1                                  0x0070 0x02D8 0x0538 0x3 0x1
#define MX8MN_IOMUXC_ENET_TD3_SPDIF1_EXT_CLK                                   0x0070 0x02D8 0x0568 0x4 0x1
#define MX8MN_IOMUXC_ENET_TD3_GPIO1_IO18                                       0x0070 0x02D8 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_TD3_USDHC3_DATA6                                     0x0070 0x02D8 0x0584 0x6 0x1
#define MX8MN_IOMUXC_ENET_TD2_ENET1_RGMII_TD2                                  0x0074 0x02DC 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_TD2_ENET1_TX_CLK                                     0x0074 0x02DC 0x05A4 0x1 0x0
#define MX8MN_IOMUXC_ENET_TD2_CCMSRCGPCMIX_ENET_REF_CLK_ROOT                   0x0074 0x02DC 0x05A4 0x1 0x0
#define MX8MN_IOMUXC_ENET_TD2_SAI6_RX_DATA0                                    0x0074 0x02DC 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_TD2_PDM_BIT_STREAM3                                  0x0074 0x02DC 0x0540 0x3 0x2
#define MX8MN_IOMUXC_ENET_TD2_GPIO1_IO19                                       0x0074 0x02DC 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_TD2_USDHC3_DATA7                                     0x0074 0x02DC 0x054C 0x6 0x1
#define MX8MN_IOMUXC_ENET_TD1_ENET1_RGMII_TD1                                  0x0078 0x02E0 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_TD1_SAI6_RX_SYNC                                     0x0078 0x02E0 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_TD1_PDM_BIT_STREAM2                                  0x0078 0x02E0 0x053C 0x3 0x2
#define MX8MN_IOMUXC_ENET_TD1_GPIO1_IO20                                       0x0078 0x02E0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_TD1_USDHC3_CD_B                                      0x0078 0x02E0 0x0598 0x6 0x3
#define MX8MN_IOMUXC_ENET_TD0_ENET1_RGMII_TD0                                  0x007C 0x02E4 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_TD0_SAI6_RX_BCLK                                     0x007C 0x02E4 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_TD0_PDM_BIT_STREAM1                                  0x007C 0x02E4 0x0538 0x3 0x2
#define MX8MN_IOMUXC_ENET_TD0_GPIO1_IO21                                       0x007C 0x02E4 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_TD0_USDHC3_WP                                        0x007C 0x02E4 0x05B8 0x6 0x3
#define MX8MN_IOMUXC_ENET_TX_CTL_ENET1_RGMII_TX_CTL                            0x0080 0x02E8 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_TX_CTL_SAI6_MCLK                                     0x0080 0x02E8 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_TX_CTL_GPIO1_IO22                                    0x0080 0x02E8 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_TX_CTL_USDHC3_DATA0                                  0x0080 0x02E8 0x05B4 0x6 0x1
#define MX8MN_IOMUXC_ENET_TXC_ENET1_RGMII_TXC                                  0x0084 0x02EC 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_TXC_ENET1_TX_ER                                      0x0084 0x02EC 0x0000 0x1 0x0
#define MX8MN_IOMUXC_ENET_TXC_SAI7_TX_DATA0                                    0x0084 0x02EC 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_TXC_GPIO1_IO23                                       0x0084 0x02EC 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_TXC_USDHC3_DATA1                                     0x0084 0x02EC 0x05B0 0x6 0x1
#define MX8MN_IOMUXC_ENET_RX_CTL_ENET1_RGMII_RX_CTL                            0x0088 0x02F0 0x0574 0x0 0x0
#define MX8MN_IOMUXC_ENET_RX_CTL_SAI7_TX_SYNC                                  0x0088 0x02F0 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_RX_CTL_PDM_BIT_STREAM3                               0x0088 0x02F0 0x0540 0x3 0x3
#define MX8MN_IOMUXC_ENET_RX_CTL_GPIO1_IO24                                    0x0088 0x02F0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_RX_CTL_USDHC3_DATA2                                  0x0088 0x02F0 0x05E4 0x6 0x1
#define MX8MN_IOMUXC_ENET_RXC_ENET1_RGMII_RXC                                  0x008C 0x02F4 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_RXC_ENET1_RX_ER                                      0x008C 0x02F4 0x05C8 0x1 0x0
#define MX8MN_IOMUXC_ENET_RXC_SAI7_TX_BCLK                                     0x008C 0x02F4 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_RXC_PDM_BIT_STREAM2                                  0x008C 0x02F4 0x053C 0x3 0x3
#define MX8MN_IOMUXC_ENET_RXC_GPIO1_IO25                                       0x008C 0x02F4 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_RXC_USDHC3_DATA3                                     0x008C 0x02F4 0x05E0 0x6 0x1
#define MX8MN_IOMUXC_ENET_RD0_ENET1_RGMII_RD0                                  0x0090 0x02F8 0x057C 0x0 0x0
#define MX8MN_IOMUXC_ENET_RD0_SAI7_RX_DATA0                                    0x0090 0x02F8 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_RD0_PDM_BIT_STREAM1                                  0x0090 0x02F8 0x0538 0x3 0x3
#define MX8MN_IOMUXC_ENET_RD0_GPIO1_IO26                                       0x0090 0x02F8 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_RD0_USDHC3_DATA4                                     0x0090 0x02F8 0x0558 0x6 0x1
#define MX8MN_IOMUXC_ENET_RD1_ENET1_RGMII_RD1                                  0x0094 0x02FC 0x0554 0x0 0x0
#define MX8MN_IOMUXC_ENET_RD1_SAI7_RX_SYNC                                     0x0094 0x02FC 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_RD1_PDM_BIT_STREAM0                                  0x0094 0x02FC 0x0534 0x3 0x1
#define MX8MN_IOMUXC_ENET_RD1_GPIO1_IO27                                       0x0094 0x02FC 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_RD1_USDHC3_RESET_B                                   0x0094 0x02FC 0x0000 0x6 0x0
#define MX8MN_IOMUXC_ENET_RD2_ENET1_RGMII_RD2                                  0x0098 0x0300 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_RD2_SAI7_RX_BCLK                                     0x0098 0x0300 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_RD2_PDM_CLK                                          0x0098 0x0300 0x0000 0x3 0x0
#define MX8MN_IOMUXC_ENET_RD2_GPIO1_IO28                                       0x0098 0x0300 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_RD2_USDHC3_CLK                                       0x0098 0x0300 0x05A0 0x6 0x1
#define MX8MN_IOMUXC_ENET_RD3_ENET1_RGMII_RD3                                  0x009C 0x0304 0x0000 0x0 0x0
#define MX8MN_IOMUXC_ENET_RD3_SAI7_MCLK                                        0x009C 0x0304 0x0000 0x2 0x0
#define MX8MN_IOMUXC_ENET_RD3_SPDIF1_IN                                        0x009C 0x0304 0x05CC 0x3 0x5
#define MX8MN_IOMUXC_ENET_RD3_GPIO1_IO29                                       0x009C 0x0304 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ENET_RD3_USDHC3_CMD                                       0x009C 0x0304 0x05DC 0x6 0x1
#define MX8MN_IOMUXC_SD1_CLK_USDHC1_CLK                                        0x00A0 0x0308 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_CLK_ENET1_MDC                                         0x00A0 0x0308 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SD1_CLK_UART1_DCE_TX                                      0x00A0 0x0308 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_CLK_UART1_DTE_RX                                      0x00A0 0x0308 0x04F4 0x4 0x4
#define MX8MN_IOMUXC_SD1_CLK_GPIO2_IO0                                         0x00A0 0x0308 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_CMD_USDHC1_CMD                                        0x00A4 0x030C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_CMD_ENET1_MDIO                                        0x00A4 0x030C 0x04C0 0x1 0x3
#define MX8MN_IOMUXC_SD1_CMD_UART1_DCE_RX                                      0x00A4 0x030C 0x04F4 0x4 0x5
#define MX8MN_IOMUXC_SD1_CMD_UART1_DTE_TX                                      0x00A4 0x030C 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_CMD_GPIO2_IO1                                         0x00A4 0x030C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_DATA0_USDHC1_DATA0                                    0x00A8 0x0310 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_DATA0_ENET1_RGMII_TD1                                 0x00A8 0x0310 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SD1_DATA0_UART1_DCE_RTS_B                                 0x00A8 0x0310 0x04F0 0x4 0x4
#define MX8MN_IOMUXC_SD1_DATA0_UART1_DTE_CTS_B                                 0x00A8 0x0310 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_DATA0_GPIO2_IO2                                       0x00A8 0x0310 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_DATA1_USDHC1_DATA1                                    0x00AC 0x0314 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_DATA1_ENET1_RGMII_TD0                                 0x00AC 0x0314 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SD1_DATA1_UART1_DCE_CTS_B                                 0x00AC 0x0314 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_DATA1_UART1_DTE_RTS_B                                 0x00AC 0x0314 0x04F0 0x4 0x5
#define MX8MN_IOMUXC_SD1_DATA1_GPIO2_IO3                                       0x00AC 0x0314 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_DATA2_USDHC1_DATA2                                    0x00B0 0x0318 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_DATA2_ENET1_RGMII_RD0                                 0x00B0 0x0318 0x057C 0x1 0x1
#define MX8MN_IOMUXC_SD1_DATA2_UART2_DCE_TX                                    0x00B0 0x0318 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_DATA2_UART2_DTE_RX                                    0x00B0 0x0318 0x04FC 0x4 0x4
#define MX8MN_IOMUXC_SD1_DATA2_GPIO2_IO4                                       0x00B0 0x0318 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_DATA3_USDHC1_DATA3                                    0x00B4 0x031C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_DATA3_ENET1_RGMII_RD1                                 0x00B4 0x031C 0x0554 0x1 0x1
#define MX8MN_IOMUXC_SD1_DATA3_UART2_DCE_RX                                    0x00B4 0x031C 0x04FC 0x4 0x5
#define MX8MN_IOMUXC_SD1_DATA3_UART2_DTE_TX                                    0x00B4 0x031C 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_DATA3_GPIO2_IO5                                       0x00B4 0x031C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_DATA4_USDHC1_DATA4                                    0x00B8 0x0320 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_DATA4_ENET1_RGMII_TX_CTL                              0x00B8 0x0320 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SD1_DATA4_I2C1_SCL                                        0x00B8 0x0320 0x055C 0x3 0x1
#define MX8MN_IOMUXC_SD1_DATA4_UART2_DCE_RTS_B                                 0x00B8 0x0320 0x04F8 0x4 0x4
#define MX8MN_IOMUXC_SD1_DATA4_UART2_DTE_CTS_B                                 0x00B8 0x0320 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_DATA4_GPIO2_IO6                                       0x00B8 0x0320 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_DATA5_USDHC1_DATA5                                    0x00BC 0x0324 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_DATA5_ENET1_TX_ER                                     0x00BC 0x0324 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SD1_DATA5_I2C1_SDA                                        0x00BC 0x0324 0x056C 0x3 0x1
#define MX8MN_IOMUXC_SD1_DATA5_UART2_DCE_CTS_B                                 0x00BC 0x0324 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_DATA5_UART2_DTE_RTS_B                                 0x00BC 0x0324 0x04F8 0x4 0x5
#define MX8MN_IOMUXC_SD1_DATA5_GPIO2_IO7                                       0x00BC 0x0324 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_DATA6_USDHC1_DATA6                                    0x00C0 0x0328 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_DATA6_ENET1_RGMII_RX_CTL                              0x00C0 0x0328 0x0574 0x1 0x1
#define MX8MN_IOMUXC_SD1_DATA6_I2C2_SCL                                        0x00C0 0x0328 0x05D0 0x3 0x1
#define MX8MN_IOMUXC_SD1_DATA6_UART3_DCE_TX                                    0x00C0 0x0328 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_DATA6_UART3_DTE_RX                                    0x00C0 0x0328 0x0504 0x4 0x4
#define MX8MN_IOMUXC_SD1_DATA6_GPIO2_IO8                                       0x00C0 0x0328 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_DATA7_USDHC1_DATA7                                    0x00C4 0x032C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_DATA7_ENET1_RX_ER                                     0x00C4 0x032C 0x05C8 0x1 0x1
#define MX8MN_IOMUXC_SD1_DATA7_I2C2_SDA                                        0x00C4 0x032C 0x0560 0x3 0x1
#define MX8MN_IOMUXC_SD1_DATA7_UART3_DCE_RX                                    0x00C4 0x032C 0x0504 0x4 0x5
#define MX8MN_IOMUXC_SD1_DATA7_UART3_DTE_TX                                    0x00C4 0x032C 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_DATA7_GPIO2_IO9                                       0x00C4 0x032C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_RESET_B_USDHC1_RESET_B                                0x00C8 0x0330 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_RESET_B_ENET1_TX_CLK                                  0x00C8 0x0330 0x05A4 0x1 0x1
#define MX8MN_IOMUXC_SD1_RESET_B_CCMSRCGPCMIX_ENET_REF_CLK_ROOT                0x00C8 0x0330 0x05A4 0x1 0x0
#define MX8MN_IOMUXC_SD1_RESET_B_I2C3_SCL                                      0x00C8 0x0330 0x0588 0x3 0x1
#define MX8MN_IOMUXC_SD1_RESET_B_UART3_DCE_RTS_B                               0x00C8 0x0330 0x0500 0x4 0x2
#define MX8MN_IOMUXC_SD1_RESET_B_UART3_DTE_CTS_B                               0x00C8 0x0330 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_RESET_B_GPIO2_IO10                                    0x00C8 0x0330 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD1_STROBE_USDHC1_STROBE                                  0x00CC 0x0334 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD1_STROBE_I2C3_SDA                                       0x00CC 0x0334 0x05BC 0x3 0x1
#define MX8MN_IOMUXC_SD1_STROBE_UART3_DCE_CTS_B                                0x00CC 0x0334 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD1_STROBE_UART3_DTE_RTS_B                                0x00CC 0x0334 0x0500 0x4 0x3
#define MX8MN_IOMUXC_SD1_STROBE_GPIO2_IO11                                     0x00CC 0x0334 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_CD_B_USDHC2_CD_B                                      0x00D0 0x0338 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD2_CD_B_GPIO2_IO12                                       0x00D0 0x0338 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_CD_B_CCMSRCGPCMIX_TESTER_ACK                          0x00D0 0x0338 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SD2_CLK_USDHC2_CLK                                        0x00D4 0x033C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD2_CLK_SAI5_RX_SYNC                                      0x00D4 0x033C 0x04E4 0x1 0x1
#define MX8MN_IOMUXC_SD2_CLK_ECSPI2_SCLK                                       0x00D4 0x033C 0x0580 0x2 0x1
#define MX8MN_IOMUXC_SD2_CLK_UART4_DCE_RX                                      0x00D4 0x033C 0x050C 0x3 0x4
#define MX8MN_IOMUXC_SD2_CLK_UART4_DTE_TX                                      0x00D4 0x033C 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SD2_CLK_SAI5_MCLK                                         0x00D4 0x033C 0x0594 0x4 0x1
#define MX8MN_IOMUXC_SD2_CLK_GPIO2_IO13                                        0x00D4 0x033C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_CLK_CCMSRCGPCMIX_OBSERVE0                             0x00D4 0x033C 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SD2_CMD_USDHC2_CMD                                        0x00D8 0x0340 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD2_CMD_SAI5_RX_BCLK                                      0x00D8 0x0340 0x04D0 0x1 0x1
#define MX8MN_IOMUXC_SD2_CMD_ECSPI2_MOSI                                       0x00D8 0x0340 0x0590 0x2 0x1
#define MX8MN_IOMUXC_SD2_CMD_UART4_DCE_TX                                      0x00D8 0x0340 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SD2_CMD_UART4_DTE_RX                                      0x00D8 0x0340 0x050C 0x3 0x5
#define MX8MN_IOMUXC_SD2_CMD_PDM_CLK                                           0x00D8 0x0340 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SD2_CMD_GPIO2_IO14                                        0x00D8 0x0340 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_CMD_CCMSRCGPCMIX_OBSERVE1                             0x00D8 0x0340 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SD2_DATA0_USDHC2_DATA0                                    0x00DC 0x0344 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD2_DATA0_SAI5_RX_DATA0                                   0x00DC 0x0344 0x04D4 0x1 0x1
#define MX8MN_IOMUXC_SD2_DATA0_I2C4_SDA                                        0x00DC 0x0344 0x058C 0x2 0x1
#define MX8MN_IOMUXC_SD2_DATA0_UART2_DCE_RX                                    0x00DC 0x0344 0x04FC 0x3 0x6
#define MX8MN_IOMUXC_SD2_DATA0_UART2_DTE_TX                                    0x00DC 0x0344 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SD2_DATA0_PDM_BIT_STREAM0                                 0x00DC 0x0344 0x0534 0x4 0x2
#define MX8MN_IOMUXC_SD2_DATA0_GPIO2_IO15                                      0x00DC 0x0344 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_DATA0_CCMSRCGPCMIX_OBSERVE2                           0x00DC 0x0344 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SD2_DATA1_USDHC2_DATA1                                    0x00E0 0x0348 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD2_DATA1_SAI5_TX_SYNC                                    0x00E0 0x0348 0x04EC 0x1 0x1
#define MX8MN_IOMUXC_SD2_DATA1_I2C4_SCL                                        0x00E0 0x0348 0x05D4 0x2 0x1
#define MX8MN_IOMUXC_SD2_DATA1_UART2_DCE_TX                                    0x00E0 0x0348 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SD2_DATA1_UART2_DTE_RX                                    0x00E0 0x0348 0x04FC 0x3 0x7
#define MX8MN_IOMUXC_SD2_DATA1_PDM_BIT_STREAM1                                 0x00E0 0x0348 0x0538 0x4 0x4
#define MX8MN_IOMUXC_SD2_DATA1_GPIO2_IO16                                      0x00E0 0x0348 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_DATA1_CCMSRCGPCMIX_WAIT                               0x00E0 0x0348 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SD2_DATA2_USDHC2_DATA2                                    0x00E4 0x034C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD2_DATA2_SAI5_TX_BCLK                                    0x00E4 0x034C 0x04E8 0x1 0x1
#define MX8MN_IOMUXC_SD2_DATA2_ECSPI2_SS0                                      0x00E4 0x034C 0x0570 0x2 0x2
#define MX8MN_IOMUXC_SD2_DATA2_SPDIF1_OUT                                      0x00E4 0x034C 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SD2_DATA2_PDM_BIT_STREAM2                                 0x00E4 0x034C 0x053C 0x4 0x4
#define MX8MN_IOMUXC_SD2_DATA2_GPIO2_IO17                                      0x00E4 0x034C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_DATA2_CCMSRCGPCMIX_STOP                               0x00E4 0x034C 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SD2_DATA3_USDHC2_DATA3                                    0x00E8 0x0350 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD2_DATA3_SAI5_TX_DATA0                                   0x00E8 0x0350 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SD2_DATA3_ECSPI2_MISO                                     0x00E8 0x0350 0x0578 0x2 0x1
#define MX8MN_IOMUXC_SD2_DATA3_SPDIF1_IN                                       0x00E8 0x0350 0x05CC 0x3 0x2
#define MX8MN_IOMUXC_SD2_DATA3_PDM_BIT_STREAM3                                 0x00E8 0x0350 0x0540 0x4 0x4
#define MX8MN_IOMUXC_SD2_DATA3_GPIO2_IO18                                      0x00E8 0x0350 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_DATA3_CCMSRCGPCMIX_EARLY_RESET                        0x00E8 0x0350 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SD2_RESET_B_USDHC2_RESET_B                                0x00EC 0x0354 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD2_RESET_B_GPIO2_IO19                                    0x00EC 0x0354 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_RESET_B_CCMSRCGPCMIX_SYSTEM_RESET                     0x00EC 0x0354 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SD2_WP_USDHC2_WP                                          0x00F0 0x0358 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SD2_WP_GPIO2_IO20                                         0x00F0 0x0358 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SD2_WP_CORESIGHT_EVENTI                                   0x00F0 0x0358 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_ALE_RAWNAND_ALE                                      0x00F4 0x035C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_ALE_QSPI_A_SCLK                                      0x00F4 0x035C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_ALE_PDM_BIT_STREAM0                                  0x00F4 0x035C 0x0534 0x3 0x3
#define MX8MN_IOMUXC_NAND_ALE_UART3_DCE_RX                                     0x00F4 0x035C 0x0504 0x4 0x6
#define MX8MN_IOMUXC_NAND_ALE_UART3_DTE_TX                                     0x00F4 0x035C 0x0000 0x4 0x0
#define MX8MN_IOMUXC_NAND_ALE_GPIO3_IO0                                        0x00F4 0x035C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_ALE_CORESIGHT_TRACE_CLK                              0x00F4 0x035C 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_CE0_B_RAWNAND_CE0_B                                  0x00F8 0x0360 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_CE0_B_QSPI_A_SS0_B                                   0x00F8 0x0360 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_CE0_B_PDM_BIT_STREAM1                                0x00F8 0x0360 0x0538 0x3 0x5
#define MX8MN_IOMUXC_NAND_CE0_B_UART3_DCE_TX                                   0x00F8 0x0360 0x0000 0x4 0x0
#define MX8MN_IOMUXC_NAND_CE0_B_UART3_DTE_RX                                   0x00F8 0x0360 0x0504 0x4 0x7
#define MX8MN_IOMUXC_NAND_CE0_B_GPIO3_IO1                                      0x00F8 0x0360 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_CE0_B_CORESIGHT_TRACE_CTL                            0x00F8 0x0360 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_CE1_B_RAWNAND_CE1_B                                  0x00FC 0x0364 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_CE1_B_QSPI_A_SS1_B                                   0x00FC 0x0364 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_CE1_B_USDHC3_STROBE                                  0x00FC 0x0364 0x059C 0x2 0x0
#define MX8MN_IOMUXC_NAND_CE1_B_PDM_BIT_STREAM0                                0x00FC 0x0364 0x0534 0x3 0x4
#define MX8MN_IOMUXC_NAND_CE1_B_I2C4_SCL                                       0x00FC 0x0364 0x05D4 0x4 0x2
#define MX8MN_IOMUXC_NAND_CE1_B_GPIO3_IO2                                      0x00FC 0x0364 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_CE1_B_CORESIGHT_TRACE0                               0x00FC 0x0364 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_CE2_B_RAWNAND_CE2_B                                  0x0100 0x0368 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_CE2_B_QSPI_B_SS0_B                                   0x0100 0x0368 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_CE2_B_USDHC3_DATA5                                   0x0100 0x0368 0x0550 0x2 0x0
#define MX8MN_IOMUXC_NAND_CE2_B_PDM_BIT_STREAM1                                0x0100 0x0368 0x0538 0x3 0x6
#define MX8MN_IOMUXC_NAND_CE2_B_I2C4_SDA                                       0x0100 0x0368 0x058C 0x4 0x2
#define MX8MN_IOMUXC_NAND_CE2_B_GPIO3_IO3                                      0x0100 0x0368 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_CE2_B_CORESIGHT_TRACE1                               0x0100 0x0368 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_CE3_B_RAWNAND_CE3_B                                  0x0104 0x036C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_CE3_B_QSPI_B_SS1_B                                   0x0104 0x036C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_CE3_B_USDHC3_DATA6                                   0x0104 0x036C 0x0584 0x2 0x0
#define MX8MN_IOMUXC_NAND_CE3_B_PDM_BIT_STREAM2                                0x0104 0x036C 0x053C 0x3 0x5
#define MX8MN_IOMUXC_NAND_CE3_B_I2C3_SDA                                       0x0104 0x036C 0x05BC 0x4 0x2
#define MX8MN_IOMUXC_NAND_CE3_B_GPIO3_IO4                                      0x0104 0x036C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_CE3_B_CORESIGHT_TRACE2                               0x0104 0x036C 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_CLE_RAWNAND_CLE                                      0x0108 0x0370 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_CLE_QSPI_B_SCLK                                      0x0108 0x0370 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_CLE_USDHC3_DATA7                                     0x0108 0x0370 0x054C 0x2 0x0
#define MX8MN_IOMUXC_NAND_CLE_GPIO3_IO5                                        0x0108 0x0370 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_CLE_CORESIGHT_TRACE3                                 0x0108 0x0370 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_DATA00_RAWNAND_DATA00                                0x010C 0x0374 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_DATA00_QSPI_A_DATA0                                  0x010C 0x0374 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_DATA00_PDM_BIT_STREAM2                               0x010C 0x0374 0x053C 0x3 0x6
#define MX8MN_IOMUXC_NAND_DATA00_UART4_DCE_RX                                  0x010C 0x0374 0x050C 0x4 0x6
#define MX8MN_IOMUXC_NAND_DATA00_UART4_DTE_TX                                  0x010C 0x0374 0x0000 0x4 0x0
#define MX8MN_IOMUXC_NAND_DATA00_GPIO3_IO6                                     0x010C 0x0374 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_DATA00_CORESIGHT_TRACE4                              0x010C 0x0374 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_DATA01_RAWNAND_DATA01                                0x0110 0x0378 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_DATA01_QSPI_A_DATA1                                  0x0110 0x0378 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_DATA01_PDM_BIT_STREAM3                               0x0110 0x0378 0x0540 0x3 0x5
#define MX8MN_IOMUXC_NAND_DATA01_UART4_DCE_TX                                  0x0110 0x0378 0x0000 0x4 0x0
#define MX8MN_IOMUXC_NAND_DATA01_UART4_DTE_RX                                  0x0110 0x0378 0x050C 0x4 0x7
#define MX8MN_IOMUXC_NAND_DATA01_GPIO3_IO7                                     0x0110 0x0378 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_DATA01_CORESIGHT_TRACE5                              0x0110 0x0378 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_DATA02_RAWNAND_DATA02                                0x0114 0x037C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_DATA02_QSPI_A_DATA2                                  0x0114 0x037C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_DATA02_USDHC3_CD_B                                   0x0114 0x037C 0x0598 0x2 0x0
#define MX8MN_IOMUXC_NAND_DATA02_I2C4_SDA                                      0x0114 0x037C 0x058C 0x4 0x3
#define MX8MN_IOMUXC_NAND_DATA02_GPIO3_IO8                                     0x0114 0x037C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_DATA02_CORESIGHT_TRACE6                              0x0114 0x037C 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_DATA03_RAWNAND_DATA03                                0x0118 0x0380 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_DATA03_QSPI_A_DATA3                                  0x0118 0x0380 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_DATA03_USDHC3_WP                                     0x0118 0x0380 0x05B8 0x2 0x0
#define MX8MN_IOMUXC_NAND_DATA03_GPIO3_IO9                                     0x0118 0x0380 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_DATA03_CORESIGHT_TRACE7                              0x0118 0x0380 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_DATA04_RAWNAND_DATA04                                0x011C 0x0384 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_DATA04_QSPI_B_DATA0                                  0x011C 0x0384 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_DATA04_USDHC3_DATA0                                  0x011C 0x0384 0x05B4 0x2 0x0
#define MX8MN_IOMUXC_NAND_DATA04_GPIO3_IO10                                    0x011C 0x0384 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_DATA04_CORESIGHT_TRACE8                              0x011C 0x0384 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_DATA05_RAWNAND_DATA05                                0x0120 0x0388 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_DATA05_QSPI_B_DATA1                                  0x0120 0x0388 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_DATA05_USDHC3_DATA1                                  0x0120 0x0388 0x05B0 0x2 0x0
#define MX8MN_IOMUXC_NAND_DATA05_GPIO3_IO11                                    0x0120 0x0388 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_DATA05_CORESIGHT_TRACE9                              0x0120 0x0388 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_DATA06_RAWNAND_DATA06                                0x0124 0x038C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_DATA06_QSPI_B_DATA2                                  0x0124 0x038C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_DATA06_USDHC3_DATA2                                  0x0124 0x038C 0x05E4 0x2 0x0
#define MX8MN_IOMUXC_NAND_DATA06_GPIO3_IO12                                    0x0124 0x038C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_DATA06_CORESIGHT_TRACE10                             0x0124 0x038C 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_DATA07_RAWNAND_DATA07                                0x0128 0x0390 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_DATA07_QSPI_B_DATA3                                  0x0128 0x0390 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_DATA07_USDHC3_DATA3                                  0x0128 0x0390 0x05E0 0x2 0x0
#define MX8MN_IOMUXC_NAND_DATA07_GPIO3_IO13                                    0x0128 0x0390 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_DATA07_CORESIGHT_TRACE11                             0x0128 0x0390 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_DQS_RAWNAND_DQS                                      0x012C 0x0394 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_DQS_QSPI_A_DQS                                       0x012C 0x0394 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_DQS_PDM_CLK                                          0x012C 0x0394 0x0000 0x3 0x0
#define MX8MN_IOMUXC_NAND_DQS_I2C3_SCL                                         0x012C 0x0394 0x0588 0x4 0x2
#define MX8MN_IOMUXC_NAND_DQS_GPIO3_IO14                                       0x012C 0x0394 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_DQS_CORESIGHT_TRACE12                                0x012C 0x0394 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_RE_B_RAWNAND_RE_B                                    0x0130 0x0398 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_RE_B_QSPI_B_DQS                                      0x0130 0x0398 0x0000 0x1 0x0
#define MX8MN_IOMUXC_NAND_RE_B_USDHC3_DATA4                                    0x0130 0x0398 0x0558 0x2 0x0
#define MX8MN_IOMUXC_NAND_RE_B_PDM_BIT_STREAM1                                 0x0130 0x0398 0x0538 0x3 0x7
#define MX8MN_IOMUXC_NAND_RE_B_GPIO3_IO15                                      0x0130 0x0398 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_RE_B_CORESIGHT_TRACE13                               0x0130 0x0398 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_READY_B_RAWNAND_READY_B                              0x0134 0x039C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_READY_B_USDHC3_RESET_B                               0x0134 0x039C 0x0000 0x2 0x0
#define MX8MN_IOMUXC_NAND_READY_B_PDM_BIT_STREAM3                              0x0134 0x039C 0x0540 0x3 0x6
#define MX8MN_IOMUXC_NAND_READY_B_I2C3_SCL                                     0x0134 0x039C 0x0588 0x4 0x3
#define MX8MN_IOMUXC_NAND_READY_B_GPIO3_IO16                                   0x0134 0x039C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_READY_B_CORESIGHT_TRACE14                            0x0134 0x039C 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_WE_B_RAWNAND_WE_B                                    0x0138 0x03A0 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_WE_B_USDHC3_CLK                                      0x0138 0x03A0 0x05A0 0x2 0x0
#define MX8MN_IOMUXC_NAND_WE_B_I2C3_SDA                                        0x0138 0x03A0 0x05BC 0x4 0x3
#define MX8MN_IOMUXC_NAND_WE_B_GPIO3_IO17                                      0x0138 0x03A0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_WE_B_CORESIGHT_TRACE15                               0x0138 0x03A0 0x0000 0x6 0x0
#define MX8MN_IOMUXC_NAND_WP_B_RAWNAND_WP_B                                    0x013C 0x03A4 0x0000 0x0 0x0
#define MX8MN_IOMUXC_NAND_WP_B_USDHC3_CMD                                      0x013C 0x03A4 0x05DC 0x2 0x0
#define MX8MN_IOMUXC_NAND_WP_B_I2C4_SDA                                        0x013C 0x03A4 0x058C 0x4 0x4
#define MX8MN_IOMUXC_NAND_WP_B_GPIO3_IO18                                      0x013C 0x03A4 0x0000 0x5 0x0
#define MX8MN_IOMUXC_NAND_WP_B_CORESIGHT_EVENTO                                0x013C 0x03A4 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SAI5_RXFS_SAI5_RX_SYNC                                    0x0140 0x03A8 0x04E4 0x0 0x0
#define MX8MN_IOMUXC_SAI5_RXFS_GPIO3_IO19                                      0x0140 0x03A8 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI5_RXC_SAI5_RX_BCLK                                     0x0144 0x03AC 0x04D0 0x0 0x0
#define MX8MN_IOMUXC_SAI5_RXC_PDM_CLK                                          0x0144 0x03AC 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI5_RXC_GPIO3_IO20                                       0x0144 0x03AC 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI5_RXD0_SAI5_RX_DATA0                                   0x0148 0x03B0 0x04D4 0x0 0x0
#define MX8MN_IOMUXC_SAI5_RXD0_PDM_BIT_STREAM0                                 0x0148 0x03B0 0x0534 0x4 0x0
#define MX8MN_IOMUXC_SAI5_RXD0_GPIO3_IO21                                      0x0148 0x03B0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI5_RXD1_SAI5_RX_DATA1                                   0x014C 0x03B4 0x04D8 0x0 0x0
#define MX8MN_IOMUXC_SAI5_RXD1_SAI5_TX_SYNC                                    0x014C 0x03B4 0x04EC 0x3 0x0
#define MX8MN_IOMUXC_SAI5_RXD1_PDM_BIT_STREAM1                                 0x014C 0x03B4 0x0538 0x4 0x0
#define MX8MN_IOMUXC_SAI5_RXD1_GPIO3_IO22                                      0x014C 0x03B4 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI5_RXD2_SAI5_RX_DATA2                                   0x0150 0x03B8 0x04DC 0x0 0x0
#define MX8MN_IOMUXC_SAI5_RXD2_SAI5_TX_BCLK                                    0x0150 0x03B8 0x04E8 0x3 0x0
#define MX8MN_IOMUXC_SAI5_RXD2_PDM_BIT_STREAM2                                 0x0150 0x03B8 0x053C 0x4 0x0
#define MX8MN_IOMUXC_SAI5_RXD2_GPIO3_IO23                                      0x0150 0x03B8 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI5_RXD3_SAI5_RX_DATA3                                   0x0154 0x03BC 0x04E0 0x0 0x0
#define MX8MN_IOMUXC_SAI5_RXD3_SAI5_TX_DATA0                                   0x0154 0x03BC 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SAI5_RXD3_PDM_BIT_STREAM3                                 0x0154 0x03BC 0x0540 0x4 0x0
#define MX8MN_IOMUXC_SAI5_RXD3_GPIO3_IO24                                      0x0154 0x03BC 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI5_MCLK_SAI5_MCLK                                       0x0158 0x03C0 0x0594 0x0 0x0
#define MX8MN_IOMUXC_SAI5_MCLK_GPIO3_IO25                                      0x0158 0x03C0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI2_RXFS_SAI2_RX_SYNC                                    0x01B0 0x0418 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI2_RXFS_SAI5_TX_SYNC                                    0x01B0 0x0418 0x04EC 0x1 0x2
#define MX8MN_IOMUXC_SAI2_RXFS_SAI5_TX_DATA1                                   0x01B0 0x0418 0x0000 0x2 0x0
#define MX8MN_IOMUXC_SAI2_RXFS_SAI2_RX_DATA1                                   0x01B0 0x0418 0x05AC 0x3 0x0
#define MX8MN_IOMUXC_SAI2_RXFS_UART1_DCE_TX                                    0x01B0 0x0418 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI2_RXFS_UART1_DTE_RX                                    0x01B0 0x0418 0x04F4 0x4 0x2
#define MX8MN_IOMUXC_SAI2_RXFS_GPIO4_IO21                                      0x01B0 0x0418 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI2_RXFS_PDM_BIT_STREAM2                                 0x01B0 0x0418 0x053C 0x6 0x7
#define MX8MN_IOMUXC_SAI2_RXC_SAI2_RX_BCLK                                     0x01B4 0x041C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI2_RXC_SAI5_TX_BCLK                                     0x01B4 0x041C 0x04E8 0x1 0x2
#define MX8MN_IOMUXC_SAI2_RXC_UART1_DCE_RX                                     0x01B4 0x041C 0x04F4 0x4 0x3
#define MX8MN_IOMUXC_SAI2_RXC_UART1_DTE_TX                                     0x01B4 0x041C 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI2_RXC_GPIO4_IO22                                       0x01B4 0x041C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI2_RXC_PDM_BIT_STREAM1                                  0x01B4 0x041C 0x0538 0x6 0x8
#define MX8MN_IOMUXC_SAI2_RXD0_SAI2_RX_DATA0                                   0x01B8 0x0420 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI2_RXD0_SAI5_TX_DATA0                                   0x01B8 0x0420 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SAI2_RXD0_SAI2_TX_DATA1                                   0x01B8 0x0420 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SAI2_RXD0_UART1_DCE_RTS_B                                 0x01B8 0x0420 0x04F0 0x4 0x2
#define MX8MN_IOMUXC_SAI2_RXD0_UART1_DTE_CTS_B                                 0x01B8 0x0420 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI2_RXD0_GPIO4_IO23                                      0x01B8 0x0420 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI2_RXD0_PDM_BIT_STREAM3                                 0x01B8 0x0420 0x0540 0x6 0x7
#define MX8MN_IOMUXC_SAI2_TXFS_SAI2_TX_SYNC                                    0x01BC 0x0424 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI2_TXFS_SAI5_TX_DATA1                                   0x01BC 0x0424 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SAI2_TXFS_SAI2_TX_DATA1                                   0x01BC 0x0424 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SAI2_TXFS_UART1_DCE_CTS_B                                 0x01BC 0x0424 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI2_TXFS_UART1_DTE_RTS_B                                 0x01BC 0x0424 0x04F0 0x4 0x3
#define MX8MN_IOMUXC_SAI2_TXFS_GPIO4_IO24                                      0x01BC 0x0424 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI2_TXFS_PDM_BIT_STREAM2                                 0x01BC 0x0424 0x053C 0x6 0x8
#define MX8MN_IOMUXC_SAI2_TXC_SAI2_TX_BCLK                                     0x01C0 0x0428 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI2_TXC_SAI5_TX_DATA2                                    0x01C0 0x0428 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SAI2_TXC_GPIO4_IO25                                       0x01C0 0x0428 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI2_TXC_PDM_BIT_STREAM1                                  0x01C0 0x0428 0x0538 0x6 0x9
#define MX8MN_IOMUXC_SAI2_TXD0_SAI2_TX_DATA0                                   0x01C4 0x042C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI2_TXD0_SAI5_TX_DATA3                                   0x01C4 0x042C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SAI2_TXD0_GPIO4_IO26                                      0x01C4 0x042C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI2_TXD0_CCMSRCGPCMIX_BOOT_MODE4                         0x01C4 0x042C 0x0540 0x6 0x8
#define MX8MN_IOMUXC_SAI2_MCLK_SAI2_MCLK                                       0x01C8 0x0430 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI2_MCLK_SAI5_MCLK                                       0x01C8 0x0430 0x0594 0x1 0x2
#define MX8MN_IOMUXC_SAI2_MCLK_GPIO4_IO27                                      0x01C8 0x0430 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI2_MCLK_SAI3_MCLK                                       0x01C8 0x0430 0x05C0 0x6 0x1
#define MX8MN_IOMUXC_SAI3_RXFS_SAI3_RX_SYNC                                    0x01CC 0x0434 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI3_RXFS_GPT1_CAPTURE1                                   0x01CC 0x0434 0x05F0 0x1 0x0
#define MX8MN_IOMUXC_SAI3_RXFS_SAI5_RX_SYNC                                    0x01CC 0x0434 0x04E4 0x2 0x2
#define MX8MN_IOMUXC_SAI3_RXFS_SAI3_RX_DATA1                                   0x01CC 0x0434 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SAI3_RXFS_SPDIF1_IN                                       0x01CC 0x0434 0x05CC 0x4 0x3
#define MX8MN_IOMUXC_SAI3_RXFS_GPIO4_IO28                                      0x01CC 0x0434 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI3_RXFS_PDM_BIT_STREAM0                                 0x01CC 0x0434 0x0534 0x6 0x5
#define MX8MN_IOMUXC_SAI3_RXC_SAI3_RX_BCLK                                     0x01D0 0x0438 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI3_RXC_GPT1_CLK                                         0x01D0 0x0438 0x05E8 0x1 0x0
#define MX8MN_IOMUXC_SAI3_RXC_SAI5_RX_BCLK                                     0x01D0 0x0438 0x04D0 0x2 0x2
#define MX8MN_IOMUXC_SAI3_RXC_SAI2_RX_DATA1                                    0x01D0 0x0438 0x05AC 0x3 0x2
#define MX8MN_IOMUXC_SAI3_RXC_UART2_DCE_CTS_B                                  0x01D0 0x0438 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI3_RXC_UART2_DTE_RTS_B                                  0x01D0 0x0438 0x04F8 0x4 0x2
#define MX8MN_IOMUXC_SAI3_RXC_GPIO4_IO29                                       0x01D0 0x0438 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI3_RXC_PDM_CLK                                          0x01D0 0x0438 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SAI3_RXD_SAI3_RX_DATA0                                    0x01D4 0x043C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI3_RXD_GPT1_COMPARE1                                    0x01D4 0x043C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SAI3_RXD_SAI5_RX_DATA0                                    0x01D4 0x043C 0x04D4 0x2 0x2
#define MX8MN_IOMUXC_SAI3_RXD_SAI3_TX_DATA1                                    0x01D4 0x043C 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SAI3_RXD_UART2_DCE_RTS_B                                  0x01D4 0x043C 0x04F8 0x4 0x3
#define MX8MN_IOMUXC_SAI3_RXD_UART2_DTE_CTS_B                                  0x01D4 0x043C 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI3_RXD_GPIO4_IO30                                       0x01D4 0x043C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI3_RXD_PDM_BIT_STREAM1                                  0x01D4 0x043C 0x0538 0x6 0x10
#define MX8MN_IOMUXC_SAI3_TXFS_SAI3_TX_SYNC                                    0x01D8 0x0440 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI3_TXFS_GPT1_CAPTURE2                                   0x01D8 0x0440 0x05EC 0x1 0x0
#define MX8MN_IOMUXC_SAI3_TXFS_SAI5_RX_DATA1                                   0x01D8 0x0440 0x04D8 0x2 0x1
#define MX8MN_IOMUXC_SAI3_TXFS_SAI3_TX_DATA1                                   0x01D8 0x0440 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SAI3_TXFS_UART2_DCE_RX                                    0x01D8 0x0440 0x04FC 0x4 0x2
#define MX8MN_IOMUXC_SAI3_TXFS_UART2_DTE_TX                                    0x01D8 0x0440 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI3_TXFS_GPIO4_IO31                                      0x01D8 0x0440 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI3_TXFS_PDM_BIT_STREAM3                                 0x01D8 0x0440 0x0540 0x6 0x9
#define MX8MN_IOMUXC_SAI3_TXC_SAI3_TX_BCLK                                     0x01DC 0x0444 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI3_TXC_GPT1_COMPARE2                                    0x01DC 0x0444 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SAI3_TXC_SAI5_RX_DATA2                                    0x01DC 0x0444 0x04DC 0x2 0x1
#define MX8MN_IOMUXC_SAI3_TXC_SAI2_TX_DATA1                                    0x01DC 0x0444 0x0000 0x3 0x0
#define MX8MN_IOMUXC_SAI3_TXC_UART2_DCE_TX                                     0x01DC 0x0444 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI3_TXC_UART2_DTE_RX                                     0x01DC 0x0444 0x04FC 0x4 0x3
#define MX8MN_IOMUXC_SAI3_TXC_GPIO5_IO0                                        0x01DC 0x0444 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI3_TXC_PDM_BIT_STREAM2                                  0x01DC 0x0444 0x053C 0x6 0x9
#define MX8MN_IOMUXC_SAI3_TXD_SAI3_TX_DATA0                                    0x01E0 0x0448 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SAI3_TXD_GPT1_COMPARE3                                    0x01E0 0x0448 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SAI3_TXD_SAI5_RX_DATA3                                    0x01E0 0x0448 0x04E0 0x2 0x1
#define MX8MN_IOMUXC_SAI3_TXD_SPDIF1_EXT_CLK                                   0x01E0 0x0448 0x0568 0x4 0x2
#define MX8MN_IOMUXC_SAI3_TXD_GPIO5_IO1                                        0x01E0 0x0448 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI3_TXD_CCMSRCGPCMIX_BOOT_MODE5                          0x01E0 0x0448 0x0000 0x6 0x0
#define MX8MN_IOMUXC_SAI3_MCLK_SAI3_MCLK                                       0x01E4 0x044C 0x05C0 0x0 0x0
#define MX8MN_IOMUXC_SAI3_MCLK_PWM4_OUT                                        0x01E4 0x044C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SAI3_MCLK_SAI5_MCLK                                       0x01E4 0x044C 0x0594 0x2 0x3
#define MX8MN_IOMUXC_SAI3_MCLK_SPDIF1_OUT                                      0x01E4 0x044C 0x0000 0x4 0x0
#define MX8MN_IOMUXC_SAI3_MCLK_GPIO5_IO2                                       0x01E4 0x044C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SAI3_MCLK_SPDIF1_IN                                       0x01E4 0x044C 0x05CC 0x6 0x4
#define MX8MN_IOMUXC_SPDIF_TX_SPDIF1_OUT                                       0x01E8 0x0450 0x0000 0x0 0x0
#define MX8MN_IOMUXC_SPDIF_TX_PWM3_OUT                                         0x01E8 0x0450 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SPDIF_TX_GPIO5_IO3                                        0x01E8 0x0450 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SPDIF_RX_SPDIF1_IN                                        0x01EC 0x0454 0x05CC 0x0 0x0
#define MX8MN_IOMUXC_SPDIF_RX_PWM2_OUT                                         0x01EC 0x0454 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SPDIF_RX_GPIO5_IO4                                        0x01EC 0x0454 0x0000 0x5 0x0
#define MX8MN_IOMUXC_SPDIF_EXT_CLK_SPDIF1_EXT_CLK                              0x01F0 0x0458 0x0568 0x0 0x0
#define MX8MN_IOMUXC_SPDIF_EXT_CLK_PWM1_OUT                                    0x01F0 0x0458 0x0000 0x1 0x0
#define MX8MN_IOMUXC_SPDIF_EXT_CLK_GPIO5_IO5                                   0x01F0 0x0458 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ECSPI1_SCLK_ECSPI1_SCLK                                   0x01F4 0x045C 0x05D8 0x0 0x0
#define MX8MN_IOMUXC_ECSPI1_SCLK_UART3_DCE_RX                                  0x01F4 0x045C 0x0504 0x1 0x0
#define MX8MN_IOMUXC_ECSPI1_SCLK_UART3_DTE_TX                                  0x01F4 0x045C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_ECSPI1_SCLK_I2C1_SCL                                      0x01F4 0x045C 0x055C 0x2 0x2
#define MX8MN_IOMUXC_ECSPI1_SCLK_SAI5_RX_SYNC                                  0x01F4 0x045C 0x04DC 0x3 0x2
#define MX8MN_IOMUXC_ECSPI1_SCLK_GPIO5_IO6                                     0x01F4 0x045C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ECSPI1_MOSI_ECSPI1_MOSI                                   0x01F8 0x0460 0x05A8 0x0 0x0
#define MX8MN_IOMUXC_ECSPI1_MOSI_UART3_DCE_TX                                  0x01F8 0x0460 0x0000 0x1 0x0
#define MX8MN_IOMUXC_ECSPI1_MOSI_UART3_DTE_RX                                  0x01F8 0x0460 0x0504 0x1 0x1
#define MX8MN_IOMUXC_ECSPI1_MOSI_I2C1_SDA                                      0x01F8 0x0460 0x056C 0x2 0x2
#define MX8MN_IOMUXC_ECSPI1_MOSI_SAI5_RX_BCLK                                  0x01F8 0x0460 0x04D0 0x3 0x3
#define MX8MN_IOMUXC_ECSPI1_MOSI_GPIO5_IO7                                     0x01F8 0x0460 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ECSPI1_MISO_ECSPI1_MISO                                   0x01FC 0x0464 0x05C4 0x0 0x0
#define MX8MN_IOMUXC_ECSPI1_MISO_UART3_DCE_CTS_B                               0x01FC 0x0464 0x0000 0x1 0x0
#define MX8MN_IOMUXC_ECSPI1_MISO_UART3_DTE_RTS_B                               0x01FC 0x0464 0x0500 0x1 0x0
#define MX8MN_IOMUXC_ECSPI1_MISO_I2C2_SCL                                      0x01FC 0x0464 0x05D0 0x2 0x2
#define MX8MN_IOMUXC_ECSPI1_MISO_SAI5_RX_DATA0                                 0x01FC 0x0464 0x04D4 0x3 0x3
#define MX8MN_IOMUXC_ECSPI1_MISO_GPIO5_IO8                                     0x01FC 0x0464 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ECSPI1_SS0_ECSPI1_SS0                                     0x0200 0x0468 0x0564 0x0 0x0
#define MX8MN_IOMUXC_ECSPI1_SS0_UART3_DCE_RTS_B                                0x0200 0x0468 0x0500 0x1 0x1
#define MX8MN_IOMUXC_ECSPI1_SS0_UART3_DTE_CTS_B                                0x0200 0x0468 0x0000 0x1 0x0
#define MX8MN_IOMUXC_ECSPI1_SS0_I2C2_SDA                                       0x0200 0x0468 0x0560 0x2 0x2
#define MX8MN_IOMUXC_ECSPI1_SS0_SAI5_RX_DATA1                                  0x0200 0x0468 0x04D8 0x3 0x2
#define MX8MN_IOMUXC_ECSPI1_SS0_SAI5_TX_SYNC                                   0x0200 0x0468 0x04EC 0x4 0x3
#define MX8MN_IOMUXC_ECSPI1_SS0_GPIO5_IO9                                      0x0200 0x0468 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ECSPI2_SCLK_ECSPI2_SCLK                                   0x0204 0x046C 0x0580 0x0 0x0
#define MX8MN_IOMUXC_ECSPI2_SCLK_UART4_DCE_RX                                  0x0204 0x046C 0x050C 0x1 0x0
#define MX8MN_IOMUXC_ECSPI2_SCLK_UART4_DTE_TX                                  0x0204 0x046C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_ECSPI2_SCLK_I2C3_SCL                                      0x0204 0x046C 0x0588 0x2 0x4
#define MX8MN_IOMUXC_ECSPI2_SCLK_SAI5_RX_DATA2                                 0x0204 0x046C 0x0000 0x3 0x0
#define MX8MN_IOMUXC_ECSPI2_SCLK_SAI5_TX_BCLK                                  0x0204 0x046C 0x04E8 0x4 0x3
#define MX8MN_IOMUXC_ECSPI2_SCLK_GPIO5_IO10                                    0x0204 0x046C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ECSPI2_MOSI_ECSPI2_MOSI                                   0x0208 0x0470 0x0590 0x0 0x0
#define MX8MN_IOMUXC_ECSPI2_MOSI_UART4_DCE_TX                                  0x0208 0x0470 0x0000 0x1 0x0
#define MX8MN_IOMUXC_ECSPI2_MOSI_UART4_DTE_RX                                  0x0208 0x0470 0x050C 0x1 0x1
#define MX8MN_IOMUXC_ECSPI2_MOSI_I2C3_SDA                                      0x0208 0x0470 0x05BC 0x2 0x4
#define MX8MN_IOMUXC_ECSPI2_MOSI_SAI5_RX_DATA3                                 0x0208 0x0470 0x04E0 0x3 0x2
#define MX8MN_IOMUXC_ECSPI2_MOSI_SAI5_TX_DATA0                                 0x0208 0x0470 0x0000 0x4 0x0
#define MX8MN_IOMUXC_ECSPI2_MOSI_GPIO5_IO11                                    0x0208 0x0470 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ECSPI2_MISO_ECSPI2_MISO                                   0x020C 0x0474 0x0578 0x0 0x0
#define MX8MN_IOMUXC_ECSPI2_MISO_UART4_DCE_CTS_B                               0x020C 0x0474 0x0000 0x1 0x0
#define MX8MN_IOMUXC_ECSPI2_MISO_UART4_DTE_RTS_B                               0x020C 0x0474 0x0508 0x1 0x0
#define MX8MN_IOMUXC_ECSPI2_MISO_I2C4_SCL                                      0x020C 0x0474 0x05D4 0x2 0x3
#define MX8MN_IOMUXC_ECSPI2_MISO_SAI5_MCLK                                     0x020C 0x0474 0x0594 0x3 0x4
#define MX8MN_IOMUXC_ECSPI2_MISO_GPIO5_IO12                                    0x020C 0x0474 0x0000 0x5 0x0
#define MX8MN_IOMUXC_ECSPI2_SS0_ECSPI2_SS0                                     0x0210 0x0478 0x0570 0x0 0x0
#define MX8MN_IOMUXC_ECSPI2_SS0_UART4_DCE_RTS_B                                0x0210 0x0478 0x0508 0x1 0x1
#define MX8MN_IOMUXC_ECSPI2_SS0_UART4_DTE_CTS_B                                0x0210 0x0478 0x0000 0x1 0x0
#define MX8MN_IOMUXC_ECSPI2_SS0_I2C4_SDA                                       0x0210 0x0478 0x058C 0x2 0x5
#define MX8MN_IOMUXC_ECSPI2_SS0_GPIO5_IO13                                     0x0210 0x0478 0x0000 0x5 0x0
#define MX8MN_IOMUXC_I2C1_SCL_I2C1_SCL                                         0x0214 0x047C 0x055C 0x0 0x0
#define MX8MN_IOMUXC_I2C1_SCL_ENET1_MDC                                        0x0214 0x047C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_I2C1_SCL_ECSPI1_SCLK                                      0x0214 0x047C 0x05D8 0x3 0x1
#define MX8MN_IOMUXC_I2C1_SCL_GPIO5_IO14                                       0x0214 0x047C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_I2C1_SDA_I2C1_SDA                                         0x0218 0x0480 0x056C 0x0 0x0
#define MX8MN_IOMUXC_I2C1_SDA_ENET1_MDIO                                       0x0218 0x0480 0x04C0 0x1 0x2
#define MX8MN_IOMUXC_I2C1_SDA_ECSPI1_MOSI                                      0x0218 0x0480 0x05A8 0x3 0x1
#define MX8MN_IOMUXC_I2C1_SDA_GPIO5_IO15                                       0x0218 0x0480 0x0000 0x5 0x0
#define MX8MN_IOMUXC_I2C2_SCL_I2C2_SCL                                         0x021C 0x0484 0x05D0 0x0 0x0
#define MX8MN_IOMUXC_I2C2_SCL_ENET1_1588_EVENT1_IN                             0x021C 0x0484 0x0000 0x1 0x0
#define MX8MN_IOMUXC_I2C2_SCL_USDHC3_CD_B                                      0x021C 0x0484 0x0598 0x2 0x1
#define MX8MN_IOMUXC_I2C2_SCL_ECSPI1_MISO                                      0x021C 0x0484 0x05C4 0x3 0x1
#define MX8MN_IOMUXC_I2C2_SCL_GPIO5_IO16                                       0x021C 0x0484 0x0000 0x5 0x0
#define MX8MN_IOMUXC_I2C2_SDA_I2C2_SDA                                         0x0220 0x0488 0x0560 0x0 0x0
#define MX8MN_IOMUXC_I2C2_SDA_ENET1_1588_EVENT1_OUT                            0x0220 0x0488 0x0000 0x1 0x0
#define MX8MN_IOMUXC_I2C2_SDA_USDHC3_WP                                        0x0220 0x0488 0x05B8 0x2 0x1
#define MX8MN_IOMUXC_I2C2_SDA_ECSPI1_SS0                                       0x0220 0x0488 0x0564 0x3 0x1
#define MX8MN_IOMUXC_I2C2_SDA_GPIO5_IO17                                       0x0220 0x0488 0x0000 0x5 0x0
#define MX8MN_IOMUXC_I2C3_SCL_I2C3_SCL                                         0x0224 0x048C 0x0588 0x0 0x0
#define MX8MN_IOMUXC_I2C3_SCL_PWM4_OUT                                         0x0224 0x048C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_I2C3_SCL_GPT2_CLK                                         0x0224 0x048C 0x0000 0x2 0x0
#define MX8MN_IOMUXC_I2C3_SCL_ECSPI2_SCLK                                      0x0224 0x048C 0x0580 0x3 0x2
#define MX8MN_IOMUXC_I2C3_SCL_GPIO5_IO18                                       0x0224 0x048C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_I2C3_SDA_I2C3_SDA                                         0x0228 0x0490 0x05BC 0x0 0x0
#define MX8MN_IOMUXC_I2C3_SDA_PWM3_OUT                                         0x0228 0x0490 0x0000 0x1 0x0
#define MX8MN_IOMUXC_I2C3_SDA_GPT3_CLK                                         0x0228 0x0490 0x0000 0x2 0x0
#define MX8MN_IOMUXC_I2C3_SDA_ECSPI2_MOSI                                      0x0228 0x0490 0x0590 0x3 0x2
#define MX8MN_IOMUXC_I2C3_SDA_GPIO5_IO19                                       0x0228 0x0490 0x0000 0x5 0x0
#define MX8MN_IOMUXC_I2C4_SCL_I2C4_SCL                                         0x022C 0x0494 0x05D4 0x0 0x0
#define MX8MN_IOMUXC_I2C4_SCL_PWM2_OUT                                         0x022C 0x0494 0x0000 0x1 0x0
#define MX8MN_IOMUXC_I2C4_SCL_ECSPI2_MISO                                      0x022C 0x0494 0x0578 0x3 0x2
#define MX8MN_IOMUXC_I2C4_SCL_GPIO5_IO20                                       0x022C 0x0494 0x0000 0x5 0x0
#define MX8MN_IOMUXC_I2C4_SDA_I2C4_SDA                                         0x0230 0x0498 0x058C 0x0 0x0
#define MX8MN_IOMUXC_I2C4_SDA_PWM1_OUT                                         0x0230 0x0498 0x0000 0x1 0x0
#define MX8MN_IOMUXC_I2C4_SDA_ECSPI2_SS0                                       0x0230 0x0498 0x0570 0x3 0x1
#define MX8MN_IOMUXC_I2C4_SDA_GPIO5_IO21                                       0x0230 0x0498 0x0000 0x5 0x0
#define MX8MN_IOMUXC_UART1_RXD_UART1_DCE_RX                                    0x0234 0x049C 0x04F4 0x0 0x0
#define MX8MN_IOMUXC_UART1_RXD_UART1_DTE_TX                                    0x0234 0x049C 0x0000 0x0 0x0
#define MX8MN_IOMUXC_UART1_RXD_ECSPI3_SCLK                                     0x0234 0x049C 0x0000 0x1 0x0
#define MX8MN_IOMUXC_UART1_RXD_GPIO5_IO22                                      0x0234 0x049C 0x0000 0x5 0x0
#define MX8MN_IOMUXC_UART1_TXD_UART1_DCE_TX                                    0x0238 0x04A0 0x0000 0x0 0x0
#define MX8MN_IOMUXC_UART1_TXD_UART1_DTE_RX                                    0x0238 0x04A0 0x04F4 0x0 0x1
#define MX8MN_IOMUXC_UART1_TXD_ECSPI3_MOSI                                     0x0238 0x04A0 0x0000 0x1 0x0
#define MX8MN_IOMUXC_UART1_TXD_GPIO5_IO23                                      0x0238 0x04A0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_UART2_RXD_UART2_DCE_RX                                    0x023C 0x04A4 0x04FC 0x0 0x0
#define MX8MN_IOMUXC_UART2_RXD_UART2_DTE_TX                                    0x023C 0x04A4 0x0000 0x0 0x0
#define MX8MN_IOMUXC_UART2_RXD_ECSPI3_MISO                                     0x023C 0x04A4 0x0000 0x1 0x0
#define MX8MN_IOMUXC_UART2_RXD_GPT1_COMPARE3                                   0x023C 0x04A4 0x0000 0x3 0x0
#define MX8MN_IOMUXC_UART2_RXD_GPIO5_IO24                                      0x023C 0x04A4 0x0000 0x5 0x0
#define MX8MN_IOMUXC_UART2_TXD_UART2_DCE_TX                                    0x0240 0x04A8 0x0000 0x0 0x0
#define MX8MN_IOMUXC_UART2_TXD_UART2_DTE_RX                                    0x0240 0x04A8 0x04FC 0x0 0x1
#define MX8MN_IOMUXC_UART2_TXD_ECSPI3_SS0                                      0x0240 0x04A8 0x0000 0x1 0x0
#define MX8MN_IOMUXC_UART2_TXD_GPT1_COMPARE2                                   0x0240 0x04A8 0x0000 0x3 0x0
#define MX8MN_IOMUXC_UART2_TXD_GPIO5_IO25                                      0x0240 0x04A8 0x0000 0x5 0x0
#define MX8MN_IOMUXC_UART3_RXD_UART3_DCE_RX                                    0x0244 0x04AC 0x0504 0x0 0x2
#define MX8MN_IOMUXC_UART3_RXD_UART3_DTE_TX                                    0x0244 0x04AC 0x0000 0x0 0x0
#define MX8MN_IOMUXC_UART3_RXD_UART1_DCE_CTS_B                                 0x0244 0x04AC 0x0000 0x1 0x0
#define MX8MN_IOMUXC_UART3_RXD_UART1_DTE_RTS_B                                 0x0244 0x04AC 0x04F0 0x1 0x0
#define MX8MN_IOMUXC_UART3_RXD_USDHC3_RESET_B                                  0x0244 0x04AC 0x0000 0x2 0x0
#define MX8MN_IOMUXC_UART3_RXD_GPT1_CAPTURE2                                   0x0244 0x04AC 0x05EC 0x3 0x1
#define MX8MN_IOMUXC_UART3_RXD_GPIO5_IO26                                      0x0244 0x04AC 0x0000 0x5 0x0
#define MX8MN_IOMUXC_UART3_TXD_UART3_DCE_TX                                    0x0248 0x04B0 0x0000 0x0 0x0
#define MX8MN_IOMUXC_UART3_TXD_UART3_DTE_RX                                    0x0248 0x04B0 0x0504 0x0 0x3
#define MX8MN_IOMUXC_UART3_TXD_UART1_DCE_RTS_B                                 0x0248 0x04B0 0x04F0 0x1 0x1
#define MX8MN_IOMUXC_UART3_TXD_UART1_DTE_CTS_B                                 0x0248 0x04B0 0x0000 0x1 0x0
#define MX8MN_IOMUXC_UART3_TXD_USDHC3_VSELECT                                  0x0248 0x04B0 0x0000 0x2 0x0
#define MX8MN_IOMUXC_UART3_TXD_GPT1_CLK                                        0x0248 0x04B0 0x05E8 0x3 0x1
#define MX8MN_IOMUXC_UART3_TXD_GPIO5_IO27                                      0x0248 0x04B0 0x0000 0x5 0x0
#define MX8MN_IOMUXC_UART4_RXD_UART4_DCE_RX                                    0x024C 0x04B4 0x050C 0x0 0x2
#define MX8MN_IOMUXC_UART4_RXD_UART4_DTE_TX                                    0x024C 0x04B4 0x0000 0x0 0x0
#define MX8MN_IOMUXC_UART4_RXD_UART2_DCE_CTS_B                                 0x024C 0x04B4 0x0000 0x1 0x0
#define MX8MN_IOMUXC_UART4_RXD_UART2_DTE_RTS_B                                 0x024C 0x04B4 0x04F8 0x1 0x0
#define MX8MN_IOMUXC_UART4_RXD_GPT1_COMPARE1                                   0x024C 0x04B4 0x0000 0x3 0x0
#define MX8MN_IOMUXC_UART4_RXD_GPIO5_IO28                                      0x024C 0x04B4 0x0000 0x5 0x0
#define MX8MN_IOMUXC_UART4_TXD_UART4_DCE_TX                                    0x0250 0x04B8 0x0000 0x0 0x0
#define MX8MN_IOMUXC_UART4_TXD_UART4_DTE_RX                                    0x0250 0x04B8 0x050C 0x0 0x3
#define MX8MN_IOMUXC_UART4_TXD_UART2_DCE_RTS_B                                 0x0250 0x04B8 0x04F8 0x1 0x1
#define MX8MN_IOMUXC_UART4_TXD_UART2_DTE_CTS_B                                 0x0250 0x04B8 0x0000 0x1 0x0
#define MX8MN_IOMUXC_UART4_TXD_GPT1_CAPTURE1                                   0x0250 0x04B8 0x05F0 0x3 0x1
#define MX8MN_IOMUXC_UART4_TXD_GPIO5_IO29                                      0x0250 0x04B8 0x0000 0x5 0x0

#endif /* __DTS_IMX8MN_PINFUNC_H */
