/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SelectionModel<T>
extends HasHandlers,
ProvidesKey<T> {
    public HandlerRegistration addSelectionChangeHandler(SelectionChangeEvent.Handler var1);

    public boolean isSelected(T var1);

    public void setSelected(T var1, boolean var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractSelectionModel<T>
    implements SelectionModel<T> {
        private final HandlerManager handlerManager = new HandlerManager(this);
        private boolean isEventCancelled;
        private boolean isEventScheduled;
        private final ProvidesKey<T> keyProvider;

        protected AbstractSelectionModel(ProvidesKey<T> keyProvider) {
            this.keyProvider = keyProvider;
        }

        @Override
        public HandlerRegistration addSelectionChangeHandler(SelectionChangeEvent.Handler handler) {
            return this.handlerManager.addHandler(SelectionChangeEvent.getType(), handler);
        }

        @Override
        public void fireEvent(GwtEvent<?> event) {
            this.handlerManager.fireEvent(event);
        }

        @Override
        public Object getKey(T item) {
            return this.keyProvider == null || item == null ? item : this.keyProvider.getKey(item);
        }

        public ProvidesKey<T> getKeyProvider() {
            return this.keyProvider;
        }

        protected void fireSelectionChangeEvent() {
            if (this.isEventScheduled()) {
                this.setEventCancelled(true);
            }
            SelectionChangeEvent.fire(this);
        }

        protected boolean isEventCancelled() {
            return this.isEventCancelled;
        }

        protected boolean isEventScheduled() {
            return this.isEventScheduled;
        }

        protected void scheduleSelectionChangeEvent() {
            this.setEventCancelled(false);
            if (!this.isEventScheduled()) {
                this.setEventScheduled(true);
                Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        AbstractSelectionModel.this.setEventScheduled(false);
                        if (AbstractSelectionModel.this.isEventCancelled()) {
                            AbstractSelectionModel.this.setEventCancelled(false);
                            return;
                        }
                        AbstractSelectionModel.this.fireSelectionChangeEvent();
                    }
                });
            }
        }

        protected void setEventCancelled(boolean isEventCancelled) {
            this.isEventCancelled = isEventCancelled;
        }

        protected void setEventScheduled(boolean isEventScheduled) {
            this.isEventScheduled = isEventScheduled;
        }
    }
}

