/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.media.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.VideoElement;
import com.google.gwt.media.client.MediaBase;

public class Video
extends MediaBase {
    private static VideoElementSupportDetector detector;

    public static Video createIfSupported() {
        if (detector == null) {
            detector = (VideoElementSupportDetector)GWT.create(VideoElementSupportDetector.class);
        }
        if (!detector.isSupportedCompileTime()) {
            return null;
        }
        VideoElement element = Document.get().createVideoElement();
        if (!VideoElementSupportDetector.isSupportedRunTime(element)) {
            return null;
        }
        return new Video(element);
    }

    public static boolean isSupported() {
        if (detector == null) {
            detector = (VideoElementSupportDetector)GWT.create(VideoElementSupportDetector.class);
        }
        if (!detector.isSupportedCompileTime()) {
            return false;
        }
        VideoElement element = Document.get().createVideoElement();
        return VideoElementSupportDetector.isSupportedRunTime(element);
    }

    protected Video(VideoElement element) {
        super(element);
    }

    @Deprecated
    public Video(String src) {
        super(Document.get().createVideoElement());
        this.getMediaElement().setSrc(src);
    }

    public String getPoster() {
        return this.getVideoElement().getPoster();
    }

    public VideoElement getVideoElement() {
        return (VideoElement)this.getMediaElement().cast();
    }

    public int getVideoHeight() {
        return this.getVideoElement().getVideoHeight();
    }

    public int getVideoWidth() {
        return this.getVideoElement().getVideoWidth();
    }

    public void setPoster(String url) {
        this.getVideoElement().setPoster(url);
    }

    private static class VideoElementSupportDetector {
        private VideoElementSupportDetector() {
        }

        static native boolean isSupportedRunTime(VideoElement var0);

        boolean isSupportedCompileTime() {
            return false;
        }
    }

    private static class VideoElementSupportDetectedNo
    extends VideoElementSupportDetector {
        private VideoElementSupportDetectedNo() {
        }

        boolean isSupportedCompileTime() {
            return false;
        }
    }

    private static class VideoElementSupportDetectedMaybe
    extends VideoElementSupportDetector {
        private VideoElementSupportDetectedMaybe() {
        }

        boolean isSupportedCompileTime() {
            return true;
        }
    }
}

