/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "es" locale.
 */
public class LocalizedNamesImpl_es extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "MX",
        "AR",
        "CO",
        "ES",
        "US",
        "PH",
        "VE",
        "PE",
        "CL",
        "CU",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DE",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "DZ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BY",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "CV",
        "KH",
        "CM",
        "CA",
        "EA",
        "TD",
        "CL",
        "CN",
        "CY",
        "VA",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "DG",
        "DK",
        "DM",
        "EC",
        "EG",
        "SV",
        "AE",
        "ER",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "PH",
        "FI",
        "FJ",
        "FR",
        "FX",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GF",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "HT",
        "HN",
        "HK",
        "HU",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "BV",
        "CX",
        "CP",
        "AC",
        "IM",
        "IS",
        "NU",
        "NF",
        "AX",
        "KY",
        "IC",
        "CC",
        "CK",
        "FO",
        "GS",
        "HM",
        "FK",
        "MP",
        "MH",
        "UM",
        "SB",
        "TC",
        "VG",
        "VI",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KG",
        "KI",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NO",
        "NC",
        "NZ",
        "OM",
        "NL",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "GB",
        "CF",
        "CZ",
        "CD",
        "DO",
        "RE",
        "RW",
        "RO",
        "RU",
        "EH",
        "WS",
        "AS",
        "BL",
        "KN",
        "SM",
        "MF",
        "PM",
        "SH",
        "LC",
        "ST",
        "VC",
        "SN",
        "RS",
        "CS",
        "SC",
        "SL",
        "SG",
        "SY",
        "SO",
        "LK",
        "SZ",
        "ZA",
        "SD",
        "SE",
        "CH",
        "SR",
        "SJ",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "IO",
        "QO",
        "TF",
        "PS",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "UG",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "YE",
        "DJ",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundo");
    namesMap.put("002", "África");
    namesMap.put("003", "América del Norte");
    namesMap.put("005", "Suramérica");
    namesMap.put("009", "Oceanía");
    namesMap.put("011", "África occidental");
    namesMap.put("013", "Centroamérica");
    namesMap.put("014", "África oriental");
    namesMap.put("015", "África septentrional");
    namesMap.put("017", "África central");
    namesMap.put("018", "África meridional");
    namesMap.put("019", "Américas");
    namesMap.put("021", "Norteamérica");
    namesMap.put("029", "Caribe");
    namesMap.put("030", "Asia oriental");
    namesMap.put("034", "Asia meridional");
    namesMap.put("035", "Sudeste asiático");
    namesMap.put("039", "Europa meridional");
    namesMap.put("053", "Australia y Nueva Zelanda");
    namesMap.put("057", "Micronesia [057]");
    namesMap.put("061", "Polinesia");
    namesMap.put("062", "Asia centromeridional");
    namesMap.put("143", "Asia central");
    namesMap.put("145", "Asia occidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa oriental");
    namesMap.put("154", "Europa septentrional");
    namesMap.put("155", "Europa occidental");
    namesMap.put("172", "Comunidad de Estados Independientes");
    namesMap.put("419", "Latinoamérica y el Caribe");
    namesMap.put("AC", "Isla de la Ascensión");
    namesMap.put("AE", "Emiratos Árabes Unidos");
    namesMap.put("AF", "Afganistán");
    namesMap.put("AG", "Antigua y Barbuda");
    namesMap.put("AI", "Anguila");
    namesMap.put("AN", "Antillas Neerlandesas");
    namesMap.put("AQ", "Antártida");
    namesMap.put("AS", "Samoa Americana");
    namesMap.put("AX", "Islas Åland");
    namesMap.put("AZ", "Azerbaiyán");
    namesMap.put("BA", "Bosnia-Herzegovina");
    namesMap.put("BE", "Bélgica");
    namesMap.put("BH", "Bahréin");
    namesMap.put("BJ", "Benín");
    namesMap.put("BL", "San Bartolomé");
    namesMap.put("BM", "Bermudas");
    namesMap.put("BN", "Brunéi");
    namesMap.put("BR", "Brasil");
    namesMap.put("BT", "Bután");
    namesMap.put("BV", "Isla Bouvet");
    namesMap.put("BW", "Botsuana");
    namesMap.put("BY", "Bielorrusia");
    namesMap.put("BZ", "Belice");
    namesMap.put("CA", "Canadá");
    namesMap.put("CC", "Islas Cocos");
    namesMap.put("CD", "República Democrática del Congo");
    namesMap.put("CF", "República Centroafricana");
    namesMap.put("CG", "Congo - Brazzaville");
    namesMap.put("CH", "Suiza");
    namesMap.put("CI", "Costa de Marfil");
    namesMap.put("CK", "Islas Cook");
    namesMap.put("CM", "Camerún");
    namesMap.put("CP", "Isla Clipperton");
    namesMap.put("CS", "Serbia y Montenegro");
    namesMap.put("CV", "Cabo Verde");
    namesMap.put("CX", "Isla Christmas");
    namesMap.put("CY", "Chipre");
    namesMap.put("CZ", "República Checa");
    namesMap.put("DE", "Alemania");
    namesMap.put("DG", "Diego García");
    namesMap.put("DJ", "Yibuti");
    namesMap.put("DK", "Dinamarca");
    namesMap.put("DO", "República Dominicana");
    namesMap.put("DZ", "Argelia");
    namesMap.put("EA", "Ceuta y Melilla");
    namesMap.put("EG", "Egipto");
    namesMap.put("EH", "Sáhara Occidental");
    namesMap.put("ES", "España");
    namesMap.put("ET", "Etiopía");
    namesMap.put("EU", "Unión Europea");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FJ", "Fiyi");
    namesMap.put("FK", "Islas Malvinas");
    namesMap.put("FO", "Islas Feroe");
    namesMap.put("FR", "Francia");
    namesMap.put("FX", "Francia metropolitana");
    namesMap.put("GA", "Gabón");
    namesMap.put("GB", "Reino Unido");
    namesMap.put("GD", "Granada");
    namesMap.put("GF", "Guayana Francesa");
    namesMap.put("GL", "Groenlandia");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Guinea Ecuatorial");
    namesMap.put("GR", "Grecia");
    namesMap.put("GS", "Islas Georgia del Sur y Sandwich del Sur");
    namesMap.put("HM", "Islas Heard y McDonald");
    namesMap.put("HR", "Croacia");
    namesMap.put("HT", "Haití");
    namesMap.put("HU", "Hungría");
    namesMap.put("IC", "Islas Canarias");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Isla de Man");
    namesMap.put("IO", "Territorio Británico del Océano Índico");
    namesMap.put("IR", "Irán");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JO", "Jordania");
    namesMap.put("JP", "Japón");
    namesMap.put("KE", "Kenia");
    namesMap.put("KG", "Kirguistán");
    namesMap.put("KH", "Camboya");
    namesMap.put("KM", "Comoras");
    namesMap.put("KN", "San Cristóbal y Nieves");
    namesMap.put("KP", "Corea del Norte");
    namesMap.put("KR", "Corea del Sur");
    namesMap.put("KY", "Islas Caimán");
    namesMap.put("KZ", "Kazajistán");
    namesMap.put("LB", "Líbano");
    namesMap.put("LC", "Santa Lucía");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxemburgo");
    namesMap.put("LV", "Letonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Marruecos");
    namesMap.put("MC", "Mónaco");
    namesMap.put("MD", "Moldavia");
    namesMap.put("MF", "San Martín");
    namesMap.put("MH", "Islas Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar [Birmania]");
    namesMap.put("MO", "Macao");
    namesMap.put("MP", "Islas Marianas del Norte");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MU", "Mauricio");
    namesMap.put("MV", "Maldivas");
    namesMap.put("MW", "Malaui");
    namesMap.put("MX", "México");
    namesMap.put("MY", "Malasia");
    namesMap.put("NC", "Nueva Caledonia");
    namesMap.put("NE", "Níger");
    namesMap.put("NF", "Isla Norfolk");
    namesMap.put("NL", "Países Bajos");
    namesMap.put("NO", "Noruega");
    namesMap.put("NU", "Isla Niue");
    namesMap.put("NZ", "Nueva Zelanda");
    namesMap.put("OM", "Omán");
    namesMap.put("PA", "Panamá");
    namesMap.put("PE", "Perú");
    namesMap.put("PF", "Polinesia Francesa");
    namesMap.put("PG", "Papúa Nueva Guinea");
    namesMap.put("PH", "Filipinas");
    namesMap.put("PK", "Pakistán");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "San Pedro y Miquelón");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Territorios Palestinos");
    namesMap.put("QO", "Territorios alejados de Oceanía");
    namesMap.put("RE", "Reunión");
    namesMap.put("RO", "Rumanía");
    namesMap.put("RU", "Rusia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudí");
    namesMap.put("SB", "Islas Salomón");
    namesMap.put("SD", "Sudán");
    namesMap.put("SE", "Suecia");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Santa Elena");
    namesMap.put("SI", "Eslovenia");
    namesMap.put("SJ", "Svalbard y Jan Mayen");
    namesMap.put("SK", "Eslovaquia");
    namesMap.put("SL", "Sierra Leona");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Santo Tomé y Príncipe");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Suazilandia");
    namesMap.put("TA", "Tristán da Cunha");
    namesMap.put("TC", "Islas Turcas y Caicos");
    namesMap.put("TF", "Territorios Australes Franceses");
    namesMap.put("TH", "Tailandia");
    namesMap.put("TJ", "Tayikistán");
    namesMap.put("TL", "Timor Oriental");
    namesMap.put("TM", "Turkmenistán");
    namesMap.put("TN", "Túnez");
    namesMap.put("TR", "Turquía");
    namesMap.put("TT", "Trinidad y Tobago");
    namesMap.put("TW", "Taiwán");
    namesMap.put("UA", "Ucrania");
    namesMap.put("UM", "Islas menores alejadas de los Estados Unidos");
    namesMap.put("US", "Estados Unidos");
    namesMap.put("UZ", "Uzbekistán");
    namesMap.put("VA", "Ciudad del Vaticano");
    namesMap.put("VC", "San Vicente y las Granadinas");
    namesMap.put("VG", "Islas Vírgenes Británicas");
    namesMap.put("VI", "Islas Vírgenes de los Estados Unidos");
    namesMap.put("WF", "Wallis y Futuna");
    namesMap.put("ZA", "Sudáfrica");
    namesMap.put("ZW", "Zimbabue");
    namesMap.put("ZZ", "Región desconocida o no válida");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundo",
        "002": "África",
        "003": "América del Norte",
        "005": "Suramérica",
        "009": "Oceanía",
        "011": "África occidental",
        "013": "Centroamérica",
        "014": "África oriental",
        "015": "África septentrional",
        "017": "África central",
        "018": "África meridional",
        "019": "Américas",
        "021": "Norteamérica",
        "029": "Caribe",
        "030": "Asia oriental",
        "034": "Asia meridional",
        "035": "Sudeste asiático",
        "039": "Europa meridional",
        "053": "Australia y Nueva Zelanda",
        "057": "Micronesia [057]",
        "061": "Polinesia",
        "062": "Asia centromeridional",
        "143": "Asia central",
        "145": "Asia occidental",
        "150": "Europa",
        "151": "Europa oriental",
        "154": "Europa septentrional",
        "155": "Europa occidental",
        "172": "Comunidad de Estados Independientes",
        "419": "Latinoamérica y el Caribe",
        "AC": "Isla de la Ascensión",
        "AE": "Emiratos Árabes Unidos",
        "AF": "Afganistán",
        "AG": "Antigua y Barbuda",
        "AI": "Anguila",
        "AN": "Antillas Neerlandesas",
        "AQ": "Antártida",
        "AS": "Samoa Americana",
        "AX": "Islas Åland",
        "AZ": "Azerbaiyán",
        "BA": "Bosnia-Herzegovina",
        "BE": "Bélgica",
        "BH": "Bahréin",
        "BJ": "Benín",
        "BL": "San Bartolomé",
        "BM": "Bermudas",
        "BN": "Brunéi",
        "BR": "Brasil",
        "BT": "Bután",
        "BV": "Isla Bouvet",
        "BW": "Botsuana",
        "BY": "Bielorrusia",
        "BZ": "Belice",
        "CA": "Canadá",
        "CC": "Islas Cocos",
        "CD": "República Democrática del Congo",
        "CF": "República Centroafricana",
        "CG": "Congo - Brazzaville",
        "CH": "Suiza",
        "CI": "Costa de Marfil",
        "CK": "Islas Cook",
        "CM": "Camerún",
        "CP": "Isla Clipperton",
        "CS": "Serbia y Montenegro",
        "CV": "Cabo Verde",
        "CX": "Isla Christmas",
        "CY": "Chipre",
        "CZ": "República Checa",
        "DE": "Alemania",
        "DG": "Diego García",
        "DJ": "Yibuti",
        "DK": "Dinamarca",
        "DO": "República Dominicana",
        "DZ": "Argelia",
        "EA": "Ceuta y Melilla",
        "EG": "Egipto",
        "EH": "Sáhara Occidental",
        "ES": "España",
        "ET": "Etiopía",
        "EU": "Unión Europea",
        "FI": "Finlandia",
        "FJ": "Fiyi",
        "FK": "Islas Malvinas",
        "FO": "Islas Feroe",
        "FR": "Francia",
        "FX": "Francia metropolitana",
        "GA": "Gabón",
        "GB": "Reino Unido",
        "GD": "Granada",
        "GF": "Guayana Francesa",
        "GL": "Groenlandia",
        "GP": "Guadalupe",
        "GQ": "Guinea Ecuatorial",
        "GR": "Grecia",
        "GS": "Islas Georgia del Sur y Sandwich del Sur",
        "HM": "Islas Heard y McDonald",
        "HR": "Croacia",
        "HT": "Haití",
        "HU": "Hungría",
        "IC": "Islas Canarias",
        "IE": "Irlanda",
        "IM": "Isla de Man",
        "IO": "Territorio Británico del Océano Índico",
        "IR": "Irán",
        "IS": "Islandia",
        "IT": "Italia",
        "JO": "Jordania",
        "JP": "Japón",
        "KE": "Kenia",
        "KG": "Kirguistán",
        "KH": "Camboya",
        "KM": "Comoras",
        "KN": "San Cristóbal y Nieves",
        "KP": "Corea del Norte",
        "KR": "Corea del Sur",
        "KY": "Islas Caimán",
        "KZ": "Kazajistán",
        "LB": "Líbano",
        "LC": "Santa Lucía",
        "LS": "Lesoto",
        "LT": "Lituania",
        "LU": "Luxemburgo",
        "LV": "Letonia",
        "LY": "Libia",
        "MA": "Marruecos",
        "MC": "Mónaco",
        "MD": "Moldavia",
        "MF": "San Martín",
        "MH": "Islas Marshall",
        "MK": "Macedonia",
        "MM": "Myanmar [Birmania]",
        "MO": "Macao",
        "MP": "Islas Marianas del Norte",
        "MQ": "Martinica",
        "MU": "Mauricio",
        "MV": "Maldivas",
        "MW": "Malaui",
        "MX": "México",
        "MY": "Malasia",
        "NC": "Nueva Caledonia",
        "NE": "Níger",
        "NF": "Isla Norfolk",
        "NL": "Países Bajos",
        "NO": "Noruega",
        "NU": "Isla Niue",
        "NZ": "Nueva Zelanda",
        "OM": "Omán",
        "PA": "Panamá",
        "PE": "Perú",
        "PF": "Polinesia Francesa",
        "PG": "Papúa Nueva Guinea",
        "PH": "Filipinas",
        "PK": "Pakistán",
        "PL": "Polonia",
        "PM": "San Pedro y Miquelón",
        "PN": "Pitcairn",
        "PS": "Territorios Palestinos",
        "QO": "Territorios alejados de Oceanía",
        "RE": "Reunión",
        "RO": "Rumanía",
        "RU": "Rusia",
        "RW": "Ruanda",
        "SA": "Arabia Saudí",
        "SB": "Islas Salomón",
        "SD": "Sudán",
        "SE": "Suecia",
        "SG": "Singapur",
        "SH": "Santa Elena",
        "SI": "Eslovenia",
        "SJ": "Svalbard y Jan Mayen",
        "SK": "Eslovaquia",
        "SL": "Sierra Leona",
        "SR": "Surinam",
        "ST": "Santo Tomé y Príncipe",
        "SY": "Siria",
        "SZ": "Suazilandia",
        "TA": "Tristán da Cunha",
        "TC": "Islas Turcas y Caicos",
        "TF": "Territorios Australes Franceses",
        "TH": "Tailandia",
        "TJ": "Tayikistán",
        "TL": "Timor Oriental",
        "TM": "Turkmenistán",
        "TN": "Túnez",
        "TR": "Turquía",
        "TT": "Trinidad y Tobago",
        "TW": "Taiwán",
        "UA": "Ucrania",
        "UM": "Islas menores alejadas de los Estados Unidos",
        "US": "Estados Unidos",
        "UZ": "Uzbekistán",
        "VA": "Ciudad del Vaticano",
        "VC": "San Vicente y las Granadinas",
        "VG": "Islas Vírgenes Británicas",
        "VI": "Islas Vírgenes de los Estados Unidos",
        "WF": "Wallis y Futuna",
        "ZA": "Sudáfrica",
        "ZW": "Zimbabue",
        "ZZ": "Región desconocida o no válida"
    };
  }-*/;
}
