/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordUtil;

public class RevertSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Reverts SAM or BAM files to a previous state by removing certain types of information and/or " + "substituting in the original quality scores when available.";
    @Option(shortName="I", doc="The input SAM/BAM file to revert the state of.")
    public File INPUT;
    @Option(shortName="O", doc="The output SAM/BAM file to create.")
    public File OUTPUT;
    @Option(shortName="SO", doc="The sort order to create the reverted output file with.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.queryname;
    @Option(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Option(doc="Remove duplicate read flags from all reads.  Note that if this is true and REMOVE_ALIGNMENT_INFORMATION==false,  the output may have the unusual but sometimes desirable trait of having unmapped reads that are marked as duplicates.")
    public boolean REMOVE_DUPLICATE_INFORMATION = true;
    @Option(doc="Remove all alignment information from the file.")
    public boolean REMOVE_ALIGNMENT_INFORMATION = true;
    @Option(doc="When removing alignment information, the set of optional tags to remove.")
    public List<String> ATTRIBUTE_TO_CLEAR = new ArrayList<String>(){
        {
            this.add("NM");
            this.add("UQ");
            this.add("PG");
            this.add("MD");
            this.add("MQ");
        }
    };
    @Option(doc="The sample alias to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias ", shortName="ALIAS", optional=true)
    public String SAMPLE_ALIAS;
    @Option(doc="The library name to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias ", shortName="LIB", optional=true)
    public String LIBRARY_NAME;
    private static final Log log = Log.getInstance(RevertSam.class);

    public static void main(String[] args) {
        System.exit(new RevertSam().instanceMain(args));
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader in = new SAMFileReader(this.INPUT, true);
        SAMFileHeader inHeader = in.getFileHeader();
        List rgs = inHeader.getReadGroups();
        if (this.SAMPLE_ALIAS != null || this.LIBRARY_NAME != null) {
            boolean allSampleAliasesIdentical = true;
            boolean allLibraryNamesIdentical = true;
            for (int i = 1; i < rgs.size(); ++i) {
                if (!((SAMReadGroupRecord)rgs.get(0)).getSample().equals(((SAMReadGroupRecord)rgs.get(i)).getSample())) {
                    allSampleAliasesIdentical = false;
                }
                if (((SAMReadGroupRecord)rgs.get(0)).getLibrary().equals(((SAMReadGroupRecord)rgs.get(i)).getLibrary())) continue;
                allLibraryNamesIdentical = false;
            }
            if (this.SAMPLE_ALIAS != null && !allSampleAliasesIdentical) {
                throw new PicardException("Read groups have multiple values for sample.  A value for SAMPLE_ALIAS cannot be supplied.");
            }
            if (this.LIBRARY_NAME != null && !allLibraryNamesIdentical) {
                throw new PicardException("Read groups have multiple values for library name.  A value for library name cannot be supplied.");
            }
        }
        boolean presorted = inHeader.getSortOrder() == this.SORT_ORDER;
        SAMFileHeader outHeader = new SAMFileHeader();
        for (SAMReadGroupRecord rg : inHeader.getReadGroups()) {
            if (this.SAMPLE_ALIAS != null) {
                rg.setSample(this.SAMPLE_ALIAS);
            }
            if (this.LIBRARY_NAME != null) {
                rg.setLibrary(this.LIBRARY_NAME);
            }
            outHeader.addReadGroup(rg);
        }
        outHeader.setSortOrder(this.SORT_ORDER);
        if (!this.REMOVE_ALIGNMENT_INFORMATION) {
            outHeader.setSequenceDictionary(inHeader.getSequenceDictionary());
            outHeader.setProgramRecords(inHeader.getProgramRecords());
        }
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outHeader, presorted, this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(log, 1000000, "Reverted");
        for (SAMRecord rec : in) {
            byte[] oq;
            if (rec.getNotPrimaryAlignmentFlag()) continue;
            if (this.RESTORE_ORIGINAL_QUALITIES && (oq = rec.getOriginalBaseQualities()) != null) {
                rec.setBaseQualities(oq);
                rec.setOriginalBaseQualities(null);
            }
            if (this.REMOVE_DUPLICATE_INFORMATION) {
                rec.setDuplicateReadFlag(false);
            }
            if (this.REMOVE_ALIGNMENT_INFORMATION) {
                if (rec.getReadNegativeStrandFlag()) {
                    SAMRecordUtil.reverseComplement((SAMRecord)rec);
                    rec.setReadNegativeStrandFlag(false);
                }
                rec.setReferenceIndex(-1);
                rec.setAlignmentStart(0);
                rec.setCigarString("*");
                rec.setMappingQuality(0);
                if (!rec.getReadUnmappedFlag()) {
                    rec.setInferredInsertSize(0);
                    rec.setNotPrimaryAlignmentFlag(false);
                    rec.setProperPairFlag(false);
                    rec.setReadUnmappedFlag(true);
                }
                if (rec.getReadPairedFlag()) {
                    rec.setMateAlignmentStart(0);
                    rec.setMateNegativeStrandFlag(false);
                    rec.setMateReferenceIndex(-1);
                    rec.setMateUnmappedFlag(true);
                }
                for (String tag : this.ATTRIBUTE_TO_CLEAR) {
                    rec.setAttribute(tag, null);
                }
            }
            out.addAlignment(rec);
            progress.record(rec);
        }
        out.close();
        return 0;
    }
}

