/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MethodImplementationFilter;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramFieldOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class NonPrivateMemberMarker
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor {
    private final MemberVisitor filteredMemberMarker = new OptimizationInfoMemberFilter(this);
    private final MemberVisitor implementedMethodMarker = new OptimizationInfoMemberFilter(new MethodImplementationFilter(this));

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.methodAccept("<clinit>", "()V", this.filteredMemberMarker);
        programClass.methodAccept("<init>", "()V", this.filteredMemberMarker);
        programClass.methodsAccept(this.implementedMethodMarker);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.referencedMemberAccept(this.filteredMemberMarker);
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        Clazz clazz2 = refConstant.referencedClass;
        if (clazz2 != null && !clazz2.equals(clazz) || !refConstant.getClassName(clazz).equals(clazz.getName())) {
            refConstant.referencedMemberAccept(this.filteredMemberMarker);
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        NonPrivateMemberMarker.markCanNotBeMadePrivate(programField);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        NonPrivateMemberMarker.markCanNotBeMadePrivate(programMethod);
    }

    private static void markCanNotBeMadePrivate(Field field) {
        ProgramFieldOptimizationInfo.getProgramFieldOptimizationInfo(field).setCanNotBeMadePrivate();
    }

    public static boolean canBeMadePrivate(Field field) {
        return FieldOptimizationInfo.getFieldOptimizationInfo(field).canBeMadePrivate();
    }

    private static void markCanNotBeMadePrivate(Method method) {
        ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method).setCanNotBeMadePrivate();
    }

    public static boolean canBeMadePrivate(Method method) {
        return MethodOptimizationInfo.getMethodOptimizationInfo(method).canBeMadePrivate();
    }
}

