/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.zip.InflaterFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class BlockGunzipper {
    private static InflaterFactory defaultInflaterFactory = new InflaterFactory();
    private final Inflater inflater;
    private final CRC32 crc32 = new CRC32();
    private boolean checkCrcs = false;

    BlockGunzipper() {
        this.inflater = defaultInflaterFactory.makeInflater(true);
    }

    BlockGunzipper(InflaterFactory inflaterFactory) {
        this.inflater = inflaterFactory.makeInflater(true);
    }

    public static void setDefaultInflaterFactory(InflaterFactory inflaterFactory) {
        if (inflaterFactory == null) {
            throw new IllegalArgumentException("null inflaterFactory");
        }
        defaultInflaterFactory = inflaterFactory;
    }

    public static InflaterFactory getDefaultInflaterFactory() {
        return defaultInflaterFactory;
    }

    public void setCheckCrcs(boolean check) {
        this.checkCrcs = check;
    }

    public int unzipBlock(byte[] uncompressedBlock, byte[] compressedBlock, int compressedLength) {
        return this.unzipBlock(uncompressedBlock, 0, compressedBlock, 0, compressedLength);
    }

    public int unzipBlock(byte[] uncompressedBlock, int uncompressedBlockOffset, byte[] compressedBlock, int compressedBlockOffset, int compressedLength) {
        int uncompressedSize;
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(compressedBlock, compressedBlockOffset, compressedLength);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (byteBuffer.get() != 31 || byteBuffer.get() != -117 || byteBuffer.get() != 8 || byteBuffer.get() != 4) {
                throw new SAMFormatException("Invalid GZIP header");
            }
            byteBuffer.position(byteBuffer.position() + 6);
            if (byteBuffer.getShort() != 6) {
                throw new SAMFormatException("Invalid GZIP header");
            }
            byteBuffer.position(byteBuffer.position() + 4);
            int totalBlockSize = (byteBuffer.getShort() & 0xFFFF) + 1;
            if (totalBlockSize != compressedLength) {
                throw new SAMFormatException("GZIP blocksize disagreement");
            }
            int deflatedSize = compressedLength - 18 - 8;
            byteBuffer.position(byteBuffer.position() + deflatedSize);
            int expectedCrc = byteBuffer.getInt();
            uncompressedSize = byteBuffer.getInt();
            this.inflater.reset();
            this.inflater.setInput(compressedBlock, compressedBlockOffset + 18, deflatedSize);
            int inflatedBytes = this.inflater.inflate(uncompressedBlock, uncompressedBlockOffset, uncompressedSize);
            if (inflatedBytes != uncompressedSize) {
                throw new SAMFormatException("Did not inflate expected amount");
            }
            if (this.checkCrcs) {
                this.crc32.reset();
                this.crc32.update(uncompressedBlock, uncompressedBlockOffset, uncompressedSize);
                long crc = this.crc32.getValue();
                if ((int)crc != expectedCrc) {
                    throw new SAMFormatException("CRC mismatch");
                }
            }
        }
        catch (DataFormatException e) {
            throw new RuntimeIOException(e);
        }
        return uncompressedSize;
    }
}

