/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ReaderRequirementsBox
extends JP2Box {
    public ReaderRequirementsBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            System.out.println("READBOX parentBox != null");
            System.out.flush();
            return false;
        }
        this.initBytesRead();
        int n = (int)this._boxHeader.getDataLength();
        int n2 = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        switch (n2) {
            case 1: {
                long l = ModuleBase.readUnsignedByte(this._dstrm, this._module);
                long l2 = ModuleBase.readUnsignedByte(this._dstrm, this._module);
                break;
            }
            case 2: {
                long l = this._module.readUnsignedShort(this._dstrm);
                long l2 = this._module.readUnsignedShort(this._dstrm);
                break;
            }
            case 4: {
                long l = this._module.readUnsignedInt(this._dstrm);
                long l2 = this._module.readUnsignedInt(this._dstrm);
                break;
            }
            case 8: {
                long l = this._module.readSignedLong(this._dstrm);
                long l2 = this._module.readSignedLong(this._dstrm);
                break;
            }
            default: {
                this._repInfo.setMessage(new ErrorMessage("Invalid data in Reader Requirements box", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                System.out.println("READBOX default");
                System.out.flush();
                return false;
            }
        }
        int n3 = this._module.readUnsignedShort(this._dstrm);
        for (int i = 0; i < n3; ++i) {
            int n4 = this._module.readUnsignedShort(this._dstrm);
        }
        this._module.skipBytes(this._dstrm, (int)((long)n - (this._module.getFilePos() - this.startBytesRead)), this._module);
        this.finalizeBytesRead();
        this._module.setRReqSeen(true);
        System.out.println("READBOX seen=true");
        System.out.flush();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Reader Requirements Box";
    }
}

