/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlDocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.JHOpenTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HtmlTagDesc {
    private String _name;
    private boolean _openTagRequired;
    private boolean _closeTagRequired;
    private List _implicitContainers;
    private List[] _contentArray;
    private String[] _excludedContent;
    protected int[] _sequence;
    public static final int SEQ0_1 = 0;
    public static final int SEQ1 = 1;
    public static final int SEQ1_MANY = 2;
    public static final int SEQ0_MANY = 3;
    private List _attributes;

    public HtmlTagDesc(String string, boolean bl, boolean bl2, List list, List list2) {
        this._name = string.toLowerCase();
        this._openTagRequired = bl;
        this._closeTagRequired = bl2;
        this._implicitContainers = new LinkedList();
        if (list == null) {
            this._contentArray = null;
        } else {
            this._contentArray = new List[1];
            this._contentArray[0] = list;
            this._sequence = new int[1];
            this._sequence[0] = 3;
        }
        this._attributes = list2 == null ? new ArrayList(1) : list2;
    }

    public HtmlTagDesc(String string, boolean bl, boolean bl2, int[] nArray, List[] listArray, List list) {
        this._name = string.toLowerCase();
        this._openTagRequired = bl;
        this._closeTagRequired = bl2;
        this._implicitContainers = new LinkedList();
        this._sequence = nArray;
        this._contentArray = listArray;
        this._attributes = list == null ? new ArrayList(1) : list;
    }

    public void setExcludedContent(String[] stringArray) {
        this._excludedContent = stringArray;
    }

    public boolean excludesTag(String string) {
        if (this._excludedContent == null) {
            return false;
        }
        for (int i = 0; i < this._excludedContent.length; ++i) {
            if (!this._excludedContent[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setAttributes(String[] stringArray) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            HtmlAttributeDesc htmlAttributeDesc = new HtmlAttributeDesc(stringArray[i]);
            arrayList.add(htmlAttributeDesc);
        }
        this._attributes = arrayList;
    }

    public void addImplicitContainer(HtmlTagDesc htmlTagDesc) {
        this._implicitContainers.add(htmlTagDesc);
    }

    public boolean matches(String string) {
        return string.equals(this._name);
    }

    public boolean isTemp() {
        return false;
    }

    protected boolean allowsTag(String string, int n, HtmlDocDesc htmlDocDesc) {
        Object object;
        if (this._contentArray == null) {
            return false;
        }
        if (n >= this._contentArray.length) {
            return false;
        }
        Iterator iterator = this._contentArray[n].iterator();
        while (iterator.hasNext()) {
            try {
                object = (String)iterator.next();
            }
            catch (Exception exception) {
                continue;
            }
            if (!((String)object).equals(string)) continue;
            return true;
        }
        object = (HtmlTagDesc)htmlDocDesc.supportedElements.get(string);
        if (object != null && ((HtmlTagDesc)object)._implicitContainers != null) {
            for (HtmlTagDesc htmlTagDesc : ((HtmlTagDesc)object)._implicitContainers) {
                if (!this.allowsTag(htmlTagDesc._name, n, htmlDocDesc)) continue;
                JHOpenTag jHOpenTag = new JHOpenTag(htmlTagDesc._name);
                jHOpenTag.setElement(htmlTagDesc);
                htmlDocDesc.pushElementStack(jHOpenTag);
                return true;
            }
        }
        return false;
    }

    protected List implicitContainers(String string) {
        return this._implicitContainers;
    }

    protected boolean canGetMoreAt(int n, int n2) {
        switch (this._sequence[n]) {
            case 0: 
            case 1: {
                return n2 == 0;
            }
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected boolean canAdvanceFrom(int n, int n2) {
        if (n == this._sequence.length - 1) {
            return false;
        }
        switch (this._sequence[n]) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: {
                return n2 == 1;
            }
            case 2: {
                return n2 >= 1;
            }
        }
        return false;
    }

    protected boolean allowsTag(String string, HtmlDocDesc htmlDocDesc) {
        return this.allowsTag(string, 0, htmlDocDesc);
    }

    protected boolean allowsPCData() {
        if (this._contentArray == null) {
            return false;
        }
        for (Object e : this._contentArray[0]) {
            if (e != HtmlSpecialToken.PCDATA) continue;
            return true;
        }
        return false;
    }

    protected HtmlAttributeDesc namedAttDesc(String string) {
        for (HtmlAttributeDesc htmlAttributeDesc : this._attributes) {
            if (!htmlAttributeDesc.nameMatches(string)) continue;
            return htmlAttributeDesc;
        }
        return null;
    }

    protected List missingRequiredAttributes(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(this._attributes.size());
        ArrayList arrayList2 = new ArrayList(this._attributes.size());
        for (HtmlAttributeDesc htmlAttributeDesc : this._attributes) {
            if (!htmlAttributeDesc.isRequired()) continue;
            boolean bl = false;
            for (String string : list) {
                if (!htmlAttributeDesc.nameMatches(string.toLowerCase())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(htmlAttributeDesc.getName());
        }
        return arrayList;
    }

    protected boolean isCloseTagRequired() {
        return this._closeTagRequired;
    }

    protected boolean isContentEmpty() {
        return this._contentArray == null;
    }
}

