/* marsio.h: martian device driver private declarations
 * IO & ISR
 */

#ifndef __MARSIO_H
#define __MARSIO_H

u8   mars_read_register(struct martian *mdev, u8 reg);
void mars_write_register(struct martian *mdev, u8 reg, u8 val);
int process_stream (struct martian *mdev);
void process_ring(struct martian *mdev); 

u8   mars_read_register_safe(struct martian *mdev, u8 reg);
void mars_write_register_safe(struct martian *mdev, u8 reg, u8 val);
void mars_reg_andor (struct martian *mdev, u8 reg, u8 val_and, u8 val_or); 
void mars_write_word(struct martian *mdev, u16 addr, u16 val);
void mars_write_byte(struct martian *mdev, u16 addr, u8 val);
void mars_write_dword(struct martian *mdev, u16 addr, u32 val);

void mars_write_dsp_ram (struct martian *mdev, u16 addr, u16 val);
u16 mars_read_dsp_ram (struct martian *mdev, u16 addr);
void mars_clear_dsp_ram (struct martian *mdev);
int mars_download_dsp_user (struct martian *mdev, u16 __user *data, u16 num); 

void mars_command (struct martian *mdev, 
			u8 cmd, u8 arg1, u8 arg2); 
int mars_command_long (struct martian *mdev, 
			u8 cmd, u8 arg1, u8 arg2, u8 arg3, u8 arg4); 


u16 mars_dsp_rom_checksum (struct martian *mdev);

#endif  // __MARSIO_H
