/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.internal.rdt.sync.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class SyncMergeEditor {
    public static void open(IFile file) {
        if (file == null) {
            return;
        }
        CompareUI.openCompareEditor((CompareEditorInput)new FileCompareInput(file));
    }

    private static class FileCompareInput
    extends SaveableCompareEditorInput {
        private final IFile file;

        public FileCompareInput(IFile f) {
            super(FileCompareInput.createCompareConfiguration(), FileCompareInput.getPage());
            this.file = f;
        }

        private static CompareConfiguration createCompareConfiguration() {
            CompareConfiguration conf = new CompareConfiguration();
            conf.setLeftEditable(true);
            conf.setRightEditable(false);
            return conf;
        }

        private static IWorkbenchPage getPage() {
            try {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            }
            catch (NullPointerException nullPointerException) {
                throw new RuntimeException(Messages.SyncMergeEditor_0);
            }
        }

        protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            IProject project = this.file.getProject();
            String currentSyncServiceId = SyncConfigManager.getActive((IProject)project).getSyncProviderId();
            ISynchronizeService syncService = SyncManager.getSyncService((String)currentSyncServiceId);
            SyncConfigManager.getActive((IProject)project);
            String[] mergeParts = null;
            try {
                mergeParts = syncService.getMergeConflictParts(project, this.file);
            }
            catch (CoreException e) {
                RDTSyncUIPlugin.log(e);
                return new DiffNode(null, 12, (ITypedElement)new SyncMergeItem(Messages.SyncMergeEditor_1), (ITypedElement)new SyncMergeItem(Messages.SyncMergeEditor_1), (ITypedElement)new SyncMergeItem(Messages.SyncMergeEditor_1));
            }
            if (mergeParts == null) {
                return new DiffNode(null, 12, (ITypedElement)new SyncMergeItem(Messages.SyncMergeEditor_2), (ITypedElement)new SyncMergeItem(Messages.SyncMergeEditor_2), (ITypedElement)new SyncMergeItem(Messages.SyncMergeEditor_2));
            }
            ITypedElement fileElement = SaveableCompareEditorInput.createFileElement((IFile)this.file);
            return new DiffNode(null, 12, (ITypedElement)new SyncMergeItem(mergeParts[2]), fileElement, (ITypedElement)new SyncMergeItem(mergeParts[1]));
        }

        protected void fireInputChange() {
        }

        public int hashCode() {
            IPath path = this.file.getLocation();
            if (path == null) {
                return 0;
            }
            return path.toOSString().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FileCompareInput)) {
                return false;
            }
            FileCompareInput other = (FileCompareInput)((Object)obj);
            IPath path = this.file.getLocation();
            IPath otherPath = other.file.getLocation();
            if (path == null || otherPath == null) {
                return false;
            }
            return path.toOSString().equals(otherPath.toOSString());
        }
    }

    private static class SyncMergeItem
    implements IStreamContentAccessor,
    ITypedElement,
    IModificationDate {
        private final String content;

        SyncMergeItem(String c) {
            this.content = c;
        }

        public long getModificationDate() {
            return 0L;
        }

        public String getName() {
            return "Compare Editor";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.content.getBytes());
        }
    }
}

