/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.cuda.ide.build.project.AbstractCudaModule;
import com.nvidia.cuda.ide.build.project.CudaProjectConfigurationImpl;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.util.CudaProjectUtil;
import java.util.Collection;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public final class CudaExecutable
extends AbstractCudaModule {
    private static final String ELEMENT_EXECUTABLE = "executable";
    private final ICStorageElement cudaStorage;

    public CudaExecutable(CudaProjectConfigurationImpl projectConfiguration, ICStorageElement cudaStorage) {
        super(projectConfiguration);
        this.cudaStorage = cudaStorage;
    }

    @Override
    protected ICStorageElement getElement(boolean create) {
        ICStorageElement[] elements = this.cudaStorage.getChildrenByName(ELEMENT_EXECUTABLE);
        if (elements == null || elements.length == 0) {
            if (create) {
                return this.cudaStorage.createChild(ELEMENT_EXECUTABLE);
            }
            return null;
        }
        return elements[0];
    }

    public void clearExcludes() throws CoreException {
        IFile[] files;
        IFile[] iFileArray = files = this.getExcludedFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            this.include(file);
            ++n2;
        }
        this.firePropertyChanged("files");
    }

    @Override
    public void exclude(IFile file) throws CoreException {
        boolean hasModules = this.projectConfiguration.getModules(file).length > 0;
        ICResourceDescription description = CudaProjectUtil.getFileDescription((IResource)file, this.projectConfiguration.getConfigurationDescription());
        if (hasModules) {
            CudaProjectUtil.setCompilerOptionValue(description, "nvcc.compiler.isintarget", false);
        } else {
            CudaProjectUtil.setCompilerOptionValue(description, "nvcc.compiler.isintarget", true);
            description.setExcluded(true);
        }
        this.projectConfiguration.getExcludedFiles().add(file);
        this.firePropertyChanged("files");
    }

    public IFile[] getExcludedFiles() {
        Collection<IFile> excludedFiles = this.projectConfiguration.getExcludedFiles();
        return excludedFiles.toArray(new IFile[excludedFiles.size()]);
    }

    @Override
    public ICudaModule.Type getType() {
        return ICudaModule.Type.executable;
    }

    @Override
    public void include(IFile file) throws CoreException {
        ICResourceDescription description = CudaProjectUtil.getFileDescription((IResource)file, this.projectConfiguration.getConfigurationDescription());
        description.setExcluded(false);
        CudaProjectUtil.setCompilerOptionValue(description, "nvcc.compiler.isintarget", true);
        this.projectConfiguration.getExcludedFiles().remove(file);
        this.firePropertyChanged("files");
    }

    @Override
    public boolean includes(IFile file) {
        return !this.projectConfiguration.getExcludedFiles().contains(file);
    }

    public int hashCode() {
        return this.projectConfiguration.getConfigurationDescription().hashCode() * 31;
    }

    public boolean equals(Object obj) {
        return obj instanceof CudaExecutable && ((CudaExecutable)obj).projectConfiguration.getConfigurationDescription().equals(this.projectConfiguration.getConfigurationDescription());
    }
}

