/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.editor;

import com.nvidia.cuda.ide.language.ast.KernelCallExpression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterOptions;
import org.eclipse.cdt.internal.formatter.CodeFormatterVisitor;

public class CudaCCodeFormatterVisitor
extends CodeFormatterVisitor {
    private final DefaultCodeFormatterOptions preferences;

    public CudaCCodeFormatterVisitor(DefaultCodeFormatterOptions preferences, int offset, int length) {
        super(preferences, offset, length);
        this.preferences = preferences;
    }

    protected int visit(IASTFunctionCallExpression node) {
        if (node instanceof KernelCallExpression) {
            return this.formatKernelCall((KernelCallExpression)node);
        }
        return super.visit(node);
    }

    private int formatKernelCall(KernelCallExpression node) {
        Runnable tailFormatter = this.scribe.takeTailFormatter();
        try {
            node.getFunctionNameExpression().accept((ASTVisitor)this);
        }
        finally {
            this.scribe.setTailFormatter(tailFormatter);
        }
        IASTInitializerClause[] parameters = node.getLaunchParameters();
        if (this.peekNextToken() == 1) {
            this.skipNode((IASTNode)node);
        } else {
            this.formatKernelLaunchParams(parameters);
        }
        IASTInitializerClause[] paramExpr = node.getArguments();
        if (this.peekNextToken() == 1) {
            this.skipNode((IASTNode)node);
        } else {
            this.formatFunctionCallArguments(paramExpr);
        }
        return 1;
    }

    private void formatKernelLaunchParams(IASTInitializerClause[] params) {
        if (this.peekNextToken() != 40 && (params == null || params.length == 0 || this.enclosedInMacroExpansion((IASTNode)params[0]))) {
            return;
        }
        List<Object> expressions = params != null ? Arrays.asList(params) : Collections.emptyList();
        CodeFormatterVisitor.ListOptions options = new CodeFormatterVisitor.ListOptions(this.preferences.alignment_for_arguments_in_method_invocation);
        options.fSeparatorToken = 6;
        options.fSpaceBeforeOpeningParen = this.preferences.insert_space_before_opening_paren_in_method_invocation;
        options.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_invocation;
        options.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_invocation;
        options.fSpaceBetweenEmptyParen = this.preferences.insert_space_between_empty_parens_in_method_invocation;
        options.fSpaceBeforeSeparator = this.preferences.insert_space_before_comma_in_method_invocation_arguments;
        options.fSpaceAfterSeparator = this.preferences.insert_space_after_comma_in_method_invocation_arguments;
        options.fTieBreakRule = 1;
        this.scribe.printNextToken(40, options.fSpaceBeforeOpeningParen);
        this.scribe.printNextToken(42);
        if (options.fSpaceAfterOpeningParen) {
            this.scribe.space();
        }
        this.formatList(expressions, options, false, false, null);
        this.scribe.printNextToken(44, options.fSpaceBeforeClosingParen);
        this.scribe.printNextToken(46);
    }
}

