/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.index;

import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.util.CudaProjectUtil;
import com.nvidia.cuda.ide.index.CudaSDKPDOMDescriptor;
import com.nvidia.cuda.ide.util.BasicUtil;
import java.util.HashMap;
import org.eclipse.cdt.core.index.provider.IPDOMDescriptor;
import org.eclipse.cdt.core.index.provider.IReadOnlyPDOMProvider;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public final class CudaSDKPDOMProvider
implements IReadOnlyPDOMProvider {
    private HashMap<Architecture, IPDOMDescriptor[]> providersMap = new HashMap();

    public boolean providesFor(ICProject project) throws CoreException {
        IManagedBuildInfo info;
        IConfiguration configuration = ManagedBuildManager.getSelectedConfiguration((IProject)project.getProject());
        if (configuration == null && (info = ManagedBuildManager.getBuildInfo((IResource)project.getProject())) != null) {
            configuration = info.getDefaultConfiguration();
        }
        if (configuration != null) {
            return this.isCudaToolchain(configuration.getToolChain());
        }
        return false;
    }

    private boolean isCudaToolchain(IToolChain toolChain) {
        if (toolChain == null) {
            return false;
        }
        if (toolChain.getId().equals("com.nvidia.cuda.ide.toolchain.base")) {
            return true;
        }
        return this.isCudaToolchain(toolChain.getSuperClass());
    }

    private static IPath getIndexLocationPropertyPath() {
        String location = System.getProperty("cuda.indexlocation");
        Path locationPath = location != null ? new Path(location) : null;
        return BasicUtil.isDirectory((IPath)locationPath) ? locationPath : null;
    }

    private static IPath getCudaIndexPath() {
        IPath locationPath = CudaSDKPDOMProvider.getIndexLocationPropertyPath();
        if (locationPath != null) {
            return locationPath;
        }
        locationPath = new Path(Platform.getInstallLocation().getURL().getPath());
        return BasicUtil.isDirectory(locationPath) ? locationPath : null;
    }

    private IPDOMDescriptor[] getDescriptors(Architecture architecture) {
        IPath indexFilePath;
        String pdomName = String.format("%s.pdom", architecture.indexFile);
        IPath locationPath = CudaSDKPDOMProvider.getCudaIndexPath();
        IPath iPath = indexFilePath = locationPath != null ? locationPath.append("index").append(pdomName) : null;
        if (BasicUtil.isFile(indexFilePath)) {
            return new IPDOMDescriptor[]{new CudaSDKPDOMDescriptor(indexFilePath)};
        }
        return new IPDOMDescriptor[0];
    }

    public IPDOMDescriptor[] getDescriptors(ICConfigurationDescription config) {
        Architecture architecture = CudaProjectUtil.getEditorArch((ICResourceDescription)config.getRootFolderDescription());
        if (!this.providersMap.containsKey(architecture)) {
            this.providersMap.put(architecture, this.getDescriptors(architecture));
        }
        return this.providersMap.get(architecture);
    }
}

