/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.project.CudaExecutable;
import com.nvidia.cuda.ide.build.project.CudaProjectConfigurationImpl;
import com.nvidia.cuda.ide.build.ui.NewCudaCProjectWizardOperator;
import com.nvidia.cuda.ide.wizard.CudaMainWizardPage;
import com.nvidia.cuda.ide.wizard.CudaProjectSetupWizardPage;
import com.nvidia.cuda.ide.wizard.ICudaGetLocalArchitecture;
import com.nvidia.cuda.ide.wizard.ICudaProjectWizardExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.wizards.CDTCommonProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;

public class NewCudaCProjectWizard
extends CDTCommonProjectWizard {
    private IWizardPage configsPage;
    private IWizardPage targetsPage;
    private CudaProjectSetupWizardPage toolkitWizardPage;

    public NewCudaCProjectWizard() {
        super("CUDA C/C++ Project", "Create CUDA C/C++ project of selected type");
    }

    private static IToolChain[] getSupportedCUDAToolchains() {
        IToolChain[] toolchains;
        ArrayList<IToolChain> rc = new ArrayList<IToolChain>();
        IToolChain[] iToolChainArray = toolchains = ManagedBuildManager.getExtensionsToolChains((String)"org.eclipse.cdt.build.core.buildArtefactType", (String)"org.eclipse.cdt.build.core.buildArtefactType.exe");
        int n = toolchains.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IToolChain tc = iToolChainArray[n2];
            if (!tc.isAbstract() && tc.isSupported() && (id = tc.getId()) != null && id.startsWith("com.nvidia.cuda.ide.toolchain")) {
                rc.add(tc);
            }
            ++n2;
        }
        return rc.toArray(new IToolChain[rc.size()]);
    }

    private static int getToolChainPriority(IToolChain tc) {
        String name;
        String string = name = tc != null ? tc.getUniqueRealName() : null;
        if (name == null) {
            return 0;
        }
        Matcher m = Pattern.compile("\\D+(\\d+)\\.(\\d+)").matcher(name);
        if (!m.matches()) {
            return 0;
        }
        return Integer.decode(m.group(1)) * 100 + Integer.decode(m.group(2));
    }

    private static IToolChain findBestToolchain(IToolChain[] toolchains) {
        IToolChain best = null;
        IToolChain[] iToolChainArray = toolchains;
        int n = toolchains.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain tc = iToolChainArray[n2];
            if (best == null || NewCudaCProjectWizard.getToolChainPriority(best) < NewCudaCProjectWizard.getToolChainPriority(tc)) {
                best = tc;
            }
            ++n2;
        }
        return best;
    }

    private static void validateDefaultToolchain() {
        List preferred = CDTPrefUtil.getPreferredTCs();
        if (preferred.size() > 1) {
            return;
        }
        Object[] toolchains = NewCudaCProjectWizard.getSupportedCUDAToolchains();
        if (CoreUtil.isNullOrEmpty((Object[])toolchains)) {
            return;
        }
        IToolChain best = NewCudaCProjectWizard.findBestToolchain((IToolChain[])toolchains);
        if (best == null || NewCudaCProjectWizard.getToolChainPriority(best) == 0) {
            return;
        }
        Activator.log(null, "Adding %s (id=%s) to the list of preferred toolchains", best.getUniqueRealName(), best.getId());
        CDTPrefUtil.addPreferredTC((String)best.getId());
    }

    public void addPages() {
        NewCudaCProjectWizard.validateDefaultToolchain();
        this.fMainPage = new CudaMainWizardPage(CUIPlugin.getResourceString((String)"CProjectWizard"));
        this.toolkitWizardPage = new CudaProjectSetupWizardPage(false);
        this.toolkitWizardPage.setDelegate((CudaMainWizardPage)this.fMainPage);
        ((CudaMainWizardPage)this.fMainPage).setToolkitWizardPage((IWizardPage)this.toolkitWizardPage);
        this.fMainPage.setTitle("New CUDA C/C++ Project");
        this.fMainPage.setDescription("Create a new project of selected type");
        try {
            this.targetsPage = (IWizardPage)CoreUtil.accessService(ICudaProjectWizardExtension.class, (IOSGIServiceAccess)new IOSGIServiceAccess<ICudaProjectWizardExtension, IWizardPage>(){

                public IWizardPage runWithService(ICudaProjectWizardExtension service) throws CoreException {
                    return service.getExtensionPage(NewCudaCProjectWizard.this.fMainPage);
                }
            });
            this.addPage((IWizardPage)this.fMainPage);
            this.addPage((IWizardPage)this.toolkitWizardPage);
            this.addPage(this.targetsPage);
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
    }

    protected IProject continueCreation(IProject prj) {
        if (this.continueCreationMonitor == null) {
            this.continueCreationMonitor = new NullProgressMonitor();
        }
        try {
            try {
                this.continueCreationMonitor.beginTask("Add Project Nature", 2);
                CProjectNature.addCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
                CCProjectNature.addCCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
                NewCudaCProjectWizardOperator.prepareToInitModule(this, prj);
            }
            catch (CoreException coreException) {
                this.continueCreationMonitor.done();
            }
        }
        finally {
            this.continueCreationMonitor.done();
        }
        return prj;
    }

    public String[] getContentTypeIDs() {
        return new String[]{"com.nvidia.cuda.ide.cudac"};
    }

    public String[] getNatures() {
        return new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature"};
    }

    public IWizardPage getWizardExtensionPage() {
        return this.targetsPage;
    }

    public void runInitModule(final IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.toolkitWizardPage.isSkipped()) {
            this.setExecutableProperties(project, this.toolkitWizardPage);
        }
        CoreUtil.accessService(ICudaProjectWizardExtension.class, (IOSGIServiceAccess)new IOSGIServiceAccess<ICudaProjectWizardExtension, Object>(){

            public Object runWithService(ICudaProjectWizardExtension service) throws CoreException {
                service.configureProject(project, NewCudaCProjectWizard.this.targetsPage);
                return null;
            }
        });
    }

    protected void selectAndReveal(IResource newResource) {
    }

    public void setConfigsPage(IWizardPage configsPage) {
        this.configsPage = configsPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.targetsPage) {
            return this.configsPage;
        }
        return super.getNextPage(page);
    }

    protected boolean setCreated() throws CoreException {
        NewCudaCProjectWizardOperator.finalizeModule();
        return super.setCreated();
    }

    protected void setExecutableProperties(IProject project, CudaProjectSetupWizardPage page) throws CoreException {
        ICConfigurationDescription[] configurations;
        page.getPageData();
        ICProjectDescription projectDescription = CCorePlugin.getDefault().getProjectDescription(project);
        projectDescription.setReadOnly(false, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configurations = projectDescription.getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configuration = iCConfigurationDescriptionArray[n2];
            CudaProjectConfigurationImpl cuda = new CudaProjectConfigurationImpl(configuration);
            cuda.reload();
            CudaExecutable module = cuda.getExecutable();
            module.setPhysicalArchitectures(page.getPhysicalArchitecturesForAllConfigurations());
            module.setVirtualArchitectures(page.getVirtualArchitecturesForAllConfigurations());
            module.setDeviceLinkerEnabled(page.isDeviceLinking());
            ++n2;
        }
        CCorePlugin.getDefault().setProjectDescription(project, projectDescription);
    }

    public String getLocalArchitecture() {
        if (this.targetsPage != null && this.targetsPage instanceof ICudaGetLocalArchitecture) {
            return ((ICudaGetLocalArchitecture)this.targetsPage).getLocalArchitecture();
        }
        return "native";
    }
}

