/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;

public class CompareCoreUtils {
    public static String getResourceEncoding(Repository db, String repoPath) {
        if (db.isBare()) {
            return null;
        }
        IFile resource = ResourceUtil.getFileForLocation(db, repoPath);
        if (resource == null) {
            return null;
        }
        return CompareCoreUtils.getResourceEncoding((IResource)resource);
    }

    public static String getResourceEncoding(IResource resource) {
        String charset;
        IEncodedStorage encodedStorage = (IEncodedStorage)resource;
        try {
            charset = encodedStorage.getCharset();
            if (charset == null) {
                charset = resource.getParent().getDefaultCharset();
            }
        }
        catch (CoreException coreException) {
            charset = "UTF-8";
        }
        return charset;
    }

    public static DiffEntry getChangeDiffEntry(Repository repository, String newPath, RevCommit newCommit, RevCommit oldCommit, ObjectReader objectReader) throws IOException {
        TreeWalk walk = new TreeWalk(objectReader);
        walk.setRecursive(true);
        walk.addTree((AnyObjectId)oldCommit.getTree());
        walk.addTree((AnyObjectId)newCommit.getTree());
        List entries = DiffEntry.scan((TreeWalk)walk);
        for (DiffEntry diff : entries) {
            if (diff.getChangeType() != DiffEntry.ChangeType.MODIFY || !newPath.equals(diff.getNewPath())) continue;
            return diff;
        }
        if (entries.size() < 2) {
            return null;
        }
        RenameDetector detector = new RenameDetector(repository);
        detector.addAll((Collection)entries);
        List renames = detector.compute(walk.getObjectReader(), (ProgressMonitor)NullProgressMonitor.INSTANCE);
        for (DiffEntry diff : renames) {
            if (diff.getChangeType() != DiffEntry.ChangeType.RENAME || !newPath.equals(diff.getNewPath())) continue;
            return diff;
        }
        return null;
    }
}

