/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;

public class CLIThreadInfo
extends MIInfo {
    private Integer fCurrentThread;

    public CLIThreadInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public Integer getCurrentThread() {
        return this.fCurrentThread;
    }

    protected void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord cons = (MIStreamRecord)oobs[i];
                    String str = cons.getString();
                    this.parseThreadInfo(str.trim());
                }
                ++i;
            }
        }
    }

    protected void parseThreadInfo(String str) {
        Pattern pattern;
        Matcher matcher;
        if (str.length() > 0 && (matcher = (pattern = Pattern.compile("Current thread is (\\d+)", 8)).matcher(str)).find()) {
            String id = matcher.group(1).trim();
            this.fCurrentThread = Integer.parseInt(id);
        }
    }
}

