/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public final class IdeUtil {
    private static int countFoldersToMake(IContainer parent) {
        if (parent == null) {
            return -1;
        }
        if (parent.exists()) {
            return 0;
        }
        int result = IdeUtil.countFoldersToMake(parent.getParent());
        return result < 0 ? result : result + 1;
    }

    private static void createParent(IContainer parent, SubMonitor subMonitor) throws CoreException {
        if (!parent.exists()) {
            IdeUtil.createParent(parent.getParent(), subMonitor);
            ((IFolder)parent).create(false, false, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public static void createParents(IResource file, IProgressMonitor monitor) throws CoreException {
        int count = IdeUtil.countFoldersToMake(file.getParent());
        if (count > 0) {
            SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor);
            convert.beginTask("Create parents", count);
            IdeUtil.createParent(file.getParent(), convert);
        } else if (count < 0) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.sdk", String.format("Invalid path: %s", file.getFullPath().toOSString())));
        }
    }

    public static IFile getWorkspaceFile(String path) {
        if (path != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path p = new Path(path);
            if (p.segmentCount() > 1) {
                IFile file = root.getFile((IPath)p);
                if (!file.exists()) {
                    return null;
                }
                return file;
            }
        }
        return null;
    }

    private IdeUtil() {
    }
}

