/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.LineBackgroundPainter;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.IBackgroundHighlight;
import org.eclipse.cdt.ui.text.ILineBackgroundPainter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class BackgroundHighlightingManager
implements ICReconcilingListener,
ITextInputListener,
ILineBackgroundPainter {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_LAYER = "layer";
    private static final String ELEMENT_BACKGROUND_HIGHLIGHTING = "backgroundHighlighting";
    private List<Position> fCodePositions = Collections.emptyList();
    private IDocument fDocument;
    private CEditor fEditor;
    private Object fJobLock = new Object();
    private LineBackgroundPainter fLineBackgroundPainter;
    private ITranslationUnit fTranslationUnit;
    private Job fUpdateJob;
    private Collection<IBackgroundHighlight> highlightings;

    @Override
    public void aboutToBeReconciled() {
    }

    private List<Position> collectPositions(IASTTranslationUnit ast) {
        LinkedList<Position> positions = new LinkedList<Position>();
        for (IBackgroundHighlight highlighting : this.highlightings) {
            positions.addAll(highlighting.collectPositions(ast));
        }
        return positions;
    }

    private Collection<IBackgroundHighlight> getHighlightings(ILanguage language) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(CUIPlugin.getPluginId(), "semanticHighlighting");
        TreeSet<IConfigurationElement> set = new TreeSet<IConfigurationElement>(new ContributionsComparator());
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String lang;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELEMENT_BACKGROUND_HIGHLIGHTING.equals(element.getName()) && ((lang = element.getAttribute(ATTR_LANGUAGE)) == null || language != null && this.sameLanguage(lang, language))) {
                set.add(element);
            }
            ++n2;
        }
        LinkedList<IBackgroundHighlight> collection = new LinkedList<IBackgroundHighlight>();
        for (IConfigurationElement element : set) {
            try {
                collection.add((IBackgroundHighlight)element.createExecutableExtension(ATTR_CLASS));
            }
            catch (Exception e) {
                CUIPlugin.log(String.format("Failed to instantiate highlighter %s from plugin %s", element.getAttribute(ATTR_CLASS), element.getContributor().getName()), e);
            }
        }
        return collection;
    }

    private boolean sameLanguage(String lang, ILanguage language) {
        return language.equals(LanguageManager.getInstance().getLanguage(lang));
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (this.fEditor != null && this.fLineBackgroundPainter != null && !this.fLineBackgroundPainter.isDisposed()) {
            this.fLineBackgroundPainter.removeHighlightPositions(this.fCodePositions);
            this.fCodePositions = Collections.emptyList();
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        this.fDocument = newInput;
    }

    public void install(CEditor editor, LineBackgroundPainter lineBackgroundPainter) {
        ILanguage language;
        assert (this.fEditor == null);
        assert (editor != null && lineBackgroundPainter != null);
        this.fEditor = editor;
        this.fLineBackgroundPainter = lineBackgroundPainter;
        IWorkingCopy cElement = this.fEditor.getInputCElement();
        this.fTranslationUnit = cElement instanceof ITranslationUnit ? (ITranslationUnit)cElement : null;
        this.fDocument = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        try {
            language = this.fTranslationUnit != null ? this.fTranslationUnit.getLanguage() : null;
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            language = null;
        }
        this.highlightings = this.getHighlightings(language);
        for (IBackgroundHighlight highlight : this.highlightings) {
            highlight.install(this.fDocument, this);
        }
        this.fEditor.getViewer().addTextInputListener((ITextInputListener)this);
        this.fEditor.addReconcileListener(this);
    }

    @Override
    public boolean isDisposed() {
        return this.fLineBackgroundPainter.isDisposed();
    }

    @Override
    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return;
        }
        final List<Position> newInactiveCodePositions = this.collectPositions(ast);
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                if (BackgroundHighlightingManager.this.fEditor != null && BackgroundHighlightingManager.this.fLineBackgroundPainter != null && !BackgroundHighlightingManager.this.fLineBackgroundPainter.isDisposed()) {
                    BackgroundHighlightingManager.this.fLineBackgroundPainter.replaceHighlightPositions(BackgroundHighlightingManager.this.fCodePositions, newInactiveCodePositions);
                    BackgroundHighlightingManager.this.fCodePositions = newInactiveCodePositions;
                }
            }
        };
        if (this.fEditor != null && !Display.getDefault().getThread().equals(Thread.currentThread())) {
            Display.getDefault().asyncExec(updater);
        }
    }

    @Override
    public void refresh() {
        this.scheduleJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fUpdateJob == null) {
                this.fUpdateJob = new Job(CEditorMessages.InactiveCodeHighlighting_job){

                    protected IStatus run(final IProgressMonitor monitor) {
                        IStatus result = Status.OK_STATUS;
                        if (BackgroundHighlightingManager.this.fTranslationUnit != null) {
                            ASTProvider astProvider = CUIPlugin.getDefault().getASTProvider();
                            result = astProvider.runOnAST((ICElement)BackgroundHighlightingManager.this.fTranslationUnit, ASTProvider.WAIT_IF_OPEN, monitor, new ASTCache.ASTRunnable(){

                                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                                    BackgroundHighlightingManager.this.reconciled(ast, true, monitor);
                                    return Status.OK_STATUS;
                                }
                            });
                        }
                        if (monitor.isCanceled()) {
                            result = Status.CANCEL_STATUS;
                        }
                        return result;
                    }
                };
                this.fUpdateJob.setPriority(50);
            }
            if (this.fUpdateJob.getState() == 0) {
                this.fUpdateJob.schedule();
            }
        }
    }

    @Override
    public void setBackgroundColor(String key, RGB color) {
        this.fLineBackgroundPainter.setBackgroundColor(key, this.getColor(color));
    }

    private Color getColor(RGB color) {
        if (color != null) {
            return CDTUITools.getColorManager().getColor(color);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fUpdateJob != null && this.fUpdateJob.getState() == 4) {
                this.fUpdateJob.cancel();
            }
        }
        for (IBackgroundHighlight highlight : this.highlightings) {
            highlight.uninstall();
        }
        if (this.fLineBackgroundPainter != null && !this.fLineBackgroundPainter.isDisposed()) {
            this.fLineBackgroundPainter.removeHighlightPositions(this.fCodePositions);
            this.fCodePositions = Collections.emptyList();
            this.fLineBackgroundPainter = null;
        }
        if (this.fEditor != null) {
            this.fEditor.removeReconcileListener(this);
            if (this.fEditor.getViewer() != null) {
                this.fEditor.getViewer().removeTextInputListener((ITextInputListener)this);
            }
            this.fEditor = null;
            this.fTranslationUnit = null;
            this.fDocument = null;
        }
    }

    private static final class ContributionsComparator
    implements Comparator<IConfigurationElement> {
        private ContributionsComparator() {
        }

        @Override
        public int compare(IConfigurationElement o1, IConfigurationElement o2) {
            int layer2;
            int layer1 = this.getLayerValue(o1.getAttribute(BackgroundHighlightingManager.ATTR_LAYER), o1);
            if (layer1 == (layer2 = this.getLayerValue(o2.getAttribute(BackgroundHighlightingManager.ATTR_LAYER), o2))) {
                int c = this.comparePossiblyNullStrings(o1.getAttribute(BackgroundHighlightingManager.ATTR_LANGUAGE), o2.getAttribute(BackgroundHighlightingManager.ATTR_LANGUAGE));
                if (c == 0) {
                    c = this.comparePossiblyNullStrings(o1.getAttribute(BackgroundHighlightingManager.ATTR_CLASS), o2.getAttribute(BackgroundHighlightingManager.ATTR_CLASS));
                }
                return c;
            }
            return layer1 > layer2 ? 1 : -1;
        }

        protected int comparePossiblyNullStrings(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.trim().compareTo(s2.trim());
        }

        protected final int getLayerValue(String layerString, IConfigurationElement element) {
            if (layerString == null || layerString.trim().length() == 0) {
                return 1;
            }
            try {
                return Integer.valueOf(layerString.trim());
            }
            catch (NumberFormatException numberFormatException) {
                CUIPlugin.logError(String.format("Layer %s is not a valid value in %s background highlight from %s plugin", layerString, element.getAttribute(BackgroundHighlightingManager.ATTR_CLASS), element.getContributor().getName()));
                return 1;
            }
        }
    }
}

