/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionInformation;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.RefactoringsRegistry;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ExtractFunctionRefactoringDescriptor
extends CRefactoringDescriptor {
    protected static final String NAME = "name";
    protected static final String VISIBILITY = "visibility";
    protected static final String REPLACE_DUPLICATES = "replaceDuplicates";

    public ExtractFunctionRefactoringDescriptor(String project, String description, String comment, Map<String, String> arguments) {
        super("org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoring", project, description, comment, 4, arguments);
    }

    @Override
    public CRefactoring createRefactoring(RefactoringStatus status) throws CoreException {
        ISelection selection = this.getSelection();
        ICProject project = this.getCProject();
        IFile file = this.getFile();
        ILanguage language = LanguageManager.getInstance().getLanguageForFile(file, null);
        ExtractFunctionRefactoring refactoring = (ExtractFunctionRefactoring)RefactoringsRegistry.getLanguageDelegate(language, "extractFunction");
        if (refactoring == null) {
            return refactoring;
        }
        refactoring.init((ICElement)this.getTranslationUnit(), selection, project);
        ExtractFunctionInformation info = refactoring.getRefactoringInfo();
        info.setMethodName((String)this.arguments.get(NAME));
        info.setVisibility(VisibilityEnum.getEnumForStringRepresentation((String)this.arguments.get(VISIBILITY)));
        info.setReplaceDuplicates(Boolean.parseBoolean((String)this.arguments.get(REPLACE_DUPLICATES)));
        return refactoring;
    }
}

