/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.cuda.ide.debug.memory.CudaGdbMemoryBlockRetrievalManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.provisional.model.IMemoryBlockRetrievalManager;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.ShutdownSequence;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;

public final class CudaLaunch
extends GdbLaunch {
    protected IMemoryBlockRetrievalManager fMemRetrievalManager;
    private final AtomicBoolean isShutDown = new AtomicBoolean(false);
    private boolean preemption;

    public CudaLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
    }

    public void initializeControl() throws CoreException {
        try {
            final DsfSession fSession = this.getSession();
            fSession.getExecutor().submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    CudaLaunch.this.fMemRetrievalManager = new CudaGdbMemoryBlockRetrievalManager("org.eclipse.cdt.dsf.gdb", CudaLaunch.this.getLaunchConfiguration(), fSession);
                    fSession.registerModelAdapter(IMemoryBlockRetrievalManager.class, (Object)CudaLaunch.this.fMemRetrievalManager);
                    fSession.addServiceEventListener((Object)CudaLaunch.this.fMemRetrievalManager, null);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", 0, "Failed to start debugger due to a runtime exception.", (Throwable)e));
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public boolean isPreemptionOn() {
        return this.preemption;
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void shutdownSession(final RequestMonitor rm) {
        if (!this.isShutDown.compareAndSet(false, true)) {
            rm.done();
            return;
        }
        final DsfSession session = this.getSession();
        ShutdownSequence shutdownSeq = new ShutdownSequence(this.getDsfExecutor(), session.getId(), new RequestMonitor((Executor)session.getExecutor(), rm){

            public void handleCompleted() {
                if (CudaLaunch.this.fMemRetrievalManager != null) {
                    session.removeServiceEventListener((Object)CudaLaunch.this.fMemRetrievalManager);
                    CudaLaunch.this.fMemRetrievalManager.dispose();
                }
                CudaLaunch.super.shutdownSession(rm);
            }
        });
        session.getExecutor().execute((Runnable)shutdownSeq);
    }

    public void setPreemptionEnabled(boolean preemption) {
        this.preemption = preemption;
    }
}

