/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.query;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.ElementQuery;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import java.util.Arrays;
import java.util.TreeSet;

public final class AndQuery
implements IElementQuery {
    private static final CudaCoord[] EMPTY_COORD_ARRAY = new CudaCoord[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final IElementQuery q1;
    private final IElementQuery q2;

    public AndQuery(IElementQuery q1, IElementQuery q2) {
        this.q1 = q1;
        this.q2 = q2;
    }

    @Override
    public CudaCoord[] filterBlocks(Kernel kernel) {
        CudaCoord coord;
        CudaCoord[] intersect = this.intersect(this.q1.filterBlocks(kernel), this.q2.filterBlocks(kernel));
        if (intersect == null) {
            coord = CudaCoord.ZERO;
        } else if (intersect.length > 0) {
            coord = intersect[0];
        } else {
            return intersect;
        }
        try {
            CudaCoord[] threads = this.filterThreads(kernel.getBlock(coord));
            if (threads == null || threads.length > 0) {
                return intersect;
            }
            return EMPTY_COORD_ARRAY;
        }
        catch (CudaException e) {
            Activator.log(e);
            return EMPTY_COORD_ARRAY;
        }
    }

    @Override
    public byte[] filterLanes(Warp warp) {
        return this.intersect(this.q1.filterLanes(warp), this.q2.filterLanes(warp));
    }

    @Override
    public byte[] filterSMs(Device device) {
        byte id;
        byte[] intersect = this.intersect(this.q1.filterSMs(device), this.q2.filterSMs(device));
        if (intersect == null) {
            id = 0;
        } else {
            if (intersect.length == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            id = intersect[0];
        }
        try {
            byte[] warps = this.filterWarps(device.getSm(id));
            if (warps == null || warps.length > 0) {
                return intersect;
            }
            return EMPTY_BYTE_ARRAY;
        }
        catch (CudaException e) {
            Activator.log(e);
            return EMPTY_BYTE_ARRAY;
        }
    }

    @Override
    public CudaCoord[] filterThreads(Block block) {
        return this.intersect(this.q1.filterThreads(block), this.q2.filterThreads(block));
    }

    @Override
    public byte[] filterWarps(StreamingMultiprocessor sm) {
        byte id;
        byte[] intersect = this.intersect(this.q1.filterWarps(sm), this.q2.filterWarps(sm));
        if (intersect == null) {
            id = 0;
        } else {
            if (intersect.length == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            id = intersect[0];
        }
        try {
            byte[] lanes = this.filterLanes(sm.getWarp(id));
            if (lanes == null || lanes.length > 0) {
                return intersect;
            }
            return EMPTY_BYTE_ARRAY;
        }
        catch (CudaException e) {
            Activator.log(e);
            return EMPTY_BYTE_ARRAY;
        }
    }

    @Override
    public IElementQuery getHardwareQuery() {
        return ElementQuery.and(this.q1.getHardwareQuery(), this.q2.getHardwareQuery());
    }

    @Override
    public IElementQuery getLogicalQuery() {
        return ElementQuery.and(this.q1.getLogicalQuery(), this.q2.getLogicalQuery());
    }

    @Override
    public boolean hasHardwareFilters() {
        return this.q1.hasHardwareFilters() || this.q2.hasHardwareFilters();
    }

    @Override
    public boolean hasLogicalFilters() {
        return this.q1.hasLogicalFilters() || this.q2.hasLogicalFilters();
    }

    @Override
    public boolean hasNoFilters() {
        return this.q1.hasNoFilters() && this.q2.hasNoFilters();
    }

    private byte[] intersect(byte[] ar1, byte[] ar2) {
        if (ar1 == null) {
            return ar2;
        }
        if (ar2 == null) {
            return ar1;
        }
        if (ar1.length == 0 || ar2.length == 0) {
            return new byte[0];
        }
        int i = 0;
        int j = 0;
        int k = 0;
        byte[] res = new byte[Math.min(ar1.length, ar2.length)];
        while (i < ar1.length && j < ar2.length) {
            if (ar1[i] == ar2[j]) {
                res[k++] = ar1[i];
                ++i;
                ++j;
                continue;
            }
            if (ar1[i] < ar2[j]) {
                ++i;
                continue;
            }
            ++j;
        }
        if (k == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (k < res.length) {
            byte[] res2 = new byte[k + 1];
            System.arraycopy(res, 0, res2, 0, k + 1);
            return res2;
        }
        return res;
    }

    private CudaCoord[] intersect(CudaCoord[] blocks1, CudaCoord[] blocks2) {
        if (blocks1 == null) {
            return blocks2;
        }
        if (blocks1.length == 0) {
            return blocks1;
        }
        if (blocks2 == null) {
            return blocks1;
        }
        if (blocks2.length == 0) {
            return blocks2;
        }
        TreeSet<CudaCoord> set = new TreeSet<CudaCoord>(Arrays.asList(blocks1));
        set.retainAll(Arrays.asList(blocks2));
        return set.toArray(new CudaCoord[set.size()]);
    }

    @Override
    public boolean match(ICudaRuntimeObject object) {
        switch (object.getType()) {
            case kernel: {
                return this.basicMatch(object) && this.nonEmptyArray(this.filterBlocks((Kernel)object));
            }
            case block: {
                return this.basicMatch(object) && this.nonEmptyArray(this.filterThreads((Block)object));
            }
            case device: {
                return this.basicMatch(object) && this.nonEmptyArray(this.filterSMs((Device)object));
            }
            case sm: {
                return this.basicMatch(object) && this.nonEmptyArray(this.filterWarps((StreamingMultiprocessor)object));
            }
            case warp: {
                return this.basicMatch(object) && this.nonEmptyArray(this.filterLanes((Warp)object));
            }
        }
        return this.basicMatch(object);
    }

    private boolean nonEmptyArray(byte[] array) {
        return array == null || array.length > 0;
    }

    private boolean nonEmptyArray(CudaCoord[] array) {
        return array == null || array.length > 0;
    }

    private boolean basicMatch(ICudaRuntimeObject object) {
        return this.q1.match(object) && this.q2.match(object);
    }

    public String toString() {
        return String.format("(%s and %s)", this.q1, this.q2);
    }

    @Override
    public ElementType getElementType() {
        ElementType type1 = this.q1.getElementType();
        ElementType type2 = this.q2.getElementType();
        if (type1.ordinal() > type2.ordinal()) {
            return type2;
        }
        return type1;
    }
}

