/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.nvidia.cuda.ide.debug.service.ICudaStack;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.Dictionary;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CudaStack
extends MIStack
implements ICudaStack {
    public CudaStack(DsfSession session) {
        super(session);
    }

    private void findMatchingFrame(IRunControl.IExecutionDMContext anotherThread, IStack.IFrameDMContext frame, final DataRequestMonitor<IStack.IFrameDMContext> rm) {
        IRunControl.IExecutionDMContext originalThread = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frame, IRunControl.IExecutionDMContext.class);
        final IStack.IFrameDMContext stackFrame = this.createFrameDMContext(anotherThread, frame.getLevel());
        if (anotherThread.equals(originalThread)) {
            rm.setData((Object)stackFrame);
            rm.done();
        } else {
            this.sameFrames(stackFrame, frame, new DataRequestMonitor<Boolean>((Executor)new ImmediateInDsfExecutor(this.getExecutor()), rm){

                protected void handleSuccess() {
                    if (Boolean.TRUE.equals(this.getData())) {
                        rm.setData((Object)stackFrame);
                    } else {
                        rm.setStatus((IStatus)new Status(1, "com.nvidia.cuda.ide.debug", "<on another stack frame>"));
                    }
                    rm.done();
                }
            });
        }
    }

    @Override
    public void getCorrespondingStackFrame(IDMContext originalThread, IDMContext newThread, final DataRequestMonitor<IStack.IFrameDMContext> rm) {
        IStack.IFrameDMContext frame = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)originalThread, IStack.IFrameDMContext.class);
        final IRunControl.IExecutionDMContext anotherThread = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)newThread, IRunControl.IExecutionDMContext.class);
        if (frame != null && anotherThread != null) {
            this.findMatchingFrame(anotherThread, frame, rm);
        } else {
            IRunControl.IExecutionDMContext thread = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)originalThread, IRunControl.IExecutionDMContext.class);
            if (thread != null) {
                this.getTopFrame((IDMContext)thread, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext>((Executor)new ImmediateInDsfExecutor(this.getExecutor()), rm){

                    protected void handleSuccess() {
                        if (this.getData() != null) {
                            CudaStack.this.findMatchingFrame(anotherThread, (IStack.IFrameDMContext)this.getData(), (DataRequestMonitor<IStack.IFrameDMContext>)rm);
                        } else {
                            rm.done();
                        }
                    }
                });
            } else {
                rm.done();
            }
        }
    }

    protected boolean isSameFrame(IStack.IFrameDMData data1, IStack.IFrameDMData data2) {
        if (data1 == null || data2 == null) {
            return false;
        }
        return data1.getFile().equals(data2.getFile()) && data1.getFunction().equals(data2.getFunction());
    }

    protected void register(String[] classes, Dictionary properties) {
        String[] interfaces = DebugUtil.ensureContains(classes, ICudaStack.class.getName(), MIStack.class.getName());
        super.register(interfaces, properties);
    }

    private void sameFrames(IStack.IFrameDMContext frame1, IStack.IFrameDMContext frame2, DataRequestMonitor<Boolean> rm) {
        final IStack.IFrameDMData[] datas = new IStack.IFrameDMData[2];
        final CountingRequestMonitor crm = new CountingRequestMonitor((Executor)new ImmediateInDsfExecutor(this.getExecutor()), (RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                boolean sameFrame = CudaStack.this.isSameFrame(datas[0], datas[1]);
                this.val$rm.setData((Object)sameFrame);
                this.val$rm.done();
            }
        };
        crm.setDoneCount(2);
        this.getFrameData(frame1, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)new ImmediateInDsfExecutor(this.getExecutor()), (RequestMonitor)crm){

            protected void handleSuccess() {
                datas[0] = (IStack.IFrameDMData)this.getData();
                crm.done();
            }
        });
        this.getFrameData(frame2, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)new ImmediateInDsfExecutor(this.getExecutor()), (RequestMonitor)crm){

            protected void handleSuccess() {
                datas[1] = (IStack.IFrameDMData)this.getData();
                crm.done();
            }
        });
    }
}

