/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel;

import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.model.events.ElementPinnedStatusEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaThreadColumns;
import com.nvidia.cuda.ide.debug.ui.viewmodel.IDataContextProvider;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.CudaRegisterVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.CudaVariableVMNode;
import com.nvidia.cuda.ide.debug.util.ThreadColumnsManager;
import com.nvidia.cuda.ide.debug.util.ThreadsColumnPresentation;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.DsfCastToTypeSupport;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.DisabledExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionManagerVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.IExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.SingleExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterBitFieldVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbExpressionVMProvider;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.RootDMVMNode;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public final class CudaExpressionVMProvider
extends GdbExpressionVMProvider
implements ICudaThreadColumns {
    public CudaExpressionVMProvider(AbstractVMAdapter adapter, IPresentationContext context, DsfSession session) {
        super(adapter, context, session);
        context.setProperty("cuda_threads", (Object)this);
    }

    protected void configureLayout() {
        SingleExpressionVMNode expressionManagerNode;
        SyncRegisterDataAccess syncRegDataAccess = new SyncRegisterDataAccess(this.getSession());
        SyncVariableDataAccess syncvarDataAccess = new SyncVariableDataAccess(this.getSession());
        RootDMVMNode rootNode = new RootDMVMNode((AbstractVMProvider)this);
        if ("org.eclipse.cdt.dsf.ui.expression_hover".equals(this.getPresentationContext().getId())) {
            expressionManagerNode = new SingleExpressionVMNode((ExpressionVMProvider)this);
            this.addChildNodes((IVMNode)rootNode, new IVMNode[]{expressionManagerNode});
        } else {
            expressionManagerNode = new ExpressionManagerVMNode((ExpressionVMProvider)this);
            this.addChildNodes((IVMNode)rootNode, new IVMNode[]{expressionManagerNode});
        }
        DisabledExpressionVMNode disabledExpressionNode = new DisabledExpressionVMNode((IVMProvider)this);
        CudaRegisterVMNode registerNode = new CudaRegisterVMNode((AbstractDMVMProvider)this, this.getSession(), syncRegDataAccess);
        RegisterBitFieldVMNode bitFieldNode = new RegisterBitFieldVMNode((AbstractDMVMProvider)this, this.getSession(), syncRegDataAccess);
        this.addChildNodes(registerNode, new IVMNode[]{bitFieldNode});
        CudaVariableVMNode variableNode = new CudaVariableVMNode((AbstractDMVMProvider)this, this.getSession(), syncvarDataAccess);
        this.addChildNodes(variableNode, (IVMNode[])new IExpressionVMNode[]{variableNode});
        ((VariableVMNode)variableNode).setCastToTypeSupport(new DsfCastToTypeSupport(this.getSession(), (AbstractDMVMProvider)this, syncvarDataAccess));
        this.setExpressionNodes(new IExpressionVMNode[]{disabledExpressionNode, registerNode, variableNode});
        this.setRootNode((IRootVMNode)rootNode);
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return new ThreadsColumnPresentation(super.createColumnPresentation(context, element));
    }

    @Override
    public IFocusDMContext getColumnFocus(String columnId) {
        return this.getColumnsManager().getColumnFocus(columnId);
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return ThreadsColumnPresentation.getId(super.getColumnPresentationId(context, element));
    }

    public void handleEvent(Object event, RequestMonitor rm) {
        if (event instanceof ElementPinnedStatusEvent || event instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.getColumnsManager().refresh();
        }
        super.handleEvent(event, rm);
    }

    public void refresh() {
        this.getColumnsManager().refresh();
        super.refresh();
    }

    public void update(final IViewerInputUpdate update) {
        IDataContextProvider stackFrameProvider;
        Object element = update.getElement();
        if (element instanceof IAdaptable && (stackFrameProvider = (IDataContextProvider)((IAdaptable)element).getAdapter(IDataContextProvider.class)) != null) {
            stackFrameProvider.getDataContext(element, (DataRequestMonitor<IDMVMContext>)new ViewerDataRequestMonitor<IDMVMContext>(this.getExecutor(), (IViewerUpdate)update){

                protected void handleSuccess() {
                    CudaExpressionVMProvider.this.getColumnsManager().showColumns(this.getData());
                    update.setInputElement(this.getData());
                    update.done();
                }
            });
            return;
        }
        this.getColumnsManager().showColumns(update.getElement());
        super.update(update);
    }

    private ThreadColumnsManager getColumnsManager() {
        return ThreadColumnsManager.getColumnsManager(this.getPresentationContext(), "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME", "org.eclipse.cdt.dsf.ui.COLUMN_ID__TYPE", "org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE");
    }
}

