/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.Kernel;
import java.util.Comparator;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;

public class DeviceThreadComparator
implements Comparator<DeviceThread> {
    private final ICoordSorter sorter;

    public DeviceThreadComparator(ICoordSorter sorter) {
        this.sorter = sorter;
    }

    @Override
    public int compare(DeviceThread o1, DeviceThread o2) {
        Kernel k1 = (Kernel)DMContexts.getAncestorOfType((IDMContext)o1, Kernel.class);
        Kernel k2 = (Kernel)DMContexts.getAncestorOfType((IDMContext)o2, Kernel.class);
        int order = Long.signum(k1.getId() - k2.getId());
        if (order == 0 && (order = this.sorter.compare(k1.getGridDim(), o1.getBlockIdx(), o2.getBlockIdx())) == 0) {
            order = this.sorter.compare(k1.getBlockDim(), o1.getThreadIdx(), o2.getThreadIdx());
        }
        return Integer.signum(order);
    }
}

