/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityEvent;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityMetric;
import com.nvidia.viper.activity.CuptiActivityPCSamplingRecordInfo;
import com.nvidia.viper.activity.CuptiActivityPartitionedGlobalCacheConfigKind;
import com.nvidia.viper.activity.CuptiLaunchType;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.Metric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CuptiActivityKernel
extends CuptiActivityBase
implements ICuptiActivity {
    public int correlationId;
    public long gridId;
    public long parentGridId;
    public int deviceId;
    public int contextId;
    public int streamId;
    public long start;
    public long end;
    public long queued;
    public long submitted;
    public long completed;
    public int gridX = -1;
    public int gridY = -1;
    public int gridZ = -1;
    public int blockX = -1;
    public int blockY = -1;
    public int blockZ = -1;
    public int parentBlockX = -1;
    public int parentBlockY = -1;
    public int parentBlockZ = -1;
    public int regPerThread = -1;
    public int statSharedMem = -1;
    public int dynaSharedMem = -1;
    public int lmemPerThread = -1;
    public int lmemTotal = -1;
    public int cacheConfigRequested = -1;
    public int cacheConfigExecuted = -1;
    public int sharedMemoryConfig = -1;
    public int partitionedGlobalCacheRequested = -1;
    public int partitionedGlobalCacheExecuted = -1;
    public int isSharedMemoryCarveoutRequested = 0;
    public int sharedMemoryCarveoutRequested = 0;
    public long sharedMemoryExecuted = 0L;
    public int launchType = CuptiLaunchType.CUPTI_LAUNCH_TYPE_REGULAR.getCode();
    public String name;
    public int runtimeCorrelationId;
    private Map<Event, Long> eventMap = null;
    private Map<Metric, CuptiActivityMetric> aggregateMetricMap = null;
    private Map<Metric, Vector<CuptiActivityMetric>> instanceMetricMap = null;
    private List<ICuptiActivitySourceLevelResult> sourceLevelResults = null;
    private CuptiActivityPCSamplingRecordInfo pcSamplingRecordInfo;

    public CuptiActivityKernel() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    public CuptiActivityKernel(CuptiActivityKind kind, long gridId, long parentGridId, int correlationId, int deviceId, int contextId, int streamId, long start, long end, String name, long queued, long submitted, CuptiLaunchType launchType) {
        this.kind = kind.getCode();
        this.correlationId = correlationId;
        this.runtimeCorrelationId = 0;
        this.gridId = gridId;
        this.parentGridId = parentGridId;
        this.deviceId = deviceId;
        this.contextId = contextId;
        this.streamId = streamId;
        this.start = start;
        this.end = end;
        this.queued = queued;
        this.submitted = submitted;
        this.submitted = 0L;
        this.completed = 0L;
        this.name = name;
        this.launchType = launchType.getCode();
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.start > 0L && this.end > 0L && this.start < this.end;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        try {
            NativeCupti.cuptiPDMAppendActivity(hPdm, this);
            if (this.eventMap != null) {
                for (Event event : this.eventMap.keySet()) {
                    CuptiActivityBase activity = new CuptiActivityEvent(this.correlationId, event.getDomain(), event.getId(), this.eventMap.get(event));
                    ((CuptiActivityEvent)activity).appendToPDM(hPdm);
                }
            }
            if (this.aggregateMetricMap != null) {
                for (CuptiActivityMetric cuptiActivityMetric : this.aggregateMetricMap.values()) {
                    cuptiActivityMetric.correlationId = this.correlationId;
                    cuptiActivityMetric.appendToPDM(hPdm);
                }
            }
            if (this.instanceMetricMap != null) {
                for (Vector vector : this.instanceMetricMap.values()) {
                    for (CuptiActivityBase activity : vector) {
                        if (activity == null) continue;
                        ((CuptiActivityMetric)activity).correlationId = this.correlationId;
                        ((CuptiActivityMetric)activity).appendToPDM(hPdm);
                    }
                }
            }
            if (this.sourceLevelResults != null) {
                for (ICuptiActivitySourceLevelResult iCuptiActivitySourceLevelResult : this.sourceLevelResults) {
                    iCuptiActivitySourceLevelResult.appendToPDM(hPdm);
                }
            }
        }
        catch (Exception exception) {
            ViperExceptionHandler.logError("append to pdm failed", exception);
        }
    }

    private static <T> Set<T> getMapKeySet(Map<T, ?> map) {
        if (map != null) {
            return Collections.unmodifiableSet(map.keySet());
        }
        return Collections.emptySet();
    }

    public Set<Event> getEvents() {
        return CuptiActivityKernel.getMapKeySet(this.eventMap);
    }

    public Long getEventValue(Event event) {
        return this.eventMap == null ? null : this.eventMap.get(event);
    }

    public void setEventValue(Event event, Long value) {
        if (event != null) {
            if (value == null) {
                if (this.eventMap != null) {
                    this.eventMap.remove(event);
                }
            } else {
                if (this.eventMap == null) {
                    this.eventMap = new HashMap<Event, Long>();
                }
                this.eventMap.put(event, value);
            }
        }
    }

    public Set<Metric> getAggregateMetrics() {
        return CuptiActivityKernel.getMapKeySet(this.aggregateMetricMap);
    }

    public CuptiActivityMetric getAggregateMetricActivity(Metric metric) {
        return this.aggregateMetricMap == null ? null : this.aggregateMetricMap.get(metric);
    }

    public void setAggregateMetricActivity(Metric metric, CuptiActivityMetric activity) {
        if (activity != null && !CuptiActivityKind.CUPTI_ACTIVITY_KIND_METRIC.equals((Object)activity.getKind())) {
            ViperExceptionHandler.logError("expected aggregate metric, got " + (Object)((Object)activity.getKind()));
        } else if (metric != null) {
            if (activity == null) {
                if (this.aggregateMetricMap != null) {
                    this.aggregateMetricMap.remove(metric);
                }
            } else {
                if (this.aggregateMetricMap == null) {
                    this.aggregateMetricMap = new HashMap<Metric, CuptiActivityMetric>();
                }
                this.aggregateMetricMap.put(metric, activity);
            }
        }
    }

    public Set<Metric> getInstanceMetrics() {
        return CuptiActivityKernel.getMapKeySet(this.instanceMetricMap);
    }

    public CuptiActivityMetric getInstanceMetricActivity(Metric metric, int instance) {
        if (this.instanceMetricMap == null) {
            return null;
        }
        Vector<CuptiActivityMetric> instanceMetrics = this.instanceMetricMap.get(metric);
        if (instance < 0 || instance >= instanceMetrics.size()) {
            return null;
        }
        return instanceMetrics.get(instance);
    }

    public List<CuptiActivityMetric> getInstanceMetricActivities(Metric metric) {
        if (this.instanceMetricMap == null) {
            return Collections.emptyList();
        }
        Vector<CuptiActivityMetric> instanceMetrics = this.instanceMetricMap.get(metric);
        if (instanceMetrics == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(instanceMetrics);
    }

    public void setInstanceMetricActivity(Metric metric, int instance, CuptiActivityMetric activity) {
        if (activity != null && !CuptiActivityKind.CUPTI_ACTIVITY_KIND_METRIC_INSTANCE.equals((Object)activity.getKind())) {
            ViperExceptionHandler.logError("expected per-instance metric, got " + (Object)((Object)activity.getKind()));
        } else if (metric != null) {
            Vector<CuptiActivityMetric> instanceMetrics;
            Vector<CuptiActivityMetric> vector = instanceMetrics = this.instanceMetricMap == null ? null : this.instanceMetricMap.get(metric);
            if (activity == null) {
                if (instanceMetrics != null && instance >= 0 && instance < instanceMetrics.size()) {
                    instanceMetrics.set(instance, null);
                }
            } else {
                if (instanceMetrics == null) {
                    instanceMetrics = new Vector(Math.max(16, instance + 1));
                    if (this.instanceMetricMap == null) {
                        this.instanceMetricMap = new HashMap<Metric, Vector<CuptiActivityMetric>>();
                    }
                    this.instanceMetricMap.put(metric, instanceMetrics);
                }
                if (instance >= instanceMetrics.size()) {
                    instanceMetrics.setSize(instance + 1);
                }
                instanceMetrics.set(instance, activity);
            }
        }
    }

    public Collection<ICuptiActivitySourceLevelResult> getSourceLevelResults() {
        if (this.sourceLevelResults != null) {
            return Collections.unmodifiableCollection(this.sourceLevelResults);
        }
        return Collections.emptyList();
    }

    public boolean addSourceLevelResult(ICuptiActivitySourceLevelResult result) {
        result.setCorrelationId(this.correlationId);
        if (this.sourceLevelResults == null) {
            this.sourceLevelResults = new ArrayList<ICuptiActivitySourceLevelResult>();
        }
        return this.sourceLevelResults.add(result);
    }

    public boolean removeSourceLevelResult(ICuptiActivitySourceLevelResult result) {
        if (this.sourceLevelResults == null) {
            return false;
        }
        return this.sourceLevelResults.remove(result);
    }

    public void clearSourceLevelResults() {
        if (this.sourceLevelResults == null) {
            return;
        }
        this.sourceLevelResults.clear();
    }

    public static int decodeSharedMemoryConfig(int sharedConfig) {
        switch (sharedConfig) {
            case 0: 
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
        }
        return -1;
    }

    public static int decodePartitionedGlobalCacheConfig(int partitionedGlobalCacheConfig) {
        if (CuptiActivityPartitionedGlobalCacheConfigKind.CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON.equals(partitionedGlobalCacheConfig)) {
            return 1;
        }
        return 0;
    }

    public static int decodeSharedMemoryCarveoutConfig(int isSharedMemoryCarveoutRequested, int sharedMemoryCarveoutRequested) {
        if (isSharedMemoryCarveoutRequested == 1) {
            return sharedMemoryCarveoutRequested;
        }
        return -1;
    }

    public void setPCSamplingRecordInfo(CuptiActivityPCSamplingRecordInfo pcSamplingRecordInfo) {
        this.pcSamplingRecordInfo = pcSamplingRecordInfo;
    }

    public CuptiActivityPCSamplingRecordInfo getPCSamplingRecordInfo() {
        return this.pcSamplingRecordInfo;
    }

    public void clearAllAnalysis() {
        if (this.eventMap != null) {
            this.eventMap.clear();
        }
        if (this.aggregateMetricMap != null) {
            this.aggregateMetricMap.clear();
        }
        if (this.instanceMetricMap != null) {
            this.instanceMetricMap.clear();
        }
        if (this.sourceLevelResults != null) {
            this.sourceLevelResults.clear();
        }
        this.eventMap = null;
        this.aggregateMetricMap = null;
        this.instanceMetricMap = null;
        this.sourceLevelResults = null;
    }
}

