/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalBase;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineNvlink;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TimelineIntervalNvlink
extends TimelineIntervalBase {
    private Long startValue;
    private Long endValue;
    private Long avgThroughput = 0L;
    private Long maxThroughput = 0L;
    private Long totalIdleTime = 0L;
    private Map<Long, Long> timestampValueMap = new TreeMap<Long, Long>();

    public TimelineIntervalNvlink(TimelineIntervalKind kind, long start, long end, long startValue, long endValue) {
        super(kind, start, end, 0L);
        this.startValue = startValue;
        this.endValue = endValue;
    }

    private int getHeight(long value, int maxHeight) {
        Timeline tl = this.getPrimaryTimeline();
        if (tl instanceof TimelineNvlink) {
            TimelineNvlink nvlinkTL = (TimelineNvlink)tl;
            long maxValue = nvlinkTL.getMaxValue();
            double util = (double)value / (double)maxValue;
            int height = (int)(util * (double)maxHeight);
            if (util > 0.0) {
                return Math.max(1, height);
            }
            return height;
        }
        return 0;
    }

    public int getStartHeight(int maxHeight) {
        return this.getHeight(this.startValue, maxHeight);
    }

    public int getEndHeight(int maxHeight) {
        return this.getHeight(this.endValue, maxHeight);
    }

    public int getHeightAtTimestamp(long normalizedTimestamp, int maxHeight) {
        long actualTimestamp = normalizedTimestamp + this.getNormalizedTime();
        Long value = this.timestampValueMap.get(actualTimestamp);
        if (value != null) {
            return this.getHeight(value, maxHeight);
        }
        return 0;
    }

    public Long getStartValue() {
        return this.startValue;
    }

    public Long getEndValue() {
        return this.endValue;
    }

    public void setTimestampValue(Long timestamp, Long value) {
        this.timestampValueMap.put(timestamp, value);
    }

    public List<Long> getIntermediateIntervals() {
        ArrayList<Long> normalizedIntervals = new ArrayList<Long>();
        for (Long timestamp : this.timestampValueMap.keySet()) {
            normalizedIntervals.add(timestamp - this.getNormalizedTime());
        }
        return normalizedIntervals;
    }

    public long getMaxThroughput() {
        if (this.maxThroughput == 0L) {
            for (Long value : this.timestampValueMap.values()) {
                if (this.maxThroughput >= value) continue;
                this.maxThroughput = value;
            }
        }
        return this.maxThroughput;
    }

    public long getAvgThroughput() {
        if (this.avgThroughput == 0L) {
            long totalThroughput = 0L;
            int nonZeroCount = 0;
            for (Long value : this.timestampValueMap.values()) {
                totalThroughput += value.longValue();
                if (value <= 0L) continue;
                ++nonZeroCount;
            }
            this.avgThroughput = totalThroughput / (long)nonZeroCount;
        }
        return this.avgThroughput;
    }

    public long getIdleTime() {
        if (this.totalIdleTime == 0L) {
            boolean foundZeroValue = false;
            long prevTimestamp = 0L;
            for (Map.Entry<Long, Long> entry : this.timestampValueMap.entrySet()) {
                Long value = entry.getValue();
                if (foundZeroValue && value == 0L) {
                    this.totalIdleTime = this.totalIdleTime + (entry.getKey() - prevTimestamp);
                }
                foundZeroValue = value == 0L;
                prevTimestamp = entry.getKey();
            }
        }
        return this.totalIdleTime;
    }
}

