/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.properties;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.parts.SessionEditPart;
import com.nvidia.viper.parts.TimelineEditPart;
import com.nvidia.viper.ui.ExecutableAdvancedOptionsPropertyControl;
import com.nvidia.viper.ui.ExecutableOptionsPropertyControl;
import com.nvidia.viper.ui.ExecutablePropertyControl;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ExecutablePropertySection
extends AbstractPropertySection {
    private Executable executable = null;
    private ExecutablePropertyControl propertyControl;
    private ExecutableOptionsPropertyControl optionsControl;
    private MultiProcessSettingListener multiProcessSettingListener;
    private ExecutableAdvancedOptionsPropertyControl advancedOptionsControl;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Session session = null;
        if (input instanceof SessionEditPart) {
            session = ((SessionEditPart)input).getCastedModel();
        } else if (input instanceof TimelineEditPart) {
            session = ((TimelineEditPart)input).getCastedModel().getSession();
        }
        if (session != null) {
            this.optionsControl.setInput(session);
        }
        Executable executable = this.executable = session == null ? null : session.getExecutable();
        if (this.executable != null) {
            this.propertyControl.setInput(this.executable);
            this.advancedOptionsControl.setInput(this.executable);
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage page) {
        super.createControls(parent, page);
        Composite top = this.getWidgetFactory().createFlatFormComposite(parent);
        this.propertyControl = new ExecutablePropertyControl(top, 0, (IRunnableContext)page.getSite().getService(IProgressService.class)){

            @Override
            public void setValidationStatus(IStatus status) {
            }
        };
        FormData dataPropertyControl = new FormData();
        dataPropertyControl.left = new FormAttachment(0, 0);
        dataPropertyControl.right = new FormAttachment(100, 0);
        dataPropertyControl.top = new FormAttachment(0, 4);
        this.propertyControl.setLayoutData(dataPropertyControl);
        this.optionsControl = new ExecutableOptionsPropertyControl(top, 0, (IRunnableContext)page.getSite().getService(IProgressService.class));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.propertyControl, 4);
        this.optionsControl.setLayoutData(data);
        this.multiProcessSettingListener = new MultiProcessSettingListener(this.optionsControl);
        this.propertyControl.setListener(this.multiProcessSettingListener);
        this.advancedOptionsControl = new ExecutableAdvancedOptionsPropertyControl(top, 0, false);
        FormData advancedData = new FormData();
        advancedData.left = new FormAttachment(0, 0);
        advancedData.right = new FormAttachment(100, 0);
        advancedData.top = new FormAttachment((Control)this.optionsControl, 6);
        this.advancedOptionsControl.setLayoutData(advancedData);
        this.propertyControl.setBackgroundMode(1);
        this.propertyControl.setBackground(top.getBackground());
        this.optionsControl.setBackgroundMode(1);
        this.optionsControl.setBackground(top.getBackground());
        this.advancedOptionsControl.setBackgroundMode(1);
        this.advancedOptionsControl.setBackground(top.getBackground());
        this.optionsControl.disableOptionsThatOnlyWorkWithSingleProcessProfiling();
        ViperHelp.setContextHelp((Control)parent, ViperHelp.SETTINGS_VIEW_CONTEXT_ID);
    }

    public void refresh() {
        this.propertyControl.refresh();
        this.optionsControl.refresh();
        this.advancedOptionsControl.refresh();
    }

    public static class MultiProcessSettingListener {
        private ExecutableOptionsPropertyControl optionsControl;

        MultiProcessSettingListener(ExecutableOptionsPropertyControl optionsControl) {
            this.optionsControl = optionsControl;
        }

        public void updateOptions() {
            this.optionsControl.updateOptions();
        }
    }
}

