/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.chart.ui.AxesConfiguration;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.ViperChartSeries;
import java.util.LinkedList;

public final class KernelPerSMOccupancyChart
implements IViperChart {
    private final Double[] occupancys;

    public KernelPerSMOccupancyChart(Double[] occupancys) {
        this.occupancys = occupancys;
    }

    public ViperChartSeries[] getSeries() {
        LinkedList<Double> values = new LinkedList<Double>();
        Double[] doubleArray = this.occupancys;
        int n = this.occupancys.length;
        int n2 = 0;
        while (n2 < n) {
            Double occ = doubleArray[n2];
            values.add(occ * 100.0);
            ++n2;
        }
        return new ViperChartSeries[]{new ViperChartSeries(values.toArray(new Double[0]), ViperChartSeries.Type.STACKED_BAR, "Occupancy")};
    }

    public String getTitle() {
        return null;
    }

    public boolean isHighlighted() {
        return false;
    }

    public boolean showLegend() {
        return false;
    }

    public int getHeight() {
        return 300;
    }

    public int getWidth() {
        return 900;
    }

    public AxesConfiguration getAxesConfiguration() {
        return new AxesConfiguration("Multiprocessor", "Occupancy", true, Integer.valueOf(100), Integer.valueOf(10), null, Integer.valueOf(10), true, new String[]{"10%", "20%", "30%", "40%", "50%", "60%", "70%", "80%", "90%", "100%"}, false);
    }

    public String[] getLabels() {
        LinkedList<String> labels = new LinkedList<String>();
        int cnt = 0;
        while (cnt < this.occupancys.length) {
            labels.add("SM " + cnt);
            ++cnt;
        }
        return labels.toArray(new String[0]);
    }

    public boolean colorBySeries() {
        return true;
    }
}

