/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCommands;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DefaultGCCDependencyCalculator2Commands
implements IManagedDependencyCommands {
    IPath source;
    IResource resource;
    IBuildObject buildContext;
    ITool tool;
    IPath topBuildDirectory;
    IProject project;
    IPath sourceLocation;
    IPath outputLocation;
    boolean needExplicitRuleForFile;
    Boolean genericCommands = null;

    public DefaultGCCDependencyCalculator2Commands(IPath source, IResource resource, IBuildObject buildContext, ITool tool, IPath topBuildDirectory) {
        this.source = source;
        this.resource = resource;
        this.buildContext = buildContext;
        this.tool = tool;
        this.topBuildDirectory = topBuildDirectory;
        if (buildContext instanceof IConfiguration) {
            IConfiguration config = (IConfiguration)buildContext;
            this.project = (IProject)config.getOwner();
        } else if (buildContext instanceof IResourceInfo) {
            IResourceInfo rcInfo = (IResourceInfo)buildContext;
            this.project = rcInfo.getParent().getOwner().getProject();
        }
        Path projectPath = new Path(EFSExtensionManager.getDefault().getPathFromURI(this.project.getLocationURI()));
        this.sourceLocation = source.isAbsolute() ? source : projectPath.append(source);
        this.outputLocation = projectPath.append(topBuildDirectory).append(this.getDependencyFiles()[0]);
        boolean resourceNameRequiresExplicitRule = true;
        if (resource != null) {
            resourceNameRequiresExplicitRule = resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(this.sourceLocation.toString()) || !resource.isLinked() && GnuMakefileGenerator.containsSpecialCharacters(resource.getProjectRelativePath().toString());
        }
        boolean bl = this.needExplicitRuleForFile = resourceNameRequiresExplicitRule || BuildMacroProvider.getReferencedExplitFileMacros(tool).length > 0 || BuildMacroProvider.getReferencedExplitFileMacros(tool.getToolCommand(), 1, new FileContextData(this.sourceLocation, this.outputLocation, null, tool)).length > 0;
        if (this.needExplicitRuleForFile) {
            this.genericCommands = new Boolean(false);
        }
    }

    public DefaultGCCDependencyCalculator2Commands(IPath source, IBuildObject buildContext, ITool tool, IPath topBuildDirectory) {
        this(source, null, buildContext, tool, topBuildDirectory);
    }

    @Override
    public boolean areCommandsGeneric() {
        if (this.genericCommands == null) {
            this.genericCommands = new Boolean(true);
        }
        return this.genericCommands;
    }

    @Override
    public String[] getDependencyCommandOptions() {
        IPath outPath;
        String[] options = new String[4];
        options[0] = "-MMD";
        options[1] = "-MP";
        if (this.needExplicitRuleForFile) {
            outPath = this.getDependencyFiles()[0];
            options[2] = "-MF\"" + outPath.toString() + "\"";
        } else {
            options[2] = "-MF\"$(@:%.o=%.d)\"";
        }
        if (this.buildContext instanceof IResourceConfiguration || this.needExplicitRuleForFile) {
            String optTxt;
            outPath = this.getDependencyFiles()[0];
            options[3] = optTxt = "-MT\"" + GnuMakefileGenerator.escapeWhitespaces(outPath.toString()) + "\"";
        } else {
            options[3] = "-MT\"$(@:%.o=%.d)\"";
        }
        return options;
    }

    @Override
    public IPath[] getDependencyFiles() {
        IPath depFilePath = this.source.removeFileExtension().addFileExtension("d");
        if (!depFilePath.isAbsolute() && this.topBuildDirectory.isPrefixOf(depFilePath)) {
            depFilePath = depFilePath.removeFirstSegments(1);
        }
        IPath[] paths = new IPath[]{depFilePath};
        return paths;
    }

    @Override
    public String[] getPostToolDependencyCommands() {
        return null;
    }

    @Override
    public String[] getPreToolDependencyCommands() {
        return null;
    }

    @Override
    public IBuildObject getBuildContext() {
        return this.buildContext;
    }

    @Override
    public IPath getSource() {
        return this.source;
    }

    @Override
    public ITool getTool() {
        return this.tool;
    }

    @Override
    public IPath getTopBuildDirectory() {
        return this.topBuildDirectory;
    }
}

