/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.operations.SystemDeferredTreeContentManager;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class SystemViewLabelAndContentProvider
extends LabelProvider
implements ITreeContentProvider,
ILabelProvider,
ITableLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final Object[] NO_OBJECTS = new Object[0];
    protected Viewer viewer;
    private boolean filesOnly;
    private boolean foldersOnly;
    private String filterString = null;
    private Hashtable resolvedChildrenPerFolder = null;
    private boolean _enableDeferredQueries = true;
    private SystemDeferredTreeContentManager manager;

    public SystemViewLabelAndContentProvider() {
    }

    public SystemViewLabelAndContentProvider(boolean foldersOnly, boolean filesOnly) {
        this();
        this.foldersOnly = foldersOnly;
        this.filesOnly = filesOnly;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
        this.flushCache();
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void flushCache() {
        this.resolvedChildrenPerFolder = null;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        Object obj;
        if (this.viewer != null && (obj = this.viewer.getInput()) != null && !(obj instanceof IWorkspace)) {
            boolean cfr_ignored_0 = obj instanceof IContainer;
        }
    }

    protected ISystemViewElementAdapter getViewAdapter(Object o) {
        if (o instanceof IContextObject) {
            o = ((IContextObject)o).getModelObject();
        }
        ISystemViewElementAdapter adapter = null;
        if (o == null) {
            SystemBasePlugin.logWarning("ERROR: null passed to getAdapter in SystemViewLabelAndContentProvider");
        } else {
            adapter = o instanceof IAdaptable ? (ISystemViewElementAdapter)((IAdaptable)o).getAdapter(ISystemViewElementAdapter.class) : (ISystemViewElementAdapter)Platform.getAdapterManager().getAdapter(o, ISystemViewElementAdapter.class);
            if (adapter == null && !(o instanceof PendingUpdateAdapter)) {
                SystemBasePlugin.logWarning("ADAPTER IS NULL FOR ELEMENT OF TYPE: " + o.getClass().getName());
            }
        }
        if (adapter != null && this.viewer != null) {
            Shell shell = null;
            shell = this.viewer instanceof ISystemShellProvider ? ((ISystemShellProvider)this.viewer).getShell() : this.viewer.getControl().getShell();
            adapter.setShell(shell);
            adapter.setViewer(this.viewer);
            if (this.viewer.getInput() instanceof ISystemViewInputProvider) {
                ISystemViewInputProvider inputProvider = (ISystemViewInputProvider)this.viewer.getInput();
                adapter.setInput(inputProvider);
            }
        } else if (this.viewer == null) {
            SystemBasePlugin.logWarning("VIEWER IS NULL FOR SYSTEMVIEWLABELANDCONTENTPROVIDER");
        }
        return adapter;
    }

    public void cancelJobs(Object location) {
        if (this.manager != null) {
            this.manager.cancel(location);
        }
    }

    protected boolean supportsDeferredQueries() {
        return this._enableDeferredQueries;
    }

    public void setEnableDeferredQueries(boolean enable) {
        this._enableDeferredQueries = enable;
    }

    public Object[] getChildren(Object object) {
        Object element = object;
        if (object instanceof IContextObject) {
            element = ((IContextObject)object).getModelObject();
        }
        ISystemViewElementAdapter adapter = this.getViewAdapter(element);
        if (this.supportsDeferredQueries() && this.manager != null && adapter != null) {
            Object[] children;
            ISubSystem ss = null;
            ss = object instanceof IContextObject ? ((IContextObject)object).getSubSystem() : adapter.getSubSystem(object);
            if (ss != null && adapter.supportsDeferredQueries(ss) && (children = this.manager.getChildren(object, this.getViewer())) != null) {
                return children;
            }
        }
        if (adapter != null) {
            String expandToFilter;
            if (this.viewer instanceof SystemView && ((SystemView)this.viewer).getSystemViewPart() != null && adapter instanceof ISystemRemoteElementAdapter && (expandToFilter = ((SystemView)this.viewer).getExpandToFilter(element)) != null) {
                return adapter.getChildrenUsingExpandToFilter(element, expandToFilter);
            }
            Object[] children = null;
            if ((this.filesOnly || this.foldersOnly) && this.resolvedChildrenPerFolder != null && (children = (Object[])this.resolvedChildrenPerFolder.get(element)) != null) {
                return children;
            }
            children = object instanceof IContextObject ? adapter.getChildren((IContextObject)object, (IProgressMonitor)new NullProgressMonitor()) : adapter.getChildren((IAdaptable)object, (IProgressMonitor)new NullProgressMonitor());
            if (children == null) {
                ISubSystem ss = null;
                ss = object instanceof IContextObject ? ((IContextObject)object).getSubSystem() : adapter.getSubSystem(object);
                if (ss != null && !ss.isConnected()) {
                    final ISubSystem fss = ss;
                    new Job(SystemResources.ACTION_CONNECT_LABEL){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                fss.connect(monitor, false);
                            }
                            catch (SystemMessageException ex) {
                                final SystemMessageException fex = ex;
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        SystemMessageDialog dlg = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), fex.getSystemMessage());
                                        dlg.open();
                                    }
                                });
                            }
                            catch (Exception exception) {
                                return Status.CANCEL_STATUS;
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
            if (!(!this.filesOnly && !this.foldersOnly || children.length == 1 && children[0] instanceof SystemMessageObject)) {
                if (this.resolvedChildrenPerFolder == null) {
                    this.resolvedChildrenPerFolder = new Hashtable();
                }
                this.resolvedChildrenPerFolder.put(element, children);
            }
            return children;
        }
        return NO_OBJECTS;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(element);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(element);
        if (adapter != null) {
            if (element instanceof IContextObject) {
                return adapter.hasChildren((IContextObject)element);
            }
            return adapter.hasChildren((IAdaptable)element);
        }
        if (element instanceof IContextObject) {
            element = ((IContextObject)element).getModelObject();
        }
        if (this.manager != null && this.manager.isDeferredAdapter(element)) {
            return this.manager.mayHaveChildren(element);
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!(newInput instanceof IWorkspace)) {
            boolean cfr_ignored_0 = newInput instanceof IContainer;
        }
        if (viewer instanceof AbstractTreeViewer) {
            this.manager = new SystemDeferredTreeContentManager(this, (AbstractTreeViewer)viewer);
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return this.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        return this.getText(element);
    }

    public Image getImage(Object element) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(element);
        if (adapter == null) {
            return null;
        }
        ImageDescriptor descriptor = adapter.getImageDescriptor(element);
        if (descriptor == null) {
            return null;
        }
        descriptor = this.decorateImage(descriptor, element);
        ImageRegistry imageRegistry = RSEUIPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(descriptor.toString());
        if (image == null) {
            image = descriptor.createImage();
            imageRegistry.put(descriptor.toString(), image);
        }
        return image;
    }

    public String getText(Object element) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(element);
        if (adapter == null) {
            IWorkbenchAdapter wadapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);
            if (wadapter == null) {
                return super.getText(element);
            }
            return wadapter.getLabel(element);
        }
        return this.decorateText(adapter.getText(element), element);
    }

    protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
        return input;
    }

    protected String decorateText(String input, Object element) {
        return input;
    }

    public StyledString getStyledText(Object element) {
        return new StyledString(this.getText(element));
    }
}

