/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTToken;
import org.eclipse.cdt.core.dom.ast.IASTTokenList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAttribute;
import org.eclipse.cdt.core.dom.ast.gnu.IGCCASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.parser.cpp.ICPPASTAttributeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttribute;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class AttributeWriter
extends NodeWriter {
    public AttributeWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
    }

    public void writeAttributeSpecifier(IASTAttributeSpecifier attribute) {
        if (attribute instanceof ICPPASTAttributeSpecifier) {
            this.writeAttributeSpecifier((ICPPASTAttributeSpecifier)attribute);
        } else if (attribute instanceof IGCCASTAttributeSpecifier) {
            this.writeGCCAttributeSpecifier((IGCCASTAttributeSpecifier)attribute);
        }
    }

    private void writeGCCAttributeSpecifier(IGCCASTAttributeSpecifier specifier) {
        this.scribe.print("__attribute__");
        this.scribe.print("(");
        this.scribe.print("(");
        IASTAttribute[] innerAttributes = specifier.getAttributes();
        int i = 0;
        while (i < innerAttributes.length) {
            IASTAttribute innerAttribute = innerAttributes[i];
            this.writeAttribute((CPPASTAttribute)innerAttribute);
            if (i < innerAttributes.length - 1) {
                this.scribe.print(',');
                this.scribe.printSpace();
            }
            ++i;
        }
        this.scribe.print(")");
        this.scribe.print(")");
    }

    private void writeAttributeSpecifier(ICPPASTAttributeSpecifier specifier) {
        this.scribe.print("[");
        this.scribe.print("[");
        IASTAttribute[] innerAttributes = specifier.getAttributes();
        int i = 0;
        while (i < innerAttributes.length) {
            IASTAttribute innerAttribute = innerAttributes[i];
            this.writeAttribute((ICPPASTAttribute)innerAttribute);
            if (i < innerAttributes.length - 1) {
                this.scribe.print(',');
                this.scribe.printSpace();
            }
            ++i;
        }
        this.scribe.print("]");
        this.scribe.print("]");
    }

    private void writeAttribute(ICPPASTAttribute attribute) {
        char[] scope = attribute.getScope();
        if (scope != null) {
            this.scribe.print(scope);
            this.scribe.print("::");
        }
        this.scribe.print(attribute.getName());
        IASTToken argumentClause = attribute.getArgumentClause();
        if (argumentClause != null) {
            this.scribe.print("(");
            this.printTokens(argumentClause);
            this.scribe.print(")");
        }
        if (attribute.hasPackExpansion()) {
            this.scribe.printSpace();
            this.scribe.print("...");
        }
    }

    protected void printTokens(IASTToken token) {
        if (token instanceof IASTTokenList) {
            IASTToken[] iASTTokenArray = ((IASTTokenList)token).getTokens();
            int n = iASTTokenArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTToken innerToken = iASTTokenArray[n2];
                this.printTokens(innerToken);
                ++n2;
            }
        } else {
            char[] tokenCharImage = token.getTokenCharImage();
            this.scribe.print(tokenCharImage);
        }
    }
}

