/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultPCSampling;
import com.nvidia.viper.birt.report.ReportTableData;
import com.nvidia.viper.chart.BirtChartSVGUtil;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.analysis.IAnalysisResultSVG;
import com.nvidia.viper.ui.chart.KernelPCSamplingStallReasonChart;
import org.eclipse.swt.graphics.GC;

public class PCSamplingResultSVG
implements IAnalysisResultSVG {
    protected final IViperChart viperChart;
    private final AnalysisResult result;
    private ReportTableData[] tableDataArr = null;
    Session activeSession;

    public PCSamplingResultSVG(AnalysisResult result, Session activeSession) {
        this.result = result;
        AnalysisResultPCSampling samplingResult = this.getResult();
        this.activeSession = activeSession;
        this.viperChart = new KernelPCSamplingStallReasonChart(samplingResult);
    }

    private AnalysisResultPCSampling getResult() {
        return (AnalysisResultPCSampling)this.result;
    }

    public IViperChart getViperChart() {
        return this.viperChart;
    }

    @Override
    public boolean createSVG(String filePath, int width, int height, GC gc) {
        return BirtChartSVGUtil.createChartSVG((IViperChart)this.getViperChart(), (String)filePath, (int)width, (int)height);
    }

    @Override
    public int getPreferredSVGHieght(GC gc) {
        return this.viperChart.getHeight();
    }

    @Override
    public ReportTableData[] getTableElements() {
        ReportTableData[] tableDataSet = this.constructReportTableDataArr();
        return tableDataSet;
    }

    private ReportTableData[] constructReportTableDataArr() {
        int n;
        int n2;
        String[] stringArray;
        boolean isSrcFileNameListEmpty;
        if (this.tableDataArr != null) {
            return this.tableDataArr;
        }
        int rowNum = 0;
        int tableNum = 0;
        AnalysisResultPCSampling samplingResult = this.getResult();
        String[] funcNameList = samplingResult.getFunctionNameList(this.activeSession);
        String[] srcFileNameList = samplingResult.getSourceFileNameList(this.activeSession);
        boolean isFuncNameListEmpty = funcNameList == null || funcNameList.length <= 0;
        boolean bl = isSrcFileNameListEmpty = srcFileNameList == null || srcFileNameList.length <= 0;
        if (!isFuncNameListEmpty && !isSrcFileNameListEmpty) {
            this.tableDataArr = new ReportTableData[2];
        } else if (!isFuncNameListEmpty || !isSrcFileNameListEmpty) {
            this.tableDataArr = new ReportTableData[1];
        } else {
            return null;
        }
        if (!isFuncNameListEmpty) {
            String[][] funcTable = new String[funcNameList.length + 1][3];
            funcTable[rowNum][0] = "Cuda Functions";
            funcTable[rowNum][1] = "Sample Count";
            funcTable[rowNum][2] = "% of Kernel Samples";
            ++rowNum;
            stringArray = funcNameList;
            n2 = funcNameList.length;
            n = 0;
            while (n < n2) {
                String funcName;
                funcTable[rowNum][0] = funcName = stringArray[n];
                Long samples = samplingResult.getSampleCount(samplingResult.getFunctionId(funcName, this.activeSession), this.activeSession);
                funcTable[rowNum][1] = String.valueOf(samples);
                double percentSamples = samples != null ? 100.0 * (double)samples.longValue() / samplingResult.getTotalSamples(this.activeSession) : 0.0;
                funcTable[rowNum][2] = String.valueOf(percentSamples);
                ++rowNum;
                ++n;
            }
            this.tableDataArr[tableNum] = new ReportTableData(funcTable, null, null, 0, rowNum, 0, 3);
            ++tableNum;
        }
        if (!isSrcFileNameListEmpty) {
            rowNum = 0;
            String[][] srcTable = new String[srcFileNameList.length][1];
            stringArray = srcFileNameList;
            n2 = srcFileNameList.length;
            n = 0;
            while (n < n2) {
                String srcFileName;
                srcTable[rowNum][0] = srcFileName = stringArray[n];
                ++rowNum;
                ++n;
            }
            this.tableDataArr[tableNum] = new ReportTableData(srcTable, "Source Files :", null, 0, rowNum, 0, 1);
        }
        return this.tableDataArr;
    }
}

