/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.editor.SourceSassColumnControl;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.editor.config.CudaViewerConfiguration;
import com.nvidia.viper.editor.config.SassViewerConfiguration;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.ui.CudaViewer;
import com.nvidia.viper.ui.SassViewer;
import com.nvidia.viper.ui.ViperViewerBase;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class ViewerControl
extends Composite {
    protected CompositeRuler viewRuler;
    private ViewerControlType viewerControlType;
    private SourceSassEditor editor;
    private ViperViewerBase viewer;
    private Button selectNextButton;
    private Button selectPreviousButton;
    private GridData lineColGrid;
    private LineNumberRulerColumn lineCol;
    private Label labelSourceCol;
    private OverviewRuler overviewRuler;
    private int ANNOTATION_RULER_WIDTH = 10;
    private int OVERVIEW_WIDTH = 12;
    private SourceSassColumnControl columnControl;

    public ViewerControl(SourceSassEditor editor, Composite parent, int style, ViewerControlType viewerControlType) {
        super(parent, style);
        this.editor = editor;
        this.viewerControlType = viewerControlType;
        this.viewRuler = new CompositeRuler();
        this.columnControl = new SourceSassColumnControl(this);
        this.setCurrentAnalysis();
        if (this.viewerControlType.equals((Object)ViewerControlType.SASS_VIEWER_CONTROL)) {
            this.createSassControls();
        } else {
            this.createCudaControls();
        }
    }

    private void setCurrentAnalysis() {
        AnalysisResultSourceLevel sourceLevel = this.editor.getSourceSassModel().getAnalysisResultSourceLevel();
        this.columnControl.setCurrentAnalysis(sourceLevel.getAnalysisResultSourceLevelKind());
    }

    private void createCudaControls() {
        this.lineColGrid = new GridData(-1, -1);
        this.columnControl.addLabel("Line", "", this.lineColGrid);
        int numColumns = this.columnControl.createViewerColumns();
        GridData gridDataTextArea = new GridData(4, 0x1000000, true, false);
        this.labelSourceCol = this.columnControl.addLabel("", "", gridDataTextArea);
        this.lineCol = new LineNumberRulerColumn();
        this.viewRuler.addDecorator(0, (IVerticalRulerColumn)this.lineCol);
        this.createOverViewRuler();
        this.viewer = new CudaViewer(this, (IVerticalRuler)this.viewRuler, (IOverviewRuler)this.overviewRuler, true, 68354);
        GridLayout layout = this.columnControl.getLayout();
        layout.marginWidth = 0;
        GridData viewerLayoutData = (GridData)this.viewer.getControl().getLayoutData();
        viewerLayoutData.horizontalSpan = numColumns + 2;
        this.layout();
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                ((CudaViewer)ViewerControl.this.viewer).clear();
                ((ViewerControl)ViewerControl.this).lineColGrid.widthHint = ViewerControl.this.lineCol.getWidth() + 5;
                ViewerControl.this.layout();
            }
        });
        AnnotationModel annotationModel = new AnnotationModel();
        this.viewer.setDocument((IDocument)new Document(), (IAnnotationModel)annotationModel);
        this.viewer.configure(new CudaViewerConfiguration());
        this.setupAnnotation(annotationModel);
        this.columnControl.showViewerColumns();
    }

    private void createSassControls() {
        GridData data = new GridData(this.ANNOTATION_RULER_WIDTH, -1);
        this.columnControl.addLabel("", "", data);
        int numColumns = this.columnControl.createViewerColumns();
        GridData gridDataTextArea = new GridData(4, 0x1000000, true, false);
        this.columnControl.addLabel("Disassembly", "", gridDataTextArea);
        this.viewRuler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(this.ANNOTATION_RULER_WIDTH));
        this.selectNextButton = this.addButtonInSassViewer(1024);
        this.selectNextButton.setToolTipText(ViperMessages.SelectNextInstructionButton_Tooltip);
        this.selectPreviousButton = this.addButtonInSassViewer(128);
        this.selectPreviousButton.setToolTipText(ViperMessages.SelectPrevInstructionButton_Tooltip);
        this.createOverViewRuler();
        this.viewer = new SassViewer(this, (IVerticalRuler)this.viewRuler, (IOverviewRuler)this.overviewRuler, true, 68354);
        GridLayout layout = this.columnControl.getLayout();
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        GridData viewerLayoutData = (GridData)this.viewer.getControl().getLayoutData();
        viewerLayoutData.horizontalSpan = numColumns + 3;
        this.layout();
        AnnotationModel annotationModel = new AnnotationModel();
        Document sassDocument = new Document();
        this.viewer.setDocument((IDocument)sassDocument, (IAnnotationModel)annotationModel);
        this.viewer.configure(new SassViewerConfiguration());
        this.setupAnnotation(annotationModel);
        this.columnControl.showViewerColumns();
    }

    protected void changeLabel(Label label, String text, String tooltipText) {
        if (label != null) {
            label.setText(text);
            label.setToolTipText(tooltipText);
            this.columnControl.getLayout();
        }
    }

    protected Button addButtonInSassViewer(final int style) {
        if (this.viewerControlType.equals((Object)ViewerControlType.SASS_VIEWER_CONTROL)) {
            Button but = new Button((Composite)this, 4 | style);
            but.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (style == 1024) {
                        ((SassViewer)ViewerControl.this.viewer).selectNext();
                    } else if (style == 128) {
                        ((SassViewer)ViewerControl.this.viewer).selectPrevious();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            but.setLayoutData((Object)new GridData(25, 25));
            return but;
        }
        return null;
    }

    public CompositeRuler getViewRuler() {
        return this.viewRuler;
    }

    public ViperViewerBase getViewer() {
        return this.viewer;
    }

    public SourceSassEditor getEditor() {
        return this.editor;
    }

    public void updateSassViewer() {
        if (this.viewerControlType.equals((Object)ViewerControlType.SASS_VIEWER_CONTROL)) {
            this.viewer.getDocument().set(this.editor.getSourceSassModel().getSassDocumentString());
            this.updateAnalysis();
        }
    }

    public void updateCudaViewer() {
        CudaViewer cudaViewer;
        if (this.viewerControlType.equals((Object)ViewerControlType.SOURCE_VIEWER_CONTOL) && (cudaViewer = (CudaViewer)this.viewer) != null && cudaViewer.getFileName() != null) {
            cudaViewer.removeCaretListener();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    block11: {
                        ITextFileBufferManager mgr = FileBuffers.getTextFileBufferManager();
                        Path path = new Path(ViewerControl.this.editor.getViewerFileName());
                        try {
                            try {
                                mgr.connect((IPath)path, LocationKind.LOCATION, null);
                                ITextFileBuffer buff = mgr.getTextFileBuffer((IPath)path, LocationKind.LOCATION);
                                cudaViewer.setDocument(buff.getDocument(), cudaViewer.getAnnotationModel());
                                cudaViewer.removeAnnotations();
                            }
                            catch (CoreException e) {
                                ViperExceptionHandler.handle("File not found", "The file '" + path.toOSString() + "' could not found", (Exception)((Object)e));
                                try {
                                    mgr.disconnect((IPath)path, LocationKind.LOCATION, null);
                                }
                                catch (CoreException coreException) {
                                    ViperExceptionHandler.logError("couldn't disconnect FileBufferManager");
                                }
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                mgr.disconnect((IPath)path, LocationKind.LOCATION, null);
                            }
                            catch (CoreException coreException) {
                                ViperExceptionHandler.logError("couldn't disconnect FileBufferManager");
                            }
                            throw throwable;
                        }
                        try {
                            mgr.disconnect((IPath)path, LocationKind.LOCATION, null);
                        }
                        catch (CoreException coreException) {
                            ViperExceptionHandler.logError("couldn't disconnect FileBufferManager");
                        }
                    }
                }
            });
            cudaViewer.addCaretListener();
            this.updateAnalysis();
        }
    }

    public void selectAnalysisStage(Analysis analysis) {
        this.columnControl.selectAnalysisStage(analysis);
    }

    public void enableNextButton(boolean enable) {
        this.selectNextButton.setEnabled(enable);
    }

    public void enablePreviousButton(boolean enable) {
        this.selectPreviousButton.setEnabled(enable);
    }

    public void updateAnalysis() {
        this.setCurrentAnalysis();
        Analysis analysis = this.editor.getSession().getAnalysis();
        this.columnControl.updateViewerColumns(analysis, this.viewer.getAnnotationModel());
    }

    public void changeSourceColLabel(String text, String tooltipText) {
        this.changeLabel(this.labelSourceCol, text, tooltipText);
    }

    protected void setupAnnotation(AnnotationModel annotationModel) {
        SourceSassEditor.AnnotationType[] annotationTypes = this.columnControl.getAnnotationTypes();
        int i = annotationTypes.length - 1;
        while (i >= 0) {
            SourceSassEditor.AnnotationType annotationType = annotationTypes[i];
            this.overviewRuler.addAnnotationType((Object)annotationType.getType());
            this.overviewRuler.setAnnotationTypeLayer((Object)annotationType.getType(), 3);
            this.overviewRuler.setAnnotationTypeColor((Object)annotationType.getType(), annotationType.getColor());
            --i;
        }
        this.overviewRuler.setModel((IAnnotationModel)annotationModel);
    }

    protected void createOverViewRuler() {
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        this.overviewRuler = new OverviewRuler((IAnnotationAccess)annotationAccess, this.OVERVIEW_WIDTH, (ISharedTextColors)new SharedColor());
    }

    public ViewerControlType getViewerControlType() {
        return this.viewerControlType;
    }

    public SourceSassColumnControl getColumnControl() {
        return this.columnControl;
    }

    class SharedColor
    implements ISharedTextColors {
        SharedColor() {
        }

        public Color getColor(RGB rgb) {
            return new Color((Device)Display.getDefault(), rgb);
        }

        public void dispose() {
        }
    }

    public static enum ViewerControlType {
        SOURCE_VIEWER_CONTOL,
        SASS_VIEWER_CONTROL;

    }
}

