/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.viper.activity.CuptiActivityOpenAcc;
import com.nvidia.viper.activity.CuptiOpenAccEventKind;
import com.nvidia.viper.model.OpenAccSummary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OpenAccAggregate
implements Comparable<OpenAccAggregate> {
    private long inclusiveTime;
    private long exclusiveTime;
    private long calls;
    private long endTime;
    private CuptiActivityOpenAcc openAcc;
    private Map<String, OpenAccAggregate> children;
    private boolean sourceAggregate;
    private boolean root;
    private OpenAccAggregate parent;
    private OpenAccSummary summary;

    public void addChild(OpenAccAggregate child) {
        CuptiActivityOpenAcc openAcc = child.getOpenAcc();
        String name = child.sourceAggregate ? String.valueOf(openAcc.srcFile) + ":" + openAcc.lineNo : String.valueOf(CuptiActivityOpenAcc.getCuptiEventName(CuptiOpenAccEventKind.valueOf(openAcc.eventKind))) + ":" + openAcc.lineNo;
        this.children.put(name, child);
        child.parent = this;
    }

    public OpenAccAggregate getChild(CuptiActivityOpenAcc openAcc) {
        String name = this.root ? String.valueOf(openAcc.srcFile) + ":" + openAcc.lineNo : String.valueOf(CuptiActivityOpenAcc.getCuptiEventName(CuptiOpenAccEventKind.valueOf(openAcc.eventKind))) + ":" + openAcc.lineNo;
        return this.children.get(name);
    }

    public long getCalls() {
        return this.calls;
    }

    public OpenAccAggregate(OpenAccSummary summary, OpenAccAggregate parent, CuptiActivityOpenAcc openAcc, boolean isSource) {
        this.summary = summary;
        this.inclusiveTime = openAcc.end - openAcc.start;
        this.endTime = openAcc.end;
        this.calls = 1L;
        this.children = new HashMap<String, OpenAccAggregate>();
        this.sourceAggregate = isSource;
        this.root = false;
        this.parent = parent;
        if (!this.sourceAggregate) {
            this.exclusiveTime = this.inclusiveTime;
        }
        this.openAcc = openAcc;
    }

    public OpenAccAggregate(OpenAccSummary summary) {
        this.summary = summary;
        this.root = true;
        this.children = new HashMap<String, OpenAccAggregate>();
        this.parent = null;
    }

    public CuptiActivityOpenAcc getOpenAcc() {
        return this.openAcc;
    }

    public void incrementInclusiveTime(long time) {
        this.inclusiveTime += time;
    }

    public void incrementExclusiveTime(long time) {
        this.exclusiveTime += time;
    }

    public void subtractExclusiveTime(long time) {
        this.exclusiveTime -= time;
    }

    public void incrementEndTime(long time) {
        this.endTime = time;
    }

    public void setCalls(long calls) {
        this.calls = calls;
    }

    public String getEventName() {
        return CuptiActivityOpenAcc.getCuptiEventName(CuptiOpenAccEventKind.valueOf(this.openAcc.eventKind));
    }

    public String getDisplayName() {
        if (this.sourceAggregate) {
            return String.valueOf(this.getRelativeFilePath()) + ":" + this.openAcc.lineNo;
        }
        return this.getEventName();
    }

    public String getRelativeFilePath() {
        return this.openAcc.getRelativePath();
    }

    public String getFullFilePath() {
        return this.openAcc.srcFile;
    }

    public int getLineNo() {
        return this.openAcc.lineNo;
    }

    public long getInclusiveTime() {
        return this.inclusiveTime;
    }

    public long getExclusiveTime() {
        return this.exclusiveTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Object[] getChildren() {
        ArrayList<OpenAccAggregate> set = new ArrayList<OpenAccAggregate>(this.children.values());
        Collections.sort(set, Collections.reverseOrder());
        return set.toArray();
    }

    @Override
    public int compareTo(OpenAccAggregate o) {
        long difference = this.inclusiveTime - o.inclusiveTime;
        if (difference > 0L) {
            return 1;
        }
        if (difference < 0L) {
            return -1;
        }
        return 0;
    }

    public boolean isSource() {
        return this.sourceAggregate;
    }

    public OpenAccAggregate getParent() {
        return this.parent;
    }

    public long getTotalTime() {
        return this.summary.getTotalTime();
    }
}

