/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.remote.core.AbstractRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.core.messages.Messages;
import org.eclipse.remote.internal.core.services.local.LocalConnection;

public class LocalConnectionManager
extends AbstractRemoteConnectionManager {
    private final IRemoteConnection fLocalConnection;

    public LocalConnectionManager(IRemoteServices services) {
        super(services);
        this.fLocalConnection = new LocalConnection(services);
    }

    @Override
    public IRemoteConnection getConnection(String name) {
        if (name.equals(this.fLocalConnection.getName())) {
            return this.fLocalConnection;
        }
        return null;
    }

    @Override
    public IRemoteConnection getConnection(URI uri) {
        if (uri.getScheme().equals(EFS.getLocalFileSystem().getScheme())) {
            return this.fLocalConnection;
        }
        return null;
    }

    @Override
    public List<IRemoteConnection> getConnections() {
        ArrayList<IRemoteConnection> list = new ArrayList<IRemoteConnection>();
        list.add(this.fLocalConnection);
        return list;
    }

    @Override
    public IRemoteConnectionWorkingCopy newConnection(String name) throws RemoteConnectionException {
        throw new RemoteConnectionException(Messages.Unable_to_create_new_local_connections);
    }

    @Override
    public void removeConnection(IRemoteConnection connection) {
    }
}

