/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIStackListFramesInfo
extends MIInfo {
    MIFrame[] frames;

    public MIStackListFramesInfo(MIOutput out) {
        super(out);
    }

    public MIFrame[] getMIFrames() {
        if (this.frames == null) {
            this.parse();
        }
        return this.frames;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList aList = new ArrayList(1);
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                if (var.equals("stack")) {
                    MIValue val = results[i].getMIValue();
                    if (val instanceof MIList) {
                        this.parseStack((MIList)val, aList);
                    } else if (val instanceof MITuple) {
                        this.parseStack((MITuple)val, aList);
                    }
                }
                ++i;
            }
        }
        this.frames = aList.toArray(new MIFrame[aList.size()]);
    }

    void parseStack(MIList miList, List aList) {
        MIResult[] results = miList.getMIResults();
        int i = 0;
        while (i < results.length) {
            MIValue value;
            String var = results[i].getVariable();
            if (var.equals("frame") && (value = results[i].getMIValue()) instanceof MITuple) {
                aList.add(new MIFrame((MITuple)value));
            }
            ++i;
        }
    }

    void parseStack(MITuple tuple, List aList) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            MIValue value;
            String var = results[i].getVariable();
            if (var.equals("frame") && (value = results[i].getMIValue()) instanceof MITuple) {
                aList.add(new MIFrame((MITuple)value));
            }
            ++i;
        }
    }
}

